//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Payu;


/**
 * Created by franklin on 5/30/15.
 * Payu Errors
 * when SDK validates the post params (paymentDefaultParams, CCDCParams, NetbankingParams, CashCardParam, Emi params, paisawallet param)
 * any one of these error code, proper error message should be return via postParam
 */
public interface PayuErrors {

    //prefix and postfix
    String PRE_PREIX = "should be the ";
    String CARD_PREIX = PRE_PREIX + "card ";
    String UDF_POSTIX = " should not be null, it can be empty or string";
    String INVALID_PREIX1 = "Please enter valid ";
    String INVALID_PREIX2 = "Please provide valid ";
    String MANDATORY_PARAM_PREIX = "Mandatory param ";
    String IS_MISSING_POSTIX = " is missing";

    int NO_ERROR = 0000;  // TODO rename this gus as SUCCESS or something else.
    int MISSING_PARAMETER_EXCEPTION = 5001;
    int NUMBER_FORMAT_EXCEPTION = 5002;
    int INVALID_AMOUNT_EXCEPTION = 5003;
    int UN_SUPPORTED_ENCODING_EXCEPTION = 5004;
    int INVALID_BANKCODE_EXCEPTION = 5005;
    int INVALID_PG_EXCEPTION = 5006;
    int INVALID_CARD_TOKEN_EXCEPTION = 5007;
    int INVALID_CARD_NUMBER_EXCEPTION = 5008;
    int INVALID_CVV_EXCEPTION = 5009;
    int INVALID_MONTH_EXCEPTION = 5010;
    int INVALID_YEAR_EXCEPTION = 5011;
    int CARD_EXPIRED_EXCEPTION = 5012;
    int USER_CREDENTIALS_NOT_FOUND_EXCEPTION = 5013;
    int INVALID_USER_CREDENTIALS = 5014;
    int JSON_EXCEPTION = 5014;
    int NO_SUCH_ALGORITHM_EXCEPTION = 5015;
    int PROTOCOL_EXCEPTION = 5016;
    int IO_EXCEPTION = 5016;

    int DELETE_CARD_EXCEPTION = 5017;
    int GET_USER_CARD_EXCEPTION = 5018;

    int INVALID_HASH = 5019;

    int APPLICATION_NOT_FOUND_EXCEPTION = 5020;

    String MANDATORY_PARAM_VAR1_IS_MISSING = MANDATORY_PARAM_PREIX + "var1" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR2_IS_MISSING = MANDATORY_PARAM_PREIX + "var2" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR3_IS_MISSING = MANDATORY_PARAM_PREIX + "var3" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR4_IS_MISSING = MANDATORY_PARAM_PREIX + "var4" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR5_IS_MISSING = MANDATORY_PARAM_PREIX + "var5" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR6_IS_MISSING = MANDATORY_PARAM_PREIX + "var6" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR7_IS_MISSING = MANDATORY_PARAM_PREIX + "var7" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR8_IS_MISSING = MANDATORY_PARAM_PREIX + "var8" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_VAR9_IS_MISSING = MANDATORY_PARAM_PREIX + "var9" + IS_MISSING_POSTIX;


    String MANDATORY_PARAM_KEY_IS_MISSING = MANDATORY_PARAM_PREIX + "key" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_SALT_IS_MISSING = MANDATORY_PARAM_PREIX + "salt" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_HASH_IS_MISSING = MANDATORY_PARAM_PREIX + "hash" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_COMMAND_IS_MISSING = MANDATORY_PARAM_PREIX + "command" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_TXNID_IS_MISSING = MANDATORY_PARAM_PREIX + "txnid" + IS_MISSING_POSTIX;

    String MANDATORY_PARAM_FIRST_NAME_IS_MISSING = MANDATORY_PARAM_PREIX + "firstname" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_EMAIL_IS_MISSING = MANDATORY_PARAM_PREIX + "email" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_PRODUCT_INFO_IS_MISSING = MANDATORY_PARAM_PREIX + "product info" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_SURL_IS_MISSING = MANDATORY_PARAM_PREIX + "surl" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_FURL_IS_MISSING = MANDATORY_PARAM_PREIX + "furl" + IS_MISSING_POSTIX;


    String MANDATORY_PARAM_BANK_CODE_IS_MISSING = MANDATORY_PARAM_PREIX + "bankcode" + IS_MISSING_POSTIX;
    String MANDATORY_PARAM_PG_IS_MISSING = MANDATORY_PARAM_PREIX + "pg is missing, pg should be any one of CC, EMI, CASH, NB, PAYU_MONEY";

    String TRANSACTION_ID_MISSING = PRE_PREIX + "Transaction id (txnid)";
    String MIHPAY_ID_MISSING = PRE_PREIX + "Payu id (mihpayid) of the transaction which was given by payu.";
    String CARD_TOKEN_MISSING = PRE_PREIX + "card token, you get the card token when you store/fetch a card";
    String USER_CREDENTIALS_MISSING = PRE_PREIX + "user credentials and it should be merchant_key:unique_user_id.";
    String USER_CREDENTIALS_OR_DEFAULT_MISSING = " should be user_credentials (merchant_key:unique_user_id.) to get the merchant information and stored card or default to get only the merchant information";
    String CARD_NUMBER_MISSING = " should be a valid credit / debit card number";
    String NAME_ON_CARD_MISSING = " should be name on card";


    String CARD_TYPE_MISSING = CARD_PREIX + "type; please use CC as card type";
    String CARD_MODE_MISSING = CARD_PREIX + "mode; please use CC as card mode";
    String CARD_NAME_MISSING = CARD_PREIX + "name (nickname of the card)";

    String CARD_BIN_MISSING = "number or the card bin (first 6 digit of the card)";
    String END_DATE_TIME_MISSING = PRE_PREIX + "till date in YYYY-MM-DD hh:mm:ss format.";
    String FROM_DATE_TIME_MISSING = PRE_PREIX + "from date in YYYY-MM-DD hh:mm:ss format";
    String END_DATE_MISSING = "till date in YYYY-MM-DD format.";
    String FROM_DATE_MISSING = PRE_PREIX + "from date in YYYY-MM-DD format";
    String BANK_CODE_MISSING = PRE_PREIX + "bank code for one bank, default for getting all banks";
    String OFFER_KEY_MISSING = " should be offer key example : offer@1234 ";
    String POST_DATA_MISSING = "Post data is missing";

    String USER_CREDENTIALS_NOT_FOUND = " Card can not be stored!, user_credentials is missing!";

    String CARD_EXPIRED = " It seems the card is expired!";

    String INVALID_YEAR = " Invalid year, year should be 4 digit YYYY format";
    String INVALID_MONTH = " Invalid month, it should be two digit number range from 01 to 12 MM format";
    String INVALID_JSON = " should be a stringified JSON object; It seems there is an exception while parsing JSON";
    String INVALID_AMOUNT = " Amount should be a Double value example 5.00";
    String INVALID_AMOUNT_TO_REFUND = "  should contain the amount which needs to be refunded. Please note that both partial and full refunds are allowed.";
    String INVALID_TOKEN_ID = PRE_PREIX + "Token ID(unique token from merchant)";
    String INVALID_BANK_REFERENCE_ID = PRE_PREIX + "Bank Ref Id for the requested transaction.";
    String INVALID_ACTION = PRE_PREIX + "Action (cancel/capture/refund)";
    String INVALID_BANK_CODE_CC = "For credit card payment bank code should be CC";
    String INVALID_BANK_CODE = "Invalid bank code please verify";
    String INVALID_PAYMENT_OPTION = " Invalid card payment option. ccnum / card_token missing.";
    String INVALID_CARD_TOKEN = " Invalid card token";
    String INVALID_CARD_NUMBER = " Invalid card number, Failed while applying Luhn";
    String INVALID_CVV = " Invalid cvv, please verify";
    String INVALID_URL = " should be something like https://www.payu.in/txnstatus";
    String INVALID_PG = "Invalid pg!, pg should be any one of CC, EMI, CASH, NB, PAYU_MONEY";
    String INVALID_ALGORITHM_SHA = " Message digest sha 512 not found!";
    String INVALID_PRODUCT_INFO = "Product info should not be null, it can be empty or string";
    String INVALID_FIRST_NAME = "First name should not be null, it can be empty or string";
    String INVALID_EMAIL = "Email should not be null, it can be empty or string";


    String INVALID_UDF1 = "UDF1" + UDF_POSTIX;
    String INVALID_UDF2 = "UDF2" + UDF_POSTIX;
    String INVALID_UDF3 = "UDF3" + UDF_POSTIX;
    String INVALID_UDF4 = "UDF4" + UDF_POSTIX;
    String INVALID_UDF5 = "UDF5" + UDF_POSTIX;


    String INVALID_SALT = "Salt should be a valid string";


    String INVALID_POST_PARAMS = INVALID_PREIX1 + "MerchantWebService object / PaymentDefaultParams and PaymnentModeParam";
    String INVALID_PAYMENT_DEFAULT_PARAMS = INVALID_PREIX1 + "PaymentDefaultParamsObject";
    String INVALID_PAYMENT_MODES = INVALID_PREIX2 + "PaymentModes (Anyone from NB, CASH, EMI, CC, PAYU_MONEY)";
    String INVALID_CARD_DETAILS = INVALID_PREIX2 + "card details (card number , cvv, exp month, exp year, card name)";
    String INVALID_EMI_DETAILS = INVALID_PREIX2 + "email details";
    String INVALID_USER_CREDENTIALS_MISSING = " Invalid user credentials, user_credentials should be merchant_key:unique_user_id.";

    String USE_DEFAULT = " Please send var1 as 'default'";
    String MORE_THAN_ONE_TXNID = "if you want to verify more than one transaction please separate them by pipe : ex 6234567|45678987|4567876 ";
    String NEW_STATUS = " should be new status to be set";
    String REQUEST_ID = PRE_PREIX + "Request ID which you get while cancel_refund_transaction api";

    // no error block
    String SDK_DETAILS_FETCHED_SUCCESSFULLY = "Data fetched successfully, Stored card status: ";


    // Applction context not found in Payu.java file.
    java.lang.String APP_CONTEXT_NOT_FOUND = "Application context not found please set your applciation context by adding Payu.setInstance(this) from your activity ";
}
