//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by franklin on 6/25/15.
 * Simple implementation of Payu hashes
 * once the user calculate all the hashes from his server he should create a {@link PayuHashes} object.
 * and assign all the required hashes. Use {@link com.payu.india.Payu.PayuConstants#PAYU_HASHES} for sending it via intent.
 * its a bean, no need to worry about serialization.
 * in case of sdkui all Activity's onCreate function look for intent.getParacleable{@link com.payu.india.Payu.PayuConstants#PAYU_HASHES}
 */
public class PayuHashes implements Parcelable {


    protected PayuHashes(Parcel in) {
        paymentHash = in.readString();
        verifyPaymentHash = in.readString();
        checkPaymentHash = in.readString();
        cancelRefundTransactionHash = in.readString();
        checkActionStatusHash = in.readString();
        captureTransactionHash = in.readString();
        updateRequestsHash = in.readString();
        codVerifyHash = in.readString();
        codCancelHash = in.readString();
        getTdrHash = in.readString();
        udfUpdateHash = in.readString();
        createInvoiceHash = in.readString();
        checkOfferStatusHash = in.readString();
        netBankingStatusHash = in.readString();
        issuingBankStatusHash = in.readString();
        transactionDetailsHash = in.readString();
        transactionInfoHash = in.readString();
        checkIsDomesticHash = in.readString();
        storedCardsHash = in.readString();
        saveCardHash = in.readString();
        editCardHash = in.readString();
        deleteCardHash = in.readString();
        merchantIbiboCodesHash = in.readString();
        vasForMobileSdkHash = in.readString();
        paymentRelatedDetailsForMobileSdkHash = in.readString();
        deleteStoreCardCvv = in.readString();
        checkOfferDetailsHash = in.readString();
    }

    public static final Creator<PayuHashes> CREATOR = new Creator<PayuHashes>() {
        @Override
        public PayuHashes createFromParcel(Parcel in) {
            return new PayuHashes(in);
        }

        @Override
        public PayuHashes[] newArray(int size) {
            return new PayuHashes[size];
        }
    };

    public String getPaymentHash() {
        return paymentHash;
    }

    public void setPaymentHash(String paymentHash) {
        this.paymentHash = paymentHash;
    }

    public String getVerifyPaymentHash() {
        return verifyPaymentHash;
    }

    public void setVerifyPaymentHash(String verifyPaymentHash) {
        this.verifyPaymentHash = verifyPaymentHash;
    }

    public String getCheckPaymentHash() {
        return checkPaymentHash;
    }

    public void setCheckPaymentHash(String checkPaymentHash) {
        this.checkPaymentHash = checkPaymentHash;
    }

    public String getCancelRefundTransactionHash() {
        return cancelRefundTransactionHash;
    }

    public void setCancelRefundTransactionHash(String cancelRefundTransactionHash) {
        this.cancelRefundTransactionHash = cancelRefundTransactionHash;
    }

    public String getCheckActionStatusHash() {
        return checkActionStatusHash;
    }

    public void setCheckActionStatusHash(String checkActionStatusHash) {
        this.checkActionStatusHash = checkActionStatusHash;
    }

    public String getCaptureTransactionHash() {
        return captureTransactionHash;
    }

    public void setCaptureTransactionHash(String captureTransactionHash) {
        this.captureTransactionHash = captureTransactionHash;
    }

    public String getUpdateRequestsHash() {
        return updateRequestsHash;
    }

    public void setUpdateRequestsHash(String updateRequestsHash) {
        this.updateRequestsHash = updateRequestsHash;
    }

    public String getCodVerifyHash() {
        return codVerifyHash;
    }

    public void setCodVerifyHash(String codVerifyHash) {
        this.codVerifyHash = codVerifyHash;
    }

    public String getCodCancelHash() {
        return codCancelHash;
    }

    public void setCodCancelHash(String codCancelHash) {
        this.codCancelHash = codCancelHash;
    }

    public String getGetTdrHash() {
        return getTdrHash;
    }

    public void setGetTdrHash(String getTdrHash) {
        this.getTdrHash = getTdrHash;
    }

    public String getUdfUpdateHash() {
        return udfUpdateHash;
    }

    public void setUdfUpdateHash(String udfUpdateHash) {
        this.udfUpdateHash = udfUpdateHash;
    }

    public String getCreateInvoiceHash() {
        return createInvoiceHash;
    }

    public void setCreateInvoiceHash(String createInvoiceHash) {
        this.createInvoiceHash = createInvoiceHash;
    }

    public String getCheckOfferStatusHash() {
        return checkOfferStatusHash;
    }

    public void setCheckOfferStatusHash(String checkOfferStatusHash) {
        this.checkOfferStatusHash = checkOfferStatusHash;
    }

    public String getNetBankingStatusHash() {
        return netBankingStatusHash;
    }

    public void setNetBankingStatusHash(String netBankingStatusHash) {
        this.netBankingStatusHash = netBankingStatusHash;
    }

    public String getIssuingBankStatusHash() {
        return issuingBankStatusHash;
    }

    public void setIssuingBankStatusHash(String issuingBankStatusHash) {
        this.issuingBankStatusHash = issuingBankStatusHash;
    }

    public String getTransactionDetailsHash() {
        return transactionDetailsHash;
    }

    public void setTransactionDetailsHash(String transactionDetailsHash) {
        this.transactionDetailsHash = transactionDetailsHash;
    }

    public String getTransactionInfoHash() {
        return transactionInfoHash;
    }

    public void setTransactionInfoHash(String transactionInfoHash) {
        this.transactionInfoHash = transactionInfoHash;
    }

    public String getCheckIsDomesticHash() {
        return checkIsDomesticHash;
    }

    public void setCheckIsDomesticHash(String checkIsDomesticHash) {
        this.checkIsDomesticHash = checkIsDomesticHash;
    }

    public String getStoredCardsHash() {
        return storedCardsHash;
    }

    public void setStoredCardsHash(String storedCardsHash) {
        this.storedCardsHash = storedCardsHash;
    }

    public String getSaveCardHash() {
        return saveCardHash;
    }

    public void setSaveCardHash(String saveCardHash) {
        this.saveCardHash = saveCardHash;
    }

    public String getEditCardHash() {
        return editCardHash;
    }

    public void setEditCardHash(String editCardHash) {
        this.editCardHash = editCardHash;
    }

    public String getDeleteCardHash() {
        return deleteCardHash;
    }

    public void setDeleteCardHash(String deleteCardHash) {
        this.deleteCardHash = deleteCardHash;
    }

    public String getMerchantIbiboCodesHash() {
        return merchantIbiboCodesHash;
    }

    public void setMerchantIbiboCodesHash(String merchantIbiboCodesHash) {
        this.merchantIbiboCodesHash = merchantIbiboCodesHash;
    }

    public String getVasForMobileSdkHash() {
        return vasForMobileSdkHash;
    }

    public void setVasForMobileSdkHash(String vasForMobileSdkHash) {
        this.vasForMobileSdkHash = vasForMobileSdkHash;
    }

    public String getPaymentRelatedDetailsForMobileSdkHash() {
        return paymentRelatedDetailsForMobileSdkHash;
    }

    public void setPaymentRelatedDetailsForMobileSdkHash(String paymentRelatedDetailsForMobileSdkHash) {
        this.paymentRelatedDetailsForMobileSdkHash = paymentRelatedDetailsForMobileSdkHash;
    }

    public String getDeleteStoreCardCvv() {
        return deleteStoreCardCvv;
    }

    public void setDeleteStoreCardCvv(String deleteStoreCardCvv) {
        this.deleteStoreCardCvv = deleteStoreCardCvv;
    }


    public String getCheckOfferDetailsHash() {
        return checkOfferDetailsHash;
    }

    public void setCheckOfferDetailsHash(String checkOfferDetails) {
        this.checkOfferDetailsHash = checkOfferDetails;
    }


    private String paymentHash; // hash for  making payment.
    private String verifyPaymentHash; // hash for PayuConstants.VERIFY_PAYMENT command
    private String checkPaymentHash; // hash for PayuConstants. CHECK_PAYMENT command
    private String cancelRefundTransactionHash; // hash for PayuConstants.CANCEL_REFUND_TRANSACTION command
    private String checkActionStatusHash; // hash for PayuConstants.CHECK_ACTION_STATUS command
    private String captureTransactionHash; // hash for PayuConstants.CAPTURE_TRANSACTION command
    private String updateRequestsHash; // hash for PayuConstants.UPDATE_REQUESTS command
    private String codVerifyHash; // hash for PayuConstants.COD_VERIFY command
    private String codCancelHash; // hash for PayuConstants.COD_CANCEL command
    private String getTdrHash; // hash for PayuConstants.GET_TDR command
    private String udfUpdateHash; // hash for PayuConstants.UDF_UPDATE command
    private String createInvoiceHash; // hash for PayuConstants.CREATE_INVOICE command
    private String checkOfferStatusHash; // hash for PayuConstants.CHECK_OFFER_STATUS command
    private String netBankingStatusHash; // hash for PayuConstants.GET_NETBANKING_STATUS command
    private String issuingBankStatusHash; // hash for PayuConstants.GET_ISSUING_BANK_STATUS command
    private String transactionDetailsHash; // hash for PayuConstants.GET_TRANSACTION_DETAILS command
    private String transactionInfoHash; // hash for PayuConstants.GET_TRANSACTION_INFO command
    private String checkIsDomesticHash; // hash for PayuConstants.CHECK_IS_DOMESTIC command
    private String storedCardsHash; // hash for PayuConstants.GET_USER_CARDS command
    private String saveCardHash; // hash for PayuConstants.SAVE_USER_CARD command
    private String editCardHash; // hash for PayuConstants.EDIT_USER_CARD command
    private String deleteCardHash; // hash for PayuConstants.delete_user_card command
    @Deprecated
    private String merchantIbiboCodesHash; // hash for PayuConstants.GET_MERCHANT_IBIBO_CODES command
    private String vasForMobileSdkHash; // hash for PayuConstants.VAS_FOR_MOBILE_SDK command
    private String paymentRelatedDetailsForMobileSdkHash; // hash for PayuConstants.PAYMENT_RELATED_DETAILS_FOR_MOBILE_SDK command
    private String deleteStoreCardCvv; // hash for PayuConstants.DELETE_STORE_CARD_CVV command


    private String checkOfferDetailsHash; // hash for checking offer PayuConstants.CHECK_OFFER_DETAILS command


    public PayuHashes() {
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(paymentHash);
        dest.writeString(verifyPaymentHash);
        dest.writeString(checkPaymentHash);
        dest.writeString(cancelRefundTransactionHash);
        dest.writeString(checkActionStatusHash);
        dest.writeString(captureTransactionHash);
        dest.writeString(updateRequestsHash);
        dest.writeString(codVerifyHash);
        dest.writeString(codCancelHash);
        dest.writeString(getTdrHash);
        dest.writeString(udfUpdateHash);
        dest.writeString(createInvoiceHash);
        dest.writeString(checkOfferStatusHash);
        dest.writeString(netBankingStatusHash);
        dest.writeString(issuingBankStatusHash);
        dest.writeString(transactionDetailsHash);
        dest.writeString(transactionInfoHash);
        dest.writeString(checkIsDomesticHash);
        dest.writeString(storedCardsHash);
        dest.writeString(saveCardHash);
        dest.writeString(editCardHash);
        dest.writeString(deleteCardHash);
        dest.writeString(merchantIbiboCodesHash);
        dest.writeString(vasForMobileSdkHash);
        dest.writeString(paymentRelatedDetailsForMobileSdkHash);
        dest.writeString(deleteStoreCardCvv);
        dest.writeString(checkOfferDetailsHash);
    }
}

