//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;

/**
 * Created by franklin on 6/4/15.
 * Simple Bean implementations of Payu Config
 * Every payu Async tasks require Config object
 * {@link PayuConfig#data } Should be the final data, which will be posted on payu server
 * {@link PayuConfig#environment} Should be the environment.
 * {@link PayuConstants#MOBILE_STAGING_ENV}
 * {@link PayuConstants#PRODUCTION_ENV}
 * {@link PayuConstants#STAGING_ENV}
 * if none of the evn specified sdk will point to {@link PayuConstants#PRODUCTION_ENV}
 */
public class PayuConfig implements Parcelable {

    public static final Creator<PayuConfig> CREATOR = new Creator<PayuConfig>() {
        @Override
        public PayuConfig createFromParcel(Parcel in) {
            return new PayuConfig(in);
        }

        @Override
        public PayuConfig[] newArray(int size) {
            return new PayuConfig[size];
        }
    };

    private String data; // should be the final data posted to payu server
    private int environment; // environment.

    public PayuConfig() {
    }

    protected PayuConfig(Parcel in) {
        data = in.readString();
        environment = in.readInt();
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public int getEnvironment() {
        return environment;
    }

    public void setEnvironment(int environment) {
        this.environment = environment;
    }

    public PostData getConfig() {
        PostData postData = new PostData();
        if (this.data == null || this.data.length() < 1) {
            postData.setCode(PayuErrors.MISSING_PARAMETER_EXCEPTION);
            postData.setResult(PayuConstants.ERROR);
            postData.setResult(PayuErrors.POST_DATA_MISSING);
            return postData;
        }

        switch (this.environment) {
            case PayuConstants.STAGING_ENV:
                this.environment = PayuConstants.STAGING_ENV;
                break;
            case PayuConstants.PRODUCTION_ENV:
                this.environment = PayuConstants.PRODUCTION_ENV;
                break;
            case PayuConstants.MOBILE_STAGING_ENV:
                this.environment = PayuConstants.MOBILE_STAGING_ENV;
                break;
            case PayuConstants.MOBILE_DEV_ENV:
                this.environment = PayuConstants.MOBILE_DEV_ENV;
                break;
            default:
                this.environment = PayuConstants.PRODUCTION_ENV;
                break;
        }

        postData.setCode(PayuErrors.NO_ERROR);
        postData.setStatus(PayuConstants.SUCCESS);
        postData.setResult(PayuConstants.SUCCESS);
        return postData;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(data);
        dest.writeInt(environment);
    }
}
