/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.PostParams;

import android.support.annotation.NonNull;
import com.payu.india.Model.PaymentParams;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class PaymentPostParams
extends PayuUtils {
    private PaymentParams mPaymentParams;
    private String mPaymentMode;
    private PostData postData;
    private StringBuffer post;

    private PaymentPostParams() {
    }

    public PaymentPostParams(PaymentParams paymentParams, @NonNull String paymentMode) {
        this.mPaymentParams = paymentParams;
        this.mPaymentMode = paymentMode;
        PaymentPostParams.setAnalyticsKeyCB(this.mPaymentParams.getKey());
    }

    public PostData getPaymentPostParams() {
        this.postData = new PostData();
        this.post = new StringBuffer();
        if (!PayuConstants.PG_SET.contains(this.mPaymentMode)) {
            return this.getReturnData("Invalid pg!, pg should be any one of CC, EMI, CASH, NB, PAYU_MONEY");
        }
        this.post.append(this.concatParams("pg", this.mPaymentMode));
        this.post.append(this.concatParams("device_type", "1"));
        block60: for (int i = 0; i < PayuConstants.PAYMENT_PARAMS_ARRAY.length; ++i) {
            switch (PayuConstants.PAYMENT_PARAMS_ARRAY[i]) {
                case "key": {
                    if (this.mPaymentParams.getKey() == null || this.mPaymentParams.getKey().length() < 1) {
                        return this.getReturnData("Mandatory param key is missing");
                    }
                    this.post.append(this.concatParams("key", this.mPaymentParams.getKey()));
                    continue block60;
                }
                case "txnid": {
                    if (this.mPaymentParams.getTxnId() == null || this.mPaymentParams.getTxnId().length() < 1) {
                        return this.getReturnData("Mandatory param txnid is missing");
                    }
                    this.post.append(this.concatParams("txnid", this.mPaymentParams.getTxnId()));
                    continue block60;
                }
                case "amount": {
                    Double amount = 0.0;
                    try {
                        amount = this.mPaymentParams != null ? Double.parseDouble(this.mPaymentParams.getAmount()) : 0.0;
                    }
                    catch (NumberFormatException e) {
                        return this.getReturnData(5002, " Amount should be a Double value example 5.00");
                    }
                    catch (NullPointerException e) {
                        return this.getReturnData(5003, " Amount should be a Double value example 5.00");
                    }
                    if (amount < 1.0) {
                        return this.getReturnData(5003, " Amount should be a Double value example 5.00");
                    }
                    this.post.append(this.concatParams("amount", this.mPaymentParams.getAmount()));
                    continue block60;
                }
                case "productinfo": {
                    if (this.mPaymentParams.getProductInfo() == null || this.mPaymentParams.getProductInfo().length() < 1) {
                        return this.getReturnData("Mandatory param product info is missing");
                    }
                    this.post.append(this.concatParams("productinfo", this.mPaymentParams.getProductInfo()));
                    continue block60;
                }
                case "firstname": {
                    if (this.mPaymentParams.getFirstName() == null) {
                        return this.getReturnData("Mandatory param firstname is missing");
                    }
                    this.post.append(this.concatParams("firstname", this.mPaymentParams.getFirstName()));
                    continue block60;
                }
                case "email": {
                    if (this.mPaymentParams.getEmail() == null) {
                        return this.getReturnData("Mandatory param email is missing");
                    }
                    this.post.append(this.concatParams("email", this.mPaymentParams.getEmail()));
                    continue block60;
                }
                case "surl": {
                    if (this.mPaymentParams.getSurl() == null || this.mPaymentParams.getSurl().length() < 1) {
                        return this.getReturnData("Mandatory param surl is missing");
                    }
                    try {
                        this.post.append("surl=").append(URLEncoder.encode(this.mPaymentParams.getSurl(), "UTF-8")).append("&");
                        continue block60;
                    }
                    catch (UnsupportedEncodingException e) {
                        return this.getReturnData(5004, "surl should be something like https://www.payu.in/txnstatus");
                    }
                }
                case "furl": {
                    if (this.mPaymentParams.getFurl() == null || this.mPaymentParams.getFurl().length() < 1) {
                        return this.getReturnData("Mandatory param furl is missing");
                    }
                    try {
                        this.post.append("furl=").append(URLEncoder.encode(this.mPaymentParams.getFurl(), "UTF-8")).append("&");
                        continue block60;
                    }
                    catch (UnsupportedEncodingException e) {
                        return this.getReturnData(5004, "furl should be something like https://www.payu.in/txnstatus");
                    }
                }
                case "hash": {
                    if (this.mPaymentParams.getHash() == null || this.mPaymentParams.getHash().length() < 1) {
                        return this.getReturnData("Mandatory param hash is missing");
                    }
                    this.post.append(this.concatParams("hash", this.mPaymentParams.getHash()));
                    continue block60;
                }
                case "udf1": {
                    if (this.mPaymentParams.getUdf1() == null) {
                        return this.getReturnData("UDF1 should not be null, it can be empty or string");
                    }
                    this.post.append(this.concatParams("udf1", this.mPaymentParams.getUdf1()));
                    continue block60;
                }
                case "udf2": {
                    if (this.mPaymentParams.getUdf2() == null) {
                        return this.getReturnData("UDF2 should not be null, it can be empty or string");
                    }
                    this.post.append(this.concatParams("udf2", this.mPaymentParams.getUdf2()));
                    continue block60;
                }
                case "udf3": {
                    if (this.mPaymentParams.getUdf3() == null) {
                        return this.getReturnData("UDF3 should not be null, it can be empty or string");
                    }
                    this.post.append(this.concatParams("udf3", this.mPaymentParams.getUdf3()));
                    continue block60;
                }
                case "udf4": {
                    if (this.mPaymentParams.getUdf4() == null) {
                        return this.getReturnData("UDF4 should not be null, it can be empty or string");
                    }
                    this.post.append(this.concatParams("udf4", this.mPaymentParams.getUdf4()));
                    continue block60;
                }
                case "udf5": {
                    if (this.mPaymentParams.getUdf5() == null) {
                        return this.getReturnData("UDF5 should not be null, it can be empty or string");
                    }
                    this.post.append(this.concatParams("udf5", this.mPaymentParams.getUdf5()));
                }
            }
        }
        if (this.mPaymentParams.getPhone() != null) {
            this.post.append(this.concatParams("phone", this.mPaymentParams.getPhone()));
        }
        this.post.append(this.mPaymentParams.getOfferKey() != null ? this.concatParams("offer_key", this.mPaymentParams.getOfferKey()) : "");
        this.post.append(this.mPaymentParams.getLastName() != null ? this.concatParams("lastname", this.mPaymentParams.getLastName()) : "");
        this.post.append(this.mPaymentParams.getAddress1() != null ? this.concatParams("address1", this.mPaymentParams.getAddress1()) : "");
        this.post.append(this.mPaymentParams.getAddress2() != null ? this.concatParams("address2", this.mPaymentParams.getAddress2()) : "");
        this.post.append(this.mPaymentParams.getCity() != null ? this.concatParams("city", this.mPaymentParams.getCity()) : "");
        this.post.append(this.mPaymentParams.getState() != null ? this.concatParams("state", this.mPaymentParams.getState()) : "");
        this.post.append(this.mPaymentParams.getCountry() != null ? this.concatParams("country", this.mPaymentParams.getCountry()) : "");
        this.post.append(this.mPaymentParams.getZipCode() != null ? this.concatParams("zipcode", this.mPaymentParams.getZipCode()) : "");
        this.post.append(this.mPaymentParams.getCodUrl() != null ? this.concatParams("codurl", this.mPaymentParams.getCodUrl()) : "");
        this.post.append(this.mPaymentParams.getDropCategory() != null ? this.concatParams("drop_category", this.mPaymentParams.getDropCategory()) : "");
        this.post.append(this.mPaymentParams.getEnforcePayMethod() != null ? this.concatParams("enforce_paymethod", this.mPaymentParams.getEnforcePayMethod()) : "");
        this.post.append(this.mPaymentParams.getCustomNote() != null ? this.concatParams("custom_note", this.mPaymentParams.getCustomNote()) : "");
        this.post.append(this.mPaymentParams.getNoteCategory() != null ? this.concatParams("note_category", this.mPaymentParams.getNoteCategory()) : "");
        this.post.append(this.mPaymentParams.getShippingFirstName() != null ? this.concatParams("shipping_firstname", this.mPaymentParams.getShippingFirstName()) : "");
        this.post.append(this.mPaymentParams.getShippingLastName() != null ? this.concatParams("shipping_lastname", this.mPaymentParams.getShippingLastName()) : "");
        this.post.append(this.mPaymentParams.getShippingAddress1() != null ? this.concatParams("shipping_address1", this.mPaymentParams.getShippingAddress1()) : "");
        this.post.append(this.mPaymentParams.getShippingAddress2() != null ? this.concatParams("shipping_address2", this.mPaymentParams.getShippingAddress2()) : "");
        this.post.append(this.mPaymentParams.getShippingCity() != null ? this.concatParams("shipping_city", this.mPaymentParams.getShippingCity()) : "");
        this.post.append(this.mPaymentParams.getShippingState() != null ? this.concatParams("shipping_state", this.mPaymentParams.getShippingState()) : "");
        this.post.append(this.mPaymentParams.getShippingCounty() != null ? this.concatParams("shipping_county", this.mPaymentParams.getShippingCounty()) : "");
        this.post.append(this.mPaymentParams.getShippingZipCode() != null ? this.concatParams("shipping_zipcode", this.mPaymentParams.getShippingZipCode()) : "");
        this.post.append(this.mPaymentParams.getShippingPhone() != null ? this.concatParams("shipping_phone", this.mPaymentParams.getShippingPhone()) : "");
        switch (this.mPaymentMode) {
            case "CC": {
                this.post.append(this.concatParams("bankcode", "CC"));
                if (null != this.mPaymentParams.getCardNumber() && this.validateCardNumber(this.mPaymentParams.getCardNumber()).booleanValue()) {
                    this.post.append(this.concatParams("ccnum", this.mPaymentParams.getCardNumber()));
                    if (!this.getIssuer(this.mPaymentParams.getCardNumber()).contentEquals("SMAE")) {
                        if (!this.validateCvv(this.mPaymentParams.getCardNumber(), this.mPaymentParams.getCvv())) {
                            return this.getReturnData(5009, " Invalid cvv, please verify");
                        }
                        this.post.append(this.concatParams("ccvv", this.mPaymentParams.getCvv()));
                        try {
                            if (!this.validateExpiry(Integer.parseInt(this.mPaymentParams.getExpiryMonth()), Integer.parseInt(this.mPaymentParams.getExpiryYear()))) {
                                return this.getReturnData(5012, " It seems the card is expired!");
                            }
                            this.post.append(this.concatParams("ccexpyr", this.mPaymentParams.getExpiryYear()));
                            this.post.append(this.concatParams("ccexpmon", this.mPaymentParams.getExpiryMonth()));
                        }
                        catch (NumberFormatException e) {
                            return this.getReturnData(5002, " It seems the card is expired!");
                        }
                        catch (Exception e) {
                            return this.getReturnData(5001, " It seems the card is expired!");
                        }
                    }
                    if (this.validateCvv(this.mPaymentParams.getCardNumber(), this.mPaymentParams.getCvv())) {
                        this.post.append(this.concatParams("ccvv", this.mPaymentParams.getCvv()));
                    }
                    try {
                        if (this.validateExpiry(Integer.parseInt(this.mPaymentParams.getExpiryMonth()), Integer.parseInt(this.mPaymentParams.getExpiryYear()))) {
                            this.post.append(this.concatParams("ccexpyr", this.mPaymentParams.getExpiryYear()));
                            this.post.append(this.concatParams("ccexpmon", this.mPaymentParams.getExpiryMonth()));
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    String nameOnCard = null != this.mPaymentParams.getNameOnCard() && this.mPaymentParams.getNameOnCard().trim().length() > 0 ? this.mPaymentParams.getNameOnCard() : "PayuUser";
                    String cardName = null != this.mPaymentParams.getCardName() ? this.mPaymentParams.getCardName() : nameOnCard;
                    this.post.append(this.concatParams("ccname", nameOnCard));
                    if (this.mPaymentParams.getStoreCard() == 1) {
                        if (this.mPaymentParams.getUserCredentials() != null) {
                            this.post.append(this.concatParams("card_name", cardName));
                            this.post.append(this.mPaymentParams.getUserCredentials() != null ? this.concatParams("user_credentials", this.mPaymentParams.getUserCredentials()) : "");
                            this.post.append(this.mPaymentParams.getStoreCard() == 1 ? this.concatParams("store_card", "" + this.mPaymentParams.getStoreCard()) : "");
                            this.post.append(this.mPaymentParams.getEnableOneClickPayment() == 1 ? this.concatParams("one_click_checkout", "" + this.mPaymentParams.getEnableOneClickPayment()) : "");
                        } else {
                            return this.getReturnData(" Card can not be stored!, user_credentials is missing!");
                        }
                    }
                    return this.getReturnData(0, "SUCCESS", this.trimAmpersand(this.post.toString()));
                }
                if (null != this.mPaymentParams.getCardToken()) {
                    if (this.mPaymentParams.getUserCredentials() != null) {
                        this.post.append(this.concatParams("user_credentials", this.mPaymentParams.getUserCredentials()));
                        this.post.append(this.concatParams("store_card_token", this.mPaymentParams.getCardToken()));
                        if (this.mPaymentParams.getCardBin() != null && !this.getIssuer(this.mPaymentParams.getCardBin()).contentEquals("SMAE")) {
                            if (this.mPaymentParams.getCvv() == null && null == this.mPaymentParams.getCardCvvMerchant()) {
                                return this.getReturnData(" Invalid cvv, please verify");
                            }
                            if (!this.validateExpiry(Integer.parseInt(this.mPaymentParams.getExpiryMonth()), Integer.parseInt(this.mPaymentParams.getExpiryYear()))) {
                                return this.getReturnData(" It seems the card is expired!");
                            }
                        }
                        if (this.mPaymentParams.getCardCvvMerchant() == null) {
                            this.post.append(this.mPaymentParams.getCvv() != null ? this.concatParams("ccvv", this.mPaymentParams.getCvv()) : this.concatParams("ccvv", "123"));
                        } else {
                            this.post.append(this.concatParams("card_merchant_param", this.mPaymentParams.getCardCvvMerchant()));
                        }
                        this.post.append(this.mPaymentParams.getExpiryMonth() != null ? this.concatParams("ccexpmon", this.mPaymentParams.getExpiryMonth()) : this.concatParams("ccexpmon", "12"));
                        this.post.append(this.mPaymentParams.getExpiryYear() != null ? this.concatParams("ccexpyr", this.mPaymentParams.getExpiryYear()) : this.concatParams("ccexpmon", "2080"));
                        this.post.append(this.mPaymentParams.getNameOnCard() == null ? this.concatParams("ccname", "PayuUser") : this.concatParams("ccname", this.mPaymentParams.getNameOnCard()));
                        this.post.append(this.mPaymentParams.getEnableOneClickPayment() == 1 ? this.concatParams("one_click_checkout", "" + this.mPaymentParams.getEnableOneClickPayment()) : "");
                        return this.getReturnData(0, "SUCCESS", this.trimAmpersand(this.post.toString()));
                    }
                    return this.getReturnData(5013, "should be the user credentials and it should be merchant_key:unique_user_id.");
                }
                return this.getReturnData(5008, " Invalid card number, Failed while applying Luhn");
            }
            case "NB": {
                if (this.mPaymentParams.getBankCode() == null || this.mPaymentParams.getBankCode().length() <= 1) {
                    return this.getReturnData(5005, "Invalid bank code please verify");
                }
                this.post.append(this.concatParams("bankcode", this.mPaymentParams.getBankCode()));
                return this.getReturnData(0, "SUCCESS", this.trimAmpersand(this.post.toString()));
            }
            case "EMI": {
                if (this.mPaymentParams.getBankCode() != null && this.mPaymentParams.getBankCode().length() > 1) {
                    this.post.append(this.concatParams("pg", "EMI"));
                    this.post.append(this.concatParams("bankcode", this.mPaymentParams.getBankCode()));
                    if (this.validateCardNumber("" + this.mPaymentParams.getCardNumber()).booleanValue()) {
                        this.post.append(this.concatParams("ccnum", "" + this.mPaymentParams.getCardNumber()));
                        if (!this.getIssuer("" + this.mPaymentParams.getCardNumber()).contentEquals("SMAE")) {
                            if (!this.validateCvv("" + this.mPaymentParams.getCardNumber(), "" + this.mPaymentParams.getCvv())) {
                                return this.getReturnData(5009, " Invalid cvv, please verify");
                            }
                            this.post.append(this.concatParams("ccvv", "" + this.mPaymentParams.getCvv()));
                            try {
                                if (!this.validateExpiry(Integer.parseInt(this.mPaymentParams.getExpiryMonth()), Integer.parseInt(this.mPaymentParams.getExpiryYear()))) {
                                    return this.getReturnData(5012, " It seems the card is expired!");
                                }
                                this.post.append(this.concatParams("ccexpyr", "" + this.mPaymentParams.getExpiryYear()));
                                this.post.append(this.concatParams("ccexpmon", "" + this.mPaymentParams.getExpiryMonth()));
                            }
                            catch (NumberFormatException e) {
                                return this.getReturnData(5002, " It seems the card is expired!");
                            }
                        }
                        this.post.append(this.mPaymentParams.getNameOnCard() == null ? this.concatParams("ccname", "PayuUser") : this.concatParams("ccname", this.mPaymentParams.getNameOnCard()));
                        if (this.mPaymentParams.getStoreCard() == 1) {
                            if (this.mPaymentParams.getUserCredentials() != null) {
                                this.post.append(this.mPaymentParams.getCardName() == null ? this.concatParams("card_name", "PayuUser") : this.concatParams("name_on_card", this.mPaymentParams.getCardName()));
                                this.post.append(this.mPaymentParams.getUserCredentials() != null ? this.concatParams("user_credentials", this.mPaymentParams.getUserCredentials()) : "");
                                this.post.append(this.mPaymentParams.getStoreCard() == 1 ? this.concatParams("store_card", "" + this.mPaymentParams.getStoreCard()) : "");
                            } else {
                                return this.getReturnData(" Card can not be stored!, user_credentials is missing!");
                            }
                        }
                        return this.getReturnData(0, "SUCCESS", this.trimAmpersand(this.post.toString()));
                    }
                    return this.getReturnData(5008, " Invalid card number, Failed while applying Luhn");
                }
                return this.getReturnData("Please provide valid email details");
            }
            case "CASH": {
                this.post.append(this.concatParams("pg", "CASH"));
                if (this.mPaymentParams == null || this.mPaymentParams.getBankCode() == null || this.mPaymentParams.getBankCode().length() <= 1) {
                    return this.getReturnData(5005, "Invalid bank code please verify");
                }
                this.post.append(this.concatParams("bankcode", this.mPaymentParams.getBankCode()));
                return this.getReturnData(0, "SUCCESS", this.post.toString());
            }
            case "PAYU_MONEY": {
                this.post.append(this.concatParams("bankcode", "PAYUW".toLowerCase()));
                this.post.append(this.concatParams("pg", "wallet"));
                return this.getReturnData(0, "SUCCESS", this.post.toString());
            }
        }
        return this.getReturnData(0, "SUCCESS", this.post.toString());
    }
}

