//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.PostParams;

import com.payu.india.Model.PaymentDefaultParams;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;

/**
 * Created by franklin on 6/19/15.
 * To make a Payment using payumoney pasiawallet need to call {@link PayuWalletPostParams#getPayuWalletPostParams()}
 * {@link PayuWalletPostParams#PayuWalletPostParams(PaymentDefaultParams)}  requires {@link PaymentDefaultParams}
 * {@link PaymentDefaultParams }includes the basic payment mandatory default params
 */
@Deprecated
public class PayuWalletPostParams extends PaymentDefaultPostParams {

    private PaymentDefaultParams paymentDefaultParams;
    private StringBuilder post;

    /**
     * @param paymentDefaultParams Should have the all the mandatory params such as key, amount, txnid, productinfo, firstname, email, udf1..5, and other optional fields if any.
     */
    @Deprecated
    public PayuWalletPostParams(PaymentDefaultParams paymentDefaultParams) {
        super(paymentDefaultParams);
        this.paymentDefaultParams = paymentDefaultParams;
    }

    /**
     * Once the {@link PaymentDefaultParams} set then you can call {@link PayuWalletPostParams#getPayuWalletPostParams()}
     * {@link CCDCPostParams#getPaymentDefaultPostParams()}  } will return {@link PostData}. All validation will be taken place there only.
     * if it passes everything {@link PostData#getResult()} will give the postData else it gives the error reason.
     * Set pg as {@link PayuConstants#WALLET}and set the bank code as {@link PayuConstants#PAYUW}
     *
     * @return {@link PostData}
     */
    @Deprecated
    public PostData getPayuWalletPostParams() {
        PostData postData = getPaymentDefaultPostParams();
        if (postData.getCode() == PayuErrors.NO_ERROR) {
            post = new StringBuilder();
            post.append(postData.getResult());
            post.append(concatParams(PayuConstants.BANK_CODE, PayuConstants.PAYUW.toLowerCase()));
            post.append(concatParams(PayuConstants.PG, PayuConstants.WALLET));

            return getReturnData(PayuErrors.NO_ERROR, PayuConstants.SUCCESS, trimAmpersand(post.toString()));
        } else {
            return postData;
        }
    }
}
