//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.


package com.payu.india.Extras;

/**
 * Created by franklin on 7/7/15.
 * Simple sdk helper class helps the developer/merchant/qc to find out sdk basic details.
 */
public class PayUSdkDetails {

    /**
     * Empty constructor helps to create new instances
     */
    public PayUSdkDetails() {
    } // TODO get Activity instance and read app/device info

    /**
     * Current build number,
     * Every time we make a change, we update this manually!.
     * The format is DDMMYY
     *
     * @return String ex: 07072077
     */
    public String getSdkBuildNumber() {
        return "27072015";
    }

    /**
     * Read and send the version code from build.gradle file of sdk.
     *
     * @return String 7.0
     */
    public String getSdkVersionCode() {
        return "" + com.payu.india.BuildConfig.VERSION_CODE;
    }

    /**
     * Read and send the version name from build.gradle file of sdk.
     *
     * @return String 0.7
     */
    public String getSdkVersionName() {
        return com.payu.india.BuildConfig.VERSION_NAME;
    }

    /**
     * Read and send SDk's app id.
     *
     * @return String 8765
     */
    public String getSdkApplicationId() {
        return com.payu.india.BuildConfig.APPLICATION_ID;
    }

    /**
     * Read and send sdk build flavor
     *
     * @return String free
     */
    public String getSdkFlavor() {
        return com.payu.india.BuildConfig.FLAVOR;
    }

    /**
     * Read and send sdk build type
     *
     * @return String Release
     */
    public String getSdkBuildType() {
        return com.payu.india.BuildConfig.BUILD_TYPE;
    }
}
