package com.payu.custombrowser.util;

import android.os.AsyncTask;

import com.payu.custombrowser.bean.CustomBrowserAsyncTaskData;
import com.payu.custombrowser.cbinterface.CustomBrowserAsyncTaskInterface;

import java.io.InputStream;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

/**
 * Created by franklin.michael on 23/06/16.
 * Custom browser Generic async task.
 * Should be initialized with {@link CustomBrowserAsyncTaskInterface}
 * The response will be send the implemented class as string.
 * CustomBrowserAsyncTask takes {@link CustomBrowserAsyncTaskData} as input.
 */

public class CustomBrowserAsyncTask extends AsyncTask<CustomBrowserAsyncTaskData, String, String> {

    private CustomBrowserAsyncTaskInterface mCustomBrowserAsyncTaskInterface;
    private String webServiceType;

    private CustomBrowserAsyncTask() {
    } // no object without interface

    public CustomBrowserAsyncTask(CustomBrowserAsyncTaskInterface customBrowserAsyncTaskInterface, String webserviceType) {
        mCustomBrowserAsyncTaskInterface = customBrowserAsyncTaskInterface;
        this.webServiceType = webserviceType;
        L.v("Class Name: "+getClass().getCanonicalName()+"Call " + webserviceType);
    }


    @Override
    protected void onPreExecute() {
        super.onPreExecute();
    }

    /**
     * following should be the possitions
     *
     * @param customBrowserAsyncTaskData
     * @return
     */
    @Override
    protected String doInBackground(CustomBrowserAsyncTaskData... customBrowserAsyncTaskData) {
        CustomBrowserAsyncTaskData mCustomBrowserAsyncTaskData = customBrowserAsyncTaskData[0];
        try {
            URL url = new URL(mCustomBrowserAsyncTaskData.getUrl());
            L.v("Class Name: "+getClass().getCanonicalName()+"URL Verify UPI "+url);
            HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
            conn.setRequestMethod(mCustomBrowserAsyncTaskData.getHttpMethod());
            conn.setSSLSocketFactory(new TLSSocketFactory());
            conn.setConnectTimeout(CBConstant.VERIFY_HTTP_TIMEOUT);
            conn.setRequestProperty("Content-Type", mCustomBrowserAsyncTaskData.getContentType());
            conn.setRequestProperty("Content-Length", "" + (null != mCustomBrowserAsyncTaskData.getPostData() ? mCustomBrowserAsyncTaskData.getPostData().length() : 0));
            byte[] postParamsByte = mCustomBrowserAsyncTaskData.getPostData().getBytes();
            L.v("Class Name: "+getClass().getCanonicalName()+"Request Data Verify: "+mCustomBrowserAsyncTaskData.getPostData());
            conn.getOutputStream().write(postParamsByte);

            InputStream responseInputStream = conn.getInputStream();
            L.v("Class Name: "+getClass().getCanonicalName()+"Response Code : : : " + conn.getResponseCode() + "");
            L.v("Class Name: "+getClass().getCanonicalName()+"Response URL : : : " + conn.getURL());
            L.v("Class Name: "+getClass().getCanonicalName()+"Request : : : " + conn.getRequestMethod());
            StringBuffer responseStringBuffer = new StringBuffer();
            byte[] byteContainer = new byte[1024];
            for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                responseStringBuffer.append(new String(byteContainer, 0, i));
            }
            L.v("Class Name: "+getClass().getCanonicalName()+"VPA Verify Response "+responseStringBuffer.toString());
            return responseStringBuffer.toString();
        } catch (Exception e) {
            e.printStackTrace();
            L.e("Class Name: "+getClass().getCanonicalName()+" Verify Error "+e.getMessage());
            return e.getMessage().toString();

        }
    }



    @Override
    protected void onPostExecute(String s) {
        super.onPostExecute(s);
        L.v("Class Name: "+getClass().getCanonicalName()+"Res " + s);
        mCustomBrowserAsyncTaskInterface.onCustomBrowserAsyncTaskResponse(s, webServiceType);
    }


}
