package com.payu.custombrowser;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;

import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.payu.custombrowser.bean.ReviewOrderData;

import java.util.ArrayList;


/**
 * A simple {@link Fragment} subclass.
 * Activities that contain this fragment must implement the
 * {@link OnReviewOrderDetailCloseListener} interface
 * to handle interaction events.
 * Use the {@link ReviewOrderFragment#newInstance} factory method to
     * create an instance of this fragment.
 */
public class ReviewOrderFragment extends Fragment {

    private static final String REVIEW_ORDER_DETAIL_LIST = "review_order_detail_list";
    private static final String LAYOUT_RES = "layout_res";

    private ArrayList<ReviewOrderData> reviewOrderDetailList;
    private int resLayout;
    private OnReviewOrderDetailCloseListener mListener;
    private int reviewHeight;
    public ReviewOrderFragment() {
        // Required empty public constructor
    }

    /**
     * Use this factory method to create a new instance of
     * this fragment using the provided parameters.
     *
     * @param reviewOrderDetailList Parameter 1.
     * @return A new instance of fragment ReviewOrderFragment.
     */
    // TODO: Rename and change types and number of parameters
    public static ReviewOrderFragment newInstance(ArrayList<ReviewOrderData> reviewOrderDetailList, @LayoutRes int resLayout) {
        ReviewOrderFragment fragment = new ReviewOrderFragment();
        Bundle args = new Bundle();
        args.putParcelableArrayList(REVIEW_ORDER_DETAIL_LIST, reviewOrderDetailList);
        args.putInt(LAYOUT_RES, resLayout);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            reviewOrderDetailList = getArguments().getParcelableArrayList(REVIEW_ORDER_DETAIL_LIST);
            resLayout = getArguments().getInt(LAYOUT_RES);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_review_order, container, false);
        return view;

    }

    @Override
    public void onViewCreated(final View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        LinearLayout layout = (LinearLayout) view.findViewById(R.id.payu_review_order_list);
        if (resLayout == -1) {
            if(reviewOrderDetailList!=null) {
                for (ReviewOrderData reviewOrderDetail : reviewOrderDetailList) {
                    View orderDetailsRowView = getActivity().getLayoutInflater().inflate(R.layout.payu_review_order_list_row, null, false);
                    TextView orderDetailKey = (TextView) orderDetailsRowView.findViewById(R.id.t_review_order_details_key);
                    TextView orderDetailValue = (TextView) orderDetailsRowView.findViewById(R.id.t_review_order_details_value);
                    orderDetailKey.setText(reviewOrderDetail.getKey());
                    orderDetailValue.setText(reviewOrderDetail.getValue());
                    layout.addView(orderDetailsRowView);
                }
            }
        } else {
            View orderDetailsRowView = getActivity().getLayoutInflater().inflate(resLayout, null, false);
            RelativeLayout reviewOrderViewLayout = ((RelativeLayout) view.findViewById(R.id.r_payu_review_order));
            reviewOrderViewLayout.removeAllViews();
            reviewOrderViewLayout.addView(orderDetailsRowView);
           // layout.addView(orderDetailsRowView);
        }
        optimiseReviewFragmentHeight(view);
        view.findViewById(R.id.i_payu_close_review).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                v.setEnabled(false);
                v.setClickable(false);
                mListener.onFragmentInteraction();

                TranslateAnimation animate = new TranslateAnimation(0, 0, 0,reviewHeight);
                animate.setDuration(500);
                animate.setFillBefore(false);
                animate.setFillEnabled(true);
                animate.setZAdjustment(TranslateAnimation.ZORDER_TOP);
                view.startAnimation(animate);

                final Handler handlertrans = new Handler();
                handlertrans.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if(getActivity()!=null && !getActivity().isFinishing()) {
                            view.setVisibility(View.GONE);
                            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                            ft.remove(ReviewOrderFragment.this);
                            ft.commit();
                        }
                    }
                }, 450);



            }
        });
    }

    // TODO: Rename method, update argument and hook method into UI event
    public void onButtonPressed(Uri uri) {
        if (mListener != null) {
            mListener.onFragmentInteraction();
        }
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof OnReviewOrderDetailCloseListener) {
            mListener = (OnReviewOrderDetailCloseListener) context;
        } else {
            throw new RuntimeException(context.toString()
                    + " must implement OnReviewOrderDetailCloseListener");
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        mListener = null;
    }

    /**
     * This interface must be implemented by activities that contain this
     * fragment to allow an interaction in this fragment to be communicated
     * to the activity and potentially other fragments contained in that
     * activity.
     * <p>
     * See the Android Training lesson <a href=
     * "http://developer.android.com/training/basics/fragments/communicating.html"
     * >Communicating with Other Fragments</a> for more information.
     */
    public interface OnReviewOrderDetailCloseListener {
        // TODO: Update argument type and name
        void onFragmentInteraction();
    }

    private void optimiseReviewFragmentHeight(View view) {
        DisplayMetrics metrics = new DisplayMetrics();
        getActivity().getWindowManager().getDefaultDisplay().getMetrics(metrics);
        int height = metrics.heightPixels;
        view.measure(View.MeasureSpec.UNSPECIFIED, View.MeasureSpec.UNSPECIFIED);
        reviewHeight =  (int) (height * (0.45));
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT,reviewHeight);
        view.setLayoutParams(layoutParams);
    }
}
