package com.payu.custombrowser.wrapper;

import android.app.Activity;
import android.content.Context;

import com.payu.custombrowser.analytics.CBAnalytics;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.bean.CustomBrowserResultData;
import com.payu.custombrowser.upiintent.UPIPaymentConstants;
import com.payu.custombrowser.upiintent.UPIUtil;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.PaymentOption;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class PhonePeWrapper extends PaymentOptionWrapper {
    private ClassLoader phonepeWrapperClassLoader;
    private Constructor phonepeWrapperConstructor;
    private Class phonepeWrapperClass;
    private Object phonepeWrapperObject;
    private CBAnalytics analytics;
    private Activity activity;
    private CustomBrowserConfig customBrowserConfig;
    private UPIUtil upiUtil;
    /**
     *  Reflection Callback mapping with PayUCustomBrowserCallback and wrapper callback and SamsungPay Wrapper Callback
     */
    private java.lang.reflect.InvocationHandler cbCallback = new java.lang.reflect.InvocationHandler() {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equalsIgnoreCase(CBConstant.PAYMENT_OPTION_SUCCESS)) {
                analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.TRNX_STATUS, CBAnalyticsConstant.SUCCESS_TRANSACTION, null,upiUtil.getValuePostData(customBrowserConfig.getPayuPostData(),CBConstant.KEY) , upiUtil.getValuePostData(customBrowserConfig.getPayuPostData(), UPIPaymentConstants.TXNID), null));
                cbListener.onPaymentSuccess(args[0] + "", null);
            } else if (method.getName().equalsIgnoreCase(CBConstant.PAYMENT_OPTION_FAILURE)) {
                analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.TRNX_STATUS, CBAnalyticsConstant.FAILURE_TRANSACTION, null,upiUtil.getValuePostData(customBrowserConfig.getPayuPostData(),CBConstant.KEY) , upiUtil.getValuePostData(customBrowserConfig.getPayuPostData(), UPIPaymentConstants.TXNID), null));
                cbListener.onPaymentFailure(args[0] + "", null);
            } else if (method.getName().equalsIgnoreCase(CBConstant.PAYMENT_OPTION_INIT_SUCCESS)) {
                CustomBrowserResultData resultData = new CustomBrowserResultData();
                resultData.setPaymentOption(PaymentOption.PHONEPE);
                resultData.setPaymentOptionAvailable(true);
                cbListener.isPaymentOptionAvailable(resultData);
                CustomBrowserData.SINGLETON.setPaymentOption(PaymentOption.PHONEPE);
            } else if (method.getName().equalsIgnoreCase(CBConstant.PAYMENT_OPTION_INIT_FAILURE)) {
                CustomBrowserResultData resultData = new CustomBrowserResultData();
                resultData.setPaymentOption(PaymentOption.PHONEPE);
                resultData.setPaymentOptionAvailable(false);
                resultData.setErrorMessage(args[1] + "");
                cbListener.isPaymentOptionAvailable(resultData);
                CustomBrowserData.SINGLETON.removePaymentOption(PaymentOption.PHONEPE);
            }
            return null;
        }
    };

    /**
     * Function to make payment by phonepe
     *
     * @param activity            activity context
     * @param customBrowserConfig {@link CustomBrowserConfig}
     */
    @Override
    public void makePayment(Activity activity, CustomBrowserConfig customBrowserConfig) {
        try {
            if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null)
                this.cbListener = CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback();
            if (null == phonepeWrapperObject)
                initPhonePe();
            this.activity = activity;
            this.upiUtil = new UPIUtil();
            this.customBrowserConfig = customBrowserConfig;
            this.analytics = CBAnalytics.getInstance(activity.getApplicationContext(),"local_cache_analytics");
            Method method = phonepeWrapperObject.getClass().getMethod("makePayment", Activity.class, String.class, Boolean.class);
            method.invoke(phonepeWrapperObject, activity, customBrowserConfig.getPayuPostData(), customBrowserConfig.getIsPhonePeUserCacheEnabled() == CustomBrowserConfig.TRUE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initPhonePe() {
        try {
            phonepeWrapperClassLoader = PhonePeWrapper.class.getClassLoader();
            phonepeWrapperClass = phonepeWrapperClassLoader.loadClass("com.payu.phonepe.PhonePeWrapper");
            phonepeWrapperConstructor = phonepeWrapperClass.getDeclaredConstructor(java.lang.reflect.InvocationHandler.class);
            phonepeWrapperConstructor.setAccessible(true);
            phonepeWrapperObject = phonepeWrapperConstructor.newInstance(cbCallback);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Function to check for phonepe availability
     *
     * @param context           Context
     * @param paymentOptionHash Payment Related Details Hash
     * @param merchantKey       Merchant Key
     * @param user_credentials  User Credentials
     */
    @Override
    public void checkForPaymentOptionAvailability(Context context, String paymentOptionHash, String merchantKey, String user_credentials) {
        if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null)
            this.cbListener = CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback();
        try {
            initPhonePe();
            Method method = phonepeWrapperObject.getClass().getMethod("checkForPaymentAvailability", Context.class, String.class, String.class, String.class);
            method.invoke(phonepeWrapperObject, context, paymentOptionHash, merchantKey, user_credentials);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
