package com.payu.custombrowser.util;

import android.app.Activity;

import com.payu.custombrowser.PayUCustomBrowserCallback;
import com.payu.custombrowser.analytics.CBAnalytics;
import com.payu.custombrowser.bean.CustomBrowserAsyncTaskData;
import com.payu.custombrowser.bean.CustomBrowserResultData;
import com.payu.custombrowser.cbinterface.CustomBrowserAsyncTaskInterface;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by himanshu.gupta on 08/03/18.
 */

public class PaymentOptionHandler implements CustomBrowserAsyncTaskInterface {

    private PayUCustomBrowserCallback payUCustomBrowserCallback;
    private String merchantKey;
    private String paymentOptionHash;
    private String user_credentials;
    private Activity activity;
    public PaymentOptionHandler(Activity activity,PayUCustomBrowserCallback payUCustomBrowserCallback, String merchantKey, String paymentOptionHash, String user_credentials) {
        this.payUCustomBrowserCallback = payUCustomBrowserCallback;
        this.merchantKey = merchantKey;
        this.paymentOptionHash = paymentOptionHash;
        this.user_credentials = user_credentials;
        this.activity= activity;
        checkPayment();
    }

    private void checkPayment() {
        CustomBrowserAsyncTaskData customBrowserAsyncTaskData = new CustomBrowserAsyncTaskData();
        customBrowserAsyncTaskData.setHttpMethod("POST");
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(createPostData());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        jsonArray.put(jsonObject);
        customBrowserAsyncTaskData.setPostData(jsonArray.toString());
        customBrowserAsyncTaskData.setUrl(CBAnalytics.ANALYTICS_URL);
        CustomBrowserAsyncTask customBrowserAsyncTask = new CustomBrowserAsyncTask(this);
        customBrowserAsyncTask.execute(customBrowserAsyncTaskData);
    }

    private String createPostData(){
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CBConstant.COMMAND);
        stringBuilder.append("=");
        stringBuilder.append(CBConstant.PAYMENT_RELATED_DETAILS_FOR_MOBILE_SDK);
        stringBuilder.append("&");
        stringBuilder.append(CBConstant.IMEI);
        stringBuilder.append("=");
        stringBuilder.append(CBUtil.getImei(activity));
        stringBuilder.append("&");
        stringBuilder.append(CBConstant.UDID);
        stringBuilder.append("=");
        stringBuilder.append(CBUtil.getUdid(activity));
        stringBuilder.append("&");
        stringBuilder.append(CBConstant.KEY);
        stringBuilder.append("=");
        stringBuilder.append(merchantKey);
        stringBuilder.append("&");
        stringBuilder.append(CBConstant.HASH);
        stringBuilder.append("=");
        stringBuilder.append(paymentOptionHash);
        stringBuilder.append("&");
        stringBuilder.append(CBConstant.VAR1);
        stringBuilder.append("=");
        stringBuilder.append(user_credentials);
        return stringBuilder.toString();
    }

    @Override
    public void onCustomBrowserAsyncTaskResponse(String cbAsynTaskResponse) {
        CustomBrowserResultData customBrowserResultData = new CustomBrowserResultData();
        customBrowserResultData.setJsonResult(cbAsynTaskResponse);
        payUCustomBrowserCallback.isPaymentOptionAvailable(customBrowserResultData);
    }

}
