package com.payu.custombrowser.services;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;

import com.payu.custombrowser.Bank;
import com.payu.custombrowser.CBActivity;
import com.payu.custombrowser.R;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Random;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;

import static com.payu.custombrowser.util.CBConstant.MERCHANTKEY;
import static com.payu.custombrowser.util.CBConstant.SNOOZE_NOTIFICATION_ID;
import static com.payu.custombrowser.util.CBConstant.TXN_ID;


/**
 * Created by franklin.michael on 29/03/16.
 */
public class SnoozeService extends Service {

    // Threshold time to complete download the image
    private static int IMAGE_DOWNLOAD_TIME_OUT;
    // Living time snoozeof the  service - 30 min

    private int SNOOZE_SERVICE_TTL = CBConstant.DEFAULT_SURE_PAY_TTL;
    // Get webview live status frequency.
    private final int TRACK_WEB_VIEW_TIME_INTERVAL = 500;

    // Intent put extra constants.
    private final String SNOOZE_GET_WEBVIEW_STATUS_INTENT_ACTION = "webview_status_action";
    private final String SNOOZE_BROAD_CAST_MESSAGE = "snooze_broad_cast_message";

    private final String CURRENT_URL = "currentUrl";
    //Retry Url for Surepay s2s html case
    private final String S2S_RETRY_URL = "s2sRetryUrl";
    // Binder for snoozeService - we need this to access snoozeObject from CustomBrowserLifeCycle
    private final IBinder snoozeBinder = new SnoozeBinder();
    String MERCHANT_CHECKOUT_ACTIVITY = "merchantCheckoutActivity";
    // using a handler's post delay to calculate internet speed
    private Handler handler;
    // Runner used with handler to calculate internet speed.
    private Runnable runnable;
    // using handler's post delay to track webview status every one min.
    private Handler trackWebViewStatusHandler;
    // New thread for the service
    private HandlerThread snoozeHandlerThread;
    // Timer which expires on SNOOZE_SERVICE_TTL to destroy the service
    private CountDownTimer killSnoozeServiceCounter;
    // looper from the snoozeHandlerTread for serviceHandler.
    private Looper mServiceLooper;
    // Handler running with snoozeHandlerThread.
    private ServiceHandler mServiceHandler;
    // n/w download start time
    private long startTime;
    // n/w download complete time
    private long endTime;
    // exponential backoff time for checking network download.
    private int exponentialBackOffTime = 1000;
    // exponential backoff time threshold;
    private int EXPONENTIAL_BACKOFF_TIME_THRESHOLD = 60000; // 5 min = 5 * 60 * 1000  = 300000ms. ;
    // Time taken to download the image.
    private long imageDownloadTime;
    // message broad casted from service
    private String broadCastingMessage = "";
    // message received from activity.
    private String receivedMessage = "";
    // notification intent variables.
    // Complete post data.
    private String postData = "";
    private String postURL = "";
    // current url which was being loaded on webview on the time user clicks snooze button.
    private String currentUrl = "";
    //Retry Url for Surepay s2s html case
    private String s2sRetryUrl = "";
    private String merchantKey = "";
    private String txnId = "";
    private String merchantCheckoutActivity;
    // Snooze service Flags.
    // Are we able to download the image with in IMAGE_DOWNLOAD_TIME_OUT
    private boolean isImageDownloadTimedOut;
    // Flag to keep track of service live status. - All the timer and threads should be running if and only if service is live.
    private boolean isServiceAlive = true;
    // Flag to keep track of webview status.
    private boolean isWebViewAlive;
    // Flag to tell notification is launched or not.
    private boolean isNotificationIntentPrepared;
    // Flag to tell whether the notification intent is webview intent or merchant checkout intent.
    private boolean isWebViewIntentPrepared;
    private long timeToNotify;
    private boolean verifyPaymentCheck;
    private String verifyURL = Bank.DEBUG ? "https://mobiletest.payu.in/merchant/postservice?form=2" : "https://info.payu.in/merchant/postservice?form=2";
    private CustomBrowserConfig customBrowserConfig;
    private String payuResponse;
    private CBUtil cbUtil;
    private String verifyParam;
    private HashMap<String, String> postParamsMap;
    private String surePayS2SPayUId=null;
    private String sessionId=null;

    /**
     * Verify API is call to verify the payment
     * Verify Api return the transaction status (Failure or success)
     */
    private Runnable verifyPaymentRunnable = new Runnable() {

        @Override
        public void run() {
            try {

                URL url = new URL(verifyURL);
                HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
                String payuId =null;
                String phpSessionId =null;
                String key =null;
                String txnid =null;
                if(!TextUtils.isEmpty(cbUtil.getCookie("PAYUID", getApplicationContext()))){
                    payuId =cbUtil.getCookie("PAYUID", getApplicationContext());
                }else if(!TextUtils.isEmpty(surePayS2SPayUId)){
                    payuId = surePayS2SPayUId;
                }
                if(!TextUtils.isEmpty(cbUtil.getCookie("PHPSESSID", getApplicationContext()))){
                    phpSessionId =cbUtil.getCookie("PHPSESSID", getApplicationContext());
                }else if(!TextUtils.isEmpty(sessionId)){
                    phpSessionId = sessionId;
                }else if(TextUtils.isEmpty(sessionId)){
                    phpSessionId ="123456";//Don't send empty session id
                }
                if(!TextUtils.isEmpty(postData)) {
                    key = cbUtil.getDataFromPostData(postData, "key");
                    txnid = cbUtil.getDataFromPostData(postData, "txnid");
                }else {
                    key = merchantKey;
                    txnid = txnId;
                }

                String post = "command=verifyTxnStatus&var1=" + txnid + "&key=" + key + "&priorityParam=" + verifyParam;
                conn.setRequestMethod("POST");
                conn.setConnectTimeout(CBConstant.VERIFY_HTTP_TIMEOUT);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Content-Length", String.valueOf(post.length()));
                // setting cookie(php session ID ad payuID) to request
                conn.setRequestProperty("Cookie", "PHPSESSID=" + phpSessionId + "; PAYUID=" + payuId);
                conn.setDoOutput(true);
                byte[] postParamsByte = post.getBytes();
                conn.getOutputStream().write(postParamsByte);

                byte[] buffer = new byte[1024];
                // Do some busy waiting while the stream is open.
                if (conn.getResponseCode() == 200) {
                    if (conn.getInputStream() != null) {
                        StringBuffer responseStringBuffer = CBUtil.getStringBufferFromInputStream(conn.getInputStream());
                        if (responseStringBuffer != null) {
                            JSONObject jsonObject = new JSONObject(responseStringBuffer.toString());
                            payuResponse = responseStringBuffer.toString();
                            onTransactionStatusReceived(responseStringBuffer.toString());
                        }
                    }
                }else{
                    onTransactionStatusReceived("{\"api_status\":\"0\",\"message\":\"Some error occurred\"}");
                }
            } catch (Exception e) {
                onTransactionStatusReceived("{\"api_status\":\"0\",\"message\":\"Some exception occurred\"}");
                e.printStackTrace();
            }

        }
    };


    /**
     * Method to launch notification or update ui based of app status.
     * @param response response received from payu server.
     */
    private void onTransactionStatusReceived(String response){

        try {
            String verifyApiStatus = cbUtil.getValueOfJSONKey(response, getString(R.string.cb_snooze_verify_api_status));
            if(CBActivity.STATE == CBConstant.STATE_PAUSED){ // App is in background
                if(verifyApiStatus.contentEquals(CBConstant.TRANSACTION_STATUS_SUCCESS)) { // Transaction status verified.
                    broadcastAnalyticsEvent(CBAnalyticsConstant.TRANSACTION_VERIFIED_NOTIFICATION, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                }else { // transaction status not verified.
                    broadcastAnalyticsEvent(CBAnalyticsConstant.TRANSACTION_NOT_VERIFIED_NOTIFICATION, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                }
                launchNotificationTransactionUpdate(response);
            }else{ // app is in foreground .
                if(verifyApiStatus.contentEquals(CBConstant.TRANSACTION_STATUS_SUCCESS)) { // Transaction status verified.
                    broadcastAnalyticsEvent(CBAnalyticsConstant.TRANSACTION_VERIFIED_DIALOG_FOREGROUND, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                }else { // transaction status not verified.
                    broadcastAnalyticsEvent(CBAnalyticsConstant.TRANSACTION_NOT_VERIFIED_DIALOG_FOREGROUND, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                }
                // broadcast the message.
                broadcastEvent(CBConstant.BACKWARD_JOURNEY_STATUS, response, false);
                // If app is on foreground, UI will get update, so we can kill service.
                killSnoozeService();
            }
        } catch (JSONException e) {
            e.printStackTrace();
            if(CBActivity.STATE == CBConstant.STATE_PAUSED){ // App is in background
                broadcastAnalyticsEvent(CBAnalyticsConstant.TRANSACTION_NOT_VERIFIED_NOTIFICATION, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                // Launch notification.
                launchNotificationTransactionUpdate(response);
            }else{ // app is in foreground.
                broadcastAnalyticsEvent(CBAnalyticsConstant.TRANSACTION_NOT_VERIFIED_DIALOG_FOREGROUND, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                // update UI
                broadcastEvent(CBConstant.BACKWARD_JOURNEY_STATUS, response, false);
                // If app is on foreground, UI will get update, so we can kill service.
                killSnoozeService();
            }
        }
    }


    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        // Service has been bound, webview is live.
        isWebViewAlive = true;
        return snoozeBinder;
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
//        return super.onStartCommand(intent, flags, startId);

        cbUtil = new CBUtil();

        // Check for if payment need to vve verified
        merchantCheckoutActivity = intent.getStringExtra(MERCHANT_CHECKOUT_ACTIVITY);
        customBrowserConfig = intent.getParcelableExtra(CBConstant.CB_CONFIG);
        SNOOZE_SERVICE_TTL = customBrowserConfig.getSurePayBackgroundTTL();
        postParamsMap = cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData());
        IMAGE_DOWNLOAD_TIME_OUT = Bank.snoozeImageDownloadTimeout > 0 ? Bank.snoozeImageDownloadTimeout : 10000;

        // IMAGE_DOWNLOAD_TIME_OUT=1;
        if (intent.getExtras().containsKey(CBConstant.VERIFICATION_MSG_RECEIVED) && intent.getExtras().getBoolean(CBConstant.VERIFICATION_MSG_RECEIVED)) {
            // verify payment check
            verifyPaymentCheck = true;
            if (intent.getExtras().containsKey(CBConstant.VERIFY_ADDON_PARAMS)) {
                verifyParam = intent.getExtras().getString(CBConstant.VERIFY_ADDON_PARAMS);
            }
            postData = customBrowserConfig.getPayuPostData();
            postURL = customBrowserConfig.getPostURL();
            merchantKey = intent.getStringExtra(MERCHANTKEY);
            txnId = intent.getStringExtra(TXN_ID);
            surePayS2SPayUId = intent.getStringExtra(CBConstant.PAYUID);

        } else {
            verifyPaymentCheck = false;
            // Reading the incoming intent data.
            currentUrl = intent.getStringExtra(CURRENT_URL);
            s2sRetryUrl = intent.getStringExtra(S2S_RETRY_URL);
        }

        // lets start listening network
        // For each start request, send a message to start a job and deliver the
        // start ID so we know which request we're stopping when we finish the job
        Message msg = mServiceHandler.obtainMessage();
        msg.arg1 = startId;
        mServiceHandler.sendMessage(msg);
        // We need to restart the service with original intent if the service dies.
        if(Bank.hasToStart) {
            return START_REDELIVER_INTENT;
        }else {
            //No need to restart the service if surepay autoresume
            return START_NOT_STICKY;
        }
    }

    @Override
    public void onCreate() {
        // Start up the thread running the service.  Note that we create a
        // separate thread because the service normally runs in the process's
        // main thread, which we don't want to block.  We also make it
        // background priority so CPU-intensive work will not disrupt our UI.

        String SNOOZE_SERVICE_HANDLER_THREAD = "SnoozeServiceHandlerThread";
        snoozeHandlerThread = new HandlerThread(SNOOZE_SERVICE_HANDLER_THREAD, Process.THREAD_PRIORITY_BACKGROUND);
        snoozeHandlerThread.start();

        // Get the HandlerThread's Looper and use it for our Handler
        mServiceLooper = snoozeHandlerThread.getLooper();
        mServiceHandler = new ServiceHandler(mServiceLooper);
    }

    /**
     * Method to kill the snooze service.
     * Cancel all timers and threads if possible.
     * Should be accessible to outside world, Webview should be able to destroy the service.
     */
    public void killSnoozeService() {
        isServiceAlive = false;
        if (killSnoozeServiceCounter != null) {
            killSnoozeServiceCounter.cancel();
            killSnoozeServiceCounter = null;
        }
        snoozeHandlerThread.interrupt(); // This wont help though.
        stopSelf();
    }

    /**
     * Method sets the webview status from Custombrowser.
     * Once Custombrowser's broad cast receiver receives a message, it calls update webview status to update webview status.
     *
     * @param webviewStatus message received from custombrowser.
     */
    public void updateWebviewStatus(String webviewStatus) {
        receivedMessage = webviewStatus;
    }

    /**
     * Calculate internet speed, only if the service is alive.
     * Use handler's post delay to repeat the steps till detect good network strength.
     */
    private void calculateInternetSpeed() {
        handler = new Handler(mServiceLooper);
        runnable = new Runnable() {
            @Override
            public void run() {
                if (isServiceAlive) {
                    downloadImage();
                }
            }
        };
        handler.postDelayed(runnable, Math.min(exponentialBackOffTime, EXPONENTIAL_BACKOFF_TIME_THRESHOLD));
    }

    /**
     * function to calculate the image download speed.
     */
    private void downloadImage() {
        isImageDownloadTimedOut = false;
        final String imageURL = CBConstant.SNOOZE_IMAGE_DOWNLOAD_END_POINT + CBConstant.SNOOZE_IMAGE_COLLECTIONS[new Random().nextInt(2)];
        final CountDownTimer imageDownloadTimer = new CountDownTimer(IMAGE_DOWNLOAD_TIME_OUT, 1000) {
            @Override
            public void onTick(long l) {
            }

            @Override
            public void onFinish() {
                this.cancel();
                isImageDownloadTimedOut = true;
            }
        };

        imageDownloadTimer.start();

        // Creating a separate thread inorder to run the imageDownloadTimer smoothly.
        Thread downloadImageThread = new Thread(new Runnable() {
            @Override
            public void run() {
                try {

                    // Even before making image download call we identify whether we have internet connection or not.
                    // if we dont have this check in case of no internet we will get io exception and we dont start the image download again.
                    // We dont want to keep trying if the url has some problem.
                    if (cbUtil.isNetworkAvailable(getApplicationContext())) {
                        startTime = System.currentTimeMillis();
                        // Open a stream to download the image from our URL.
                        URLConnection connection = new URL(imageURL).openConnection();
                        connection.setUseCaches(false);
                        connection.connect();
                        int imageSize = connection.getContentLength();
                        InputStream input = connection.getInputStream();

                        byte[] buffer = new byte[1024];

                        // Do some busy waiting while the stream is open.

                        while (!isImageDownloadTimedOut && input.read(buffer) != -1) {
                            // Reading input stream
                        }

                        if (isImageDownloadTimedOut) { // time out.
                            imageDownloadTimer.cancel();
                            input.close();
                            // it was imageDownloadTime=-1
                            imageDownloadTime = IMAGE_DOWNLOAD_TIME_OUT + 1;
                        } else { // Download completed before time out.
                            imageDownloadTimer.cancel();
                            endTime = System.currentTimeMillis();
                            input.close();
                            imageDownloadTime = endTime - startTime;

                        }
                        if (imageDownloadTime > IMAGE_DOWNLOAD_TIME_OUT) { // took more time to download than threshold time!, we will retry exponential back off time.
                            exponentialBackOffTime += exponentialBackOffTime;
                            // calculating internet speed after exponential back off time.
                            handler.postDelayed(runnable, Math.min(exponentialBackOffTime, EXPONENTIAL_BACKOFF_TIME_THRESHOLD));
                        } else { // We have a better connection  now.
                            if (isServiceAlive) {
                                // logging analytics from here instead of launchSnooze because its been used by both forward and backward journey.
                                // replaced with new event
                                //broadcastAnalyticsEvent(CBAnalyticsConstant.SNOOZE_NOTIFICATION_TYPE, CBAnalyticsConstant.INTERNET_RESTORED);
                                if (verifyPaymentCheck) {
                                    broadcastAnalyticsEvent(CBAnalyticsConstant.SNOOZE_VERIFY_API_STATUS, CBAnalyticsConstant.SNOOZE_VERIFY_API_CALLED);
                                  //  verifyPayment.start();
                                   new Thread(verifyPaymentRunnable).start();
                                } else { // forward journey
                                    // launch notification with webview intent.
                                    if(CBActivity.STATE == CBConstant.STATE_RESUMED){ // Activity is on foreground
                                        broadcastEvent(getString(R.string.internet_restored), getString(R.string.resuming_your_transaction), true);
                                        // Inter net restored and the app is in foreground.
                                         broadcastAnalyticsEvent(CBAnalyticsConstant.INTERNET_RESTORED_DIALOG_FOREGROUND, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);

                                        // Webview is on foreground!, kill the snooze service.
                                        killSnoozeService();
                                    }else{ // activity is not on foreground
                                        launchNotification(isWebViewAlive);
                                        // This event should be launched only if app is in bacgroud (only if notification launched.)
                                        broadcastAnalyticsEvent(CBAnalyticsConstant.INTERNET_RESTORED_NOTIFICATION , CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                                    }
                                }
                            }
                        }
                    } else {
                        handler.postDelayed(runnable, Math.min(exponentialBackOffTime, EXPONENTIAL_BACKOFF_TIME_THRESHOLD));
                    }
                } catch (MalformedURLException e) {
                    imageDownloadTime = -1;
                    imageDownloadTimer.cancel();
                    e.printStackTrace();
                } catch (SSLException e) {
                    // Here ssl exception come when the internet completely goes off while downloading image. Due to handshake
                    // This case we need to try anain.
                    handler.postDelayed(runnable, Math.min(exponentialBackOffTime, EXPONENTIAL_BACKOFF_TIME_THRESHOLD));
                    e.printStackTrace();
                } catch (IOException e) {
                    imageDownloadTime = -1;
                    imageDownloadTimer.cancel();
                    e.printStackTrace();
                } catch (Exception e) {
                    imageDownloadTime = -1;
                    imageDownloadTimer.cancel();
                }
            }
        });
        downloadImageThread.start();
    }

    /**
     * Function takes care of launching notification.
     *
     * @param webViewLiving living status of webview
     */
    private void launchNotification(boolean webViewLiving) {

        // We are no longer using it.
        //broadcastAnalyticsEvent(CBAnalyticsConstant.SNOOZE_NOTIFICATION_PREPARE_TIME, "" + timeToNotify);

        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this,customBrowserConfig.getSurePayNotificationChannelId());
        mBuilder.setContentTitle(customBrowserConfig.getSurePayNotificationGoodNetworkTitle())
                .setContentText(customBrowserConfig.getSurePayNotificationGoodNetWorkHeader())
                .setSmallIcon(customBrowserConfig.getSurePayNotificationIcon())
                .setAutoCancel(true)
                .setPriority(NotificationCompat.PRIORITY_HIGH)
                .setDefaults(Notification.DEFAULT_VIBRATE)
                .setStyle(new NotificationCompat.BigTextStyle()
                        .bigText(customBrowserConfig.getSurePayNotificationGoodNetWorkHeader() + "\n\n" + customBrowserConfig.getSurePayNotificationGoodNetWorkBody()));


        // We need to find the product info and amount;

        if (Build.VERSION.SDK_INT >= 23) {
            mBuilder.setColor(getResources().getColor(R.color.cb_blue_button, null));
        } else {
            mBuilder.setColor(getResources().getColor(R.color.cb_blue_button));
        }
        isNotificationIntentPrepared = true;

        Intent notifyIntent = new Intent();
        notifyIntent.putExtra(CURRENT_URL, currentUrl);
        notifyIntent.putExtra(S2S_RETRY_URL, s2sRetryUrl);
        notifyIntent.putExtra(CBConstant.SENDER, CBConstant.SNOOZE_SERVICE);
        boolean isValidMerchantCheckoutActivity = true;
        if (webViewLiving) {
            //broadcastAnalyticsEvent(CBAnalyticsConstant.CB_NOTIFICATION_LAUNCHED_TIME,Bank.getSystemCurrentTime() );
            isWebViewIntentPrepared = true;
            notifyIntent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
            notifyIntent.putExtra(CURRENT_URL, currentUrl);
            notifyIntent.putExtra(CBConstant.CB_CONFIG, customBrowserConfig);
            notifyIntent.setClass(getApplicationContext(), CBActivity.class);

        } else {
            // intent to check whether the given merchant checkout activity is a valid activity or not.
            Intent checkValidActivityIntent = new Intent();
            checkValidActivityIntent.setClassName(getApplicationContext(), merchantCheckoutActivity == null ? "" : merchantCheckoutActivity);
            if (null != checkValidActivityIntent.resolveActivityInfo(getPackageManager(), 0)) { // it is a valid activity.
                notifyIntent.setClassName(getApplicationContext(), merchantCheckoutActivity);
                // post type added for merchant to differentiate between fwd and backward journey
                notifyIntent.putExtra(CBConstant.POST_TYPE, "sure_pay_payment_data"); // TODO : rename it to snooze_payment_data
                notifyIntent.putExtra(CBConstant.POST_DATA, customBrowserConfig.getPayuPostData());
            }else{
                isValidMerchantCheckoutActivity = false;
            }
            broadcastAnalyticsEvent(CBAnalyticsConstant.SNOOZE_NOTIFICATION_EXPECTED_ACTION, CBAnalyticsConstant.MERCHANT_CHECKOUT_PAGE);
            //broadcastAnalyticsEvent(CBAnalyticsConstant.MERCHANT_CHECKOUT_NOTIFICATION_LAUNCHED_TIME, Bank.getSystemCurrentTime());
            isWebViewIntentPrepared = false;


            // web view is not live
            killSnoozeService();
        }


        // throw exception to let the merchant know about Activity not found.
        try {
            if (!isValidMerchantCheckoutActivity) {
                throw new ActivityNotFoundException("The Activity " + merchantCheckoutActivity + " is not found, Please set valid activity ");
            }else {
                // Creates the PendingIntent
                PendingIntent notifyPendingIntent = PendingIntent.getActivity(getApplicationContext(), 0, notifyIntent, PendingIntent.FLAG_UPDATE_CURRENT);

                // Puts the PendingIntent into the notification builder
                mBuilder.setContentIntent(notifyPendingIntent);
                // Notifications are issued by sending them to the
                // NotificationManager system service.
                // Builds an anonymous Notification object from the builder, and
                // passes it to the NotificationManager

                // replaced with new event
                // broadcastAnalyticsEvent(CBAnalyticsConstant.SNOOZE_NOTIFICATION_TIME, Bank.getSystemCurrentTime());
                NotificationManager mNotificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
                mNotificationManager.notify(SNOOZE_NOTIFICATION_ID, mBuilder.build());


                // broadcast an event to Custom browser, to say a notification has been launched.
                broadcastEvent(CBConstant.GOOD_NETWORK_NOTIFICATION_LAUNCHED, "true", true);
            }
        } catch (ActivityNotFoundException e) {
            e.printStackTrace();
        }
    }

    /**
     * Broadcast the analytics event which is received by activity
     *
     * @param key   event key
     * @param value event value
     */
    private void broadcastAnalyticsEvent(String key, String value) {
        Intent broadCastIntent = new Intent(SNOOZE_GET_WEBVIEW_STATUS_INTENT_ACTION);
        broadCastIntent.putExtra(CBAnalyticsConstant.BROAD_CAST_FROM_SNOOZE_SERVICE, true);
        broadCastIntent.putExtra(CBAnalyticsConstant.KEY, key);
        broadCastIntent.putExtra(CBAnalyticsConstant.VALUE, value);
        LocalBroadcastManager.getInstance(SnoozeService.this).sendBroadcast(broadCastIntent);
    }

    /**
     * Launch notification with transaction status
     */
    private void launchNotificationTransactionUpdate(String verifyResponse) {

        try {
            String verifyApiStatus = cbUtil.getValueOfJSONKey(verifyResponse, getString(R.string.cb_snooze_verify_api_status));

            broadcastAnalyticsEvent(CBAnalyticsConstant.SNOOZE_VERIFY_API_RESPONSE_RECEIVED, verifyApiStatus + "");

            // TODO Move NotificationCompat.Builder to a common place
           // if (verifyApiStatus == 1) {
                //replaced with new event
                //broadcastAnalyticsEvent(CBAnalyticsConstant.SNOOZE_NOTIFICATION_TIME, Bank.getSystemCurrentTime());
                //replaced with new event
                //broadcastAnalyticsEvent(CBAnalyticsConstant.SNOOZE_NOTIFICATION_TYPE, CBAnalyticsConstant.TRANSACTION_VERIFIED);
           // } else if (verifyApiStatus == 0) {
                //replaced with new event
                //broadcastAnalyticsEvent(CBAnalyticsConstant.SNOOZE_NOTIFICATION_TIME, Bank.getSystemCurrentTime());
                //replaced with new event
                //broadcastAnalyticsEvent(CBAnalyticsConstant.SNOOZE_NOTIFICATION_TYPE, CBAnalyticsConstant.TRANSACTION_STATUS_UNKNOWN);
           // }

            NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this,customBrowserConfig.getSurePayNotificationChannelId());
            String snoozeNotificationTxnVerifiedBigText = verifyApiStatus.contentEquals(CBConstant.TRANSACTION_STATUS_SUCCESS) ? customBrowserConfig.getSurePayNotificationTransactionVerifiedHeader() + "\n\n" + customBrowserConfig.getSurePayNotificationTransactionVerifiedBody() : customBrowserConfig.getSurePayNotificationTransactionNotVerifiedHeader() + "\n\n" + customBrowserConfig.getSurePayNotificationTransactionNotVerifiedBody();
            mBuilder.setContentTitle(verifyApiStatus.contentEquals(CBConstant.TRANSACTION_STATUS_SUCCESS) ? customBrowserConfig.getSurePayNotificationTransactionVerifiedTitle() : customBrowserConfig.getSurePayNotificationTransactionNotVerifiedTitle())
                    .setContentText(verifyApiStatus.contentEquals(CBConstant.TRANSACTION_STATUS_SUCCESS) ? customBrowserConfig.getSurePayNotificationTransactionVerifiedHeader() : customBrowserConfig.getSurePayNotificationTransactionNotVerifiedHeader())
                    .setSmallIcon(customBrowserConfig.getSurePayNotificationIcon())
                    .setAutoCancel(true)
                    .setPriority(NotificationCompat.PRIORITY_HIGH)
                    .setDefaults(Notification.DEFAULT_VIBRATE)
                    .setStyle(new NotificationCompat.BigTextStyle().bigText(snoozeNotificationTxnVerifiedBigText));

            Intent notifyIntent=new Intent();
            notifyIntent.putExtra(CBConstant.CB_CONFIG, customBrowserConfig);
            isNotificationIntentPrepared = true;
            // payuresponse from verify API
            notifyIntent.putExtra(CBConstant.PAYU_RESPONSE, verifyResponse);
            boolean isValidMerchantCheckoutActivity = true;
            if (isWebViewAlive) {
                notifyIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_SINGLE_TOP);
                //  notifyIntent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
                isWebViewIntentPrepared = true;
                // Creates the PendingIntent
                notifyIntent.putExtra(CBConstant.SENDER, CBConstant.SNOOZE_SERVICE);
                notifyIntent.putExtra(CBConstant.VERIFICATION_MSG_RECEIVED, true);
                notifyIntent.setClass(getApplicationContext(), CBActivity.class);
            } else {
                Intent checkValidActivityIntent = new Intent();
                checkValidActivityIntent.setClassName(getApplicationContext(), merchantCheckoutActivity == null ? "" : merchantCheckoutActivity);
                if (null != checkValidActivityIntent.resolveActivityInfo(getPackageManager(), 0)) { // it is a valid activity.
                notifyIntent.putExtra(CBConstant.POST_DATA, verifyResponse);
                notifyIntent.setClassName(getApplicationContext(), merchantCheckoutActivity);
                notifyIntent.putExtra(CBConstant.POST_TYPE, "verify_response_post_data");
                }else{
                    isValidMerchantCheckoutActivity =  false;
                }
                broadcastAnalyticsEvent(CBAnalyticsConstant.SNOOZE_NOTIFICATION_EXPECTED_ACTION, CBAnalyticsConstant.MERCHANT_CHECKOUT_PAGE);
                isWebViewIntentPrepared = false;
                // web view is not live
                killSnoozeService();
            }

            // throw exception to let the merchant know about Activity not found.
            try {
                if (!isValidMerchantCheckoutActivity) {
                    throw new ActivityNotFoundException("The Activity " + merchantCheckoutActivity + " is not found, Please set valid activity ");
                }else {
                    PendingIntent notifyPendingIntent = PendingIntent.getActivity(this, 0, notifyIntent, PendingIntent.FLAG_UPDATE_CURRENT);

                    // Puts the PendingIntent into the notification builder
                    mBuilder.setContentIntent(notifyPendingIntent);
                    // Notifications are issued by sending them to the
                    // NotificationManager system service.

                    // Builds an anonymous Notification object from the builder, and
                    // passes it to the NotificationManager
                    NotificationManager mNotificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
                    mNotificationManager.notify(CBConstant.TRANSACTION_STATUS_NOTIFICATION_ID, mBuilder.build());

                    // broadcast an event to Custom browser, to say a notification has been launched.
                    broadcastEvent(CBConstant.GOOD_NETWORK_NOTIFICATION_LAUNCHED, verifyResponse, false);
                }
            } catch (ActivityNotFoundException e) {
                e.printStackTrace();
            }
        } catch (Exception e) {

            e.printStackTrace();
        }
    }

    private void launchNoInternetNotification() {

        // replaced with new event
        //broadcastAnalyticsEvent(CBAnalyticsConstant.SNOOZE_NOTIFICATION_TIME, Bank.getSystemCurrentTime());
        // replaced with new event
        //broadcastAnalyticsEvent(CBAnalyticsConstant.SNOOZE_NOTIFICATION_TYPE, CBAnalyticsConstant.NO_INTERNET_FOUND);
        broadcastAnalyticsEvent(CBAnalyticsConstant.SNOOZE_NOTIFICATION_EXPECTED_ACTION, CBAnalyticsConstant.MERCHANT_CHECKOUT_PAGE);

        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this,customBrowserConfig.getSurePayNotificationChannelId());
        mBuilder.setContentTitle(customBrowserConfig.getSurePayNotificationPoorNetWorkTitle())
                .setContentText(customBrowserConfig.getSurePayNotificationPoorNetWorkHeader())
                .setSmallIcon(customBrowserConfig.getSurePayNotificationIcon())
                .setAutoCancel(true)
                .setPriority(NotificationCompat.PRIORITY_HIGH)
                .setDefaults(Notification.DEFAULT_VIBRATE)
                .setStyle(new NotificationCompat.BigTextStyle()
                        .bigText(customBrowserConfig.getSurePayNotificationPoorNetWorkHeader() + customBrowserConfig.getSurePayNotificationPoorNetWorkBody()));


        if (Build.VERSION.SDK_INT >= 23) {
            mBuilder.setColor(getResources().getColor(R.color.cb_blue_button, null));
        } else {
            mBuilder.setColor(getResources().getColor(R.color.cb_blue_button));
        }

        // intent to check whether the given merchant checkout activity is a valid activity or not.
        Intent checkValidActivityIntent = new Intent();
        checkValidActivityIntent.setClassName(getApplicationContext(), merchantCheckoutActivity == null ? "" : merchantCheckoutActivity);
        if (null != checkValidActivityIntent.resolveActivityInfo(getPackageManager(), 0)) { // it is a valid activity.
            Intent notifyIntent = new Intent();
            notifyIntent.setClassName(getApplicationContext(), merchantCheckoutActivity);
            // post type added for merchant to differentiate between fwd and backward journey
            notifyIntent.putExtra(CBConstant.POST_TYPE, "sure_pay_payment_data"); // TODO : rename it to snooze_payment_data
            notifyIntent.putExtra(CBConstant.POST_DATA, customBrowserConfig.getPayuPostData());

            // Creates the PendingIntent
            PendingIntent notifyPendingIntent = PendingIntent.getActivity(this, 0, notifyIntent, PendingIntent.FLAG_UPDATE_CURRENT);

            // Puts the PendingIntent into the notification builder
            mBuilder.setContentIntent(notifyPendingIntent);
            // Notifications are issued by sending them to the
            // NotificationManager system service.

            // Builds an anonymous Notification object from the builder, and
            // passes it to the NotificationManager
            NotificationManager mNotificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
            mNotificationManager.notify(SNOOZE_NOTIFICATION_ID, mBuilder.build()); // Launching with the same notification id.
        }else{
            try{
                throw new ActivityNotFoundException("The Activity " + merchantCheckoutActivity + " is not found, Please set valid activity ");
            }catch(ActivityNotFoundException e){
                e.printStackTrace();
            }
        }
    }

    // Handler that receives messages from the thread
    private final class ServiceHandler extends Handler {

        public ServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            // if(!verifyPaymentCheck) {
            // Normally we would do some work here, like download a file.
            // here we start listening phone state changing.
            // Don't forget to stop this service once received the better n/w
            isServiceAlive = true;
            // Initializing and starting killSnoozeCountDownTimer to kill the service in 30 min
            killSnoozeServiceCounter = new CountDownTimer(SNOOZE_SERVICE_TTL, 5000) {
                @Override
                public void onTick(long l) {
                    timeToNotify = (SNOOZE_SERVICE_TTL - l) / 1000;
                }

                @Override
                public void onFinish() { // done
                    // if we could not find better internet before service dies we launch the notification anyways. (does not matter webview is alive or not.)
                    // The only thing we need to take care is there is no notification launched already.
                    // if the activity is on background then only launch notification.
                    if (!isNotificationIntentPrepared && CBActivity.STATE == CBConstant.STATE_PAUSED) {
                        // Good internet not found yet.
                        launchNoInternetNotification();

                        // Good network is not found, app in background, and service dies.
                        broadcastAnalyticsEvent(CBAnalyticsConstant.INTERNET_NOT_RESTORED_NOTIFICATION, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                    }else if(!isNotificationIntentPrepared && CBActivity.STATE == CBConstant.STATE_RESUMED){
                        // Internet not restored, and app is in foreground, service dies
                        broadcastAnalyticsEvent(CBAnalyticsConstant.INTERNET_NOT_RESTORED_DIALOG_FOREGROUND, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                    }

                    /**
                     * if webview is live we update the snoozeDialog with new message
                     * else we launch a notification with empty intent.
                     * And if any notification launched already, Let the service die peacefully!.
                     * Then kill the service.
                     * This event will finish the webview activity. So this broadcast should be the last statement.
                     */
                    if (isWebViewAlive && !isNotificationIntentPrepared) {
                        // Broadcast message to Activity to check Webview's status
                        Intent broadCastIntent = new Intent(SNOOZE_GET_WEBVIEW_STATUS_INTENT_ACTION);
                        broadCastIntent.putExtra(CBConstant.SNOOZE_SERVICE_STATUS, CBConstant.SNOOZE_SERVICE_DEAD);
                        LocalBroadcastManager.getInstance(SnoozeService.this).sendBroadcast(broadCastIntent);
                    }

                    killSnoozeService();
                }
            };
            killSnoozeServiceCounter.start();

            // Keeps tracking of webview status.
            // get the webview status in isWebViewAlive variable.
            trackWebViewStatusHandler = new Handler();
            trackWebViewStatusHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    if (isServiceAlive) { // Broadcast message only if the service is alive.
                        if (broadCastingMessage.contentEquals(receivedMessage)) {
                            // Web view is alive
                            isWebViewAlive = true;
                        } else {
                            isWebViewAlive = false;
                            if (isServiceAlive && verifyPaymentCheck && isNotificationIntentPrepared && isWebViewIntentPrepared) {
                                launchNotificationTransactionUpdate(payuResponse);
                            } else if (isServiceAlive && isNotificationIntentPrepared && isWebViewIntentPrepared) {
                                launchNotification(isWebViewAlive);
                            }
                        }


                        // we post every four sec
                        trackWebViewStatusHandler.postDelayed(this, TRACK_WEB_VIEW_TIME_INTERVAL);

                        // Broadcast message to Activity to check Webview's status
                        Intent broadCastIntent = new Intent(SNOOZE_GET_WEBVIEW_STATUS_INTENT_ACTION);
                        broadCastingMessage = "" + System.currentTimeMillis();
                        broadCastIntent.putExtra(SNOOZE_BROAD_CAST_MESSAGE, broadCastingMessage);
                        LocalBroadcastManager.getInstance(SnoozeService.this).sendBroadcast(broadCastIntent);

                    }
                }
            }, TRACK_WEB_VIEW_TIME_INTERVAL);
            //  }

            // identify good internet speed.
            calculateInternetSpeed();
        }

    }

    /**
     * Custom binder which returns instance of snoozeService.
     */
    public class SnoozeBinder extends Binder {
        public SnoozeService getSnoozeService() {
            return SnoozeService.this;
        }
    }

    /**
     * Broad cast message to activity
     * @param key, key
     * @param value, value.
     * @param isForward true if forward journey,
     */
    private void broadcastEvent(String key, String value, boolean isForward){
        Intent broadCastIntent = new Intent(SNOOZE_GET_WEBVIEW_STATUS_INTENT_ACTION);
        broadCastIntent.putExtra(CBConstant.BROADCAST_FROM_SERVICE_UPDATE_UI, true);
        broadCastIntent.putExtra(CBConstant.KEY, key);
        broadCastIntent.putExtra(CBConstant.VALUE, value);
        broadCastIntent.putExtra(CBConstant.CURRENT_URL, currentUrl);
        broadCastIntent.putExtra(CBConstant.S2S_RETRY_URL,s2sRetryUrl);
        broadCastIntent.putExtra(CBConstant.CB_CONFIG, customBrowserConfig);
        broadCastIntent.putExtra(CBConstant.IS_FORWARD_JOURNEY, isForward);
        LocalBroadcastManager.getInstance(SnoozeService.this).sendBroadcast(broadCastIntent);
    }
}
