package com.payu.custombrowser.bean;

import com.payu.custombrowser.PayUCustomBrowserCallback;
import com.payu.custombrowser.util.PaymentOption;
import com.payu.custombrowser.wrapper.SamsungPayWrapper;

import java.util.HashSet;
import java.util.Set;

public enum CustomBrowserData {
    SINGLETON;
    private PayUCustomBrowserCallback payuCustomBrowserCallback;
    private Set<PaymentOption> paymentOptionSet = new HashSet<>();
    private SamsungPayWrapper samsungPayWrapper;
    /**
     * Getter of PayU CustomBrowser Callback
     *
     * @return {@link com.payu.custombrowser.PayUCustomBrowserCallback}
     */
    public PayUCustomBrowserCallback getPayuCustomBrowserCallback() {
        return payuCustomBrowserCallback;
    }

    /**
     * Setter of PayU CustomBrowser Callback
     *
     * @param payuCustomBrowserCallback {@link com.payu.custombrowser.PayUCustomBrowserCallback}
     */
    public void setPayuCustomBrowserCallback(PayUCustomBrowserCallback payuCustomBrowserCallback) {
        this.payuCustomBrowserCallback = payuCustomBrowserCallback;
    }

    /**
     *  Check if PaymentOption availability called
     * @param paymentOptionName PaymentOption Type
     * @return  true/false
     */
    public boolean isPaymentOptionAvailabilityCalled(PaymentOption paymentOptionName) {
        return paymentOptionSet.contains(paymentOptionName);
    }

    /**
     * Put paymentOptionWrapper for paymentoption in Set
     *@param paymentOptionName PaymentOption Type
     */
    public void setPaymentOption(PaymentOption paymentOptionName) {
        this.paymentOptionSet.add(paymentOptionName);
    }

    /**
     *  Remove PaymentOption from paymentOptionSet
     * @param paymentOption PaymentOption Type
     */
    public void removePaymentOption(PaymentOption paymentOption) {
        this.paymentOptionSet.remove(paymentOption);
    }

    /**
     * Returned the saved value of SamsungPayWrapper
     * @return SamsungPayWrapper object
     */
    public SamsungPayWrapper getSamsungPayWrapper() {
        return samsungPayWrapper;
    }

    /**
     * Set the value of SamsungPay Wrapper object
     * @param samsungPayWrapper object
     */
    public void setSamsungPayWrapper(SamsungPayWrapper samsungPayWrapper) {
        this.samsungPayWrapper = samsungPayWrapper;
    }
}
