package com.payu.custombrowser.upiintent;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by himanshu.gupta on 01/05/18.
 */

public class PackageBean implements Parcelable {
    private String packageName;
    private Drawable drawable;
    private String packageId;


    private PackageBean(Parcel parcel) {
        super();
        readFromParcel(parcel);
    }

    public PackageBean(String packageName, Drawable drawable, String packageId) {
        this.packageName = packageName;
        this.drawable = drawable;
        this.packageId = packageId;
    }

    public String getPackageId() {
        return packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Drawable getDrawable() {
        return drawable;
    }

    public void setDrawable(Drawable drawable) {
        this.drawable = drawable;
    }

    public static final Parcelable.Creator<PackageBean> CREATOR = new Parcelable.Creator<PackageBean>() {
        public PackageBean createFromParcel(Parcel in) {
            return new PackageBean(in);
        }

        public PackageBean[] newArray(int size) {

            return new PackageBean[size];
        }

    };

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if ((o == null) || !(o instanceof PackageBean))
            return false;
        PackageBean packageBean = (PackageBean) o;
        return this.packageId.equalsIgnoreCase(packageBean.packageId);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + (drawable == null ? packageName.length() : drawable.hashCode());
        return hash;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private void readFromParcel(Parcel in) {
        packageName = in.readString();
        drawable = new BitmapDrawable((Bitmap) (in.readParcelable(getClass().getClassLoader())));
        packageId = in.readString();

    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(packageName);
        if(null!=drawable) {
            Bitmap bitmap = (UPIUtil.getBitmapFromDrawable(drawable));
            parcel.writeParcelable(bitmap, 0);
        }
        parcel.writeString(packageId);
    }
}
