/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.payu.custombrowser.CBActivity;
import com.payu.custombrowser.PayUCustomBrowserCallback;
import com.payu.custombrowser.PrePaymentsActivity;
import com.payu.custombrowser.a.a;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.b;
import com.payu.custombrowser.upiintent.Payment;
import com.payu.custombrowser.upiintent.PaymentResponseActivity;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.PaymentOption;

public class CustomBrowser {
    public void checkForPaymentAvailability(Activity activity, @NonNull PaymentOption paymentOption, @NonNull PayUCustomBrowserCallback payUCustomBrowserCallback, String paymentOptionHash, String merchantKey, String user_credentials) {
        b.SINGLETON.setPayuCustomBrowserCallback(payUCustomBrowserCallback);
        switch (paymentOption) {
            case SAMSUNGPAY: 
            case PHONEPE: {
                if (CBUtil.isPaymentModuleAvailable(paymentOption)) {
                    com.payu.custombrowser.d.a a2 = new com.payu.custombrowser.c.a(paymentOption).a();
                    a2.a((Context)activity, paymentOptionHash, merchantKey, user_credentials);
                    break;
                }
                payUCustomBrowserCallback.onCBErrorReceived(1022, "Device not supported or com.payu." + paymentOption.toString().toLowerCase() + " is missing");
            }
        }
    }

    public void addCustomBrowser(Activity activity, @NonNull CustomBrowserConfig cbCustomBrowserConfig, @NonNull PayUCustomBrowserCallback cbPayUCustomBrowserCallback) {
        a a2 = a.a(activity.getApplicationContext(), "local_cache_analytics");
        b.SINGLETON.setPayuCustomBrowserCallback(cbPayUCustomBrowserCallback);
        PaymentOption paymentOption = new CBUtil().getPaymentOptionFromPostData(cbCustomBrowserConfig.getPayuPostData());
        if (!TextUtils.isEmpty((CharSequence)cbCustomBrowserConfig.getReactVersion())) {
            a2.a(CBUtil.getLogMessage(activity.getApplicationContext(), "react_version_name", cbCustomBrowserConfig.getReactVersion(), null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
        }
        if (null != paymentOption) {
            if (b.SINGLETON.isPaymentOptionAvailabilityCalled(paymentOption)) {
                a2.a(CBUtil.getLogMessage(activity.getApplicationContext(), paymentOption.toString(), paymentOption.toString() + "_launched", null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
                new com.payu.custombrowser.c.a(paymentOption).a().a(activity, cbCustomBrowserConfig);
            } else {
                a2.a(CBUtil.getLogMessage(activity.getApplicationContext(), paymentOption.toString(), paymentOption.toString() + "_launch_failed", null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
                cbPayUCustomBrowserCallback.onCBErrorReceived(1021, "Forget to call checkForPaymentAvailability");
            }
        } else if (Build.VERSION.SDK_INT < 16) {
            a2.a(CBUtil.getLogMessage(activity.getApplicationContext(), "os_not_supported", Build.VERSION.SDK_INT + "", null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
            cbPayUCustomBrowserCallback.onCBErrorReceived(101, "OS_NOT_SUPPORTED");
        } else if (Build.VERSION.SDK_INT < 19 || Build.VERSION.SDK_INT == 19 && cbCustomBrowserConfig.getGmsProviderUpdatedStatus() == -1) {
            if (CBUtil.isCustomTabSupported(activity.getApplicationContext())) {
                a2.a(CBUtil.getLogMessage(activity.getApplicationContext(), "custom_tabs", "custom_tabs_launched", null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
                Intent intent = new Intent((Context)activity, PrePaymentsActivity.class);
                intent.putExtra("url", cbCustomBrowserConfig.getPostURL());
                intent.putExtra("html", cbCustomBrowserConfig.getHtmlData());
                intent.putExtra("postdata", cbCustomBrowserConfig.getPayuPostData());
                intent.putExtra("s2sRetryUrl", cbCustomBrowserConfig.getSurepayS2Surl());
                intent.putExtra("txnId", cbCustomBrowserConfig.getTransactionID());
                intent.putExtra("key", cbCustomBrowserConfig.getMerchantKey());
                activity.startActivity(intent);
            } else {
                a2.a(CBUtil.getLogMessage(activity.getApplicationContext(), "custom_tabs", "custom_tabs_launch_failed", null, cbCustomBrowserConfig.getMerchantKey(), cbCustomBrowserConfig.getTransactionID(), null));
                cbPayUCustomBrowserCallback.onCBErrorReceived(103, "CHROME_NOT_PRESENT");
            }
        } else {
            com.payu.custombrowser.upiintent.b b2;
            Payment payment;
            if (null != cbCustomBrowserConfig.getPayuPostData() && cbCustomBrowserConfig.getEnableSurePay() > 0 && (cbCustomBrowserConfig.getPostURL().contentEquals("https://secure.payu.in/_payment") || cbCustomBrowserConfig.getPostURL().contentEquals("https://mobiletest.payu.in/_payment") || cbCustomBrowserConfig.getPostURL().contentEquals("https://mobiletest.payu.in/_seamless_payment") || cbCustomBrowserConfig.getPostURL().contentEquals("https://secure.payu.in/_seamless_payment"))) {
                if (cbCustomBrowserConfig.getPayuPostData().trim().endsWith("&")) {
                    cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData().substring(0, cbCustomBrowserConfig.getPayuPostData().length() - 1));
                }
                cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData() + "&snooze=" + cbCustomBrowserConfig.getEnableSurePay());
            }
            if (null != (payment = (b2 = new com.payu.custombrowser.upiintent.b()).a(cbCustomBrowserConfig.getPayuPostData())) && b2.a((Context)activity, payment)) {
                Intent intent = new Intent((Context)activity, PaymentResponseActivity.class);
                intent.putExtra("postData", cbCustomBrowserConfig.getPayuPostData());
                activity.startActivity(intent);
            } else if (null != payment && !payment.isWebFlowSupported()) {
                cbPayUCustomBrowserCallback.onCBErrorReceived(1001, "DEVICE_NOT_SUPPORTED");
            } else {
                CBActivity.a = cbCustomBrowserConfig.getCbMenuAdapter();
                CBActivity.e = cbCustomBrowserConfig.getToolBarView();
                Intent intent = new Intent((Context)activity, CBActivity.class);
                intent.putExtra("cb_config", (Parcelable)cbCustomBrowserConfig);
                if (cbCustomBrowserConfig.getReviewOrderDefaultViewData() != null && cbCustomBrowserConfig.getReviewOrderDefaultViewData().getReviewOrderDatas() != null) {
                    intent.putExtra("order_details", cbCustomBrowserConfig.getReviewOrderDefaultViewData().getReviewOrderDatas());
                }
                activity.startActivity(intent);
            }
        }
    }
}

