package com.payu.custombrowser.bean;

import com.payu.custombrowser.PayUCustomBrowserCallback;
import com.payu.custombrowser.util.PaymentOption;

import java.util.HashSet;
import java.util.Set;

public enum CustomBrowserData {
    SINGLETON;
    private PayUCustomBrowserCallback payuCustomBrowserCallback;
    private Set<PaymentOption> paymentOptionSet = new HashSet<>();
    /**
     * Getter of PayU CustomBrowser Callback
     *
     * @return {@link com.payu.custombrowser.PayUCustomBrowserCallback}
     */
    public PayUCustomBrowserCallback getPayuCustomBrowserCallback() {
        return payuCustomBrowserCallback;
    }

    /**
     * Setter of PayU CustomBrowser Callback
     *
     * @param payuCustomBrowserCallback {@link com.payu.custombrowser.PayUCustomBrowserCallback}
     */
    public void setPayuCustomBrowserCallback(PayUCustomBrowserCallback payuCustomBrowserCallback) {
        this.payuCustomBrowserCallback = payuCustomBrowserCallback;
    }

    /**
     *  Check if PaymentOption availability called
     * @param paymentOptionName PaymentOption Type
     * @return  paymentOptionWrapper {@link com.payu.custombrowser.wrapper.PaymentOptionWrapper}
     */
    public boolean isPaymentOptionAvailabilityCalled(PaymentOption paymentOptionName) {
        return paymentOptionSet.contains(paymentOptionName);
    }

    /**
     * Put paymentOptionWrapper for paymentoption in Set
     *@param paymentOptionName PaymentOption Type
     */
    public void setPaymentOption(PaymentOption paymentOptionName) {
        this.paymentOptionSet.add(paymentOptionName);
    }

    /**
     *  Remove PaymentOption from paymentOptionSet
     * @param paymentOption PaymentOption Type
     */
    public void removePaymentOption(PaymentOption paymentOption) {
        this.paymentOptionSet.remove(paymentOption);
    }
}
