package com.payu.custombrowser.upiintent;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;

import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CBConstant;

public class PaymentResponseActivity extends Activity {
    PaymentHandler paymentHandler;
    String postData;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        postData = getIntent().getStringExtra(CBConstant.POST_DATA);
        paymentHandler = new PaymentHandler(this, postData, CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback());
        paymentHandler.initiatePayment();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == UPIPaymentConstants.PAYMENT_REQUEST_CODE) {
            if (resultCode == RESULT_OK) {
                String status = data.getStringExtra(UPIPaymentConstants.STATUS);
                if (status.equalsIgnoreCase(UPIPaymentConstants.SUCCESS)) {
                    paymentHandler.verifyPayment(UPIPaymentConstants.SUCCESS, null);
                } else {
                    paymentHandler.verifyPayment(UPIPaymentConstants.FAILURE, null);
                }
            } else {
                paymentHandler.verifyPayment(UPIPaymentConstants.CANCEL, null);
            }
        }
    }
}
