/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser.util;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.support.v4.app.NotificationCompat;
import android.support.v7.app.NotificationCompat;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebView;
import com.payu.custombrowser.R;
import com.payu.custombrowser.util.SnoozeConfigMap;
import com.payu.custombrowser.util.c;
import com.payu.custombrowser.util.g;
import com.payu.custombrowser.util.h;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CBUtil {
    public static final String CB_PREFERENCE = "com.payu.custombrowser.payucustombrowser";
    private static SharedPreferences a;

    public static String getSystemCurrentTime() {
        try {
            Date date = new Date(System.currentTimeMillis());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String string2 = simpleDateFormat.format(date);
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static String getLogMessage(Context context, String key, String value, String bank, String sdkMerchantKey, String trnxID, String pageType) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("payu_id", (Object)CBUtil.getCookie("PAYUID", context));
            jSONObject.put("txnid", (Object)trnxID);
            jSONObject.put("merchant_key", (Object)sdkMerchantKey);
            jSONObject.put("page_type", (Object)(pageType == null ? "" : pageType));
            jSONObject.put("event_key", (Object)key);
            jSONObject.put("event_value", (Object)URLEncoder.encode(value, "UTF-8"));
            jSONObject.put("bank", (Object)(bank == null ? "" : bank));
            jSONObject.put("package_name", (Object)context.getPackageName());
            jSONObject.put("ts", (Object)CBUtil.getSystemCurrentTime());
            return jSONObject.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "{}";
        }
    }

    public static String decodeContents(FileInputStream fileInputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n2;
            int n3 = 0;
            while ((n2 = fileInputStream.read()) != -1) {
                if (n3 % 2 == 0) {
                    stringBuilder.append((char)(n2 - (n3 % 5 + 1)));
                } else {
                    stringBuilder.append((char)(n2 + (n3 % 5 + 1)));
                }
                ++n3;
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuilder.toString();
    }

    public static void setAlpha(float alpha, View view) {
        if (Build.VERSION.SDK_INT < 11) {
            AlphaAnimation alphaAnimation = new AlphaAnimation(alpha, alpha);
            alphaAnimation.setDuration(10L);
            alphaAnimation.setFillAfter(true);
            view.startAnimation((Animation)alphaAnimation);
        } else {
            view.setAlpha(alpha);
        }
    }

    public static String updateLastUrl(String lastUrl) {
        try {
            if (!lastUrl.contains("||")) {
                if (lastUrl.length() > 128) {
                    return lastUrl.substring(0, 127);
                }
                return lastUrl;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(lastUrl, "||");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (string2.length() > 128) {
                string2 = string2.substring(0, 125);
            }
            if (string3.length() > 128) {
                string3 = string3.substring(0, 125);
            }
            return string2 + "||" + string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static void setVariableReflection(String className, String value, String varName) {
        try {
            if (value != null && !value.trim().equals("")) {
                Class<?> clazz = Class.forName(className);
                Field field = clazz.getDeclaredField(varName);
                field.setAccessible(true);
                field.set(null, value);
                field.setAccessible(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String filterSMS(JSONObject mBankJS, String msgBody, Context context) {
        String string2 = null;
        try {
            Matcher matcher;
            if (msgBody != null && (matcher = Pattern.compile(mBankJS.getString(context.getString(R.string.cb_detect_otp)), 2).matcher(msgBody)).find()) {
                String[] stringArray;
                for (String string3 : stringArray = mBankJS.getString(context.getString(R.string.cb_find_new_otp)).split("::")) {
                    if (!TextUtils.isEmpty((CharSequence)string3) && (matcher = Pattern.compile(string3, 2).matcher(msgBody)).find() && !TextUtils.isEmpty((CharSequence)(string2 = matcher.group().trim().replaceAll("\\.", "")))) break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public HttpsURLConnection getHttpsConn(String strURL, String postData) {
        try {
            return this.getHttpsConn(strURL, postData, -1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public HttpsURLConnection getHttpsConn(String strURL, String postData, int timeout, String cookiesList) {
        try {
            URL uRL = new URL(strURL);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setRequestMethod("POST");
            if (timeout != -1) {
                httpsURLConnection.setConnectTimeout(timeout);
            }
            httpsURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (postData != null) {
                httpsURLConnection.setRequestProperty("Content-Length", String.valueOf(postData.length()));
            }
            if (cookiesList != null) {
                httpsURLConnection.setRequestProperty("Cookie", cookiesList);
            }
            httpsURLConnection.setSSLSocketFactory(new h());
            httpsURLConnection.setDoOutput(true);
            if (postData != null) {
                byte[] byArray = postData.getBytes();
                httpsURLConnection.getOutputStream().write(byArray);
            }
            return httpsURLConnection;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public HttpsURLConnection getHttpsConn(String strURL, String postData, int timeout) {
        return this.getHttpsConn(strURL, postData, timeout, null);
    }

    public static HttpsURLConnection getHttpsConn(String strURL) {
        try {
            URL uRL = new URL(strURL);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setRequestMethod("GET");
            httpsURLConnection.setSSLSocketFactory(new h());
            httpsURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
            return httpsURLConnection;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static StringBuffer getStringBufferFromInputStream(InputStream responseInputStream) {
        try {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = new byte[1024];
            while ((n2 = responseInputStream.read(byArray)) != -1) {
                stringBuffer.append(new String(byArray, 0, n2));
            }
            return stringBuffer;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected();
    }

    public static List<String> updateRetryData(String data, Context context) {
        CBUtil.a(data, context);
        return CBUtil.processAndAddWhiteListedUrls(data);
    }

    private static void a(String string2, Context context) {
        if (string2 == null) {
            g.a(context, "RETRY_SETTINGS", "RETRY_WHITELISTED_URLS", "");
        } else {
            g.a(context, "RETRY_SETTINGS", "RETRY_WHITELISTED_URLS", string2);
        }
        c.a("#### PAYU", "DATA UPDATED IN SHARED PREFERENCES");
    }

    public void clearCookie() {
        CookieManager cookieManager = CookieManager.getInstance();
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.removeSessionCookies(null);
        } else {
            cookieManager.removeSessionCookie();
        }
    }

    public static List<String> processAndAddWhiteListedUrls(String data) {
        if (data != null && !data.equalsIgnoreCase("")) {
            String[] stringArray;
            for (String string2 : stringArray = data.split("\\|")) {
                c.a("#### PAYU", "Split Url: " + string2);
            }
            if (stringArray != null && stringArray.length > 0) {
                List<String> list = Arrays.asList(stringArray);
                return list;
            }
            c.a("#### PAYU", "Whitelisted URLs from JS: " + data);
        }
        return new ArrayList<String>();
    }

    public boolean getBooleanSharedPreference(String key, Context context) {
        a = context.getSharedPreferences(CB_PREFERENCE, 0);
        return a.getBoolean(key, false);
    }

    public boolean getBooleanSharedPreferenceDefaultTrue(String key, Context context) {
        a = context.getSharedPreferences(CB_PREFERENCE, 0);
        return a.getBoolean(key, true);
    }

    public void setBooleanSharedPreference(String key, boolean value, Context context) {
        SharedPreferences.Editor editor = context.getSharedPreferences(CB_PREFERENCE, 0).edit();
        editor.putBoolean(key, value);
        editor.apply();
    }

    public String getDeviceDensity(Activity activity) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.densityDpi + "";
    }

    public String getNetworkStatus(Context context) {
        try {
            if (null != context) {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo == null || !networkInfo.isConnected()) {
                    return "Not connected";
                }
                if (networkInfo.getType() == 1) {
                    return "WIFI";
                }
                if (networkInfo.getType() == 0) {
                    int n2 = networkInfo.getSubtype();
                    switch (n2) {
                        case 1: {
                            return "GPRS";
                        }
                        case 2: {
                            return "EDGE";
                        }
                        case 4: {
                            return "CDMA";
                        }
                        case 7: 
                        case 11: {
                            return "2G";
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: {
                            return "HSPA";
                        }
                        case 12: 
                        case 14: 
                        case 15: {
                            return "3G";
                        }
                        case 13: {
                            return "4G";
                        }
                    }
                    return "?";
                }
            }
        }
        catch (Exception exception) {
            return "?";
        }
        return "?";
    }

    public NetworkInfo getNetWorkInfo(Context mContext) {
        NetworkInfo networkInfo;
        block3: {
            ConnectivityManager connectivityManager;
            block2: {
                Network[] networkArray;
                connectivityManager = (ConnectivityManager)mContext.getSystemService("connectivity");
                networkInfo = null;
                if (Build.VERSION.SDK_INT < 21) break block2;
                for (Network network : networkArray = connectivityManager.getAllNetworks()) {
                    NetworkInfo networkInfo2 = connectivityManager.getNetworkInfo(network);
                    if (!networkInfo2.getState().equals((Object)NetworkInfo.State.CONNECTED)) continue;
                    networkInfo = networkInfo2;
                }
                break block3;
            }
            NetworkInfo[] networkInfoArray = connectivityManager.getAllNetworkInfo();
            if (networkInfoArray == null) break block3;
            for (NetworkInfo networkInfo3 : networkInfoArray) {
                if (networkInfo3.getState() != NetworkInfo.State.CONNECTED) continue;
                networkInfo = networkInfo3;
            }
        }
        return networkInfo;
    }

    public int getNetworkStrength(Context mContext) {
        NetworkInfo networkInfo = this.getNetWorkInfo(mContext);
        if (networkInfo != null) {
            if (networkInfo.getTypeName().equalsIgnoreCase("MOBILE")) {
                return this.a(mContext, networkInfo);
            }
            if (networkInfo.getTypeName().equalsIgnoreCase("wifi") && this.a(mContext, "android.permission.ACCESS_WIFI_STATE")) {
                WifiManager wifiManager = (WifiManager)mContext.getSystemService("wifi");
                try {
                    WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                    if (wifiInfo != null) {
                        return WifiManager.calculateSignalLevel((int)wifiInfo.getRssi(), (int)5);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return 0;
        }
        return 0;
    }

    private boolean a(Context context, String string2) {
        int n2 = context.checkCallingOrSelfPermission(string2);
        return n2 == 0;
    }

    private int a(Context context, NetworkInfo networkInfo) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            int n2 = 0;
            if (Build.VERSION.SDK_INT >= 18) {
                for (CellInfo cellInfo : telephonyManager.getAllCellInfo()) {
                    CellSignalStrengthGsm cellSignalStrengthGsm;
                    if (!cellInfo.isRegistered()) continue;
                    if (cellInfo instanceof CellInfoGsm) {
                        cellSignalStrengthGsm = ((CellInfoGsm)cellInfo).getCellSignalStrength();
                        n2 = cellSignalStrengthGsm.getDbm();
                        continue;
                    }
                    if (cellInfo instanceof CellInfoCdma) {
                        cellSignalStrengthGsm = ((CellInfoCdma)cellInfo).getCellSignalStrength();
                        n2 = cellSignalStrengthGsm.getDbm();
                        continue;
                    }
                    if (cellInfo instanceof CellInfoLte) {
                        cellSignalStrengthGsm = ((CellInfoLte)cellInfo).getCellSignalStrength();
                        n2 = cellSignalStrengthGsm.getDbm();
                        continue;
                    }
                    if (!(cellInfo instanceof CellInfoWcdma)) continue;
                    cellSignalStrengthGsm = ((CellInfoWcdma)cellInfo).getCellSignalStrength();
                    n2 = cellSignalStrengthGsm.getDbm();
                }
            }
            return n2;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setStringSharedPreferenceLastURL(Context context, String key, String url) {
        String string2 = this.getStringSharedPreference(context, key);
        if (string2.equalsIgnoreCase("")) {
            string2 = url;
        } else if (!string2.contains("||")) {
            string2 = string2 + "||" + url;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "||");
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken() + "||" + url;
        }
        this.storeInSharedPreferences(context, key, string2);
    }

    public String getStringSharedPreference(Context context, String key) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(CB_PREFERENCE, 0);
        return sharedPreferences.getString(key, "");
    }

    public void setStringSharedPreference(Context context, String key, String value) {
        SharedPreferences.Editor editor = context.getSharedPreferences(CB_PREFERENCE, 0).edit();
        editor.putString(key, value);
        editor.commit();
    }

    public void deleteSharedPrefKey(Context context, String key) {
        try {
            SharedPreferences.Editor editor = context.getSharedPreferences(CB_PREFERENCE, 0).edit();
            editor.remove(key);
            editor.apply();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void storeInSharedPreferences(Context context, String key, String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(CB_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        editor.apply();
    }

    public void removeFromSharedPreferences(Context context, String key) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(CB_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove(key);
        editor.apply();
    }

    public Drawable getDrawableCB(Context context, int resID) {
        if (Build.VERSION.SDK_INT < 21) {
            return context.getResources().getDrawable(resID);
        }
        return context.getResources().getDrawable(resID, context.getTheme());
    }

    public void cancelTimer(Timer timer) {
        if (timer != null) {
            timer.cancel();
            timer.purge();
        }
    }

    public String readFileInputStream(Context mContext, String fileName, int contextMode) {
        String string2 = "";
        try {
            int n2;
            File file = new File(mContext.getFilesDir(), fileName);
            if (!file.exists()) {
                mContext.openFileOutput(fileName, contextMode);
            }
            FileInputStream fileInputStream = mContext.openFileInput(fileName);
            while ((n2 = fileInputStream.read()) != -1) {
                string2 = string2 + Character.toString((char)n2);
            }
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public void writeFileOutputStream(InputStream inputStream, Context context, String fileName, int contextMode) {
        try {
            int n2;
            GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
            byte[] byArray = new byte[1024];
            FileOutputStream fileOutputStream = context.openFileOutput(fileName, contextMode);
            while ((n2 = gZIPInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n2);
            }
            gZIPInputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void resetPayuID() {
        this.clearCookie();
    }

    public String getCookieList(Context appContext, String domainName) {
        String string2 = "";
        try {
            String string3;
            CookieManager cookieManager = CookieManager.getInstance();
            if (Build.VERSION.SDK_INT < 21) {
                CookieSyncManager.createInstance((Context)appContext);
                CookieSyncManager.getInstance().sync();
            }
            if ((string3 = cookieManager.getCookie(domainName)) != null) {
                String[] stringArray;
                for (String string4 : stringArray = string3.split(";")) {
                    String[] stringArray2 = string4.split("=");
                    string2 = string2 + stringArray2[0] + "=" + stringArray2[1] + ";";
                }
            }
            if (string2.length() > 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static String getCookie(String cookieName, Context context) {
        String string2 = "";
        try {
            String string3;
            String string4 = "https://secure.payu.in";
            CookieManager cookieManager = CookieManager.getInstance();
            if (Build.VERSION.SDK_INT < 21) {
                CookieSyncManager.createInstance((Context)context);
                CookieSyncManager.getInstance().sync();
            }
            if ((string3 = cookieManager.getCookie(string4)) != null) {
                String[] stringArray;
                for (String string5 : stringArray = string3.split(";")) {
                    if (!string5.contains(cookieName)) continue;
                    String[] stringArray2 = string5.split("=");
                    string2 = stringArray2[1];
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    @Deprecated
    public String getDataFromPostData(String postData, String key) {
        String[] stringArray;
        for (String string2 : stringArray = postData.split("&")) {
            String string3;
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length < 2 || !(string3 = stringArray2[0]).equalsIgnoreCase(key)) continue;
            return stringArray2[1];
        }
        return "";
    }

    public HashMap<String, String> getDataFromPostData(String postData) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (null != postData) {
            StringTokenizer stringTokenizer = new StringTokenizer(postData, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String[] stringArray = stringTokenizer.nextToken().split("=");
                if (null == stringArray || stringArray.length <= 0 || null == stringArray[0]) continue;
                hashMap.put(stringArray[0], stringArray.length > 1 ? stringArray[1] : "");
            }
        }
        return hashMap;
    }

    public void showNotification(Context context, Intent intent, String title, String txt, int smallIcon, boolean autoCancel, NotificationCompat.Style style2, int color, int ID) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
        builder.setContentTitle((CharSequence)title).setContentText((CharSequence)txt).setSmallIcon(smallIcon).setPriority(1).setDefaults(2);
        if (autoCancel) {
            builder.setAutoCancel(autoCancel);
        }
        if (style2 != null) {
            builder.setStyle(style2);
        }
        if (color != -1) {
            builder.setColor(color);
        }
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        builder.setContentIntent(pendingIntent);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.notify(ID, builder.build());
    }

    public SnoozeConfigMap storeSnoozeConfigInSharedPref(Context context, String snoozeConfig) {
        SnoozeConfigMap snoozeConfigMap = new SnoozeConfigMap();
        try {
            JSONObject jSONObject = new JSONObject(snoozeConfig);
            g.b(context, "com.payu.custombrowser.snoozepref");
            snoozeConfigMap = this.a(context, jSONObject.getJSONArray("default"), snoozeConfigMap);
            jSONObject.remove("default");
            Iterator iterator = jSONObject.keys();
            if (iterator.hasNext()) {
                snoozeConfigMap = this.a(context, jSONObject.getJSONArray((String)iterator.next()), snoozeConfigMap);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return snoozeConfigMap;
    }

    private SnoozeConfigMap a(Context context, JSONArray jSONArray, SnoozeConfigMap snoozeConfigMap) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n2 = 0;
        try {
            int n3 = jSONArray.length();
            for (int i2 = 0; i2 < n3; ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                string2 = jSONObject.get("url").toString();
                string3 = jSONObject.get("progress_percent").toString();
                string4 = jSONObject.get("time_out").toString();
                if (jSONObject.has("disable_sp_for")) {
                    JSONObject jSONObject2 = jSONObject.getJSONObject("disable_sp_for");
                    n2 = this.a(jSONObject2);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "||");
                while (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                    g.a(context, "com.payu.custombrowser.snoozepref", string5.contentEquals("*") ? "*" : string5.trim(), string3.trim() + "||" + string4.trim() + "||" + n2);
                    snoozeConfigMap.put(string5.contentEquals("*") ? "*" : string5.trim(), string3.trim() + "||" + string4.trim() + "||" + n2);
                }
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return snoozeConfigMap;
    }

    public SnoozeConfigMap convertToSnoozeConfigMap(Map<String, ?> snoozeMap) {
        SnoozeConfigMap snoozeConfigMap = new SnoozeConfigMap();
        for (Map.Entry<String, ?> entry : snoozeMap.entrySet()) {
            snoozeConfigMap.put(entry.getKey(), entry.getValue());
        }
        return snoozeConfigMap;
    }

    public Set<String> getSurePayErrorCodes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("-7");
        hashSet.add("-8");
        hashSet.add("-15");
        return hashSet;
    }

    private int a(JSONObject jSONObject) {
        try {
            if (jSONObject.has("warn") && jSONObject.getBoolean("warn") && jSONObject.has("fail") && jSONObject.getBoolean("fail")) {
                return 3;
            }
            if (jSONObject.has("fail") && jSONObject.getBoolean("fail")) {
                return 2;
            }
            if (jSONObject.has("warn") && jSONObject.getBoolean("warn")) {
                return 1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
        return 0;
    }

    public int getSurePayDisableStatus(SnoozeConfigMap snoozeConfigMap, String webViewUrl) {
        if (null != snoozeConfigMap && webViewUrl != null) {
            for (Object k2 : snoozeConfigMap.keySet()) {
                if (!webViewUrl.startsWith(k2.toString())) continue;
                int[] nArray = snoozeConfigMap.getPercentageAndTimeout(k2.toString());
                return nArray[2];
            }
            int[] nArray = snoozeConfigMap.getPercentageAndTimeout("*");
            return nArray[2];
        }
        return 0;
    }

    public String getValueOfJSONKey(String data, String key) throws JSONException {
        JSONObject jSONObject = new JSONObject(data);
        if (jSONObject.has(key)) {
            return jSONObject.get(key).toString();
        }
        throw new JSONException("Key not found");
    }

    public static void launchPlayStore(Context context) {
        CBUtil.launchPlayStore(context, null, null);
    }

    public static void launchPlayStore(Context context, String url, String webViewVersion) {
        String string2 = CBUtil.getPackageNameFromPlayStoreLink(url);
        string2 = null == string2 ? "" : "details?id=" + string2;
        CBUtil.setWebViewVersionInSP(context, webViewVersion);
        try {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://" + string2))));
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/" + string2))));
        }
    }

    public static boolean isPlayStoreUrl(String url) {
        return url.startsWith("https://play.google.com") || url.startsWith("market://");
    }

    public static String getPackageNameFromPlayStoreLink(String url) {
        Matcher matcher = Pattern.compile("((?<=[?&]id=)[^&]+)").matcher(url);
        return matcher.find() ? matcher.group(1) : null;
    }

    public static String getWebViewVersion(WebView view) {
        String string2 = view.getSettings().getUserAgentString();
        Matcher matcher = Pattern.compile("(Chrome\\/(.*?)\\s)").matcher(string2);
        return matcher.find() ? matcher.group(2) : null;
    }

    public static void setWebViewVersionInSP(Context context, String webViewVersion) {
        if (null != webViewVersion) {
            g.a(context, CB_PREFERENCE, "webview_version", webViewVersion);
        }
    }

    public static String getWebViewVersionFromSP(Context context) {
        return g.b(context, CB_PREFERENCE, "webview_version", "");
    }

    public static String getBase64DecodedString(String data) {
        return new String(Base64.decode((String)data, (int)0));
    }

    public static String getImei(Context applicationContex) {
        String string2;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)applicationContex.getSystemService("phone");
            string2 = telephonyManager.getDeviceId();
        }
        catch (Exception exception) {
            string2 = "default";
        }
        return string2;
    }

    public static String getUdid(Context applicationContex) {
        String string2;
        try {
            string2 = Settings.Secure.getString((ContentResolver)applicationContex.getContentResolver(), (String)"android_id");
        }
        catch (Exception exception) {
            string2 = "default";
        }
        return string2;
    }

    public static boolean isSPModuleAvailable() {
        try {
            Class<?> clazz = CBUtil.class.getClassLoader().loadClass("com.payu.samsungpay.SamsungWrapper");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.e((String)"CBUtil", (String)"Please import com.payu.samsungpay to make Payment by Samsung Pay");
            return false;
        }
    }

    public static boolean isCustomTabSupported(Context context) {
        Object var1_1 = null;
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.example.com"));
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 0);
        String string2 = null;
        if (resolveInfo != null) {
            string2 = resolveInfo.activityInfo.packageName;
        }
        List list = packageManager.queryIntentActivities(intent, 0);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ResolveInfo resolveInfo2 : list) {
            Intent intent2 = new Intent();
            intent2.setAction("android.support.customtabs.action.CustomTabsService");
            intent2.setPackage(resolveInfo2.activityInfo.packageName);
            if (packageManager.resolveService(intent2, 0) == null) continue;
            arrayList.add(resolveInfo2.activityInfo.packageName);
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        return arrayList.contains("com.android.chrome");
    }
}

