package com.payu.custombrowser;

import android.app.Activity;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.os.Build;

import com.payu.custombrowser.analytics.CBAnalytics;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.upiintent.Payment;
import com.payu.custombrowser.upiintent.PaymentResponseActivity;
import com.payu.custombrowser.upiintent.UPIPaymentConstants;
import com.payu.custombrowser.upiintent.UPIUtil;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.L;
import com.payu.custombrowser.util.PaymentOption;
import com.payu.custombrowser.util.PaymentOptionHandler;

import org.json.JSONException;



public class CustomBrowser {

    /**
     * Function to check if payment is supported
     *
     * @param activity Activity instance
     * @param paymentOption {@link com.payu.custombrowser.util.PaymentOption}Payment Type
     * @param payUCustomBrowserCallback {@link com.payu.custombrowser.PayUCustomBrowserCallback}PayUCustomBrowserCallback instance
     * @param paymentOptionHash Hash for Payment Related Details api
     * @param merchantKey Merchant Key
     * @param user_credentials User Credentials
     */

    public void checkForPaymentAvailability(Activity activity, @NonNull PaymentOption paymentOption, @NonNull PayUCustomBrowserCallback payUCustomBrowserCallback, String paymentOptionHash, String merchantKey, String user_credentials){
        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(payUCustomBrowserCallback);
        switch (paymentOption){
            case SAMSUNGPAY:
                if(CBUtil.isSPModuleAvailable()) {
                    SamsungPayWrapper samsungPayWrapper = new SamsungPayWrapper();
                    samsungPayWrapper.checkForSamsungPayAvailability(activity.getApplicationContext(), paymentOptionHash, merchantKey, user_credentials);
                    CustomBrowserData.SINGLETON.setSamsungPayWrapper(samsungPayWrapper);
                } else {
                    payUCustomBrowserCallback.onCBErrorReceived(CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED,CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED_MSG);
                }
            break;
            case CC:
            case NB:
            case DC:
                PaymentOptionHandler paymentOptionHandler = new PaymentOptionHandler(activity,payUCustomBrowserCallback,merchantKey,paymentOptionHash,user_credentials);
                break;
        }

    }

    /**
     * Call this method to add CustomBrowser to application
     *
     * @param activity                    base class activity
     * @param cbCustomBrowserConfig       contain the specification of CB
     * @param cbPayUCustomBrowserCallback provide callbacks
     */
    public void addCustomBrowser(Activity activity, @NonNull CustomBrowserConfig cbCustomBrowserConfig, @NonNull PayUCustomBrowserCallback cbPayUCustomBrowserCallback) {

        String paymentOptionName = null;
        CBAnalytics analytics = CBAnalytics.getInstance(activity.getApplicationContext(),"local_cache_analytics");
        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(cbPayUCustomBrowserCallback);
        paymentOptionName = new CBUtil().getDataFromPostData(cbCustomBrowserConfig.getPayuPostData()).get(UPIPaymentConstants.BANK_CODE);

        //Check if payment option is Samsung Pay
        if (null != paymentOptionName && paymentOptionName.equalsIgnoreCase(PaymentOption.SAMSUNGPAY.getPaymentName())) {
            if (null != CustomBrowserData.SINGLETON.getSamsungPayWrapper()) {
                analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.SAMSUNG_PAY,CBAnalyticsConstant.SAMSUNG_PAY_LAUNCHED,null,cbCustomBrowserConfig.getMerchantKey(),cbCustomBrowserConfig.getTransactionID(),null));
                CustomBrowserData.SINGLETON.getSamsungPayWrapper().MakeSamsungPayPayment(activity, cbCustomBrowserConfig);
            } else {
                analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.SAMSUNG_PAY,CBAnalyticsConstant.SAMSUNG_PAY_LAUNCH_FAILED,null,cbCustomBrowserConfig.getMerchantKey(),cbCustomBrowserConfig.getTransactionID(),null));
                cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.CHECK_PAYMENT_NOT_CALLED, CBConstant.CHECK_PAYMENT_NOT_CALLED_MSG);
            }
        } else if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN) {
               //We don't support payments below JB
            analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.OS_NOT_SUPPORTED,Build.VERSION.SDK_INT+"",null,cbCustomBrowserConfig.getMerchantKey(),cbCustomBrowserConfig.getTransactionID(),null));
            cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.OS_NOT_SUPPORTED_CODE, CBConstant.OS_NOT_SUPPORTED);
        } else if ((Build.VERSION.SDK_INT < 19)
                || (Build.VERSION.SDK_INT == 19 && cbCustomBrowserConfig.getGmsProviderUpdatedStatus()==CustomBrowserConfig.FALSE)) {
            //For OS b/w JB & KK payment is by Chrome tabs only
            if(CBUtil.isCustomTabSupported(activity.getApplicationContext())) {
                analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(),CBAnalyticsConstant.CUSTOM_TABS,CBAnalyticsConstant.CUSTOM_TABS_LAUNCHED,null,cbCustomBrowserConfig.getMerchantKey(),cbCustomBrowserConfig.getTransactionID(),null));
                Intent intent = new Intent(activity, PreLollipopPaymentsActivity.class);
                intent.putExtra("url", cbCustomBrowserConfig.getPostURL());
                intent.putExtra("html", cbCustomBrowserConfig.getHtmlData());
                intent.putExtra("data", cbCustomBrowserConfig.getPayuPostData());
                intent.putExtra("txnId", cbCustomBrowserConfig.getTransactionID());
                intent.putExtra("key", cbCustomBrowserConfig.getMerchantKey());
                activity.startActivity(intent);
            } else {
                //We support payment via Chrome tabs only below KK ,No Chrome tabs found,hence payment could not proceed.
                analytics.log(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.CUSTOM_TABS,CBAnalyticsConstant.CUSTOM_TABS_LAUNCH_FAILED,null,cbCustomBrowserConfig.getMerchantKey(),cbCustomBrowserConfig.getTransactionID(),null));
                cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.CHROME_NOT_PRESENT_CODE, CBConstant.CHROME_NOT_PRESENT);
            }
        } else {
            // CustomBrowserData.SINGLETON.setPayuCustomBrowserConfig(cbCustomBrowserConfig);

            if (null != cbCustomBrowserConfig.getPayuPostData() && cbCustomBrowserConfig.getEnableSurePay() > 0 && (cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.PAYMENT_URL) || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.TEST_PAYMENT_URL)
                    || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.MOBILE_TEST_PAYMENT_URL_SEAMLESS) || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.PRODUCTION_PAYMENT_URL_SEAMLESS))) {
                // Sometimes post data contains & at the end, just removing it from the postdata
                if (cbCustomBrowserConfig.getPayuPostData().trim().endsWith("&")) {
                    cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData().substring(0, cbCustomBrowserConfig.getPayuPostData().length() - 1));
                }
                // Adding snooze=<snooze_count> in the post data being sent to payu server (_payment)
                cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData() + "&snooze=" + cbCustomBrowserConfig.getEnableSurePay());
            }
            UPIUtil upiUtil = new UPIUtil();
            Payment payment = upiUtil.getSupportedPayment(cbCustomBrowserConfig.getPayuPostData());

             if (null != payment && upiUtil.isPaymentMethodSupported(activity, payment)) {
                Intent intent = new Intent(activity, PaymentResponseActivity.class);
                intent.putExtra(CBConstant.POST_DATA, cbCustomBrowserConfig.getPayuPostData());
                activity.startActivity(intent);
            } else if (null != payment && !payment.isWebFlowSupported()) { //Payment is supported but on device its not possible
                cbPayUCustomBrowserCallback.onCBErrorReceived(UPIPaymentConstants.DEVICE_NOT_SUPPORTED_CODE, UPIPaymentConstants.DEVICE_NOT_SUPPORTED);
            } else {
                CBActivity.cbDrawerAdapter = cbCustomBrowserConfig.getCbMenuAdapter();
                CBActivity.cbConfigToolbarView = cbCustomBrowserConfig.getToolBarView();
                Intent intent = new Intent(activity, CBActivity.class);
                intent.putExtra("cb_config", cbCustomBrowserConfig);
                if (cbCustomBrowserConfig.getReviewOrderDefaultViewData() != null && cbCustomBrowserConfig.getReviewOrderDefaultViewData().getReviewOrderDatas() != null) {
                    intent.putExtra(CBConstant.ORDER_DETAILS, cbCustomBrowserConfig.getReviewOrderDefaultViewData().getReviewOrderDatas());
                }
                activity.startActivity(intent);
            }
        }
    }

}
