/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser.util;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.HashMap;
import java.util.Map;

public class SharedPreferenceUtil {
    public static void addStringToSharedPreference(Context context, String spFileName, String spKey, String spValue) {
        SharedPreferences sharedPref = context.getSharedPreferences(spFileName, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(spKey, spValue);
        editor.commit();
    }

    public static void addIntToSharedPreference(Context context, String spFileName, String spKey, int spValue) {
        SharedPreferences sharedPref = context.getSharedPreferences(spFileName, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putInt(spKey, spValue);
        editor.commit();
    }

    public static void addBooleanToSharedPreference(Context context, String spFileName, String spKey, boolean spValue) {
        SharedPreferences sharedPref = context.getSharedPreferences(spFileName, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(spKey, spValue);
        editor.commit();
    }

    public static String getStringFromSharedPreference(Context context, String spFileName, String spKey, String defaultValue) {
        SharedPreferences sharedPref = context.getSharedPreferences(spFileName, 0);
        return sharedPref.getString(spKey, defaultValue);
    }

    public static int getIntFromSharedPreference(Context context, String spFileName, String spKey, int defaultValue) {
        SharedPreferences sharedPref = context.getSharedPreferences(spFileName, 0);
        return sharedPref.getInt(spKey, defaultValue);
    }

    public static boolean getBooleanFromSharedPreference(Context context, String spFileName, String spKey, boolean defaultValue) {
        SharedPreferences sharedPref = context.getSharedPreferences(spFileName, 0);
        return sharedPref.getBoolean(spKey, defaultValue);
    }

    public static Map<String, ?> getSharedPrefMap(Context context, String prefName) {
        HashMap sharedPrefHashMap = new HashMap();
        SharedPreferences snoozeSharedPref = context.getSharedPreferences(prefName, 0);
        Map allEntries = snoozeSharedPref.getAll();
        return allEntries;
    }

    public static void removeAllFromSharedPref(Context context, String prefName) {
        SharedPreferences settings = context.getSharedPreferences(prefName, 0);
        settings.edit().clear().commit();
    }
}

