/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser.bean;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorRes;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.view.View;
import android.widget.ArrayAdapter;
import com.payu.custombrowser.Bank;
import com.payu.custombrowser.R;
import com.payu.custombrowser.bean.ReviewOrderBundle;
import com.payu.custombrowser.upiintent.Payment;
import com.payu.custombrowser.util.CBUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;

public class CustomBrowserConfig
implements Parcelable {
    public static final int STOREONECLICKHASH_MODE_NONE = 0;
    public static final int STOREONECLICKHASH_MODE_SERVER = 1;
    public static final int WARN_MODE = 1;
    public static final int FAIL_MODE = 2;
    public static final int ENABLE = 0;
    public static final int DISABLE = -1;
    private String payUOptionPaymentHash;
    private int viewPortWideEnable;
    private int autoApprove;
    private int autoSelectOTP;
    private String transactionID;
    private String merchantKey;
    private String sdkVersionName;
    private int showCustombrowser;
    private int disableBackButtonDialog;
    private int storeOneClickHash;
    private int magicRetry = 1;
    private int merchantSMSPermission;
    private int enableSurePay;
    private String merchantCheckoutActivityPath;
    private String postURL;
    private String payuPostData;
    private String htmlData;
    private int surePayNotificationIcon;
    private String surePayNotificationGoodNetworkTitle;
    private String surePayNotificationGoodNetWorkHeader;
    private String surePayNotificationGoodNetWorkBody;
    private String surePayNotificationPoorNetWorkTitle;
    private String surePayNotificationPoorNetWorkHeader;
    private String surePayNotificationPoorNetWorkBody;
    private String surePayNotificationTransactionVerifiedTitle;
    private String surePayNotificationTransactionVerifiedHeader;
    private String surePayNotificationTransactionVerifiedBody;
    private String surePayNotificationTransactionNotVerifiedTitle;
    private String surePayNotificationTransactionNotVerifiedHeader;
    private String surePayNotificationTransactionNotVerifiedBody;
    private int surePayMode;
    private int surePayBackgroundTTL;
    private int internetRestoredWindowTTL;
    private ArrayAdapter cbMenuAdapter;
    private int enableReviewOrder;
    private String reviewOrderButtonText;
    private int reviewOrderButtonTextColor;
    private transient ReviewOrderBundle reviewOrderDefaultViewData;
    private int reviewOrderCustomView;
    private static View toolBarView;
    private int cbDrawerCustomMenu;
    private int enableWebFlow;
    public static final Parcelable.Creator<CustomBrowserConfig> CREATOR;

    public String getPayUOptionPaymentHash() {
        return this.payUOptionPaymentHash;
    }

    public void setPayUOptionPaymentHash(String payUOptionPaymentHash) {
        this.payUOptionPaymentHash = payUOptionPaymentHash;
    }

    public ArrayAdapter getCbMenuAdapter() {
        return this.cbMenuAdapter;
    }

    public void setCbMenuAdapter(ArrayAdapter cbMenuAdapter) {
        this.cbMenuAdapter = cbMenuAdapter;
    }

    public int getCbDrawerCustomMenu() {
        return this.cbDrawerCustomMenu;
    }

    public void setCbDrawerCustomMenu(int cbDrawerCustomMenu) {
        this.cbDrawerCustomMenu = cbDrawerCustomMenu;
    }

    public View getToolBarView() {
        return toolBarView;
    }

    public void setToolBarView(View toolBarView) {
        CustomBrowserConfig.toolBarView = toolBarView;
    }

    private CustomBrowserConfig() {
    }

    protected CustomBrowserConfig(Parcel in) {
        this.viewPortWideEnable = in.readInt();
        this.autoApprove = in.readInt();
        this.autoSelectOTP = in.readInt();
        this.transactionID = in.readString();
        this.merchantKey = in.readString();
        this.sdkVersionName = in.readString();
        this.showCustombrowser = in.readInt();
        this.disableBackButtonDialog = in.readInt();
        this.storeOneClickHash = in.readInt();
        this.magicRetry = in.readInt();
        this.merchantSMSPermission = in.readInt();
        this.enableSurePay = in.readInt();
        this.merchantCheckoutActivityPath = in.readString();
        this.postURL = in.readString();
        this.payuPostData = in.readString();
        this.htmlData = in.readString();
        this.surePayNotificationIcon = in.readInt();
        this.surePayNotificationGoodNetworkTitle = in.readString();
        this.surePayNotificationGoodNetWorkHeader = in.readString();
        this.surePayNotificationGoodNetWorkBody = in.readString();
        this.surePayNotificationPoorNetWorkTitle = in.readString();
        this.surePayNotificationPoorNetWorkHeader = in.readString();
        this.surePayNotificationPoorNetWorkBody = in.readString();
        this.surePayNotificationTransactionVerifiedTitle = in.readString();
        this.surePayNotificationTransactionVerifiedHeader = in.readString();
        this.surePayNotificationTransactionVerifiedBody = in.readString();
        this.surePayNotificationTransactionNotVerifiedTitle = in.readString();
        this.surePayNotificationTransactionNotVerifiedHeader = in.readString();
        this.surePayNotificationTransactionNotVerifiedBody = in.readString();
        this.surePayMode = in.readInt();
        this.surePayBackgroundTTL = in.readInt();
        this.internetRestoredWindowTTL = in.readInt();
        this.reviewOrderCustomView = in.readInt();
        this.enableReviewOrder = in.readInt();
        this.reviewOrderButtonText = in.readString();
        this.reviewOrderButtonTextColor = in.readInt();
        this.cbDrawerCustomMenu = in.readInt();
        this.enableWebFlow = in.readInt();
    }

    public CustomBrowserConfig(@NonNull @Size(min=6L, max=6L) String merchantKey, @NonNull String transactionID) {
        this.transactionID = transactionID;
        this.merchantKey = merchantKey;
        this.surePayNotificationIcon = R.drawable.surepay_logo;
        this.surePayNotificationGoodNetworkTitle = "Internet Restored";
        this.surePayNotificationGoodNetWorkHeader = "You can now resume the transaction";
        this.surePayNotificationPoorNetWorkTitle = "No Internet Found";
        this.surePayNotificationPoorNetWorkHeader = "We could not detect internet on your device";
        this.surePayNotificationTransactionVerifiedTitle = "Transaction Verified";
        this.surePayNotificationTransactionVerifiedHeader = "The bank has verified this transaction and we are good to go.";
        this.surePayNotificationTransactionNotVerifiedTitle = "Transaction Status Unknown";
        this.surePayNotificationTransactionNotVerifiedHeader = "The bank could not verify the transaction at this time.";
        this.enableSurePay = 0;
        this.surePayMode = 1;
        this.surePayBackgroundTTL = 1800000;
        this.internetRestoredWindowTTL = 5000;
        this.reviewOrderCustomView = -1;
        this.enableReviewOrder = -1;
        this.reviewOrderButtonTextColor = -1;
        this.enableWebFlow = 1;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.viewPortWideEnable);
        dest.writeInt(this.autoApprove);
        dest.writeInt(this.autoSelectOTP);
        dest.writeString(this.transactionID);
        dest.writeString(this.merchantKey);
        dest.writeString(this.sdkVersionName);
        dest.writeInt(this.showCustombrowser);
        dest.writeInt(this.disableBackButtonDialog);
        dest.writeInt(this.storeOneClickHash);
        dest.writeInt(this.magicRetry);
        dest.writeInt(this.merchantSMSPermission);
        dest.writeInt(this.enableSurePay);
        dest.writeString(this.merchantCheckoutActivityPath);
        dest.writeString(this.postURL);
        dest.writeString(this.payuPostData);
        dest.writeString(this.htmlData);
        dest.writeInt(this.surePayNotificationIcon);
        dest.writeString(this.surePayNotificationGoodNetworkTitle);
        dest.writeString(this.surePayNotificationGoodNetWorkHeader);
        dest.writeString(this.surePayNotificationGoodNetWorkBody);
        dest.writeString(this.surePayNotificationPoorNetWorkTitle);
        dest.writeString(this.surePayNotificationPoorNetWorkHeader);
        dest.writeString(this.surePayNotificationPoorNetWorkBody);
        dest.writeString(this.surePayNotificationTransactionVerifiedTitle);
        dest.writeString(this.surePayNotificationTransactionVerifiedHeader);
        dest.writeString(this.surePayNotificationTransactionVerifiedBody);
        dest.writeString(this.surePayNotificationTransactionNotVerifiedTitle);
        dest.writeString(this.surePayNotificationTransactionNotVerifiedHeader);
        dest.writeString(this.surePayNotificationTransactionNotVerifiedBody);
        dest.writeInt(this.surePayMode);
        dest.writeInt(this.surePayBackgroundTTL);
        dest.writeInt(this.internetRestoredWindowTTL);
        dest.writeInt(this.reviewOrderCustomView);
        dest.writeInt(this.enableReviewOrder);
        dest.writeString(this.reviewOrderButtonText);
        dest.writeInt(this.reviewOrderButtonTextColor);
        dest.writeInt(this.cbDrawerCustomMenu);
        dest.writeInt(this.enableWebFlow);
    }

    public int describeContents() {
        return 0;
    }

    public String getPostURL() {
        return this.postURL;
    }

    public void setPostURL(String postURL) {
        this.postURL = postURL;
    }

    public String getPayuPostData() {
        return this.payuPostData;
    }

    public void setPayuPostData(String payuPostData) {
        this.payuPostData = payuPostData;
        HashMap<String, String> postParams = new CBUtil().getDataFromPostData(payuPostData);
        String defaultText = "Product info: " + postParams.get("productinfo") + "\nAmount: " + postParams.get("amount");
        if (null == this.surePayNotificationGoodNetWorkBody) {
            this.setSurePayNotificationGoodNetWorkBody(defaultText);
        }
        if (null == this.surePayNotificationPoorNetWorkBody) {
            this.setSurePayNotificationPoorNetWorkBody(defaultText);
        }
        if (null == this.surePayNotificationTransactionVerifiedBody) {
            this.setSurePayNotificationTransactionVerifiedBody(defaultText);
        }
        if (null == this.surePayNotificationTransactionNotVerifiedBody) {
            this.setSurePayNotificationTransactionNotVerifiedBody(defaultText);
        }
        if (null != postParams.get("key")) {
            this.setMerchantKey(null == Bank.keyAnalytics ? postParams.get("key") : Bank.keyAnalytics);
        }
    }

    public int getEnableSurePay() {
        return this.enableSurePay;
    }

    public void setEnableSurePay(@IntRange(from=0L, to=3L) int enableSurePay) {
        this.enableSurePay = enableSurePay > 3 ? 3 : enableSurePay;
    }

    public int getMerchantSMSPermission() {
        return this.merchantSMSPermission;
    }

    public void setMerchantSMSPermission(boolean merchantSMSPermission) {
        this.merchantSMSPermission = merchantSMSPermission ? 1 : 0;
    }

    public int getEnableWebFlow() {
        return this.enableWebFlow;
    }

    public void setEnableWebFlow(Payment payment, boolean enableWebFlow) {
        payment.setWebFlowSupported(enableWebFlow);
    }

    public int getMagicretry() {
        return this.magicRetry;
    }

    public void setmagicRetry(boolean magicRetry) {
        this.magicRetry = magicRetry ? 1 : 0;
    }

    public int getStoreOneClickHash() {
        return this.storeOneClickHash;
    }

    public void setStoreOneClickHash(int storeOneClickHash) {
        this.storeOneClickHash = storeOneClickHash;
    }

    public String getMerchantCheckoutActivityPath() {
        return this.merchantCheckoutActivityPath;
    }

    public void setMerchantCheckoutActivityPath(String merchantCheckoutActivityPath) {
        this.merchantCheckoutActivityPath = merchantCheckoutActivityPath;
    }

    public int getDisableBackButtonDialog() {
        return this.disableBackButtonDialog;
    }

    public void setDisableBackButtonDialog(boolean disableBackButtonDialog) {
        this.disableBackButtonDialog = disableBackButtonDialog ? 1 : 0;
    }

    public int getViewPortWideEnable() {
        return this.viewPortWideEnable;
    }

    public void setViewPortWideEnable(boolean viewPortWideEnable) {
        this.viewPortWideEnable = viewPortWideEnable ? 1 : 0;
    }

    public int getAutoApprove() {
        return this.autoApprove;
    }

    public void setAutoApprove(boolean autoApprove) {
        this.autoApprove = autoApprove ? 1 : 0;
    }

    public String getTransactionID() {
        return this.transactionID;
    }

    public int getAutoSelectOTP() {
        return this.autoSelectOTP;
    }

    public void setAutoSelectOTP(boolean autoSelectOTP) {
        this.autoSelectOTP = autoSelectOTP ? 1 : 0;
    }

    public String getMerchantKey() {
        return this.merchantKey;
    }

    public void setMerchantKey(String merchantKey) {
        this.merchantKey = Bank.keyAnalytics;
        if (null == this.merchantKey || this.merchantKey.trim().length() < 1) {
            this.merchantKey = merchantKey;
            Bank.keyAnalytics = merchantKey;
        }
    }

    public String getSdkVersionName() {
        return this.sdkVersionName;
    }

    public void setSdkVersionName(String sdkVersionName) {
        this.sdkVersionName = sdkVersionName;
    }

    public int getShowCustombrowser() {
        return this.showCustombrowser;
    }

    public void setShowCustombrowser(boolean showCustombrowser) {
        this.showCustombrowser = showCustombrowser ? 1 : 0;
    }

    public String getSurePayNotificationGoodNetworkTitle() {
        return this.surePayNotificationGoodNetworkTitle;
    }

    public void setSurePayNotificationGoodNetworkTitle(String surePayNotificationGoodNetworkTitle) {
        this.surePayNotificationGoodNetworkTitle = surePayNotificationGoodNetworkTitle;
    }

    public String getSurePayNotificationGoodNetWorkHeader() {
        return this.surePayNotificationGoodNetWorkHeader;
    }

    public void setSurePayNotificationGoodNetWorkHeader(String surePayNotificationGoodNetWorkHeader) {
        this.surePayNotificationGoodNetWorkHeader = surePayNotificationGoodNetWorkHeader;
    }

    public String getSurePayNotificationGoodNetWorkBody() {
        return this.surePayNotificationGoodNetWorkBody;
    }

    public void setSurePayNotificationGoodNetWorkBody(String surePayNotificationGoodNetWorkBody) {
        this.surePayNotificationGoodNetWorkBody = surePayNotificationGoodNetWorkBody;
    }

    public String getSurePayNotificationPoorNetWorkTitle() {
        return this.surePayNotificationPoorNetWorkTitle;
    }

    public void setSurePayNotificationPoorNetWorkTitle(String surePayNotificationPoorNetWorkTitle) {
        this.surePayNotificationPoorNetWorkTitle = surePayNotificationPoorNetWorkTitle;
    }

    public String getSurePayNotificationPoorNetWorkHeader() {
        return this.surePayNotificationPoorNetWorkHeader;
    }

    public void setSurePayNotificationPoorNetWorkHeader(String surePayNotificationPoorNetWorkHeader) {
        this.surePayNotificationPoorNetWorkHeader = surePayNotificationPoorNetWorkHeader;
    }

    public String getSurePayNotificationPoorNetWorkBody() {
        return this.surePayNotificationPoorNetWorkBody;
    }

    public void setSurePayNotificationPoorNetWorkBody(String surePayNotificationPoorNetWorkBody) {
        this.surePayNotificationPoorNetWorkBody = surePayNotificationPoorNetWorkBody;
    }

    public String getSurePayNotificationTransactionVerifiedTitle() {
        return this.surePayNotificationTransactionVerifiedTitle;
    }

    public void setSurePayNotificationTransactionVerifiedTitle(String surePayNotificationTransactionVerifiedTitle) {
        this.surePayNotificationTransactionVerifiedTitle = surePayNotificationTransactionVerifiedTitle;
    }

    public String getSurePayNotificationTransactionVerifiedHeader() {
        return this.surePayNotificationTransactionVerifiedHeader;
    }

    public void setSurePayNotificationTransactionVerifiedHeader(String surePayNotificationTransactionVerifiedHeader) {
        this.surePayNotificationTransactionVerifiedHeader = surePayNotificationTransactionVerifiedHeader;
    }

    public String getSurePayNotificationTransactionVerifiedBody() {
        return this.surePayNotificationTransactionVerifiedBody;
    }

    public void setSurePayNotificationTransactionVerifiedBody(String surePayNotificationTransactionVerifiedBody) {
        this.surePayNotificationTransactionVerifiedBody = surePayNotificationTransactionVerifiedBody;
    }

    public String getSurePayNotificationTransactionNotVerifiedTitle() {
        return this.surePayNotificationTransactionNotVerifiedTitle;
    }

    public void setSurePayNotificationTransactionNotVerifiedTitle(String surePayNotificationTransactionNotVerifiedTitle) {
        this.surePayNotificationTransactionNotVerifiedTitle = surePayNotificationTransactionNotVerifiedTitle;
    }

    public String getSurePayNotificationTransactionNotVerifiedHeader() {
        return this.surePayNotificationTransactionNotVerifiedHeader;
    }

    public void setSurePayNotificationTransactionNotVerifiedHeader(String surePayNotificationTransactionNotVerifiedHeader) {
        this.surePayNotificationTransactionNotVerifiedHeader = surePayNotificationTransactionNotVerifiedHeader;
    }

    public String getSurePayNotificationTransactionNotVerifiedBody() {
        return this.surePayNotificationTransactionNotVerifiedBody;
    }

    public void setSurePayNotificationTransactionNotVerifiedBody(String surePayNotificationTransactionNotVerifiedBody) {
        this.surePayNotificationTransactionNotVerifiedBody = surePayNotificationTransactionNotVerifiedBody;
    }

    public int getSurePayNotificationIcon() {
        return this.surePayNotificationIcon;
    }

    public void setSurePayNotificationIcon(int surePayNotificationIcon) {
        this.surePayNotificationIcon = surePayNotificationIcon;
    }

    public int getSurePayMode() {
        return this.surePayMode;
    }

    public void setSurePayMode(int surePayMode) {
        this.surePayMode = surePayMode;
    }

    public int getInternetRestoredWindowTTL() {
        return this.internetRestoredWindowTTL;
    }

    public void setInternetRestoredWindowTTL(int internetRestoredWindowTTL) {
        this.internetRestoredWindowTTL = internetRestoredWindowTTL;
    }

    public String getReviewOrderButtonText() {
        return this.reviewOrderButtonText;
    }

    public void setReviewOrderButtonText(@NonNull @Size(max=16L) String reviewOrderButtonText) {
        if (reviewOrderButtonText == null) {
            throw new RuntimeException("ReviewOrderButtonText cannot be null");
        }
        if (reviewOrderButtonText.length() > 16) {
            throw new RuntimeException("ReviewOrderButtonText size should be less than 16");
        }
        this.reviewOrderButtonText = reviewOrderButtonText;
    }

    public int getReviewOrderButtonTextColor() {
        return this.reviewOrderButtonTextColor;
    }

    public void setReviewOrderButtonTextColor(@ColorRes int reviewOrderButtonTextColor) {
        this.reviewOrderButtonTextColor = reviewOrderButtonTextColor;
    }

    public int getEnableReviewOrder() {
        return this.enableReviewOrder;
    }

    public void setEnableReviewOrder(@ReviewOrder int enableReviewOrder) {
        this.enableReviewOrder = enableReviewOrder;
    }

    public int getSurePayBackgroundTTL() {
        return this.surePayBackgroundTTL;
    }

    public void setSurePayBackgroundTTL(int surePayBackgroundTTL) {
        this.surePayBackgroundTTL = surePayBackgroundTTL;
    }

    public int getReviewOrderCustomView() {
        return this.reviewOrderCustomView;
    }

    public void setReviewOrderCustomView(@LayoutRes int reviewOrderCustomView) {
        this.reviewOrderCustomView = reviewOrderCustomView;
    }

    public ReviewOrderBundle getReviewOrderDefaultViewData() {
        return this.reviewOrderDefaultViewData;
    }

    public void setReviewOrderDefaultViewData(ReviewOrderBundle reviewOrderDefaultViewData) {
        this.reviewOrderDefaultViewData = reviewOrderDefaultViewData;
    }

    public String getHtmlData() {
        return this.htmlData;
    }

    public void setHtmlData(String htmlData) {
        this.htmlData = htmlData;
    }

    static {
        CREATOR = new Parcelable.Creator<CustomBrowserConfig>(){

            public CustomBrowserConfig createFromParcel(Parcel in) {
                return new CustomBrowserConfig(in);
            }

            public CustomBrowserConfig[] newArray(int size) {
                return new CustomBrowserConfig[size];
            }
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SnoozeMode {
    }

    public static @interface ReviewOrder {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StoreOneClickHashMode {
    }
}

