/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.payu.custombrowser.CBActivity;
import com.payu.custombrowser.PayUCustomBrowserCallback;
import com.payu.custombrowser.SamsungPayWrapper;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.upiintent.Payment;
import com.payu.custombrowser.upiintent.PaymentResponseActivity;
import com.payu.custombrowser.upiintent.UPIUtil;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.PaymentOption;
import com.payu.custombrowser.util.PaymentOptionHandler;

public class CustomBrowser {
    public void checkForPaymentAvailability(Activity activity, @NonNull PaymentOption paymentOption, @NonNull PayUCustomBrowserCallback payUCustomBrowserCallback, String paymentOptionHash, String merchantKey, String user_credentials) {
        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(payUCustomBrowserCallback);
        switch (paymentOption) {
            case SAMSUNGPAY: {
                if (CBUtil.isSPModuleAvailable()) {
                    SamsungPayWrapper samsungPayWrapper = new SamsungPayWrapper();
                    samsungPayWrapper.checkForSamsungPayAvailability(activity.getApplicationContext(), paymentOptionHash, merchantKey, user_credentials);
                    CustomBrowserData.SINGLETON.setSamsungPayWrapper(samsungPayWrapper);
                    break;
                }
                payUCustomBrowserCallback.onCBErrorReceived(1022, "Device not supported or com.payu.samsungpay is missing");
                break;
            }
            case CC: 
            case NB: 
            case DC: {
                PaymentOptionHandler paymentOptionHandler = new PaymentOptionHandler(activity, payUCustomBrowserCallback, merchantKey, paymentOptionHash, user_credentials);
            }
        }
    }

    public void addCustomBrowser(Activity activity, @NonNull CustomBrowserConfig cbCustomBrowserConfig, @NonNull PayUCustomBrowserCallback cbPayUCustomBrowserCallback) {
        if (Build.VERSION.SDK_INT < 19) {
            cbPayUCustomBrowserCallback.onCBErrorReceived(101, "OS_NOT_SUPPORTED");
            return;
        }
        String paymentOptionName = null;
        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(cbPayUCustomBrowserCallback);
        if (null != cbCustomBrowserConfig.getPayuPostData() && cbCustomBrowserConfig.getEnableSurePay() > 0 && (cbCustomBrowserConfig.getPostURL().contentEquals("https://secure.payu.in/_payment") || cbCustomBrowserConfig.getPostURL().contentEquals("https://mobiletest.payu.in/_payment") || cbCustomBrowserConfig.getPostURL().contentEquals("https://mobiletest.payu.in/_seamless_payment") || cbCustomBrowserConfig.getPostURL().contentEquals("https://secure.payu.in/_seamless_payment"))) {
            if (cbCustomBrowserConfig.getPayuPostData().trim().endsWith("&")) {
                cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData().substring(0, cbCustomBrowserConfig.getPayuPostData().length() - 1));
            }
            cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData() + "&snooze=" + cbCustomBrowserConfig.getEnableSurePay());
        }
        UPIUtil upiUtil = new UPIUtil();
        Payment payment = upiUtil.getSupportedPayment(cbCustomBrowserConfig.getPayuPostData());
        paymentOptionName = new CBUtil().getDataFromPostData(cbCustomBrowserConfig.getPayuPostData()).get("bankcode");
        if (null != paymentOptionName && paymentOptionName.equalsIgnoreCase(PaymentOption.SAMSUNGPAY.getPaymentName())) {
            if (null != CustomBrowserData.SINGLETON.getSamsungPayWrapper()) {
                CustomBrowserData.SINGLETON.getSamsungPayWrapper().MakeSamsungPayPayment(activity, cbCustomBrowserConfig);
            } else {
                cbPayUCustomBrowserCallback.onCBErrorReceived(1021, "Forget to call checkForPaymentAvailability");
            }
        } else if (null != payment && upiUtil.isPaymentMethodSupported((Context)activity, payment)) {
            Intent intent = new Intent((Context)activity, PaymentResponseActivity.class);
            intent.putExtra("postData", cbCustomBrowserConfig.getPayuPostData());
            activity.startActivity(intent);
        } else if (null != payment && !payment.isWebFlowSupported()) {
            cbPayUCustomBrowserCallback.onCBErrorReceived(1001, "DEVICE_NOT_SUPPORTED");
        } else {
            CBActivity.cbDrawerAdapter = cbCustomBrowserConfig.getCbMenuAdapter();
            CBActivity.cbConfigToolbarView = cbCustomBrowserConfig.getToolBarView();
            Intent intent = new Intent((Context)activity, CBActivity.class);
            intent.putExtra("cb_config", (Parcelable)cbCustomBrowserConfig);
            if (cbCustomBrowserConfig.getReviewOrderDefaultViewData() != null && cbCustomBrowserConfig.getReviewOrderDefaultViewData().getReviewOrderDatas() != null) {
                intent.putExtra("order_details", cbCustomBrowserConfig.getReviewOrderDefaultViewData().getReviewOrderDatas());
            }
            activity.startActivity(intent);
        }
    }
}

