/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser.widgets;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import com.payu.custombrowser.R;
import java.util.Timer;
import java.util.TimerTask;

public class SnoozeLoaderView
extends View {
    Activity mActivity;
    private Paint activeBarPaint;
    private Paint inActiveBarPaint;
    private Rect firstBar;
    private Rect secondBar;
    private Rect thirdBar;
    private Paint firstBarPaint;
    private Paint secondBarPaint;
    private Paint thirdBarPaint;
    private int mBarWidth = 40;
    private int mBarHeight = 120;
    private int mBarSpace = 70;
    private int mBarHeightRatio = this.mBarHeight / 3;
    private boolean shouldStartAnimation = false;
    private int mActiveColor = Color.parseColor((String)"#00adf2");
    private int mInActiveColor = Color.parseColor((String)"#b0eafc");
    private int mAnimationSpeed = 200;
    private int blinkPosition = 0;
    private Timer timer;

    public SnoozeLoaderView(Context context) {
        super(context);
        this.mActivity = (Activity)context;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnoozeLoaderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mActivity = (Activity)context;
        TypedArray snoozeLoaderArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SnoozeLoaderView, 0, 0);
        try {
            this.shouldStartAnimation = snoozeLoaderArray.getBoolean(R.styleable.SnoozeLoaderView_startAnimate, this.shouldStartAnimation);
            this.mActiveColor = snoozeLoaderArray.getColor(R.styleable.SnoozeLoaderView_activeBarColor, this.mActiveColor);
            this.mInActiveColor = snoozeLoaderArray.getColor(R.styleable.SnoozeLoaderView_inActiveBarColor, this.mInActiveColor);
            this.mBarWidth = snoozeLoaderArray.getDimensionPixelSize(R.styleable.SnoozeLoaderView_barWidth, this.mBarWidth);
            this.mBarHeight = snoozeLoaderArray.getDimensionPixelSize(R.styleable.SnoozeLoaderView_barHeight, this.mBarHeight);
            this.mBarHeightRatio = this.mBarHeight / 3;
            this.mBarSpace = snoozeLoaderArray.getDimensionPixelSize(R.styleable.SnoozeLoaderView_barSpace, this.mBarSpace);
            this.mAnimationSpeed = snoozeLoaderArray.getInt(R.styleable.SnoozeLoaderView_animationSpeed, this.mAnimationSpeed);
            this.init();
        }
        finally {
            snoozeLoaderArray.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnoozeLoaderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mActivity = (Activity)context;
        TypedArray snoozeLoaderArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SnoozeLoaderView, 0, 0);
        try {
            this.shouldStartAnimation = snoozeLoaderArray.getBoolean(R.styleable.SnoozeLoaderView_startAnimate, this.shouldStartAnimation);
            this.mActiveColor = snoozeLoaderArray.getColor(R.styleable.SnoozeLoaderView_activeBarColor, this.mActiveColor);
            this.mInActiveColor = snoozeLoaderArray.getColor(R.styleable.SnoozeLoaderView_inActiveBarColor, this.mInActiveColor);
            this.mBarWidth = snoozeLoaderArray.getDimensionPixelSize(R.styleable.SnoozeLoaderView_barWidth, this.mBarWidth);
            this.mBarHeight = snoozeLoaderArray.getDimensionPixelSize(R.styleable.SnoozeLoaderView_barHeight, this.mBarHeight);
            this.mBarHeightRatio = this.mBarHeight / 3;
            this.mBarSpace = snoozeLoaderArray.getDimensionPixelSize(R.styleable.SnoozeLoaderView_barSpace, this.mBarSpace);
            this.init();
        }
        finally {
            snoozeLoaderArray.recycle();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawRect(this.firstBar, this.firstBarPaint);
        canvas.drawRect(this.secondBar, this.secondBarPaint);
        canvas.drawRect(this.thirdBar, this.thirdBarPaint);
    }

    public void updateBar(int position) {
        switch (position) {
            case 0: {
                this.firstBarPaint = this.inActiveBarPaint;
                this.secondBarPaint = this.inActiveBarPaint;
                this.thirdBarPaint = this.inActiveBarPaint;
                break;
            }
            case 1: {
                this.firstBarPaint = this.activeBarPaint;
                this.secondBarPaint = this.inActiveBarPaint;
                this.thirdBarPaint = this.inActiveBarPaint;
                break;
            }
            case 2: {
                this.firstBarPaint = this.activeBarPaint;
                this.secondBarPaint = this.activeBarPaint;
                this.thirdBarPaint = this.inActiveBarPaint;
                break;
            }
            case 3: {
                this.firstBarPaint = this.activeBarPaint;
                this.secondBarPaint = this.activeBarPaint;
                this.thirdBarPaint = this.activeBarPaint;
                break;
            }
            default: {
                this.firstBarPaint = this.inActiveBarPaint;
                this.secondBarPaint = this.inActiveBarPaint;
                this.thirdBarPaint = this.inActiveBarPaint;
            }
        }
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SnoozeLoaderView.this.invalidate();
            }
        });
    }

    private void init() {
        this.activeBarPaint = new Paint();
        this.activeBarPaint.setColor(this.mActiveColor);
        this.activeBarPaint.setStyle(Paint.Style.FILL);
        this.inActiveBarPaint = new Paint();
        this.inActiveBarPaint.setColor(this.mInActiveColor);
        this.inActiveBarPaint.setStyle(Paint.Style.FILL);
        this.firstBarPaint = this.inActiveBarPaint;
        this.secondBarPaint = this.inActiveBarPaint;
        this.thirdBarPaint = this.inActiveBarPaint;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int centerX = w / 2;
        int centerY = h / 2;
        int secondBarLeft = centerX - this.mBarWidth / 2;
        int secondBarTop = centerY - this.mBarHeight / 2;
        int secondBarRight = secondBarLeft + this.mBarWidth;
        int secondBarBottom = secondBarTop + this.mBarHeight;
        int firstBarLeft = centerX - this.mBarWidth - this.mBarSpace - this.mBarWidth / 2;
        int firstBarTop = centerY - this.mBarHeight / 2 - this.mBarHeightRatio;
        int firstBarRight = firstBarLeft + this.mBarWidth;
        int firstBarBottom = firstBarTop + this.mBarHeight + this.mBarHeightRatio + this.mBarHeightRatio;
        int thirdBarLeft = centerX + this.mBarWidth / 2 + this.mBarSpace;
        int thirdBarTop = centerY - this.mBarHeight / 2 + this.mBarHeightRatio;
        int thirdBarRight = thirdBarLeft + this.mBarWidth;
        int thirdBarBottom = thirdBarTop + this.mBarHeight - this.mBarHeightRatio - this.mBarHeightRatio;
        this.secondBar = new Rect(secondBarLeft, secondBarTop, secondBarRight, secondBarBottom);
        this.firstBar = new Rect(firstBarLeft, firstBarTop, firstBarRight, firstBarBottom);
        this.thirdBar = new Rect(thirdBarLeft, thirdBarTop, thirdBarRight, thirdBarBottom);
        if (this.shouldStartAnimation) {
            this.startAnimation();
        }
    }

    public void startAnimation() {
        this.shouldStartAnimation = true;
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (SnoozeLoaderView.this.blinkPosition == 4) {
                    SnoozeLoaderView.this.blinkPosition = 0;
                } else {
                    SnoozeLoaderView.this.blinkPosition = SnoozeLoaderView.this.blinkPosition + 1;
                }
                if (SnoozeLoaderView.this.shouldStartAnimation) {
                    SnoozeLoaderView.this.updateBar(SnoozeLoaderView.this.blinkPosition);
                } else {
                    this.cancel();
                }
            }
        }, 0L, (long)this.mAnimationSpeed);
    }

    public void cancelAnimation() {
        this.shouldStartAnimation = false;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int totalWidth = 3 * this.mBarWidth + 2 * this.mBarSpace + this.getPaddingLeft() + this.getPaddingRight();
        int totalHeight = this.mBarHeight + 2 * this.mBarHeightRatio + this.getPaddingTop() + this.getPaddingBottom();
        this.setMeasuredDimension(totalWidth, totalHeight);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.shouldStartAnimation = false;
    }
}

