/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser.upiintent;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.payu.custombrowser.upiintent.Payment;

public class UPIUtil {
    public boolean isPaymentMethodSupported(Context context, Payment payment) {
        if (Build.VERSION.SDK_INT >= payment.getMinSdk()) {
            try {
                context.getPackageManager().getPackageInfo(payment.getPackageName(), 0);
                return true;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    String getValuePostData(String postData, String key) {
        String[] list;
        for (String item : list = postData.split("&")) {
            String id;
            String[] items = item.split("=");
            if (items.length < 2 || !key.equalsIgnoreCase(id = items[0])) continue;
            return items[1];
        }
        return "";
    }

    public Payment getSupportedPayment(String postData) {
        if (null != postData) {
            String paymentMethod = this.getValuePostData(postData, "bankcode");
            for (Payment payment : Payment.values()) {
                if (!payment.getPaymentName().equalsIgnoreCase(paymentMethod)) continue;
                return payment;
            }
        }
        return null;
    }

    public String getUPIIntent(String payeeVpa, String payeeName, String amount, String transactionId, String transactionRefId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("upi://pay?");
        stringBuilder.append("pa");
        stringBuilder.append("=");
        stringBuilder.append(payeeVpa);
        stringBuilder.append("&");
        stringBuilder.append("pn");
        stringBuilder.append("=");
        stringBuilder.append(payeeName);
        stringBuilder.append("&");
        stringBuilder.append("am");
        stringBuilder.append("=");
        stringBuilder.append(amount);
        stringBuilder.append("&");
        stringBuilder.append("tr");
        stringBuilder.append("=");
        stringBuilder.append(transactionRefId);
        stringBuilder.append("&");
        stringBuilder.append("tid");
        stringBuilder.append("=");
        stringBuilder.append(transactionId);
        return stringBuilder.toString();
    }
}

