/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.support.annotation.NonNull;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import com.payu.custombrowser.Bank;
import com.payu.custombrowser.util.CBUtil;
import com.payu.magicretry.MagicRetryFragment;
import com.payu.magicretry.WebClient.MagicRetryWebViewClient;

public class PayUWebViewClient
extends MagicRetryWebViewClient {
    private boolean loadingFinished = true;
    private boolean redirect = false;
    private String mainUrl = "";
    private Bank bank;

    public PayUWebViewClient(@NonNull Bank bank, @NonNull String merchantKey) {
        this.bank = bank;
        if (Bank.keyAnalytics == null) {
            Bank.keyAnalytics = merchantKey;
        }
    }

    public PayUWebViewClient(@NonNull Bank bank, @NonNull MagicRetryFragment magicRetryFragment, @NonNull String merchantKey) {
        super(magicRetryFragment);
        this.bank = bank;
        if (Bank.keyAnalytics == null) {
            Bank.keyAnalytics = merchantKey;
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.loadingFinished = false;
        if (this.bank != null) {
            this.bank.onPageStartedWebclient(url);
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (!this.redirect) {
            this.loadingFinished = true;
        }
        if (url.equals(this.mainUrl)) {
            this.loadingFinished = true;
            this.redirect = false;
        } else {
            this.redirect = false;
        }
        if (this.bank != null) {
            this.bank.onPageFinishWebclient(url);
        }
    }

    public void onLoadResource(WebView view, String url) {
        if (this.bank != null) {
            this.bank.onLoadResourse(view, url);
        }
        super.onLoadResource(view, url);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        if (failingUrl != null && this.bank != null && Build.VERSION.SDK_INT < 23) {
            this.bank.onReceivedErrorWebClient(errorCode, description);
        }
    }

    @TargetApi(value=23)
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
        if (this.bank != null) {
            this.bank.onReceivedErrorWebClient(error.getErrorCode(), error.getDescription().toString());
        }
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        this.bank.onReceivedSslError(view, handler, error);
        if (Build.VERSION.SDK_INT <= 10) {
            handler.proceed();
        } else if (Build.VERSION.SDK_INT >= 14) {
            // empty if block
        }
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        this.mainUrl = url;
        if (CBUtil.isPlayStoreUrl(url)) {
            CBUtil.launchPlayStore(this.bank.getContext(), url, CBUtil.getWebViewVersion(view));
            return true;
        }
        if (!this.loadingFinished) {
            this.redirect = true;
        }
        this.loadingFinished = false;
        if (this.bank != null) {
            this.bank.onOverrideURL(url);
        }
        return false;
    }
}

