/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser.services;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.NotificationCompat;
import com.payu.custombrowser.Bank;
import com.payu.custombrowser.CBActivity;
import com.payu.custombrowser.R;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Random;
import javax.net.ssl.SSLException;
import org.json.JSONException;
import org.json.JSONObject;

public class SnoozeService
extends Service {
    private static int IMAGE_DOWNLOAD_TIME_OUT;
    private int SNOOZE_SERVICE_TTL = 1800000;
    private final int TRACK_WEB_VIEW_TIME_INTERVAL = 500;
    private final String SNOOZE_GET_WEBVIEW_STATUS_INTENT_ACTION = "webview_status_action";
    private final String SNOOZE_BROAD_CAST_MESSAGE = "snooze_broad_cast_message";
    private final String CURRENT_URL = "currentUrl";
    private final IBinder snoozeBinder = new SnoozeBinder();
    String MERCHANT_CHECKOUT_ACTIVITY = "merchantCheckoutActivity";
    private Handler handler;
    private Runnable runnable;
    private Handler trackWebViewStatusHandler;
    private HandlerThread snoozeHandlerThread;
    private CountDownTimer killSnoozeServiceCounter;
    private Looper mServiceLooper;
    private ServiceHandler mServiceHandler;
    private long startTime;
    private long endTime;
    private int exponentialBackOffTime = 1000;
    private int EXPONENTIAL_BACKOFF_TIME_THRESHOLD = 60000;
    private long imageDownloadTime;
    private String broadCastingMessage = "";
    private String receivedMessage = "";
    private String postData = "";
    private String postURL = "";
    private String currentUrl = "";
    private String merchantCheckoutActivity;
    private boolean isImageDownloadTimedOut;
    private boolean isServiceAlive = true;
    private boolean isWebViewAlive;
    private boolean isNotificationIntentPrepared;
    private boolean isWebViewIntentPrepared;
    private long timeToNotify;
    private boolean verifyPaymentCheck;
    private String verifyURL = "https://info.payu.in/merchant/postservice?form=2";
    private CustomBrowserConfig customBrowserConfig;
    private String payuResponse;
    private CBUtil cbUtil;
    private String verifyParam;
    private HashMap<String, String> postParamsMap;
    private Runnable verifyPaymentRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                URL url = new URL(SnoozeService.this.verifyURL);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                String post = "command=verifyTxnStatus&var1=" + SnoozeService.this.cbUtil.getDataFromPostData(SnoozeService.this.postData, "txnid") + "&key=" + SnoozeService.this.cbUtil.getDataFromPostData(SnoozeService.this.postData, "key") + "&priorityParam=" + SnoozeService.this.verifyParam;
                conn.setRequestMethod("POST");
                conn.setConnectTimeout(120000);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Content-Length", String.valueOf(post.length()));
                conn.setRequestProperty("Cookie", "PHPSESSID=" + SnoozeService.this.cbUtil.getCookie("PHPSESSID", SnoozeService.this.getApplicationContext()) + "; PAYUID=" + SnoozeService.this.cbUtil.getCookie("PAYUID", SnoozeService.this.getApplicationContext()));
                conn.setDoOutput(true);
                byte[] postParamsByte = post.getBytes();
                conn.getOutputStream().write(postParamsByte);
                byte[] buffer = new byte[1024];
                if (conn.getResponseCode() == 200) {
                    StringBuffer responseStringBuffer;
                    if (conn.getInputStream() != null && (responseStringBuffer = CBUtil.getStringBufferFromInputStream(conn.getInputStream())) != null) {
                        JSONObject jsonObject = new JSONObject(responseStringBuffer.toString());
                        SnoozeService.this.payuResponse = responseStringBuffer.toString();
                        SnoozeService.this.onTransactionStatusReceived(responseStringBuffer.toString());
                    }
                } else {
                    SnoozeService.this.onTransactionStatusReceived("{\"api_status\":\"0\",\"message\":\"Some error occurred\"}");
                }
            }
            catch (Exception e) {
                SnoozeService.this.onTransactionStatusReceived("{\"api_status\":\"0\",\"message\":\"Some exception occurred\"}");
                e.printStackTrace();
            }
        }
    };

    private void onTransactionStatusReceived(String response) {
        try {
            String verifyApiStatus = CBUtil.getValueOfJSONKey(response, this.getString(R.string.cb_snooze_verify_api_status));
            if (CBActivity.STATE == 2) {
                if (verifyApiStatus.contentEquals("1")) {
                    this.broadcastAnalyticsEvent("transaction_verified_notification", "-1");
                } else {
                    this.broadcastAnalyticsEvent("transaction_not_verified_notification", "-1");
                }
                this.launchNotificationTransactionUpdate(response);
            } else {
                if (verifyApiStatus.contentEquals("1")) {
                    this.broadcastAnalyticsEvent("transaction_verified_dialog_foreground", "-1");
                } else {
                    this.broadcastAnalyticsEvent("transaction_not_verified_dialog_foreground", "-1");
                }
                this.broadcastEvent("backward_journey_status", response, false);
                this.killSnoozeService();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            if (CBActivity.STATE == 2) {
                this.broadcastAnalyticsEvent("transaction_not_verified_notification", "-1");
                this.launchNotificationTransactionUpdate(response);
            }
            this.broadcastAnalyticsEvent("transaction_not_verified_dialog_foreground", "-1");
            this.broadcastEvent("backward_journey_status", response, false);
            this.killSnoozeService();
        }
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        this.isWebViewAlive = true;
        return this.snoozeBinder;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.cbUtil = new CBUtil();
        this.merchantCheckoutActivity = intent.getStringExtra(this.MERCHANT_CHECKOUT_ACTIVITY);
        this.customBrowserConfig = (CustomBrowserConfig)intent.getParcelableExtra("cb_config");
        this.SNOOZE_SERVICE_TTL = this.customBrowserConfig.getSurePayBackgroundTTL();
        this.postParamsMap = this.cbUtil.getDataFromPostData(this.customBrowserConfig.getPayuPostData());
        int n = IMAGE_DOWNLOAD_TIME_OUT = Bank.snoozeImageDownloadTimeout > 0 ? Bank.snoozeImageDownloadTimeout : 10000;
        if (intent.getExtras().containsKey("verificationMsgReceived") && intent.getExtras().getBoolean("verificationMsgReceived")) {
            this.verifyPaymentCheck = true;
            if (intent.getExtras().containsKey("verify_add_param")) {
                this.verifyParam = intent.getExtras().getString("verify_add_param");
            }
            this.postData = this.customBrowserConfig.getPayuPostData();
            this.postURL = this.customBrowserConfig.getPostURL();
        } else {
            this.verifyPaymentCheck = false;
            this.currentUrl = intent.getStringExtra("currentUrl");
        }
        Message msg = this.mServiceHandler.obtainMessage();
        msg.arg1 = startId;
        this.mServiceHandler.sendMessage(msg);
        if (Bank.hasToStart) {
            return 3;
        }
        return 2;
    }

    public void onCreate() {
        String SNOOZE_SERVICE_HANDLER_THREAD = "SnoozeServiceHandlerThread";
        this.snoozeHandlerThread = new HandlerThread(SNOOZE_SERVICE_HANDLER_THREAD, 10);
        this.snoozeHandlerThread.start();
        this.mServiceLooper = this.snoozeHandlerThread.getLooper();
        this.mServiceHandler = new ServiceHandler(this.mServiceLooper);
    }

    public void killSnoozeService() {
        this.isServiceAlive = false;
        if (this.killSnoozeServiceCounter != null) {
            this.killSnoozeServiceCounter.cancel();
            this.killSnoozeServiceCounter = null;
        }
        this.snoozeHandlerThread.interrupt();
        this.stopSelf();
    }

    public void updateWebviewStatus(String webviewStatus) {
        this.receivedMessage = webviewStatus;
    }

    private void calculateInternetSpeed() {
        this.handler = new Handler(this.mServiceLooper);
        this.runnable = new Runnable(){

            @Override
            public void run() {
                if (SnoozeService.this.isServiceAlive) {
                    SnoozeService.this.downloadImage();
                }
            }
        };
        this.handler.postDelayed(this.runnable, (long)Math.min(this.exponentialBackOffTime, this.EXPONENTIAL_BACKOFF_TIME_THRESHOLD));
    }

    private void downloadImage() {
        this.isImageDownloadTimedOut = false;
        final String imageURL = "https://static.payu.in/images/speed_test/" + CBConstant.SNOOZE_IMAGE_COLLECTIONS[new Random().nextInt(2)];
        final CountDownTimer imageDownloadTimer = new CountDownTimer(IMAGE_DOWNLOAD_TIME_OUT, 1000L){

            public void onTick(long l) {
            }

            public void onFinish() {
                this.cancel();
                SnoozeService.this.isImageDownloadTimedOut = true;
            }
        };
        imageDownloadTimer.start();
        Thread downloadImageThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SnoozeService.this.cbUtil;
                    if (CBUtil.isNetworkAvailable(SnoozeService.this.getApplicationContext())) {
                        SnoozeService.this.startTime = System.currentTimeMillis();
                        URLConnection connection = new URL(imageURL).openConnection();
                        connection.setUseCaches(false);
                        connection.connect();
                        int imageSize = connection.getContentLength();
                        InputStream input = connection.getInputStream();
                        byte[] buffer = new byte[1024];
                        while (!SnoozeService.this.isImageDownloadTimedOut && input.read(buffer) != -1) {
                        }
                        if (SnoozeService.this.isImageDownloadTimedOut) {
                            imageDownloadTimer.cancel();
                            input.close();
                            SnoozeService.this.imageDownloadTime = IMAGE_DOWNLOAD_TIME_OUT + 1;
                        } else {
                            imageDownloadTimer.cancel();
                            SnoozeService.this.endTime = System.currentTimeMillis();
                            input.close();
                            SnoozeService.this.imageDownloadTime = SnoozeService.this.endTime - SnoozeService.this.startTime;
                        }
                        if (SnoozeService.this.imageDownloadTime > (long)IMAGE_DOWNLOAD_TIME_OUT) {
                            SnoozeService.this.exponentialBackOffTime = SnoozeService.this.exponentialBackOffTime + SnoozeService.this.exponentialBackOffTime;
                            SnoozeService.this.handler.postDelayed(SnoozeService.this.runnable, (long)Math.min(SnoozeService.this.exponentialBackOffTime, SnoozeService.this.EXPONENTIAL_BACKOFF_TIME_THRESHOLD));
                        } else if (SnoozeService.this.isServiceAlive) {
                            if (SnoozeService.this.verifyPaymentCheck) {
                                SnoozeService.this.broadcastAnalyticsEvent("snooze_verify_api_status", "snooze_verify_api_called");
                                new Thread(SnoozeService.this.verifyPaymentRunnable).start();
                            } else if (CBActivity.STATE == 1) {
                                SnoozeService.this.broadcastEvent(SnoozeService.this.getString(R.string.internet_restored), SnoozeService.this.getString(R.string.resuming_your_transaction), true);
                                SnoozeService.this.broadcastAnalyticsEvent("internet_restored_dialog_foreground", "-1");
                                SnoozeService.this.killSnoozeService();
                            } else {
                                SnoozeService.this.launchNotification(SnoozeService.this.isWebViewAlive);
                                SnoozeService.this.broadcastAnalyticsEvent("internet_restored_notification", "-1");
                            }
                        }
                    } else {
                        SnoozeService.this.handler.postDelayed(SnoozeService.this.runnable, (long)Math.min(SnoozeService.this.exponentialBackOffTime, SnoozeService.this.EXPONENTIAL_BACKOFF_TIME_THRESHOLD));
                    }
                }
                catch (MalformedURLException e) {
                    SnoozeService.this.imageDownloadTime = -1L;
                    imageDownloadTimer.cancel();
                    e.printStackTrace();
                }
                catch (SSLException e) {
                    SnoozeService.this.handler.postDelayed(SnoozeService.this.runnable, (long)Math.min(SnoozeService.this.exponentialBackOffTime, SnoozeService.this.EXPONENTIAL_BACKOFF_TIME_THRESHOLD));
                    e.printStackTrace();
                }
                catch (IOException e) {
                    SnoozeService.this.imageDownloadTime = -1L;
                    imageDownloadTimer.cancel();
                    e.printStackTrace();
                }
                catch (Exception e) {
                    SnoozeService.this.imageDownloadTime = -1L;
                    imageDownloadTimer.cancel();
                }
            }
        });
        downloadImageThread.start();
    }

    private void launchNotification(boolean webViewLiving) {
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder((Context)this);
        mBuilder.setContentTitle((CharSequence)this.customBrowserConfig.getSurePayNotificationGoodNetworkTitle()).setContentText((CharSequence)this.customBrowserConfig.getSurePayNotificationGoodNetWorkHeader()).setSmallIcon(this.customBrowserConfig.getSurePayNotificationIcon()).setAutoCancel(true).setPriority(1).setDefaults(2).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)(this.customBrowserConfig.getSurePayNotificationGoodNetWorkHeader() + "\n\n" + this.customBrowserConfig.getSurePayNotificationGoodNetWorkBody())));
        if (Build.VERSION.SDK_INT >= 23) {
            mBuilder.setColor(this.getResources().getColor(R.color.cb_blue_button, null));
        } else {
            mBuilder.setColor(this.getResources().getColor(R.color.cb_blue_button));
        }
        this.isNotificationIntentPrepared = true;
        Intent notifyIntent = new Intent();
        notifyIntent.putExtra("currentUrl", this.currentUrl);
        notifyIntent.putExtra("sender", "snoozeService");
        boolean isValidMerchantCheckoutActivity = true;
        if (webViewLiving) {
            this.isWebViewIntentPrepared = true;
            notifyIntent.setFlags(0x20000000);
            notifyIntent.putExtra("currentUrl", this.currentUrl);
            notifyIntent.putExtra("cb_config", (Parcelable)this.customBrowserConfig);
            notifyIntent.setClass(this.getApplicationContext(), CBActivity.class);
        } else {
            Intent checkValidActivityIntent = new Intent();
            checkValidActivityIntent.setClassName(this.getApplicationContext(), this.merchantCheckoutActivity == null ? "" : this.merchantCheckoutActivity);
            if (null != checkValidActivityIntent.resolveActivityInfo(this.getPackageManager(), 0)) {
                notifyIntent.setClassName(this.getApplicationContext(), this.merchantCheckoutActivity);
                notifyIntent.putExtra("post_type", "sure_pay_payment_data");
                notifyIntent.putExtra("postData", this.customBrowserConfig.getPayuPostData());
            } else {
                isValidMerchantCheckoutActivity = false;
            }
            this.broadcastAnalyticsEvent("snooze_notification_expected_action", "merchant_checkout_page");
            this.isWebViewIntentPrepared = false;
            this.killSnoozeService();
        }
        try {
            if (!isValidMerchantCheckoutActivity) {
                throw new ActivityNotFoundException("The Activity " + this.merchantCheckoutActivity + " is not found, Please set valid activity ");
            }
            PendingIntent notifyPendingIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)notifyIntent, (int)0x8000000);
            mBuilder.setContentIntent(notifyPendingIntent);
            NotificationManager mNotificationManager = (NotificationManager)this.getSystemService("notification");
            mNotificationManager.notify(CBConstant.SNOOZE_NOTIFICATION_ID, mBuilder.build());
            this.broadcastEvent("good_network_notification_launched", "true", true);
        }
        catch (ActivityNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void broadcastAnalyticsEvent(String key, String value) {
        Intent broadCastIntent = new Intent("webview_status_action");
        broadCastIntent.putExtra("BROAD_CAST_FROM_SNOOZE_SERVICE", true);
        broadCastIntent.putExtra("event_key", key);
        broadCastIntent.putExtra("event_value", value);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(broadCastIntent);
    }

    private void launchNotificationTransactionUpdate(String verifyResponse) {
        try {
            String verifyApiStatus = CBUtil.getValueOfJSONKey(verifyResponse, this.getString(R.string.cb_snooze_verify_api_status));
            this.broadcastAnalyticsEvent("snooze_verify_api_response_received", verifyApiStatus + "");
            NotificationCompat.Builder mBuilder = new NotificationCompat.Builder((Context)this);
            String snoozeNotificationTxnVerifiedBigText = verifyApiStatus.contentEquals("1") ? this.customBrowserConfig.getSurePayNotificationTransactionVerifiedHeader() + "\n\n" + this.customBrowserConfig.getSurePayNotificationTransactionVerifiedBody() : this.customBrowserConfig.getSurePayNotificationTransactionNotVerifiedHeader() + "\n\n" + this.customBrowserConfig.getSurePayNotificationTransactionNotVerifiedBody();
            mBuilder.setContentTitle((CharSequence)(verifyApiStatus.contentEquals("1") ? this.customBrowserConfig.getSurePayNotificationTransactionVerifiedTitle() : this.customBrowserConfig.getSurePayNotificationTransactionNotVerifiedTitle())).setContentText((CharSequence)(verifyApiStatus.contentEquals("1") ? this.customBrowserConfig.getSurePayNotificationTransactionVerifiedHeader() : this.customBrowserConfig.getSurePayNotificationTransactionNotVerifiedHeader())).setSmallIcon(this.customBrowserConfig.getSurePayNotificationIcon()).setAutoCancel(true).setPriority(1).setDefaults(2).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)snoozeNotificationTxnVerifiedBigText));
            Intent notifyIntent = new Intent();
            notifyIntent.putExtra("cb_config", (Parcelable)this.customBrowserConfig);
            this.isNotificationIntentPrepared = true;
            notifyIntent.putExtra("payu_response", verifyResponse);
            boolean isValidMerchantCheckoutActivity = true;
            if (this.isWebViewAlive) {
                notifyIntent.setFlags(0x30000000);
                this.isWebViewIntentPrepared = true;
                notifyIntent.putExtra("sender", "snoozeService");
                notifyIntent.putExtra("verificationMsgReceived", true);
                notifyIntent.setClass(this.getApplicationContext(), CBActivity.class);
            } else {
                Intent checkValidActivityIntent = new Intent();
                checkValidActivityIntent.setClassName(this.getApplicationContext(), this.merchantCheckoutActivity == null ? "" : this.merchantCheckoutActivity);
                if (null != checkValidActivityIntent.resolveActivityInfo(this.getPackageManager(), 0)) {
                    notifyIntent.putExtra("postData", verifyResponse);
                    notifyIntent.setClassName(this.getApplicationContext(), this.merchantCheckoutActivity);
                    notifyIntent.putExtra("post_type", "verify_response_post_data");
                } else {
                    isValidMerchantCheckoutActivity = false;
                }
                this.broadcastAnalyticsEvent("snooze_notification_expected_action", "merchant_checkout_page");
                this.isWebViewIntentPrepared = false;
                this.killSnoozeService();
            }
            try {
                if (!isValidMerchantCheckoutActivity) {
                    throw new ActivityNotFoundException("The Activity " + this.merchantCheckoutActivity + " is not found, Please set valid activity ");
                }
                PendingIntent notifyPendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)notifyIntent, (int)0x8000000);
                mBuilder.setContentIntent(notifyPendingIntent);
                NotificationManager mNotificationManager = (NotificationManager)this.getSystemService("notification");
                mNotificationManager.notify(CBConstant.TRANSACTION_STATUS_NOTIFICATION_ID, mBuilder.build());
                this.broadcastEvent("good_network_notification_launched", verifyResponse, false);
            }
            catch (ActivityNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void launchNoInternetNotification() {
        this.broadcastAnalyticsEvent("snooze_notification_expected_action", "merchant_checkout_page");
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder((Context)this);
        mBuilder.setContentTitle((CharSequence)this.customBrowserConfig.getSurePayNotificationPoorNetWorkTitle()).setContentText((CharSequence)this.customBrowserConfig.getSurePayNotificationPoorNetWorkHeader()).setSmallIcon(this.customBrowserConfig.getSurePayNotificationIcon()).setAutoCancel(true).setPriority(1).setDefaults(2).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)(this.customBrowserConfig.getSurePayNotificationPoorNetWorkHeader() + this.customBrowserConfig.getSurePayNotificationPoorNetWorkBody())));
        if (Build.VERSION.SDK_INT >= 23) {
            mBuilder.setColor(this.getResources().getColor(R.color.cb_blue_button, null));
        } else {
            mBuilder.setColor(this.getResources().getColor(R.color.cb_blue_button));
        }
        Intent checkValidActivityIntent = new Intent();
        checkValidActivityIntent.setClassName(this.getApplicationContext(), this.merchantCheckoutActivity == null ? "" : this.merchantCheckoutActivity);
        if (null != checkValidActivityIntent.resolveActivityInfo(this.getPackageManager(), 0)) {
            Intent notifyIntent = new Intent();
            notifyIntent.setClassName(this.getApplicationContext(), this.merchantCheckoutActivity);
            notifyIntent.putExtra("post_type", "sure_pay_payment_data");
            notifyIntent.putExtra("postData", this.customBrowserConfig.getPayuPostData());
            PendingIntent notifyPendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)notifyIntent, (int)0x8000000);
            mBuilder.setContentIntent(notifyPendingIntent);
            NotificationManager mNotificationManager = (NotificationManager)this.getSystemService("notification");
            mNotificationManager.notify(CBConstant.SNOOZE_NOTIFICATION_ID, mBuilder.build());
        } else {
            try {
                throw new ActivityNotFoundException("The Activity " + this.merchantCheckoutActivity + " is not found, Please set valid activity ");
            }
            catch (ActivityNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void broadcastEvent(String key, String value, boolean isForward) {
        Intent broadCastIntent = new Intent("webview_status_action");
        broadCastIntent.putExtra("broadcast_from_service_update_ui", true);
        broadCastIntent.putExtra("key", key);
        broadCastIntent.putExtra("value", value);
        broadCastIntent.putExtra("currentUrl", this.currentUrl);
        broadCastIntent.putExtra("cb_config", (Parcelable)this.customBrowserConfig);
        broadCastIntent.putExtra("is_forward_journey", isForward);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(broadCastIntent);
    }

    public class SnoozeBinder
    extends Binder {
        public SnoozeService getSnoozeService() {
            return SnoozeService.this;
        }
    }

    private final class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            SnoozeService.this.isServiceAlive = true;
            SnoozeService.this.killSnoozeServiceCounter = new CountDownTimer(SnoozeService.this.SNOOZE_SERVICE_TTL, 5000L){

                public void onTick(long l) {
                    SnoozeService.this.timeToNotify = ((long)SnoozeService.this.SNOOZE_SERVICE_TTL - l) / 1000L;
                }

                public void onFinish() {
                    if (!SnoozeService.this.isNotificationIntentPrepared && CBActivity.STATE == 2) {
                        SnoozeService.this.launchNoInternetNotification();
                        SnoozeService.this.broadcastAnalyticsEvent("internet_not_restored_notification", "-1");
                    } else if (!SnoozeService.this.isNotificationIntentPrepared && CBActivity.STATE == 1) {
                        SnoozeService.this.broadcastAnalyticsEvent("internet_not_restored_dialog_foreground", "-1");
                    }
                    if (SnoozeService.this.isWebViewAlive && !SnoozeService.this.isNotificationIntentPrepared) {
                        Intent broadCastIntent = new Intent("webview_status_action");
                        broadCastIntent.putExtra("snoozeServiceStatus", "snoozeServiceDead");
                        LocalBroadcastManager.getInstance((Context)SnoozeService.this).sendBroadcast(broadCastIntent);
                    }
                    SnoozeService.this.killSnoozeService();
                }
            };
            SnoozeService.this.killSnoozeServiceCounter.start();
            SnoozeService.this.trackWebViewStatusHandler = new Handler();
            SnoozeService.this.trackWebViewStatusHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (SnoozeService.this.isServiceAlive) {
                        if (SnoozeService.this.broadCastingMessage.contentEquals(SnoozeService.this.receivedMessage)) {
                            SnoozeService.this.isWebViewAlive = true;
                        } else {
                            SnoozeService.this.isWebViewAlive = false;
                            if (SnoozeService.this.isServiceAlive && SnoozeService.this.verifyPaymentCheck && SnoozeService.this.isNotificationIntentPrepared && SnoozeService.this.isWebViewIntentPrepared) {
                                SnoozeService.this.launchNotificationTransactionUpdate(SnoozeService.this.payuResponse);
                            } else if (SnoozeService.this.isServiceAlive && SnoozeService.this.isNotificationIntentPrepared && SnoozeService.this.isWebViewIntentPrepared) {
                                SnoozeService.this.launchNotification(SnoozeService.this.isWebViewAlive);
                            }
                        }
                        SnoozeService.this.trackWebViewStatusHandler.postDelayed((Runnable)this, 500L);
                        Intent broadCastIntent = new Intent("webview_status_action");
                        SnoozeService.this.broadCastingMessage = "" + System.currentTimeMillis();
                        broadCastIntent.putExtra("snooze_broad_cast_message", SnoozeService.this.broadCastingMessage);
                        LocalBroadcastManager.getInstance((Context)SnoozeService.this).sendBroadcast(broadCastIntent);
                    }
                }
            }, 500L);
            SnoozeService.this.calculateInternetSpeed();
        }
    }
}

