package com.payu.custombrowser.upiintent;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;

/**
 * Created by himanshu.gupta on 18/01/18.
 */

public class UPIUtil {

    public boolean isPaymentMethodSupported(Context context, Payment payment) {

        if (Build.VERSION.SDK_INT >= payment.getMinSdk()) {
            try {
                context.getPackageManager().getPackageInfo(payment.getPackageName(), 0);
                return true;
            } catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        } else {
            return false;
        }

    }

    String getValuePostData(String postData, String key) {
        String[] list = postData.split("&");
        for (String item : list) {
            String[] items = item.split("=");
            if (items.length >= 2) {
                String id = items[0];
                if (key.equalsIgnoreCase(id)) {
                    return items[1];
                }
            }
        }
        return "";
    }

    public Payment getSupportedPayment(String postData) {
        String paymentMethod = getValuePostData(postData, UPIPaymentConstants.BANK_CODE);
        for (Payment payment : Payment.values()) {
            if (payment.getPaymentName().equalsIgnoreCase(paymentMethod)) {
                return payment;
            }
        }
        return null;
    }

    public String getUPIIntent(String payeeVpa, String payeeName, String amount, String transactionId, String transactionRefId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(UPIPaymentConstants.UPI_INTENT_PREFIX);
        stringBuilder.append(UPIPaymentConstants.PAYEEE_ADDRESS);
        stringBuilder.append("=");
        stringBuilder.append(payeeVpa);
        stringBuilder.append("&");
        stringBuilder.append(UPIPaymentConstants.PAYEE_NAME);
        stringBuilder.append("=");
        stringBuilder.append(payeeName);
        stringBuilder.append("&");
        stringBuilder.append(UPIPaymentConstants.TRANSACTION_AMOUNT);
        stringBuilder.append("=");
        stringBuilder.append(amount);
        stringBuilder.append("&");
        stringBuilder.append(UPIPaymentConstants.TRANSACTION_REF_ID);
        stringBuilder.append("=");
        stringBuilder.append(transactionRefId);
        stringBuilder.append("&");
        stringBuilder.append(UPIPaymentConstants.TRANSACTIONID);
        stringBuilder.append("=");
        stringBuilder.append(transactionId);
        return stringBuilder.toString();
    }
}
