/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.app.NotificationManager;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import com.payu.custombrowser.Bank;
import com.payu.custombrowser.R;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.magicretry.MagicRetryFragment;
import org.json.JSONException;

public class CBActivity
extends FragmentActivity
implements MagicRetryFragment.ActivityCallback {
    public static int STATE;
    CustomBrowserConfig customBrowserConfig;
    private Bank payUCustomBrowser;
    private AlertDialog snoozeDialog;
    private android.app.AlertDialog backButtonAlertDialog;
    CBUtil cbUtil;

    protected void onStart() {
        super.onStart();
    }

    protected void onResume() {
        super.onResume();
        STATE = 1;
    }

    protected void onPause() {
        super.onPause();
        STATE = 2;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(null);
        this.setContentView(R.layout.cb_payments);
        this.payUCustomBrowser = new Bank();
        this.cbUtil = new CBUtil();
        this.cbUtil.resetPayuID();
        Bundle bundle = new Bundle();
        this.customBrowserConfig = (CustomBrowserConfig)this.getIntent().getParcelableExtra("cb_config");
        bundle.putParcelable("cb_config", (Parcelable)this.customBrowserConfig);
        this.payUCustomBrowser.setArguments(bundle);
        this.getSupportFragmentManager().beginTransaction().add(R.id.main_frame, (Fragment)this.payUCustomBrowser).commit();
    }

    public void onBackPressed() {
        if (this.customBrowserConfig != null && this.customBrowserConfig.getDisableBackButtonDialog() != 1) {
            this.payUCustomBrowser.addEventAnalytics("user_input", "payu_back_button".toLowerCase());
            this.payUCustomBrowser.showBackButtonDialog();
        } else {
            this.finish();
        }
    }

    public void showMagicRetry() {
        this.payUCustomBrowser.showMagicRetry();
    }

    public void hideMagicRetry() {
        this.payUCustomBrowser.hideMagicRetry();
    }

    public void onDestroy() {
        if (this.backButtonAlertDialog != null && this.backButtonAlertDialog.isShowing()) {
            this.backButtonAlertDialog.dismiss();
            this.backButtonAlertDialog.cancel();
        }
        if (this.snoozeDialog != null && this.snoozeDialog.isShowing()) {
            this.snoozeDialog.dismiss();
            this.snoozeDialog.cancel();
        }
        STATE = 3;
        if (this.payUCustomBrowser != null && this.payUCustomBrowser.getSnoozeLoaderView() != null) {
            this.payUCustomBrowser.getSnoozeLoaderView().cancelAnimation();
        }
        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentTerminate();
        }
        NotificationManager mNotificationManager = (NotificationManager)this.getSystemService("notification");
        mNotificationManager.cancel(CBConstant.SNOOZE_NOTIFICATION_ID);
        mNotificationManager.cancel(63);
        super.onDestroy();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (null != intent && intent.getStringExtra("sender").contentEquals("snoozeService") && null != this.payUCustomBrowser) {
            this.payUCustomBrowser.killSnoozeService();
            this.payUCustomBrowser.dismissSnoozeWindow();
            this.payUCustomBrowser.snoozeNotificationIntent = null;
            this.payUCustomBrowser.isSnoozeNotificationLaunched = false;
            if (intent.getExtras().getBoolean("verificationMsgReceived")) {
                try {
                    String verifyApiStatus = this.cbUtil.getValueOfJSONKey(intent.getExtras().getString("payu_response"), this.getString(R.string.cb_snooze_verify_api_status));
                    if (verifyApiStatus.equalsIgnoreCase("1")) {
                        this.payUCustomBrowser.addEventAnalytics("transaction_verified_notification_click", "-1");
                    } else {
                        this.payUCustomBrowser.addEventAnalytics("transaction_not_verified_notification_click", "-1");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                this.payUCustomBrowser.showTransactionStatusDialog(intent.getExtras().getString("payu_response"), true);
            } else {
                this.payUCustomBrowser.addEventAnalytics("internet_restored_notification_click", "-1");
                this.payUCustomBrowser.resumeTransaction(intent);
            }
        }
    }
}

