package com.payu.custombrowser;

import android.app.AlertDialog;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;

import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.magicretry.MagicRetryFragment;

import org.json.JSONException;
import org.json.JSONObject;

public class CBActivity extends FragmentActivity implements MagicRetryFragment.ActivityCallback {

    public static int STATE;
    CustomBrowserConfig customBrowserConfig;
    private Bank payUCustomBrowser;
    private android.support.v7.app.AlertDialog snoozeDialog;
    private AlertDialog backButtonAlertDialog;
    CBUtil cbUtil;

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onResume() {
        super.onResume();
        STATE = CBConstant.STATE_RESUMED;

        // if there is sure pay notification we need to cancel it and resume the txn.
    }

    @Override
    protected void onPause() {
        super.onPause();
        STATE = CBConstant.STATE_PAUSED;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        // TODO: provide support for saveInstance as well
        // To avoid recreating activity using saveInstanceState
        super.onCreate(null);

        setContentView(com.payu.custombrowser.R.layout.cb_payments);
        payUCustomBrowser = new Bank();
        cbUtil = new CBUtil();

        // reset payuId when transaction is initiated to avoid old payuID
        cbUtil.resetPayuID();

        Bundle bundle = new Bundle();
        customBrowserConfig = getIntent().getParcelableExtra("cb_config");
        bundle.putParcelable("cb_config", customBrowserConfig);
        payUCustomBrowser.setArguments(bundle);
        getSupportFragmentManager().beginTransaction().add(com.payu.custombrowser.R.id.main_frame, payUCustomBrowser).commit();

    }

    /*public void showBackButtonDialog() {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder(this);
        alertDialog.setCancelable(false);
        alertDialog.setMessage("Do you really want to cancel the transaction ?");
        alertDialog.setPositiveButton("Ok", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                payUCustomBrowser.postToPaytxn();
                dialog.dismiss();
                if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackApprove();
                }

                payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_OK_CLICK.toLowerCase());
                CBActivity.this.finish();
            }
        });
        alertDialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_CANCEL_CLICK.toLowerCase());
                // cbAnalytics.log(CBUtil.getLogMessage(getBaseContext().getApplicationContext(), CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_CANCEL_CLICK.toLowerCase(), payUCustomBrowser.getBankName(), Bank.keyAnalytics, Bank.transactionID, payUCustomBrowser.getPageType()));
                if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackDismiss();
                }
            }
        });
        payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.PAYU_BACK_BUTTON_CLICK.toLowerCase());

        // cbAnalytics.log(CBUtil.getLogMessage(getBaseContext().getApplicationContext(), CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.PAYU_BACK_BUTTON_CLICK.toLowerCase(), payUCustomBrowser.getBankName(), Bank.keyAnalytics, Bank.transactionID, payUCustomBrowser.getPageType()));
        if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackButton(alertDialog);
        }
        backButtonAlertDialog = alertDialog.create();
        alertDialog.show();
    }*/

    @Override
    public void onBackPressed() {
        if (customBrowserConfig != null && customBrowserConfig.getDisableBackButtonDialog() != 1) {
            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.PAYU_BACK_BUTTON_CLICK.toLowerCase());
            payUCustomBrowser.showBackButtonDialog();
        } else {
            CBActivity.this.finish();
        }
    }

    /**
     * CallBack for magic retry
     */
    public void showMagicRetry() {
        payUCustomBrowser.showMagicRetry();
    }

    /**
     * CallBack for magic retry
     */
    public void hideMagicRetry() {
        payUCustomBrowser.hideMagicRetry();
    }


    @Override
    public void onDestroy() {
        if (backButtonAlertDialog != null && backButtonAlertDialog.isShowing()) {
            backButtonAlertDialog.dismiss();
            backButtonAlertDialog.cancel();
        }
        if (snoozeDialog != null && snoozeDialog.isShowing()) {
            snoozeDialog.dismiss();
            snoozeDialog.cancel();
        }
        STATE = CBConstant.STATE_DESTROYED;
        if (payUCustomBrowser != null && payUCustomBrowser.getSnoozeLoaderView() != null) {
            payUCustomBrowser.getSnoozeLoaderView().cancelAnimation();
        }

        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null)
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentTerminate();

        // if any notification from snooze service lets clear it.
        NotificationManager mNotificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        mNotificationManager.cancel(CBConstant.SNOOZE_NOTIFICATION_ID);

        // Remove slow user warning notification
        mNotificationManager.cancel(63);

        super.onDestroy();
    }

    // Will be called from snoozeService, notification click
    // No need to show the Transaction Resumed window, we can directly resume the transaction.
    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        //(new CBUtil()).clearCookie();


        if (null != intent && intent.getStringExtra(CBConstant.SENDER).contentEquals(CBConstant.SNOOZE_SERVICE)) { // it is from snooze service
            if(null != payUCustomBrowser){
                payUCustomBrowser.killSnoozeService();
                payUCustomBrowser.dismissSnoozeWindow();
                // User has clicked notification, clear the snoozeNotificationIntent
                // we are using this, because onResume of Bank.java is being called again. which will launch snooze window based on the flags.
                payUCustomBrowser.snoozeNotificationIntent = null;
                payUCustomBrowser.isSnoozeNotificationLaunched  = false;

                if (intent.getExtras().getBoolean(CBConstant.VERIFICATION_MSG_RECEIVED)) { // backward journey

                    try {
                        String  verifyApiStatus  = cbUtil.getValueOfJSONKey(intent.getExtras().getString(CBConstant.PAYU_RESPONSE), getString(R.string.cb_snooze_verify_api_status));
                        // success transaction api status 1 and failure api status 0
                        if (verifyApiStatus.equalsIgnoreCase(CBConstant.TRANSACTION_STATUS_SUCCESS)) {
                            // Logging notification click
                            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.TRANSACTION_VERIFIED_NOTIFICATION_CLICK, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                        } else {
                            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.TRANSACTION_NOT_VERIFIED_NOTIFICATION_CLICK, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                    payUCustomBrowser.showTransactionStatusDialog(intent.getExtras().getString(CBConstant.PAYU_RESPONSE),true);


                } else { // forward journey.
                    payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.INTERNET_RESTORED_NOTIFICATION_CLICK, CBAnalyticsConstant.DEFAULT_ANALYTICS_EVENT_VALUE);
                    payUCustomBrowser.resumeTransaction(intent);
                }
            }

        }
    }

}
