package com.payu.custombrowser.widgets;

import com.payu.custombrowser.analytics.CBAnalytics;
import com.payu.custombrowser.bean.CustomBrowserAsyncTaskData;
import com.payu.custombrowser.cbinterface.CustomBrowserAsyncTaskInterface;
import com.payu.custombrowser.util.CustomBrowserAsyncTask;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by franklin.michael on 12/07/16.
 *
 * Helper Class to mark the previous txn as sure_pay_canceled.
 *
 */

public class SurePayCancelAsyncTaskHelper implements CustomBrowserAsyncTaskInterface {

    // Dont allow anybody to create empty object.
    private SurePayCancelAsyncTaskHelper(){}
    private String mPostData;

    // we have post data now with the object.
    public SurePayCancelAsyncTaskHelper(String postData){
        mPostData = postData;
    }

    /**
     * Make async task.
     */
    public void execute(){
        try {
            if(null != mPostData && mPostData.length() > 0) {
                // here we tell payu backend to mark the previous transaction as user_canceled.
                CustomBrowserAsyncTaskData customBrowserAsyncTaskData = new CustomBrowserAsyncTaskData();
                customBrowserAsyncTaskData.setHttpMethod("POST");
                JSONArray jsonArray = new JSONArray();
                JSONObject jsonObject = new JSONObject(mPostData);
                jsonArray.put(jsonObject);
                customBrowserAsyncTaskData.setPostData("command=EventAnalytics&data=" + jsonArray.toString());
                customBrowserAsyncTaskData.setUrl(CBAnalytics.ANALYTICS_URL);
                CustomBrowserAsyncTask customBrowserAsyncTask = new CustomBrowserAsyncTask(this);
                customBrowserAsyncTask.execute(customBrowserAsyncTaskData);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onCustomBrowserAsyncTaskResponse(String cbAsyncTaskResponse) {

    }
}
