/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser.util;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import com.payu.custombrowser.R;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.json.JSONObject;

public class CBUtil {
    private static final String CB_PREFERENCE = "com.payu.custombrowser.payucustombrowser";
    private static SharedPreferences sharedPreferences;

    public static String getLogMessage(Context context, String key, String value, String bank, String sdkMerchantKey, String trnxID) {
        try {
            JSONObject eventAnalytics = new JSONObject();
            eventAnalytics.put("txnid", (Object)trnxID);
            eventAnalytics.put("cb_version", (Object)"6.0.0");
            eventAnalytics.put("package_name", (Object)context.getPackageName());
            eventAnalytics.put("bank", (Object)(bank == null ? "" : bank));
            eventAnalytics.put("key", (Object)key);
            eventAnalytics.put("value", (Object)value);
            eventAnalytics.put("merchant_key", (Object)sdkMerchantKey);
            return eventAnalytics.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decodeContents(FileInputStream fileInputStream) {
        StringBuilder decoded = new StringBuilder();
        try {
            int c;
            int i = 0;
            while ((c = fileInputStream.read()) != -1) {
                if (i % 2 == 0) {
                    decoded.append((char)(c - (i % 5 + 1)));
                } else {
                    decoded.append((char)(c + (i % 5 + 1)));
                }
                ++i;
            }
            fileInputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return decoded.toString();
    }

    public static boolean getBooleanSharedPreference(String key, Activity mActivity) {
        sharedPreferences = mActivity.getSharedPreferences(CB_PREFERENCE, 0);
        return sharedPreferences.getBoolean(key, false);
    }

    public static void setBooleanSharedPreference(String key, boolean value, Context context) {
        SharedPreferences.Editor editor = context.getSharedPreferences(CB_PREFERENCE, 0).edit();
        editor.putBoolean(key, value);
        editor.apply();
    }

    public static boolean isNetworkAvailable(Context context) {
        block3: {
            ConnectivityManager connectivityManager;
            block2: {
                Network[] networks;
                connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                if (Build.VERSION.SDK_INT < 21) break block2;
                for (Network mNetwork : networks = connectivityManager.getAllNetworks()) {
                    NetworkInfo networkInfo = connectivityManager.getNetworkInfo(mNetwork);
                    if (!networkInfo.getState().equals((Object)NetworkInfo.State.CONNECTED)) continue;
                    return true;
                }
                break block3;
            }
            NetworkInfo[] info = connectivityManager.getAllNetworkInfo();
            if (info == null) break block3;
            for (NetworkInfo anInfo : info) {
                if (anInfo.getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            }
        }
        return false;
    }

    public static String getDeviceDensity(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return metrics.densityDpi + "";
    }

    private static void getDownloadSpeed(Activity activity) {
        String[] testing = new String[2];
        long BeforeTime = System.currentTimeMillis();
        long TotalTxBeforeTest = TrafficStats.getTotalTxBytes();
        long TotalRxBeforeTest = TrafficStats.getTotalRxBytes();
        long TotalTxAfterTest = TrafficStats.getTotalTxBytes();
        long TotalRxAfterTest = TrafficStats.getTotalRxBytes();
        long AfterTime = System.currentTimeMillis();
        double TimeDifference = AfterTime - BeforeTime;
        double rxDiff = TotalRxAfterTest - TotalRxBeforeTest;
        double txDiff = TotalTxAfterTest - TotalTxBeforeTest;
        if (rxDiff != 0.0 && txDiff != 0.0) {
            double rxBPS = rxDiff / (TimeDifference / 1000.0);
            double txBPS = txDiff / (TimeDifference / 1000.0);
            testing[0] = String.valueOf(rxBPS) + "bps. Total rx = " + rxDiff;
            testing[1] = String.valueOf(txBPS) + "bps. Total tx = " + txDiff;
        } else {
            testing[0] = "No uploaded or downloaded bytes.";
        }
    }

    public static void setAlpha(float alpha, View view) {
        if (Build.VERSION.SDK_INT < 11) {
            AlphaAnimation animation = new AlphaAnimation(alpha, alpha);
            animation.setDuration(10L);
            animation.setFillAfter(true);
            view.startAnimation((Animation)animation);
        } else {
            view.setAlpha(alpha);
        }
    }

    public static String getNetworkStatus(Activity activity) {
        try {
            if (null != activity && !activity.isFinishing()) {
                ConnectivityManager cm = (ConnectivityManager)activity.getSystemService("connectivity");
                NetworkInfo info = cm.getActiveNetworkInfo();
                if (info == null || !info.isConnected()) {
                    return "Not connected";
                }
                if (info.getType() == 1) {
                    return "WIFI";
                }
                if (info.getType() == 0) {
                    int networkType = info.getSubtype();
                    switch (networkType) {
                        case 1: {
                            return "GPRS";
                        }
                        case 2: {
                            return "EDGE";
                        }
                        case 4: {
                            return "CDMA";
                        }
                        case 7: 
                        case 11: {
                            return "2G";
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: {
                            return "HSPA";
                        }
                        case 12: 
                        case 14: 
                        case 15: {
                            return "3G";
                        }
                        case 13: {
                            return "4G";
                        }
                    }
                    return "?";
                }
            }
        }
        catch (Exception e) {
            return "?";
        }
        return "?";
    }

    public static NetworkInfo getNetWorkInfo(Context mContext) {
        NetworkInfo network;
        block3: {
            ConnectivityManager connectivityManager;
            block2: {
                Network[] networks;
                connectivityManager = (ConnectivityManager)mContext.getSystemService("connectivity");
                network = null;
                if (Build.VERSION.SDK_INT < 21) break block2;
                for (Network mNetwork : networks = connectivityManager.getAllNetworks()) {
                    NetworkInfo networkInfo = connectivityManager.getNetworkInfo(mNetwork);
                    if (!networkInfo.getState().equals((Object)NetworkInfo.State.CONNECTED)) continue;
                    network = networkInfo;
                }
                break block3;
            }
            NetworkInfo[] info = connectivityManager.getAllNetworkInfo();
            if (info == null) break block3;
            for (NetworkInfo anInfo : info) {
                if (anInfo.getState() != NetworkInfo.State.CONNECTED) continue;
                network = anInfo;
            }
        }
        return network;
    }

    public static int getNetworkStrength(Context mContext) {
        NetworkInfo network = CBUtil.getNetWorkInfo(mContext);
        if (network != null) {
            if (network.getTypeName().equalsIgnoreCase("MOBILE")) {
                return CBUtil.getMobileStrength(mContext, network);
            }
            if (network.getTypeName().equalsIgnoreCase("wifi") && CBUtil.hasPermission(mContext, "android.permission.ACCESS_WIFI_STATE")) {
                WifiManager wifiManager = (WifiManager)mContext.getSystemService("wifi");
                try {
                    WifiInfo connectionInfo = wifiManager.getConnectionInfo();
                    if (connectionInfo != null) {
                        return WifiManager.calculateSignalLevel((int)connectionInfo.getRssi(), (int)5);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return 0;
        }
        return 0;
    }

    private static boolean hasPermission(Context context, String permission2) {
        int res = context.checkCallingOrSelfPermission(permission2);
        return res == 0;
    }

    private static int getMobileStrength(Context context, NetworkInfo networkInfo) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            int strength = 0;
            if (Build.VERSION.SDK_INT >= 18) {
                for (CellInfo info : telephonyManager.getAllCellInfo()) {
                    if (!info.isRegistered()) continue;
                    if (info instanceof CellInfoGsm) {
                        CellSignalStrengthGsm gsm = ((CellInfoGsm)info).getCellSignalStrength();
                        strength = gsm.getDbm();
                        continue;
                    }
                    if (info instanceof CellInfoCdma) {
                        CellSignalStrengthCdma cdma = ((CellInfoCdma)info).getCellSignalStrength();
                        strength = cdma.getDbm();
                        continue;
                    }
                    if (info instanceof CellInfoLte) {
                        CellSignalStrengthLte lte = ((CellInfoLte)info).getCellSignalStrength();
                        strength = lte.getDbm();
                        continue;
                    }
                    if (!(info instanceof CellInfoWcdma)) continue;
                    CellSignalStrengthWcdma wcdma = ((CellInfoWcdma)info).getCellSignalStrength();
                    strength = wcdma.getDbm();
                }
            }
            return strength;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void setStringSharedPreference(Context context, String key, String url) {
        String str = CBUtil.getStringSharedPreference(context, key);
        if (str.equalsIgnoreCase("")) {
            str = url;
        } else if (!str.contains("||")) {
            str = str + "||" + url;
        } else {
            StringTokenizer st = new StringTokenizer(str, "||");
            st.nextToken();
            str = st.nextToken() + "||" + url;
        }
        CBUtil.storeInSharedPreferences(context, key, str);
    }

    public static String getStringSharedPreference(Context context, String key) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(CB_PREFERENCE, 0);
        return sharedPreferences.getString(key, "");
    }

    public static void deleteSharedPrefKey(Context context, String key) {
        try {
            SharedPreferences.Editor sharedPreferencesEditor = context.getSharedPreferences(CB_PREFERENCE, 0).edit();
            sharedPreferencesEditor.remove(key);
            sharedPreferencesEditor.apply();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String updateLastUrl(String lastUrl) {
        try {
            if (!lastUrl.contains("||")) {
                if (lastUrl.length() > 128) {
                    return lastUrl.substring(0, 127);
                }
                return lastUrl;
            }
            StringTokenizer st = new StringTokenizer(lastUrl, "||");
            String firstURl = st.nextToken();
            String secondUrl = st.nextToken();
            if (firstURl.length() > 128) {
                firstURl = firstURl.substring(0, 125);
            }
            if (secondUrl.length() > 128) {
                secondUrl = secondUrl.substring(0, 125);
            }
            return firstURl + "||" + secondUrl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void storeInSharedPreferences(Context context, String key, String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(CB_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        editor.apply();
    }

    public static void removeFromSharedPreferences(Context context, String key) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(CB_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove(key);
        editor.apply();
    }

    public static Drawable getDrawableCB(Context context, int resID) {
        if (Build.VERSION.SDK_INT < 21) {
            return context.getResources().getDrawable(resID);
        }
        return context.getResources().getDrawable(resID, context.getTheme());
    }

    public static void setVariableReflection(String className, String value, String varName) {
        try {
            if (value != null && !value.trim().equals("")) {
                Class<?> aClass = Class.forName(className);
                Field field = aClass.getDeclaredField(varName);
                field.setAccessible(true);
                field.set(null, value);
                field.setAccessible(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String filterSMS(JSONObject mBankJS, String msgBody, Context context) {
        String mPassword = null;
        try {
            Matcher match;
            if (msgBody != null && (match = Pattern.compile(mBankJS.getString(context.getString(R.string.cb_detect_otp)), 2).matcher(msgBody)).find() && (match = Pattern.compile(mBankJS.getString(context.getString(R.string.cb_find_otp)), 2).matcher(msgBody)).find()) {
                mPassword = match.group(1).replaceAll("[^0-9]", "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mPassword;
    }

    public static void cancelTimer(Timer timer) {
        if (timer != null) {
            timer.cancel();
            timer.purge();
        }
    }

    public static String readFileInputStream(Context mContext, String fileName, int contextMode) {
        String temp = "";
        try {
            int c;
            File file = new File(mContext.getFilesDir(), fileName);
            if (!file.exists()) {
                mContext.openFileOutput(fileName, contextMode);
            }
            FileInputStream fileInputStream = mContext.openFileInput(fileName);
            while ((c = fileInputStream.read()) != -1) {
                temp = temp + Character.toString((char)c);
            }
            fileInputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return temp;
    }

    public static void writeFileOutputStream(InputStream inputStream, Activity activity, String fileName, int contextMode) {
        try {
            int len;
            GZIPInputStream responseInputStream = new GZIPInputStream(inputStream);
            byte[] buf = new byte[1024];
            FileOutputStream outputStream = activity.openFileOutput(fileName, contextMode);
            while ((len = responseInputStream.read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
            responseInputStream.close();
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HttpURLConnection getHttpsConn(String strURL, String postData) {
        try {
            URL url = new URL(strURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(postData.length()));
            conn.setDoOutput(true);
            byte[] postParamsByte = postData.getBytes();
            conn.getOutputStream().write(postParamsByte);
            return conn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HttpURLConnection getHttpsConn(String strURL) {
        try {
            URL url = new URL(strURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept-Charset", "UTF-8");
            return conn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static StringBuffer getStringBufferFromInputStream(InputStream responseInputStream) {
        try {
            int i;
            StringBuffer responseStringBuffer = new StringBuffer();
            byte[] byteContainer = new byte[1024];
            while ((i = responseInputStream.read(byteContainer)) != -1) {
                responseStringBuffer.append(new String(byteContainer, 0, i));
            }
            return responseStringBuffer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

