/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.telephony.SmsMessage;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.payu.custombrowser.Bank;
import com.payu.custombrowser.CustomBrowserMain;
import com.payu.custombrowser.PayUWebChromeClient;
import com.payu.custombrowser.PayUWebViewClient;
import com.payu.custombrowser.R;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.cbinterface.MagicRetryCallbacks;
import com.payu.custombrowser.custombar.CustomProgressBar;
import com.payu.custombrowser.util.CBUtil;
import java.net.URLEncoder;
import java.util.Timer;
import org.json.JSONException;

public abstract class PayUCustomBrowserLifecycle
extends CustomBrowserMain
implements MagicRetryCallbacks {
    boolean autoApprove;
    boolean autoSelectOtp;
    boolean pin_selected_flag;
    int chooseActionHeight;
    boolean showCB = true;
    String mPassword;
    Timer timer;
    Boolean approve_flag = false;
    boolean checkLoading;
    String enterOtpParams;
    boolean permissionGranted = true;
    boolean checkedPermission = false;
    boolean checkPermissionVisibility;
    boolean mPageReady = false;
    boolean SMSOTPClicked = false;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.activity = this.getActivity();
        if (this.activity.getIntent().getExtras() != null) {
            this.cbOldFlow = true;
            this.cbOldOnCreate();
        } else {
            this.cbOnCreate();
        }
        this.initAnalytics(Bank.keyAnalytics);
        if (this.activity != null) {
            this.pin_selected_flag = false;
            CookieManager cookieManager = CookieManager.getInstance();
            if (Build.VERSION.SDK_INT >= 21) {
                cookieManager.removeSessionCookies(null);
            } else if (Build.VERSION.SDK_INT >= 19) {
                cookieManager.removeSessionCookie();
            }
        }
    }

    public void cbOldOnCreate() {
        this.bundle = this.getArguments();
        this.autoApprove = this.bundle.getBoolean("auto_approve", false);
        this.autoSelectOtp = this.bundle.getBoolean("auto_select_otp", false);
        this.storeOneClickHash = this.bundle.getInt("store_one_click_hash", 0);
        this.merchantSMSPermission = this.bundle.getBoolean("smsPermission", false);
        if (Bank.sdkVersion == null || Bank.sdkVersion.equalsIgnoreCase("")) {
            Bank.sdkVersion = this.getArguments().getString("sdkname");
        }
        if (Bank.transactionID == null || Bank.transactionID.equalsIgnoreCase("")) {
            Bank.transactionID = this.getArguments().getString("txnid");
        }
        if (Bank.keyAnalytics == null || Bank.keyAnalytics.equalsIgnoreCase("")) {
            Bank.keyAnalytics = this.getArguments().getString("merchantid");
        }
        this.cbWebView = (WebView)this.activity.findViewById(this.getArguments().getInt("webView"));
        if (Bank.paymentMode != null && Bank.paymentMode.equalsIgnoreCase("nb")) {
            this.cbWebView.getSettings().setUseWideViewPort(true);
        } else if (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getViewPortWideEnable() == 1) {
            this.cbWebView.getSettings().setUseWideViewPort(true);
        }
    }

    public void cbOnCreate() {
        this.merchantSMSPermission = CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getMerchantSMSPermission() == 1;
        this.autoApprove = CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getAutoApprove() == 1;
        this.autoSelectOtp = CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getAutoSelectOTP() == 1;
        int n = this.storeOneClickHash = CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() == null ? 0 : CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getStoreOneClickHash();
        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() != null) {
            if (Bank.keyAnalytics == null || Bank.keyAnalytics.trim().equals("")) {
                Bank.keyAnalytics = CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getMerchantKey() != null || !CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getMerchantKey().trim().equals("") ? CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getMerchantKey() : "";
            }
            if (Bank.transactionID == null || Bank.transactionID.trim().equals("")) {
                Bank.transactionID = CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getTransactionID() != null && !CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getTransactionID().trim().equals("") ? CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getTransactionID() : "123";
            }
            if (Bank.sdkVersion == null || Bank.sdkVersion.trim().equals("")) {
                Bank.sdkVersion = CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getSdkVersionName() != null && !CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getSdkVersionName().trim().equals("") ? CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getSdkVersionName() : "";
            }
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View cbMainView;
        View cbInflatedView;
        super.onCreateView(inflater, container, savedInstanceState);
        if (this.cbOldFlow) {
            cbMainView = cbInflatedView = inflater.inflate(R.layout.bankold, container, false);
            cbInflatedView.bringToFront();
            this.cbOldFlowOnCreateView();
        } else {
            cbInflatedView = inflater.inflate(R.layout.bank, container, false);
            this.cbTransparentView = cbInflatedView.findViewById(R.id.trans_overlay);
            this.cbWebView = (WebView)cbInflatedView.findViewById(R.id.webview);
            cbMainView = cbInflatedView.findViewById(R.id.parent);
            this.cbOnCreateView();
        }
        CBUtil.setVariableReflection("com.payu.magicretry.MagicRetryFragment", "6.0.0", "cbVersion");
        this.cbBaseView = (FrameLayout)cbInflatedView.findViewById(R.id.help_view);
        this.cbSlideBarView = cbInflatedView.findViewById(R.id.view);
        this.cbWebPageProgressBar = (ProgressBar)cbInflatedView.findViewById(R.id.cb_progressbar);
        this.cbWebView.getSettings().setJavaScriptEnabled(true);
        this.cbWebView.addJavascriptInterface((Object)this, "PayU");
        this.cbWebView.getSettings().setDomStorageEnabled(true);
        this.cbWebView.getSettings().setSupportMultipleWindows(true);
        this.cbWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (PayUCustomBrowserLifecycle.this.cbTransparentView != null) {
                    PayUCustomBrowserLifecycle.this.cbTransparentView.setVisibility(8);
                }
                if (PayUCustomBrowserLifecycle.this.frameState == 2) {
                    PayUCustomBrowserLifecycle.this.minimizeWebviewHeight();
                }
                return false;
            }
        });
        this.getInitializeJS();
        cbMainView.setOnTouchListener((View.OnTouchListener)new CustomBrowserMain.CBMainViewOnTouchListener());
        return cbInflatedView;
    }

    public void cbOldFlowOnCreateView() {
        this.cbWebView.setFocusable(true);
        if (this.getArguments().getBoolean("backButton", true)) {
            this.cbWebView.setOnKeyListener(new View.OnKeyListener(){

                public boolean onKey(View v, int keyCode, KeyEvent event) {
                    if (event.getAction() == 1 && keyCode == 4) {
                        if (PayUCustomBrowserLifecycle.this.getArguments().getBoolean("backButton", true)) {
                            AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)PayUCustomBrowserLifecycle.this.activity);
                            alertDialog.setCancelable(false);
                            alertDialog.setMessage((CharSequence)"Do you really want to cancel the transaction ?");
                            alertDialog.setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    PayUCustomBrowserLifecycle.this.addEventAnalytics("user_input", "back_button_ok");
                                    dialog.dismiss();
                                    PayUCustomBrowserLifecycle.this.onBackApproved();
                                    PayUCustomBrowserLifecycle.this.activity.finish();
                                }
                            });
                            alertDialog.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    PayUCustomBrowserLifecycle.this.addEventAnalytics("user_input", "back_button_cancel");
                                    PayUCustomBrowserLifecycle.this.onBackCancelled();
                                    dialog.dismiss();
                                }
                            });
                            PayUCustomBrowserLifecycle.this.addEventAnalytics("user_input", "payu_back_button");
                            PayUCustomBrowserLifecycle.this.onBackPressed(alertDialog);
                            alertDialog.show();
                            return true;
                        }
                        PayUCustomBrowserLifecycle.this.addEventAnalytics("user_input", "m_back_button");
                        PayUCustomBrowserLifecycle.this.activity.onBackPressed();
                    }
                    return false;
                }
            });
        }
        if (Bank.paymentMode != null && Bank.paymentMode.equalsIgnoreCase("nb")) {
            this.cbWebView.getSettings().setUseWideViewPort(true);
        } else if (this.bundle.getBoolean("viewPortWide", false)) {
            this.cbWebView.getSettings().setUseWideViewPort(true);
        }
    }

    public void cbOnCreateView() {
        if (Bank.paymentMode != null && Bank.paymentMode.equalsIgnoreCase("nb")) {
            this.cbWebView.getSettings().setUseWideViewPort(true);
        } else if (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getViewPortWideEnable() == 1) {
            this.cbWebView.getSettings().setUseWideViewPort(true);
        }
        this.cbWebView.setWebChromeClient((WebChromeClient)new PayUWebChromeClient((Bank)this));
        this.cbWebView.setWebViewClient((WebViewClient)new PayUWebViewClient((Bank)this, Bank.keyAnalytics));
        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().setCBProperties(this.cbWebView, (Bank)this);
        }
        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getMagicretry() == 1) {
            this.initMagicRetry();
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().initializeMagicRetry((Bank)this, this.cbWebView, this.magicRetryFragment);
        }
    }

    public void logOnTerminate() {
        try {
            this.addEventAnalytics("last_url", URLEncoder.encode(CBUtil.updateLastUrl(CBUtil.getStringSharedPreference((Context)this.activity, "last_url")), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            CBUtil.deleteSharedPrefKey((Context)this.activity, "last_url");
        }
        if (!this.eventArray.contains("CUSTOM_BROWSER")) {
            this.eventRecorded = "NON_CUSTOM_BROWSER";
            this.addEventAnalytics("cb_status", this.eventRecorded);
        }
        this.eventRecorded = "terminate_transaction";
        this.addEventAnalytics("user_input", this.eventRecorded);
        if (this.progressDialog != null && !this.progressDialog.isShowing()) {
            this.progressDialog.dismiss();
        }
        if (this.mBroadcastReceiver != null) {
            this.unregisterBroadcast(this.mBroadcastReceiver);
            this.mBroadcastReceiver = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.logOnTerminate();
        Bank.sdkVersion = null;
        Bank.keyAnalytics = null;
        Bank.transactionID = null;
        Bank.paymentMode = null;
        this.getActivity().finish();
    }

    public void onResume() {
        super.onResume();
    }

    void prepareSmsListener() {
        if (this.mBroadcastReceiver == null) {
            this.mBroadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    try {
                        Bundle extras;
                        if (PayUCustomBrowserLifecycle.this.mBankJS == null) {
                            return;
                        }
                        Bundle myBundle = intent.getExtras();
                        if (PayUCustomBrowserLifecycle.this.getActivity() != null && (extras = intent.getExtras()) != null) {
                            String msgBody = null;
                            Object[] pdus = (Object[])extras.get("pdus");
                            if (pdus != null) {
                                SmsMessage[] msgs = new SmsMessage[pdus.length];
                                for (int i = 0; i < msgs.length; ++i) {
                                    if (Build.VERSION.SDK_INT >= 23) {
                                        String format = myBundle.getString("format");
                                        msgs[i] = SmsMessage.createFromPdu((byte[])((byte[])pdus[i]), (String)format);
                                    } else {
                                        msgs[i] = SmsMessage.createFromPdu((byte[])((byte[])pdus[i]));
                                    }
                                    msgBody = msgBody + msgs[i].getMessageBody();
                                }
                            }
                            PayUCustomBrowserLifecycle.this.mPassword = CBUtil.filterSMS(PayUCustomBrowserLifecycle.this.mBankJS, msgBody, (Context)PayUCustomBrowserLifecycle.this.getActivity());
                            if (PayUCustomBrowserLifecycle.this.mPassword != null) {
                                PayUCustomBrowserLifecycle.this.fillOTP(this);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            IntentFilter filter = new IntentFilter();
            filter.setPriority(9999999);
            filter.addAction("android.provider.Telephony.SMS_RECEIVED");
            this.registerBroadcast(this.mBroadcastReceiver, filter);
        }
    }

    public void fillOTP(BroadcastReceiver mReceiver) {
        if (this.getActivity().findViewById(R.id.otp_sms) != null) {
            final TextView otpSMS = (TextView)this.getActivity().findViewById(R.id.otp_sms);
            if (this.showCB && this.mPassword != null && otpSMS.getVisibility() != 0) {
                CBUtil.cancelTimer(this.timer);
                switch (this.eventRecorded) {
                    case "payment_initiated": 
                    case "CUSTOM_BROWSER": {
                        this.eventRecorded = "received_otp_direct";
                        break;
                    }
                    case "otp_click": {
                        this.eventRecorded = "received_otp_selected";
                        break;
                    }
                    case "regenerate_click": {
                        this.eventRecorded = "received_otp_regenerate";
                        break;
                    }
                    default: {
                        this.eventRecorded = "otp_web";
                    }
                }
                this.addEventAnalytics("otp_received", this.eventRecorded);
                otpSMS.setText((CharSequence)this.mPassword);
                this.mPassword = null;
                CustomProgressBar.removeDialog(this.getActivity().findViewById(R.id.progress));
                Button approveButton = (Button)this.getActivity().findViewById(R.id.approve);
                approveButton.setClickable(true);
                CBUtil.setAlpha(1.0f, (View)approveButton);
                approveButton.setVisibility(0);
                this.activity.findViewById(R.id.timer).setVisibility(8);
                this.activity.findViewById(R.id.retry_text).setVisibility(8);
                this.activity.findViewById(R.id.regenerate_layout).setVisibility(8);
                this.activity.findViewById(R.id.waiting).setVisibility(8);
                this.activity.findViewById(R.id.otp_recieved).setVisibility(0);
                otpSMS.setVisibility(0);
                if (this.autoApprove) {
                    approveButton.performClick();
                    this.eventRecorded = "auto_approve";
                    this.addEventAnalytics("user_input", this.eventRecorded);
                }
                approveButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        try {
                            PayUCustomBrowserLifecycle.this.mPassword = null;
                            PayUCustomBrowserLifecycle.this.eventRecorded = "approved_otp";
                            PayUCustomBrowserLifecycle.this.addEventAnalytics("user_input", PayUCustomBrowserLifecycle.this.eventRecorded);
                            PayUCustomBrowserLifecycle.this.prepareSmsListener();
                            PayUCustomBrowserLifecycle.this.checkLoading = false;
                            PayUCustomBrowserLifecycle.this.approve_flag = true;
                            PayUCustomBrowserLifecycle.this.onHelpUnavailable();
                            PayUCustomBrowserLifecycle.this.maximiseWebviewHeight();
                            PayUCustomBrowserLifecycle.this.frameState = 1;
                            PayUCustomBrowserLifecycle.this.cbWebView.loadUrl("javascript:" + PayUCustomBrowserLifecycle.this.mJS.getString(PayUCustomBrowserLifecycle.this.getString(R.string.cb_process_otp)) + "(\"" + otpSMS.getText().toString() + "\")");
                            PayUCustomBrowserLifecycle.this.hideSoftKeyboard();
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                mReceiver.abortBroadcast();
                if (this.mBroadcastReceiver != null) {
                    this.unregisterBroadcast(this.mBroadcastReceiver);
                    this.mBroadcastReceiver = null;
                }
            }
        }
    }

    private void getInitializeJS() {
        this.prepareSmsListener();
        this.eventRecorded = "payment_initiated";
        this.addEventAnalytics("user_input", this.eventRecorded);
        new AsyncTask<Void, Void, Void>(){

            /*
             * Exception decompiling
             */
            protected Void doInBackground(Void ... voids) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }.execute((Object[])new Void[]{null, null, null});
    }

    public void updateHeight(View view) {
        if (this.maxWebview == 0) {
            this.calculateMaximumWebViewHeight();
            this.maximiseWebviewHeight();
        }
        this.calculateCBHeight(view);
    }

    public void updateLoaderHeight() {
        if (this.chooseActionHeight == 0) {
            this.cbWebView.measure(-1, -1);
            int maxWebview = this.cbWebView.getMeasuredHeight();
            this.chooseActionHeight = (int)((double)maxWebview * 0.35);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 1: {
                this.checkPermissionVisibility = false;
                if (this.SMSOTPClicked) {
                    try {
                        this.cbWebView.loadUrl("javascript:" + this.mJS.getString(this.getString(R.string.cb_otp)));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                if (ContextCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_SMS") == 0) {
                    this.permissionGranted = true;
                    this.mPassword = null;
                    this.prepareSmsListener();
                    this.enter_otp(this.enterOtpParams);
                    break;
                }
                this.permissionGranted = false;
                this.enter_otp(this.enterOtpParams);
            }
        }
    }

    abstract void onPageStarted();

    abstract void enter_otp(String var1);
}

