/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.payu.custombrowser.Bank;
import com.payu.custombrowser.R;
import com.payu.custombrowser.StoreMerchantHashTask;
import com.payu.custombrowser.analytics.CBAnalytics;
import com.payu.custombrowser.analytics.PayuDeviceAnalytics;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.CustomBrowserConstant;
import com.payu.magicretry.MagicRetryFragment;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class CustomBrowserMain
extends Fragment
implements CustomBrowserConstant {
    Activity activity;
    BroadcastReceiver mBroadcastReceiver;
    JSONObject mBankJS;
    JSONObject mJS;
    int checkForInput;
    public static final boolean DEBUG = false;
    private CBAnalytics mAnalytics;
    String eventRecorded;
    ArrayList<String> eventArray = new ArrayList();
    MagicRetryFragment magicRetryFragment;
    boolean nbhelpVisible;
    Drawable drawable;
    final String CB_URL = "https://secure.payu.in/js/sdk_js/v3/";
    WebView cbWebView;
    int loading_height;
    int minWebview;
    int maxWebview;
    ProgressDialog progressDialog;
    int checkProgress = 0;
    int lastProgress;
    ProgressBar cbWebPageProgressBar;
    int frameState;
    BroadcastReceiver mReceiver = null;
    String checkValue;
    String webviewUrl;
    Set<String> urlSet;
    Set<String> postPaymentURL;
    boolean merchantSMSPermission;
    String bankName;
    String payuReponse;
    String merchantResponse;
    Boolean isSuccessTransaction;
    int storeOneClickHash;
    Bundle bundle;
    boolean cbOldFlow;
    FrameLayout cbBaseView;
    View cbSlideBarView;
    View cbTransparentView;

    public Drawable cbGetDrawable(Context context, int resID) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(resID, context.getTheme());
        }
        return context.getResources().getDrawable(resID);
    }

    void showTransparentView(final View view, Context mContext) {
        if (view != null) {
            Animation animation = AnimationUtils.loadAnimation((Context)mContext, (int)R.anim.cb_fade_in);
            view.startAnimation(animation);
            Handler handler = new Handler();
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    view.setVisibility(0);
                }
            }, 500L);
        }
    }

    void showSoftKeyboard(View editText) {
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();
        ((InputMethodManager)this.activity.getSystemService("input_method")).showSoftInput(editText, 2);
    }

    void hideSoftKeyboard() {
        this.activity.getWindow().setSoftInputMode(3);
    }

    protected void initAnalytics(String sdkMerchantKey) {
        this.mAnalytics = CBAnalytics.getInstance((Context)this.activity, "local_cache_analytics");
        this.deviceAnalytics(sdkMerchantKey);
    }

    private void deviceAnalytics(String sdkMerchantKey) {
        JSONObject deviceDetails = new JSONObject();
        try {
            deviceDetails.put("sdk_version", (Object)Bank.sdkVersion);
            deviceDetails.put("cb_version", (Object)"6.0.0");
            deviceDetails.put("os_version", (Object)(Build.VERSION.SDK_INT + ""));
            deviceDetails.put("resolution", (Object)CBUtil.getDeviceDensity(this.activity));
            deviceDetails.put("device_manufacturer", (Object)Build.MANUFACTURER);
            deviceDetails.put("device_model", (Object)Build.MODEL);
            deviceDetails.put("merchant_key", (Object)sdkMerchantKey);
            CBUtil.setVariableReflection("com.payu.magicretry.MagicRetryFragment", sdkMerchantKey, "analyticsKey");
            deviceDetails.put("txnid", (Object)Bank.transactionID);
            deviceDetails.put("network_info", (Object)CBUtil.getNetworkStatus(this.activity));
            deviceDetails.put("network_strength", CBUtil.getNetworkStrength((Context)this.activity));
            new PayuDeviceAnalytics(this.activity, "cb_local_cache_device").log(deviceDetails.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void addEventAnalytics(String key, String value) {
        try {
            this.mAnalytics.log(CBUtil.getLogMessage(this.activity.getBaseContext(), key, value.toLowerCase(), this.bankName, Bank.keyAnalytics, Bank.transactionID));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void cbSetBankDrawable(String bankNameImage) {
        if (this.drawable == null && bankNameImage != null) {
            try {
                this.drawable = bankNameImage.equalsIgnoreCase("sbinet") || bankNameImage.equalsIgnoreCase("sbi") ? CBUtil.getDrawableCB((Context)this.activity, R.drawable.sbi) : (bankNameImage.equalsIgnoreCase("icici") || bankNameImage.equalsIgnoreCase("icicinet") || bankNameImage.equalsIgnoreCase("icicicc") ? CBUtil.getDrawableCB((Context)this.activity, R.drawable.icici) : (bankNameImage.equalsIgnoreCase("kotaknet") || bankNameImage.equalsIgnoreCase("kotak") ? CBUtil.getDrawableCB((Context)this.activity, R.drawable.kotak) : (bankNameImage.equalsIgnoreCase("indus") ? CBUtil.getDrawableCB((Context)this.activity, R.drawable.induslogo) : (bankNameImage.equalsIgnoreCase("hdfc") || bankNameImage.equalsIgnoreCase("hdfcnet") ? CBUtil.getDrawableCB((Context)this.activity, R.drawable.hdfc_bank) : (bankNameImage.equalsIgnoreCase("yesnet") ? CBUtil.getDrawableCB((Context)this.activity, R.drawable.yesbank_logo) : (bankNameImage.equalsIgnoreCase("sc") ? CBUtil.getDrawableCB((Context)this.activity, R.drawable.scblogo) : (bankNameImage.equalsIgnoreCase("axisnet") || bankNameImage.equalsIgnoreCase("axis") ? CBUtil.getDrawableCB((Context)this.activity, R.drawable.axis_logo) : (bankNameImage.equalsIgnoreCase("amex") ? CBUtil.getDrawableCB((Context)this.activity, R.drawable.cb_amex_logo) : (bankNameImage.equalsIgnoreCase("hdfcnet") || bankNameImage.equalsIgnoreCase("hdfc") ? CBUtil.getDrawableCB((Context)this.activity, R.drawable.hdfc_bank) : (bankNameImage.equalsIgnoreCase("ing") ? CBUtil.getDrawableCB((Context)this.activity, R.drawable.ing_logo) : (bankNameImage.equalsIgnoreCase("idbi") ? CBUtil.getDrawableCB((Context)this.activity, R.drawable.idbi) : (bankNameImage.equalsIgnoreCase("citi") ? CBUtil.getDrawableCB((Context)this.activity, R.drawable.citi) : null))))))))))));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void hideKeyboardForcefully() {
        View view = this.activity.getCurrentFocus();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager)this.activity.getSystemService("input_method");
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    void calculateCBHeight(View view) {
        view.measure(-2, -2);
        this.loading_height = view.getMeasuredHeight();
        this.minWebview = this.maxWebview - this.loading_height;
    }

    void calculateMaximumWebViewHeight() {
        try {
            if (this.maxWebview == 0) {
                this.cbWebView.measure(-1, -1);
                this.cbWebView.requestLayout();
                this.maxWebview = this.cbWebView.getMeasuredHeight();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void maximiseWebviewHeight() {
        if (this.maxWebview == 0) {
            this.calculateMaximumWebViewHeight();
        }
        this.cbWebView.getLayoutParams().height = this.maxWebview;
        this.cbWebView.requestLayout();
    }

    void minimizeWebviewHeight() {
        this.cbWebView.getLayoutParams().height = this.minWebview;
        this.cbWebView.requestLayout();
    }

    private ProgressDialog showProgress(Context context) {
        if (null != this.activity && this.isAdded() && context != null && !this.activity.isFinishing()) {
            LayoutInflater mInflater = LayoutInflater.from((Context)context);
            final Drawable[] drawables = new Drawable[]{this.cbGetDrawable((Context)this.activity, R.drawable.l_icon1), this.cbGetDrawable((Context)this.activity, R.drawable.l_icon2), this.cbGetDrawable((Context)this.activity, R.drawable.l_icon3), this.cbGetDrawable((Context)this.activity, R.drawable.l_icon4)};
            View layout2 = mInflater.inflate(R.layout.cb_prog_dialog, null);
            final ImageView imageView = (ImageView)layout2.findViewById(R.id.imageView);
            ProgressDialog progDialog = new ProgressDialog(context, R.style.cb_progress_dialog);
            final Timer timer = new Timer();
            timer.scheduleAtFixedRate(new TimerTask(){
                int i = -1;

                @Override
                public synchronized void run() {
                    if (CustomBrowserMain.this.activity != null) {
                        CustomBrowserMain.this.activity.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (CustomBrowserMain.this.activity != null) {
                                    ++i;
                                    if (i >= drawables.length) {
                                        i = 0;
                                    }
                                    imageView.setImageBitmap(null);
                                    imageView.destroyDrawingCache();
                                    imageView.refreshDrawableState();
                                    imageView.setImageDrawable(drawables[i]);
                                }
                            }
                        });
                    }
                }
            }, 0L, 500L);
            progDialog.show();
            progDialog.setContentView(layout2);
            progDialog.setCancelable(true);
            progDialog.setCanceledOnTouchOutside(false);
            progDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    CBUtil.cancelTimer(timer);
                    if (CustomBrowserMain.this.checkProgress == 1) {
                        CustomBrowserMain.this.checkProgress = 2;
                    }
                }
            });
            return progDialog;
        }
        return null;
    }

    void progressBarVisibilityPayuChrome(int visibility) {
        if (this.activity != null && !this.activity.isFinishing() && !this.isRemoving() && this.isAdded()) {
            if (visibility == 8 || visibility == 4) {
                if (this.progressDialog != null && this.progressDialog.isShowing()) {
                    this.progressDialog.dismiss();
                    this.checkForInput = 1;
                }
            } else if (this.progressDialog == null) {
                this.progressDialog = this.showProgress((Context)this.activity);
            }
        }
    }

    void communicationError() {
        this.progressBarVisibilityPayuChrome(8);
    }

    void startAnimation(int newProgress) {
        if (this.activity != null && !this.activity.isFinishing() && !this.isRemoving() && this.isAdded()) {
            if (this.lastProgress > newProgress) {
                this.cbWebPageProgressBar.setProgress(newProgress);
            }
            if (Build.VERSION.SDK_INT >= 11) {
                ObjectAnimator animation = ObjectAnimator.ofInt((Object)this.cbWebPageProgressBar, (String)"progress", (int[])new int[]{newProgress});
                animation.setDuration(50L);
                animation.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                animation.start();
            } else {
                this.cbWebPageProgressBar.setProgress(newProgress);
            }
            this.lastProgress = newProgress;
        }
    }

    void update() {
        this.maximiseWebviewHeight();
        this.frameState = 1;
        this.onHelpUnavailable();
    }

    public void registerBroadcast(BroadcastReceiver broadcastReceiver, IntentFilter filter) {
        this.mReceiver = broadcastReceiver;
        this.getActivity().registerReceiver(broadcastReceiver, filter);
    }

    public void unregisterBroadcast(BroadcastReceiver broadcastReceiver) {
        if (this.mReceiver != null) {
            this.activity.unregisterReceiver(broadcastReceiver);
            this.mReceiver = null;
        }
    }

    public void onHelpUnavailable() {
        if (this.activity != null && !this.activity.isFinishing()) {
            this.activity.findViewById(R.id.parent).setVisibility(8);
        }
    }

    public void onBankError() {
        this.activity.findViewById(R.id.parent).setVisibility(8);
    }

    public void onHelpAvailable() {
        this.activity.findViewById(R.id.parent).setVisibility(0);
    }

    public void updateSet(Set<String> urlSet, String check) {
        if (urlSet != null && urlSet.size() > 0 && this.webviewUrl != null && !urlSet.contains(this.webviewUrl)) {
            this.progressBarVisibilityPayuChrome(8);
            this.checkProgress = 2;
        }
        this.checkValue = check;
    }

    void setUrlString() {
        if (this.mBankJS != null) {
            try {
                StringTokenizer st;
                String urlStr;
                if (this.mBankJS.has("pgUrlList")) {
                    urlStr = this.mBankJS.getString("pgUrlList");
                    st = new StringTokenizer(urlStr.replace(" ", ""), "||");
                    while (st.hasMoreTokens()) {
                        this.urlSet.add(st.nextToken());
                    }
                } else {
                    this.communicationError();
                }
                if (this.mBankJS.has("postPaymentPgUrlList")) {
                    urlStr = this.mBankJS.getString("postPaymentPgUrlList");
                    st = new StringTokenizer(urlStr.replace(" ", ""), "||");
                    while (st.hasMoreTokens()) {
                        this.postPaymentURL.add(st.nextToken());
                    }
                }
                this.updateSet(this.urlSet, "https://secure.payu.in/_payment_options");
            }
            catch (Exception e) {
                this.communicationError();
                e.printStackTrace();
            }
        }
    }

    void callTimer() {
        new CountDownTimer(5000L, 1000L){

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                if (CustomBrowserMain.this.activity != null) {
                    CustomBrowserMain.this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CustomBrowserMain.this.activity != null && !CustomBrowserMain.this.activity.isFinishing() && CustomBrowserMain.this.isAdded()) {
                                CustomBrowserMain.this.onMerchantUrlFinished();
                            }
                        }
                    });
                }
            }
        }.start();
    }

    void onMerchantUrlFinished() {
        if (this.activity != null) {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (CustomBrowserMain.this.activity != null && !CustomBrowserMain.this.activity.isFinishing() && CustomBrowserMain.this.isAdded()) {
                        if (CustomBrowserMain.this.cbOldFlow) {
                            Intent intent = new Intent();
                            intent.putExtra(CustomBrowserMain.this.getString(R.string.cb_result), CustomBrowserMain.this.merchantResponse);
                            intent.putExtra(CustomBrowserMain.this.getString(R.string.cb_payu_response), CustomBrowserMain.this.payuReponse);
                            if (CustomBrowserMain.this.isSuccessTransaction.booleanValue()) {
                                if (CustomBrowserMain.this.storeOneClickHash == 1) {
                                    StoreMerchantHashTask mStoreMerchantHashTask = new StoreMerchantHashTask();
                                    mStoreMerchantHashTask.execute(new String[]{CustomBrowserMain.this.payuReponse});
                                }
                                CustomBrowserMain.this.activity.setResult(-1, intent);
                            } else {
                                CustomBrowserMain.this.activity.setResult(0, intent);
                            }
                        } else if (CustomBrowserMain.this.isSuccessTransaction.booleanValue()) {
                            if (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getStoreOneClickHash() == 1) {
                                StoreMerchantHashTask mStoreMerchantHashTask = new StoreMerchantHashTask();
                                mStoreMerchantHashTask.execute(new String[]{CustomBrowserMain.this.payuReponse});
                            }
                            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentSuccess(CustomBrowserMain.this.payuReponse, CustomBrowserMain.this.merchantResponse);
                        } else {
                            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentFailure(CustomBrowserMain.this.payuReponse, CustomBrowserMain.this.merchantResponse);
                        }
                        CustomBrowserMain.this.activity.finish();
                    }
                }
            });
        }
    }

    public void loadUrlWebView(JSONObject mJS, String functName) {
    }

    public void onBackPressed(AlertDialog.Builder alertDialog) {
    }

    public void onBackApproved() {
    }

    public void onBackCancelled() {
    }

    public class CBMainViewOnTouchListener
    implements View.OnTouchListener {
        float initialY;
        boolean isTouch = true;
        int height = 0;

        public boolean onTouch(View v, MotionEvent event) {
            if (!CustomBrowserMain.this.nbhelpVisible) {
                CustomBrowserMain.this.maximiseWebviewHeight();
                if (!this.isTouch) {
                    return false;
                }
                int action = event.getActionMasked();
                if (CustomBrowserMain.this.cbSlideBarView.getVisibility() == 0) {
                    CustomBrowserMain.this.cbSlideBarView.setClickable(false);
                    CustomBrowserMain.this.cbSlideBarView.setOnTouchListener(null);
                    TranslateAnimation animate = new TranslateAnimation(0.0f, 0.0f, (float)this.height, 0.0f);
                    animate.setDuration(500L);
                    animate.setFillBefore(true);
                    v.startAnimation((Animation)animate);
                    CustomBrowserMain.this.cbBaseView.setVisibility(0);
                    this.isTouch = false;
                    Handler handler = new Handler();
                    handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            CustomBrowserMain.this.cbSlideBarView.setVisibility(8);
                        }
                    }, 20L);
                    Handler handlertrans = new Handler();
                    handlertrans.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            CBMainViewOnTouchListener.this.isTouch = true;
                            CustomBrowserMain.this.frameState = 2;
                            if (CustomBrowserMain.this.cbTransparentView != null && CustomBrowserMain.this.activity != null && !CustomBrowserMain.this.activity.isFinishing()) {
                                CustomBrowserMain.this.showTransparentView(CustomBrowserMain.this.cbTransparentView, (Context)CustomBrowserMain.this.activity);
                            }
                        }
                    }, 500L);
                } else {
                    switch (action) {
                        case 0: {
                            this.initialY = event.getY();
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 1: {
                            float finalY = event.getY();
                            if (!(this.initialY < finalY) || CustomBrowserMain.this.cbBaseView.getVisibility() != 0 || !(finalY - this.initialY > 0.0f)) break;
                            this.height = v.getHeight();
                            TranslateAnimation animate = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(v.getHeight() - 30));
                            animate.setDuration(500L);
                            animate.setFillBefore(false);
                            animate.setFillEnabled(true);
                            animate.setZAdjustment(1);
                            v.startAnimation((Animation)animate);
                            if (CustomBrowserMain.this.cbTransparentView != null) {
                                CustomBrowserMain.this.cbTransparentView.setVisibility(8);
                            }
                            this.isTouch = false;
                            this.isTouch = true;
                            Handler handler = new Handler();
                            handler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    CustomBrowserMain.this.frameState = 1;
                                    CustomBrowserMain.this.cbBaseView.setVisibility(8);
                                    CustomBrowserMain.this.cbSlideBarView.setVisibility(0);
                                }
                            }, 400L);
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                }
                return true;
            }
            return false;
        }
    }
}

