// The MIT License (MIT)
//
// Copyright (c) 2014-2015 PayU India
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package com.payu.custombrowser.util;

/**
 * Created by minie on 30/6/15.
 * Constants for analytics.
 */

public class CBAnalyticsConstant {

    //Event keys for CBAnalytics
    public static final String PAYMENT_INITIATED = "payment_initiated";
    public static final String CUSTOM_BROWSER = "CUSTOM_BROWSER";
    public static final String NON_CUSTOM_BROWSER = "NON_CUSTOM_BROWSER";
    public static final String PASSWORD = "password_click";
    public static final String OTP = "otp_click";
    public static final String RECEIVED_OTP_DIRECT = "received_otp_direct";
    public static final String RECEIVED_OTP_SELECTED = "received_otp_selected";
    public static final String RECEIVED_OTP_REGENERATE = "received_otp_regenerate";

    public static final String OTP_WEB = "otp_web";

    public static final String REGENERATE = "regenerate_click";
    public static final String ENTER_MANUALLY = "enter_manually_click";
    public static final String APPROVED_OTP = "approved_otp";
    public static final String SUCCESS_TRANSACTION = "success_transaction";
    public static final String FAILURE_TRANSACTION = "failure_transaction";
    public static final String TERMINATE_TRANSACTION = "terminate_transaction";


    //Keys for Device Tracking for transaction
    public static final String SDK_VERSION_NAME = "sdk_version";
    public static final String CB_VERSION_NAME = "cb_version";
    public static final String DEVICE_OS_VERSION = "os_version";
    public static final String NETWORK_INFO = "network_info";
    public static final String NETWORK_STRENGTH="network_strength";
    public static final String DEVICE_RESOLUTION = "resolution";
    public static final String DEVICE_MANUFACTURE="device_manufacturer";
    public static final String DEVICE_MODEL="device_model";
    public static final String MERCHANT_KEY="merchant_key";
    public static final String ANALYTICS_KEY="merchantid";

    public static final String TRANSACTION_ID="txnid";

    //Event Analyitcs
    public static final String BANK_NAME="bank";
    public static final String PAKAGE_NAME="package_name";
    public static final String KEY="key";
    public static final String VALUE="value";



    //Key for Event CBAnalytics
    public static final String USER_INPUT="user_input";
    public static final String LAST_URL="last_url";
    public static final String CB_STATUS="cb_status";
    public static final String OTP_RECIEVED="otp_received";
    public static final String TRNX_STATUS="trxn_status";

    public static final String MERCHANT_BACK_BUTTON_CLICK="m_back_button";
    public static final String PAYU_BACK_BUTTON_CLICK="payu_back_button";
    public static final String BACK_BUTTON_OK_CLICK="back_button_ok";
    public static final String BACK_BUTTON_CANCEL_CLICK="back_button_cancel";



    public  static final String PAYU_PREFERENCE = "PayuPreference";
    public static final String DEFAULT = "default";
    public  static final String CARD_TOKEN = "card_token";
    public static final String MERCHANT_HASH = "merchant_hash";
    public static final String CB_AUTO_APPROVE="auto_approve";
    public static final String CB_AUTO_OTP_SELECT="auto_otp_select";

    public static final int STORE_ONE_CLICK_HASH_NONE = 0;
    public static final int STORE_ONE_CLICK_HASH_SERVER = 1;
    public static final int STORE_ONE_CLICK_HASH_MOBILE = 2;

    public static final String JANTA_URL="https://jsbeasynet.jsbnet.in";
    public static final String JANTA_DOMAIN="jsbeasynet.jsbnet.in";

}