package com.payu.custombrowser.bean;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntDef;
import android.support.annotation.NonNull;
import android.support.annotation.Size;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;


public class CustomBrowserConfig implements Parcelable {

    private int viewPortWideEnable;
    private int autoApprove;
    private int autoSelectOTP;
    private String transactionID;
    private String merchantKey;
    private String sdkVersionName;
    private int showCustombrowser;
    private int disableBackButtonDialog;
    private int storeOneClickHash;
    private int magicRetry=1;
    private int merchantSMSPermission;

    public int getMerchantSMSPermission() {
        return merchantSMSPermission;
    }

    public void setMerchantSMSPermission(boolean merchantSMSPermission) {
        this.merchantSMSPermission = merchantSMSPermission ?1:0;
    }


    public int getMagicretry() {
        return magicRetry;
    }

    public void setmagicRetry(boolean magicRetry) {
        this.magicRetry = magicRetry ?1:0;
    }

    public int getStoreOneClickHash() {
        return storeOneClickHash;
    }

    @IntDef({STOREONECLICKHASH_MODE_NONE, STOREONECLICKHASH_MODE_SERVER})
    @Retention(RetentionPolicy.SOURCE)
    public @interface StoreOneClickHashMode {}

    public static final int STOREONECLICKHASH_MODE_NONE = 0;
    public static final int STOREONECLICKHASH_MODE_SERVER = 1;
    //public static final int STOREONECLICKHASH_MODE_MOBILE = 2;


    public void setStoreOneClickHash(@StoreOneClickHashMode int storeOneClickHash) {
        this.storeOneClickHash=storeOneClickHash;
    }

    public int getDisableBackButtonDialog() {
        return disableBackButtonDialog;
    }

    public void setDisableBackButtonDialog(boolean disableBackButtonDialog) {
        this.disableBackButtonDialog = disableBackButtonDialog?1:0;
    }

    public int getViewPortWideEnable() {
        return viewPortWideEnable;
    }

    public void setViewPortWideEnable(boolean viewPortWideEnable) {
        this.viewPortWideEnable = viewPortWideEnable?1:0;
    }

    public int getAutoApprove() {
        return autoApprove;
    }

    public void setAutoApprove(boolean autoApprove) {
        this.autoApprove = autoApprove ?1:0;
    }

    public String getTransactionID() {
        return transactionID;
    }



    public int getAutoSelectOTP() {
        return autoSelectOTP;
    }

    public void setAutoSelectOTP(boolean autoSelectOTP) {
        this.autoSelectOTP = autoSelectOTP?1:0;
    }

    public String getMerchantKey() {
        return merchantKey;
    }


    public String getSdkVersionName() {
        return sdkVersionName;
    }

    public void setSdkVersionName(String sdkVersionName) {
        this.sdkVersionName = sdkVersionName;
    }

    public int getShowCustombrowser() {
        return showCustombrowser;
    }

    public void setShowCustombrowser(boolean showCustombrowser) {
        this.showCustombrowser = showCustombrowser?1:0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(viewPortWideEnable);
        dest.writeInt(autoApprove);
        dest.writeInt(autoSelectOTP);
        dest.writeString(transactionID);
        dest.writeString(merchantKey);
        dest.writeString(sdkVersionName);
        dest.writeInt(showCustombrowser);
        dest.writeInt(disableBackButtonDialog);
    }

    public CustomBrowserConfig(@NonNull @Size(min=6 , max = 6) String merchantKey , @NonNull String transactionID){
        this.transactionID=transactionID;
        this.merchantKey=merchantKey;
    }

    private CustomBrowserConfig(Parcel in){
        this.viewPortWideEnable = in.readInt();
        this.autoApprove = in.readInt();
        this.autoSelectOTP = in.readInt();
        this.transactionID = in.readString();
        this.merchantKey=in.readString();
        this.sdkVersionName=in.readString();
        this.showCustombrowser=in.readInt();
        this.disableBackButtonDialog=in.readInt();
    }

    public static final Creator<CustomBrowserConfig> CREATOR = new Creator<CustomBrowserConfig>() {

        @Override
        public CustomBrowserConfig createFromParcel(Parcel source) {
            return new CustomBrowserConfig(source);
        }

        @Override
        public CustomBrowserConfig[] newArray(int size) {
            return new CustomBrowserConfig[size];
        }
    };
}
