package com.payu.custombrowser;

import android.Manifest;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.telephony.SmsMessage;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CustomBrowserConstant;
import com.payu.custombrowser.cbinterface.MagicRetryCallbacks;
import com.payu.custombrowser.custombar.CustomProgressBar;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBUtil;
import org.json.JSONException;
import org.json.JSONObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URLEncoder;
import java.util.Timer;


public abstract class PayUCustomBrowserLifecycle extends CustomBrowserMain implements MagicRetryCallbacks {

    //Check instance
    boolean autoApprove;
    boolean autoSelectOtp;

    // true - when password is selected from CB. Default value is - false
    boolean pin_selected_flag;
    int chooseActionHeight;
    boolean showCB = true;
    String mPassword;
    Timer timer;
    Boolean approve_flag = false;
    boolean checkLoading;
    String enterOtpParams;
    boolean permissionGranted = true;
    boolean checkedPermission = false;
    boolean checkPermissionVisibility;
    boolean mPageReady = false;
    boolean SMSOTPClicked = false;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        activity = getActivity();

        //Default values of CB config
        //auto approve false
        // auto select false
        // store one click none
        // merchant sms permission false
        // magic retry true
        // back button true
        // view port default false

        if(activity.getIntent().getExtras()!=null){
            cbOldFlow =true;
            cbOldOnCreate();
        }else {
            cbOnCreate();
        }
            initAnalytics(Bank.keyAnalytics);
            if (activity != null) {
                pin_selected_flag = false;
           CookieManager cookieManager = CookieManager.getInstance();
            if (Build.VERSION.SDK_INT >= 21) { // for icici white page fix.
                cookieManager.removeSessionCookies(null);
            } else {
                if(Build.VERSION.SDK_INT >=19)
                cookieManager.removeSessionCookie();
            }

            }

    }


    /**
     * For Backward compability with old CB flow
     */
    public void cbOldOnCreate(){
        bundle = getArguments();
        autoApprove = bundle.getBoolean(AUTO_APPROVE, false);
        autoSelectOtp = bundle.getBoolean(AUTO_SELECT_OTP, false);
        storeOneClickHash = bundle.getInt(STORE_ONE_CLICK_HASH, CustomBrowserConfig.STOREONECLICKHASH_MODE_NONE);
        merchantSMSPermission=bundle.getBoolean(MERCHANT_SMS_PERMISSION, false);

        if(Bank.sdkVersion==null || Bank.sdkVersion.equalsIgnoreCase(""))
            Bank.sdkVersion=(getArguments().getString(Bank.SDK_DETAILS));

        if(Bank.transactionID==null || Bank.transactionID.equalsIgnoreCase(""))
            Bank.transactionID=(getArguments().getString(Bank.TXN_ID));

        if(Bank.keyAnalytics==null || Bank.keyAnalytics.equalsIgnoreCase(""))
            Bank.keyAnalytics=(getArguments().getString(Bank.MERCHANT_KEY));

        cbWebView = (WebView) activity.findViewById(getArguments().getInt(Bank.WEBVIEW));

        if(Bank.paymentMode!=null && Bank.paymentMode.equalsIgnoreCase(NB)){
            cbWebView.getSettings().setUseWideViewPort(true);
        }else if (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() !=null && CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getViewPortWideEnable() == CB_ENABLE_OPTION) {
           // CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getViewPortWideEnable() is 1 when during integration it is set to true
            cbWebView.getSettings().setUseWideViewPort(true);
        }
    }

    public void cbOnCreate(){
        merchantSMSPermission = (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() != null) && CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getMerchantSMSPermission() == CB_ENABLE_OPTION;
        autoApprove = (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() != null) && CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getAutoApprove() == CB_ENABLE_OPTION;
        autoSelectOtp = (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() != null) && CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getAutoSelectOTP() == CB_ENABLE_OPTION;
        storeOneClickHash = (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() == null) ? 0 : CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getStoreOneClickHash();
        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() != null) {
            if (Bank.keyAnalytics == null || Bank.keyAnalytics.trim().equals("")) {
                if (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getMerchantKey() != null || !CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getMerchantKey().trim().equals(""))
                    Bank.keyAnalytics = CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getMerchantKey();
                else
                    Bank.keyAnalytics = "";
            }

            if (Bank.transactionID == null || Bank.transactionID.trim().equals("")) {
                if (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getTransactionID() != null && !CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getTransactionID().trim().equals(""))
                    Bank.transactionID = CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getTransactionID();
                else
                    Bank.transactionID = "123";
            }

            if (Bank.sdkVersion == null || Bank.sdkVersion.trim().equals("")) {
                if (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getSdkVersionName() != null && !CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getSdkVersionName().trim().equals(""))
                    Bank.sdkVersion = CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getSdkVersionName();
                else
                    Bank.sdkVersion = "";
            }


        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);

        // view which is inflated
        // For old flow it is cbSlideBarView + cbBaseView
        // for new flow it is cbWebView + cbSlideBarView + cbBaseView
        View cbInflatedView;
        // Custom Browser cbMainView which has the cbSlideBarView and the cbBaseView
        View cbMainView;

        // condition to handle old integration for CB
        if(cbOldFlow) {
            cbInflatedView = inflater.inflate(R.layout.bankold, container, false);
            cbMainView = cbInflatedView;
            cbInflatedView.bringToFront();
            cbOldFlowOnCreateView();
        }else{
            cbInflatedView = inflater.inflate(R.layout.bank, container, false);
            cbTransparentView =cbInflatedView.findViewById(R.id.trans_overlay);
            cbWebView =(WebView)cbInflatedView.findViewById(R.id.webview);
            cbMainView = cbInflatedView.findViewById(R.id.parent);
            cbOnCreateView();
        }

        CBUtil.setVariableReflection(CustomBrowserConstant.MAGIC_RETRY_PAKAGE, BuildConfig.VERSION_NAME, CustomBrowserConstant.CB_VERSION);


        // cbBaseView - FrameLayout, different cbInflatedView are added to this framelayout, event depend on js.
        cbBaseView = (FrameLayout) cbInflatedView.findViewById(R.id.help_view);
        cbSlideBarView = cbInflatedView.findViewById(R.id.view);
        cbWebPageProgressBar =(ProgressBar) cbInflatedView.findViewById(R.id.cb_progressbar);
        cbWebView.getSettings().setJavaScriptEnabled(true);
        cbWebView.addJavascriptInterface(this, "PayU");
        cbWebView.getSettings().setDomStorageEnabled(true);
        cbWebView.getSettings().setSupportMultipleWindows(true);
        cbWebView.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (cbTransparentView != null)
                    cbTransparentView.setVisibility(View.GONE);
                if (frameState == MAXIMISED) {
                    minimizeWebviewHeight();
                }
                return false;
            }
        });


        // download initialize.js file
        getInitializeJS();


        // touch listener to handle minimise and maximise of the CustomBrowser
        cbMainView.setOnTouchListener(new CBMainViewOnTouchListener());
        return cbInflatedView;
    }



    public void cbOldFlowOnCreateView(){


        cbWebView.setFocusable(true);
        if(getArguments().getBoolean(BACK_BUTTON,true)) {
            cbWebView.setOnKeyListener(new View.OnKeyListener() {
                @Override
                public boolean onKey(View v, int keyCode, KeyEvent event) {

                    if (event.getAction() == KeyEvent.ACTION_UP && keyCode == KeyEvent.KEYCODE_BACK) {
                        if (getArguments().getBoolean(BACK_BUTTON, true)) {
                            AlertDialog.Builder alertDialog = new AlertDialog.Builder(activity);
                            alertDialog.setCancelable(false);
                            alertDialog.setMessage("Do you really want to cancel the transaction ?");
                            alertDialog.setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_OK_CLICK);
                                    dialog.dismiss();
                                    onBackApproved();

                                    // CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackApprove();
                                    activity.finish();
                                }
                            });
                            alertDialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_CANCEL_CLICK);
                                    onBackCancelled();
                                    dialog.dismiss();

                                    //  CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackDismiss();
                                }
                            });
                            // CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackButton(alertDialog);
                            addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.PAYU_BACK_BUTTON_CLICK);
                            onBackPressed(alertDialog);
                            alertDialog.show();

                            return true;
                        } else {
                            addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.MERCHANT_BACK_BUTTON_CLICK);
                            activity.onBackPressed();
                        }
                    }
                    return false;
                }
            });
        }
        if(Bank.paymentMode!=null && Bank.paymentMode.equalsIgnoreCase(NB)){
            cbWebView.getSettings().setUseWideViewPort(true);
        }else if (bundle.getBoolean(VIEWPORTWIDE,false)) {
            cbWebView.getSettings().setUseWideViewPort(true);
        }
    }

    public void cbOnCreateView(){

        if(Bank.paymentMode!=null && Bank.paymentMode.equalsIgnoreCase(NB)){
            cbWebView.getSettings().setUseWideViewPort(true);
        }else if (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() !=null && CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getViewPortWideEnable() == CB_ENABLE_OPTION) {
            cbWebView.getSettings().setUseWideViewPort(true);
        }

        cbWebView.setWebChromeClient(new PayUWebChromeClient((Bank) this));
        cbWebView.setWebViewClient(new PayUWebViewClient((Bank) this, Bank.keyAnalytics));

        if(CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback()!=null)
        CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().setCBProperties(cbWebView, (Bank) this);

        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getMagicretry() == CB_ENABLE_OPTION) {
            initMagicRetry();
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().initializeMagicRetry((Bank) this, cbWebView, magicRetryFragment);
        }
    }
    // log the event for destroy of fragment
    // events - custom browser / non custom browser, last url , terminate
    public void logOnTerminate(){
        try {
            addEventAnalytics(CBAnalyticsConstant.LAST_URL, URLEncoder.encode(CBUtil.updateLastUrl(CBUtil.getStringSharedPreference(activity, CBAnalyticsConstant.LAST_URL)), "UTF-8"));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            CBUtil.deleteSharedPrefKey(activity, CBAnalyticsConstant.LAST_URL);
        }

        if (!eventArray.contains(CBAnalyticsConstant.CUSTOM_BROWSER)) {
            eventRecorded = CBAnalyticsConstant.NON_CUSTOM_BROWSER;
            addEventAnalytics( CBAnalyticsConstant.CB_STATUS, eventRecorded);
        }

        eventRecorded = CBAnalyticsConstant.TERMINATE_TRANSACTION;
        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);

        if (progressDialog != null && !progressDialog.isShowing())
            progressDialog.dismiss();

        if (mBroadcastReceiver != null) {
            unregisterBroadcast(mBroadcastReceiver);
            mBroadcastReceiver = null;
        }

    }
    public void onDestroy() {
        super.onDestroy();
        //testing remove
        logOnTerminate();
        Bank.sdkVersion=null;
        Bank.keyAnalytics=null;
        Bank.transactionID=null;
        Bank.paymentMode=null;
        getActivity().finish();
    }

    @Override
    public void onResume() {
        super.onResume();
    }


    /**
     * Preparing sms listener.
     * Reads the sms and checks whether its a otp message.
     */

     void prepareSmsListener() {
        if (mBroadcastReceiver == null) {
            mBroadcastReceiver = new BroadcastReceiver() {
                @Override
                public void onReceive(Context context, Intent intent) {
                    try {
                        if (mBankJS == null) {
                            return;
                        }
                        Bundle myBundle = intent.getExtras();
                        if (getActivity() != null) {
                            Bundle extras = intent.getExtras();
                            if (extras != null) {

                                // Get received SMS array
                                SmsMessage[] msgs;
                                String msgBody = null;
                                    Object[] pdus = (Object[]) extras.get("pdus");
                                    if(pdus!=null) {
                                        msgs = new SmsMessage[pdus.length];
                                        for (int i = 0; i < msgs.length; i++) {
                                            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                                                String format = myBundle.getString("format");
                                                msgs[i] = SmsMessage.createFromPdu((byte[]) pdus[i], format);
                                            }
                                            else {
                                                msgs[i] = SmsMessage.createFromPdu((byte[]) pdus[i]);
                                            }
                                          //  msgs[i] = SmsMessage.createFromPdu((byte[]) pdus[i]);
                                            msgBody += msgs[i].getMessageBody();
                                        }
                                    }

                                // We have the message!
                                //filter sms
                                mPassword=CBUtil.filterSMS(mBankJS,msgBody,getActivity());

                                // fill otp
                                if(mPassword!=null) {
                                    fillOTP( this);
                                }
                            }

                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            // Register the broadcast receiver
            IntentFilter filter = new IntentFilter();
            filter.setPriority(9999999);
            filter.addAction("android.provider.Telephony.SMS_RECEIVED");
            registerBroadcast(mBroadcastReceiver, filter);
        }
    }


    public void fillOTP(BroadcastReceiver mReceiver){
        if (getActivity().findViewById(R.id.otp_sms) != null) {
            final TextView otpSMS = (TextView) getActivity().findViewById(R.id.otp_sms);
            if (showCB && mPassword != null && otpSMS.getVisibility() != View.VISIBLE) {
                CBUtil.cancelTimer(timer);
                switch (eventRecorded) {
                    case CBAnalyticsConstant.PAYMENT_INITIATED:
                    case CBAnalyticsConstant.CUSTOM_BROWSER:
                        eventRecorded = CBAnalyticsConstant.RECEIVED_OTP_DIRECT;

                        break;
                    case CBAnalyticsConstant.OTP:
                        eventRecorded = CBAnalyticsConstant.RECEIVED_OTP_SELECTED;

                        break;
                    case CBAnalyticsConstant.REGENERATE:
                        eventRecorded = CBAnalyticsConstant.RECEIVED_OTP_REGENERATE;

                        break;
                    default:
                        eventRecorded = CBAnalyticsConstant.OTP_WEB;
                        break;
                }
                addEventAnalytics(CBAnalyticsConstant.OTP_RECIEVED, eventRecorded);

                otpSMS.setText(mPassword);
                mPassword = null;
                CustomProgressBar.removeDialog(getActivity().findViewById(R.id.progress));

                Button approveButton = (Button) getActivity().findViewById(R.id.approve);
                approveButton.setClickable(true);
                CBUtil.setAlpha(1, approveButton);
                approveButton.setVisibility(View.VISIBLE);

                activity.findViewById(R.id.timer).setVisibility(View.GONE);
                activity.findViewById(R.id.retry_text).setVisibility(View.GONE);
                activity.findViewById(R.id.regenerate_layout).setVisibility(View.GONE);
                activity.findViewById(R.id.waiting).setVisibility(View.GONE);
                activity.findViewById(R.id.otp_recieved).setVisibility(View.VISIBLE);
                otpSMS.setVisibility(View.VISIBLE);
                if (autoApprove) {
                    approveButton.performClick();
                    eventRecorded = CBAnalyticsConstant.CB_AUTO_APPROVE;
                    addEventAnalytics( CBAnalyticsConstant.USER_INPUT, eventRecorded);
                }
                approveButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        try {
                            mPassword=null;
                            eventRecorded = CBAnalyticsConstant.APPROVED_OTP;
                            addEventAnalytics( CBAnalyticsConstant.USER_INPUT, eventRecorded);
                            prepareSmsListener();
                            checkLoading = false;
                            approve_flag = true;
                            onHelpUnavailable();
                            maximiseWebviewHeight();
                            frameState = MINIMISED;
                            cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_process_otp)) + "(\"" + otpSMS.getText().toString() + "\")");
                            hideSoftKeyboard();

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }catch(Exception e)
                        {
                            e.printStackTrace();
                        }
                    }
                });

                // unregister the broadcast receiver.
                mReceiver.abortBroadcast();

                if (mBroadcastReceiver != null) {
                    unregisterBroadcast(mBroadcastReceiver);
                    mBroadcastReceiver = null;
                }
            }
        }
    }

    /**
     * Download initialize.js form payu server.
     */
    private void getInitializeJS() {
        // listen for OTP
        prepareSmsListener();
        eventRecorded = CBAnalyticsConstant.PAYMENT_INITIATED;

        addEventAnalytics( CBAnalyticsConstant.USER_INPUT, eventRecorded);

        // make an http request!
        new AsyncTask<Void, Void, Void>() {
            @Override
            protected Void doInBackground(Void... voids) {
                String fileName = "initialize";

                try {
                    String strURL=CB_URL + fileName + ".js";

                /*    HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setRequestProperty("Accept-Charset", "UTF-8");*/
                   HttpURLConnection conn= CBUtil.getHttpsConn(strURL);
                    if (conn !=null && conn.getResponseCode() == HttpURLConnection.HTTP_OK) {

                        CBUtil.writeFileOutputStream(conn.getInputStream(), activity, fileName, Context.MODE_PRIVATE);

                        /*GZIPInputStream responseInputStream = new GZIPInputStream(conn.getInputStream());
                        byte[] buf = new byte[1024];
                        int len;
                        FileOutputStream outputStream = activity.openFileOutput(fileName, Context.MODE_PRIVATE);
                        while ((len = responseInputStream.read(buf)) > 0) {
                            outputStream.write(buf, 0, len);
                        }
                        responseInputStream.close();
                        outputStream.close();*/
                    }

                } catch (MalformedURLException e) {
                    e.printStackTrace();
                } catch (ProtocolException e) {
                    e.printStackTrace();
                } catch (IOException e) {
                    e.printStackTrace();
                }catch(Exception e)
                {
                    e.printStackTrace();
                }finally {
                    // reading initialize.js form file.
                    try {
                        if (activity != null) {
                            mBankJS = new JSONObject(CBUtil.decodeContents(activity.openFileInput(fileName)));
                            setUrlString();
                            if (mPageReady) {
                                if (activity != null) {
                                    activity.runOnUiThread(new Runnable() {
                                        @Override
                                        public void run() {
                                            onPageStarted();
                                        }
                                    });
                                }
                            }
                        }
                    } catch (FileNotFoundException | JSONException e) {
                        communicationError();
                        e.printStackTrace();
                    } catch (Exception e) {
                        communicationError();
                        e.printStackTrace();
                    }
                }

                return null;
            }
        }.execute(null, null, null);
    }





    /**
     * Adjust cbWebView size
     *
     * @param view instance of view of which hieght has to be updated
     */
    public void updateHeight(View view) {

        if (maxWebview == 0) {
            calculateMaximumWebViewHeight();
            maximiseWebviewHeight();
        }
        calculateCBHeight(view);
    }

    /**
     * Calculate and update loader height.
     */
    public void updateLoaderHeight() {
        if (chooseActionHeight == 0) {
            cbWebView.measure(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            int maxWebview = cbWebView.getMeasuredHeight();
            chooseActionHeight = (int) (maxWebview * (0.35));
        }
    }



    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String permissions[], @NonNull int[] grantResults) {// here we get the respose of the above request for receiving sms
        switch (requestCode) {
            case 1: {
                checkPermissionVisibility = false;
                if (SMSOTPClicked) {
                    try {
                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                if(ContextCompat.checkSelfPermission(activity, Manifest.permission.RECEIVE_SMS) == PackageManager.PERMISSION_GRANTED) {// this condition checks if the user has given us the permission to read sms
                    permissionGranted = true;
                    mPassword = null;
                    prepareSmsListener();
                    enter_otp(enterOtpParams);
                }
//                }else if (grantResults[0] == PackageManager.PERMISSION_GRANTED) { this condition can be used later. so commenting out
//
//                    permissionGranted = true;
//
//                    mPassword = null;
//                    prepareSmsListener();
//
//                }
                else {
                    permissionGranted = false;
                    enter_otp(enterOtpParams);
                }
            }
        }
    }


    abstract void onPageStarted();
    abstract void enter_otp(String params);
}
