package com.payu.custombrowser;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import com.payu.custombrowser.analytics.CBAnalytics;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.magicretry.MagicRetryFragment;

public class CBActivity extends FragmentActivity implements MagicRetryFragment.ActivityCallback{
   private Bank payUCustomBrowser;

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(com.payu.custombrowser.R.layout.cb_payments);
            payUCustomBrowser = new Bank();
            getSupportFragmentManager().beginTransaction().add(com.payu.custombrowser.R.id.main_frame, payUCustomBrowser).commit();
    }

    @Override
    public void onBackPressed(){
        final CBAnalytics cbAnalytics=CBAnalytics.getInstance(getApplicationContext(),"");
        if(CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig()!=null && CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getDisableBackButtonDialog()!=1) {
            AlertDialog.Builder alertDialog = new AlertDialog.Builder(this);
            alertDialog.setCancelable(false);
            alertDialog.setMessage("Do you really want to cancel the transaction ?");
            alertDialog.setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackApprove();
                    cbAnalytics.log(CBUtil.getLogMessage(getBaseContext(), CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_OK_CLICK.toLowerCase(), payUCustomBrowser.getBankName(), Bank.keyAnalytics, Bank.transactionID));

                    CBActivity.this.finish();
                }
            });
            alertDialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    cbAnalytics.log(CBUtil.getLogMessage(getBaseContext(), CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_CANCEL_CLICK.toLowerCase(), payUCustomBrowser.getBankName(), Bank.keyAnalytics,Bank.transactionID));

                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackDismiss();
                }
            });
            cbAnalytics.log(CBUtil.getLogMessage(getBaseContext(), CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.PAYU_BACK_BUTTON_CLICK.toLowerCase(), payUCustomBrowser.getBankName(), Bank.keyAnalytics,Bank.transactionID));
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackButton(alertDialog);
            alertDialog.show();
        }else{

            CBActivity.this.finish();
        }
    }

    /**
     * CallBack for magic retry
     */
    public void showMagicRetry() {
        payUCustomBrowser.showMagicRetry();
    }

    /**
     * CallBack for magic retry
     */
    public void hideMagicRetry() {
        payUCustomBrowser.hideMagicRetry();
    }


    @Override
    public void onDestroy(){
        if(CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback()!=null)
        CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentTerminate();
        super.onDestroy();
    }
}
