// The MIT License (MIT)
//
// Copyright (c) 2014-2015 PayU India
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package com.payu.custombrowser;
import android.Manifest;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CustomBrowserConstant;
import com.payu.custombrowser.custombar.CustomProgressBar;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.magicretry.Helpers.Util;
import com.payu.magicretry.MagicRetryFragment;
import org.json.JSONException;
import org.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

/**
 * Custom browser's Fragment.
 * Keeping it as abstract for providing call back function to implementing Activities.
 * Following functions needs to be overridden.
 * {@link Bank#registerBroadcast(BroadcastReceiver, IntentFilter)}}
 * {@link Bank#unregisterBroadcast(BroadcastReceiver)}
 * {@link Bank#onHelpAvailable()}
 * {@link Bank#onHelpUnavailable()}
 * {@link Bank#onBankError()}
 */
public class Bank extends PayUCustomBrowserLifecycle {
    static String keyAnalytics;
    static String transactionID;
    static String paymentMode;
    static String sdkVersion;
    // false when onPageFinished  called second time
    private boolean firstFinish=true;


    //CB version
    public static String Version=BuildConfig.VERSION_NAME;
    static {
        Version = BuildConfig.VERSION_NAME;
    }

    //check for loading mJS only once
    private boolean mLoadingJS = false;

    //check for HDFC bank as enterOTP is called twice
    private int c_hdfc = 0;

    //listener on buttons of custom browser
    private ButtonOnclickListener buttonClickListener;

    //check for, should save user ID
    private boolean saveUserIDCheck = true;

    // bank page loading layout
    private View loadingLayout;

    // Runnable for wait for OTP timer
    private Runnable enterOtpRunnable;

    //check for first time finish call
    //private boolean firstFinish = true;

    //input bundle
    // private Bundle bundle;

    // make sure checkvisibility(dynamic CB) is called only once.
    private boolean visibilitychecked;

    //Android M handling permission check
    //private String merchantHash;
    // MR integration
    private boolean isMRDataSet = false;

    private boolean showToggleCheck;

    public String getBankName(){
        if(bankName==null)
            return "";
        return bankName;
    }

    /**
     * This method checks permission to read SMS for androidM and above
     */
    private void checkPermission() {//this method checks permission to read SMS for androidM and above
        //  if (!checkedPermission) { // this is to check if this method was called before.

        if (!checkedPermission && Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && merchantSMSPermission) {
            checkedPermission = true;
            if (ContextCompat.checkSelfPermission(activity, Manifest.permission.RECEIVE_SMS) != PackageManager.PERMISSION_GRANTED) {// this checks if we have permission to receive sms or not,
                requestPermissions(new String[]{Manifest.permission.RECEIVE_SMS}, 1); // if we dont have permission we request permission
                checkPermissionVisibility = true;
            } else {
                permissionGranted = true;
                if (SMSOTPClicked) {
                    try {
                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            onHelpAvailable();
            if(ContextCompat.checkSelfPermission(activity, Manifest.permission.RECEIVE_SMS) != PackageManager.PERMISSION_GRANTED) {
                permissionGranted = false;
            }else{
                permissionGranted = true;
            }

            if (SMSOTPClicked) {
                try {
                    cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
                } catch (JSONException e) {
                    e.printStackTrace();
                }catch(Exception e){
                    e.printStackTrace();

                }
            }
        }

    }


    /**
     * Dynamic Custom browser.
     * Now we can enable/disable cb based on javascript rules.
     *
     * @param bank name of the bank
     */
    private void checkVisibilityCB(final String bank) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            JSONObject obj = new JSONObject();
                            obj.put("androidosversion", Build.VERSION.RELEASE + "");
                            obj.put("androidmanufacturer", (Build.MANUFACTURER + "").toLowerCase());
                            obj.put("model", (Build.MODEL + "").toLowerCase());
                            obj.put("merchantid", Bank.keyAnalytics);
                            obj.put("sdkname", Bank.sdkVersion);
                            obj.put("cbname", BuildConfig.VERSION_NAME);
                            obj.put("bankname", bank.toLowerCase());
                            cbWebView.loadUrl("javascript:" + mBankJS.getString("checkVisibilityCBCall") + "(" + obj + ")");
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Callback from custombrowser tells the bank.java to show or hide the custom browser.
     *
     * @param showCustomBrowser enable or disbale custom browser
     */
    @JavascriptInterface
    public void showCustomBrowser(final boolean showCustomBrowser) {
        showCB = showCustomBrowser;
        if (getActivity() != null) {
            getActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (!showCustomBrowser) {
                        maximiseWebviewHeight();
                        frameState = MINIMISED;
                        try {
                            if (cbSlideBarView != null)
                                cbSlideBarView.setVisibility(View.GONE);
                            onHelpUnavailable();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    @JavascriptInterface
    public void setMRData(String data) {
        if (!isMRDataSet) {
            // Store the Magic retry setting in shared preference
            MagicRetryFragment.setMRData(data,getActivity().getApplicationContext());
            isMRDataSet = true;
        }
    }

    /**
     * Dismiss error page
     */
    public void onOverrideURL() {
        if (cbWebPageProgressBar != null)
            cbWebPageProgressBar.setProgress(0);
    }

    /**
     * Custom browser shows the error page.
     *
     * @param errorCode error code received by dvm for the error
     * @param description description about the error
     */
    public void onReceivedErrorWebClient(int errorCode, String description) {
        try {
            if (getActivity() != null && !getActivity().isFinishing()) {
                onHelpUnavailable();
                cbBaseView.removeAllViews();

                if(cbWebPageProgressBar !=null){
                    cbWebPageProgressBar.setVisibility(View.GONE);
                    cbWebPageProgressBar.setProgress(0);
                }
                // maximize cb webview height, if calculated maximum WebView height is greater than 0
                if (maxWebview != 0) {
                    maximiseWebviewHeight();
                    frameState = MINIMISED;
                }
                if(!cbOldFlow)
                CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onCBErrorReceived(errorCode, description);

                progressBarVisibilityPayuChrome(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // MR Integration
    private void showMagicRetryCB() {
        try {
            cbWebView.loadUrl("javascript:" + mBankJS.getString("getMagicRetryUrls") + "('" + Bank.keyAnalytics + "')");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * update progress bar according to progress recieved
     *
     * @param progress percentage completion of loading url
     */
    public void onProgressChanged(int progress){
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            if (cbWebPageProgressBar != null) {
                cbWebPageProgressBar.setVisibility(View.VISIBLE);
                // progressBar.setProgress(progress);

                if (progress == 100) {
                    if (cbWebPageProgressBar != null) {
                        cbWebPageProgressBar.setProgress(100);
                        Handler handler = new Handler();
                        handler.postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()){
                                    cbWebPageProgressBar.setVisibility(View.GONE);
                                    cbWebPageProgressBar.setProgress(0);
                                    lastProgress = 0;
                                }
                            }
                        }, 100);
                    }
                } else {
                    startAnimation(progress);
                }
            }
        }
    }




    @JavascriptInterface
    public void onMerchantHashReceived(final String result) {
        if ( getActivity() != null && ! getActivity().isFinishing() && !isRemoving() && isAdded()) {
            getActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    switch (storeOneClickHash) {
                        case CBAnalyticsConstant.STORE_ONE_CLICK_HASH_MOBILE:
                            try {
                                JSONObject hashObject = new JSONObject(result);
                                // store the cvv in shared preferences.
                                CBUtil.storeInSharedPreferences(getActivity(), hashObject.getString(CBAnalyticsConstant.CARD_TOKEN), hashObject.getString(CBAnalyticsConstant.MERCHANT_HASH));
                            } catch (JSONException e) {
                                e.printStackTrace();

                            }
                            break;
                        case CBAnalyticsConstant.STORE_ONE_CLICK_HASH_SERVER:
                            //  merchantHash = result;
                            break;
                        case CBAnalyticsConstant.STORE_ONE_CLICK_HASH_NONE:
                            break;
                    }
                }
            });
        }
    }

    /**
     * should be called for {@link PayUWebViewClient#onPageStarted(WebView, String, Bitmap)}
     *
     * @param url cbWebView url
     */
    public void onPageStartedWebclient(String url) {
	if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
	    CBUtil.setStringSharedPreference(activity, CBAnalyticsConstant.LAST_URL, "s:" + url);
	    // progress bar is set visible
	    if (cbWebPageProgressBar != null)
		cbWebPageProgressBar.setVisibility(View.VISIBLE);

	    progressBarVisibilityPayuChrome(View.VISIBLE);
	    webviewUrl = url;

	    if (checkProgress == 0) {
		if (urlSet != null && urlSet.size() > 0 && !urlSet.contains(url)) {
		    checkProgress = PRE_PAYMENT;
		}
	    }
	    if (checkProgress == POST_PAYMENT) {
		progressBarVisibilityPayuChrome(View.GONE);
	    }

	    if (checkProgress == DURING_PAYMENT) {
		if (postPaymentURL != null && postPaymentURL.size() > 0) {
		    for (String aPostPaymentURL : postPaymentURL) {
			if (url.contains(aPostPaymentURL)) {
			    progressDialog = null;
			    progressBarVisibilityPayuChrome(View.VISIBLE);
			    update();
			    checkProgress = POST_PAYMENT;
			    break;
			}
		    }
		}
	    }

	    if (checkValue != null && url.contains(checkValue)) {
		update();
		progressBarVisibilityPayuChrome(View.GONE);
	    }

	}
    }



    /**
     * Call back function from {@link PayUWebViewClient#onLoadResource(WebView, String)}
     *
     * @param view instance of cbWebView
     * @param url resourse url which  is loading
     */
    public void onLoadResourse(WebView view, String url) {
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            if (url.equalsIgnoreCase(rupeeURL) || url.contains(rupeeURL1) || url.contains(rupeeURL2)) {
                progressBarVisibilityPayuChrome(View.GONE);
                checkProgress = DURING_PAYMENT;
            }
        }
    }

    /**
     * Call back function from {@link PayUWebViewClient#onPageFinished(WebView, String)}
     * It takes care keyboard open issue and dissmiss the payu dialog.
     *
     * @param url - finish url
     */
    public void onPageFinishWebclient(String url) {
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            CBUtil.setStringSharedPreference(activity, CBAnalyticsConstant.LAST_URL, "f:" + url);
            if (checkProgress == PRE_PAYMENT) {
                progressBarVisibilityPayuChrome(View.GONE);
                checkProgress = DURING_PAYMENT;
            }
            if (firstFinish && (getArguments()!=null && getArguments().getInt("mainLayout",-1)!=-1)) {
                try {
                    final View activityRootView = activity.findViewById(getArguments().getInt("mainLayout"));
                    activityRootView.getViewTreeObserver().addOnGlobalLayoutListener(
                            new ViewTreeObserver.OnGlobalLayoutListener() {
                                private final int DefaultKeyboardDP = 100;
                                private final int EstimatedKeyboardDP = DefaultKeyboardDP + (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP ? 48 : 0);
                                private final Rect r = new Rect();

                                @Override
                                public void onGlobalLayout() {
                                    if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
                                        // Convert the dp to pixels.
                                        int estimatedKeyboardHeight = (int) TypedValue
                                                .applyDimension(TypedValue.COMPLEX_UNIT_DIP, EstimatedKeyboardDP, activityRootView.getResources().getDisplayMetrics());
                                        // Conclude whether the keyboard is shown or not.
                                        activityRootView.getWindowVisibleDisplayFrame(r);
                                        int heightDiff = activityRootView.getRootView().getHeight() - (r.bottom - r.top);
                                        boolean isShown = heightDiff >= estimatedKeyboardHeight;
                                        if (isShown) {
                                            if (checkForInput == 0) {
                                                InputMethodManager imm = (InputMethodManager) activity.getSystemService(Activity.INPUT_METHOD_SERVICE);
                                                imm.toggleSoftInput(InputMethodManager.RESULT_HIDDEN, 0);
                                                checkForInput = 1;
                                            }
                                        }
                                    }
                                }
                            });
                    firstFinish = false;

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }



    /**
     * Stores the user id on NetBanking.
     */
    @JavascriptInterface
    public void getUserId() {
        if (activity != null && !activity.isFinishing()) {
            //SH: Can we please move it to a common place
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {

                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_populate_user_id)) + "(\"" + CBUtil.getStringSharedPreference(activity, bankName) + "\")");

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    /**
     * Stroes the user id on Netbanking.
     *
     * @param params - JSON object from js
     */
    @JavascriptInterface
    public void setUserId(final String params) {
        if (saveUserIDCheck) {
            if (activity != null && !activity.isFinishing()) {
                //SH: Can we please make use of SP helper here? And every other place where SP is accessed?
                //APPLIED CHANGE
                CBUtil.storeInSharedPreferences(activity, bankName, params);
            }
        }else{
            //APPLIED CHANGE
            String savedParam=CBUtil.getStringSharedPreference(activity, bankName);
            if(!savedParam.equals("") && savedParam.equals(params)){
                //APPLIED CHANGE
                CBUtil.removeFromSharedPreferences(activity, bankName);
            }
        }

    }

    /**
     * Adds remember username and password peak view for NB
     *
     * @param fields key for handling net banking custom browser
     * @param params JSON string for net banking custom browser key
     */
    @JavascriptInterface
    public void nativeHelperForNB(final String fields, final String params) {
        if (activity != null && !activity.isFinishing()) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        onHelpAvailable();
                        if (fields != null && activity != null) {
                            View nbView = activity.getLayoutInflater().inflate(R.layout.nb_layout, null);
                            final Button bContinue = (Button) nbView.findViewById(R.id.b_continue);
                            final CheckBox checkBox = (CheckBox) (nbView.findViewById(R.id.checkbox));
                            JSONObject jsonObject = new JSONObject(params);
                            String bText = getString(R.string.cb_btn_text);
                            if (jsonObject.has(bText) && jsonObject.getString(bText) != null && !jsonObject.getString(bText).equalsIgnoreCase("")) {
                                if (fields.equals(getString(R.string.cb_button))) {
                                    if (jsonObject.has(getString(R.string.cb_checkbox))) {
                                        if (jsonObject.getBoolean(getString(R.string.cb_checkbox))) {
                                            if (saveUserIDCheck)
                                                checkBox.setChecked(true);
                                            else
                                                checkBox.setChecked(false);


                                            checkBox.setOnClickListener(new View.OnClickListener() {
                                                @Override
                                                public void onClick(View v) {
                                                    saveUserIDCheck = checkBox.isChecked();
                                                }
                                            });
                                            checkBox.setVisibility(View.VISIBLE);
                                        } else {
                                            checkBox.setVisibility(View.GONE);
                                        }

                                    } else {
                                        checkBox.setVisibility(View.GONE);
                                    }
                                    bContinue.setText(jsonObject.getString(bText));
                                    bContinue.setTransformationMethod(null);
                                    bContinue.setOnClickListener(new View.OnClickListener() {
                                        @Override
                                        public void onClick(View v) {
                                            try {
                                                cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_btn_action)));
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                    cbBaseView.removeAllViews();
                                    cbBaseView.addView(nbView);
                                    nbhelpVisible = true;
                                } else if (fields.equals(getString(R.string.cb_pwd_btn))) { // for pwd button flow
                                    bContinue.setText(jsonObject.getString(bText));
                                    if (showToggleCheck)
                                        checkBox.setChecked(true);
                                    else
                                        checkBox.setChecked(false);
                                    if (checkBox.isChecked()) {
                                        try {
                                            cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_toggle_field)) + "(\"" + true + "\")");
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    checkBox.setText(getString(R.string.cb_show_password));
                                    checkBox.setVisibility(View.VISIBLE);
                                    checkBox.setOnClickListener(new View.OnClickListener() {
                                        @Override
                                        public void onClick(View v) {
                                            showToggleCheck = checkBox.isChecked();
                                            if (checkBox.isChecked()) {
                                                try {
                                                    // mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_btn_action)));
                                                    cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_toggle_field)) + "(\"" + true + "\")");
                                                } catch (Exception e) {
                                                    e.printStackTrace();
                                                }

                                            } else {
                                                try {
                                                    cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_toggle_field)) + "(\"" + false + "\")");
                                                } catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                            }

                                        }
                                    });
                                    bContinue.setOnClickListener(new View.OnClickListener() {
                                        @Override
                                        public void onClick(View v) {
                                            try {
                                                cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_btn_action)));
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                            }

                                        }
                                    });
                                    nbhelpVisible = true;
                                    cbBaseView.removeAllViews();
                                    cbBaseView.addView(nbView);
                                }

                            } else {
                                onHelpUnavailable();
                                cbBaseView.removeAllViews();
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

            });
        }
    }


    public Bank(){
        // SH: lets combine urlSet and postPaymentURL someday
       urlSet = new HashSet<>(); //initialize the hashset for url where loader has to be visible
       postPaymentURL = new HashSet<>(); //initialize the hashset for url after transaction
       buttonClickListener = new ButtonOnclickListener(); //listener for button click event
       showToggleCheck=false; //checkbox status for netbanking
    }

    /**
     * run initialize.js manually.
     */
    @JavascriptInterface
    public void reInit() {
        if (activity != null && !activity.isFinishing()) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    onPageFinished();
                }
            });
        }
    }

    /**
     * We found the bank, call back from initialize.js with the bank name.
     *
     * @param bank name of bank recived by js
     */
    @JavascriptInterface
    public void bankFound(final String bank) {
        if (!visibilitychecked) {
            checkVisibilityCB(bank);
            visibilitychecked = true;
        }
        cbSetBankDrawable(bank);
        CBUtil.setVariableReflection(CustomBrowserConstant.MAGIC_RETRY_PAKAGE, bank, CustomBrowserConstant.BANKNAME);
        if (activity != null && !activity.isFinishing()) {
            // initialize loading
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    calculateMaximumWebViewHeight();
                }
            });
        }

        // bank name
        bankName = bank;
        if (!mPageReady) {
            try {
                if (loadingLayout == null) {
                    convertToNative("loading", "{}");
                } else {

                    View view;
                    if (activity != null) {
                        view = ((ViewGroup) activity.findViewById(R.id.help_view)).getChildAt(0);
                        if (loadingLayout != view) {
                            convertToNative("loading", "{}");
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();

            }

        }

        if (!mLoadingJS && mJS == null) {
            // do we have the js file already?
            new AsyncTask<Void, Void, Void>() { // downloading bank specific javascript file.
                @Override
                protected Void doInBackground(Void... voids) {
                    mLoadingJS = true;
                    File file;
                    try {
                        if (activity != null) {
                            String fileName = mBankJS.getString(bank);
                            file = new File(activity.getFilesDir(), fileName);
                            if (!file.exists()) {
                                // SH: Please move this to a HTTP downloader, may be a helper, at least a function
                                java.net.URL url = new URL(CB_URL + fileName + ".js");

                                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                                conn.setRequestMethod("GET");
                                conn.setRequestProperty("Accept-Charset", "UTF-8");
                                if (conn.getResponseCode() == HttpURLConnection.HTTP_OK) {

                                    CBUtil.writeFileOutputStream(conn.getInputStream(), activity, fileName, Context.MODE_PRIVATE);

//                                    GZIPInputStream responseInputStream = new GZIPInputStream(conn.getInputStream());
//                                    byte[] buf = new byte[1024];
//                                    int len;
//                                    FileOutputStream outputStream = activity.openFileOutput(fileName, Context.MODE_PRIVATE);
//                                    while ((len = responseInputStream.read(buf)) > 0) {
//                                        outputStream.write(buf, 0, len);
//                                    }
//                                    responseInputStream.close();
//                                    outputStream.close();
                                }

                            }
                        }
                    } catch (JSONException | IOException e) {
                        e.printStackTrace();
                    } catch (Exception e) {
                        e.printStackTrace();
                    } finally {
                        try {
                            if (activity != null) {
                                String fileName = mBankJS.getString(bank);
                                mJS = new JSONObject(CBUtil.decodeContents(activity.openFileInput(fileName)));
                                if (mPageReady) {
                                    if (activity != null) {
                                        activity.runOnUiThread(new Runnable() {
                                            @Override
                                            public void run() {
                                                onPageFinished();
                                            }
                                        });
                                    }
                                }
                                mLoadingJS = false;
                            }
                        } catch (JSONException | FileNotFoundException e) {
                            e.printStackTrace();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                }
            }.execute();
        }

    }



    /**
     * Js interface from Bank specific javascript.
     * Convert to native shows the bank specific native ui on the cbWebView
     *
     * @param fields can be anyone of choose, retry, incorrectotp, enterotp.
     * @param params regen: true, pin: false, otp: true.
     */
    @JavascriptInterface
    public void convertToNative(final String fields, final String params) {
        Thread.currentThread().setName("CB convertToNative");

        if (activity != null && showCB) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {

                    try {
                        if (timer != null && enterOtpRunnable != null) {
                            CBUtil.cancelTimer(timer);

                        }

                        if (fields.equals(getString(R.string.cb_error))) {  // Error
                            // fail the payment
                            // hide the view
                            onBankError();
                        } else if (fields.equals("parse error")) {
                            // hide the view
                            onBankError();
                        } else if (fields.contentEquals("loading") && !pin_selected_flag && checkLoading) { // Bank page is still loading
                            onHelpAvailable();

                            if (cbTransparentView != null)
                                cbTransparentView.setVisibility(View.VISIBLE);
//
                            loadingLayout = activity.getLayoutInflater().inflate(R.layout.loading, null);
                            ImageView im = (ImageView) loadingLayout.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            // Adjust the size of the cbWebView,
                            // updateLoaderHeight();
                            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, chooseActionHeight);
                            View layoutView = loadingLayout.findViewById(R.id.loading);
                            layoutView.setLayoutParams(params);
                            layoutView.requestLayout();
                            layoutView.invalidate();
                            CustomProgressBar.showDialog(activity, loadingLayout.findViewById(R.id.progress));

                            cbBaseView.removeAllViews();
                            cbBaseView.addView(loadingLayout);
                            if (cbBaseView.isShown()) {
                                frameState = MAXIMISED;
                            } else {
                                maximiseWebviewHeight();
                            }
                            updateHeight(loadingLayout);
                        } else if (fields.equals(getString(R.string.cb_choose))) { // choose flow.

                            addCustomBrowserEventAnalytics();

                            frameState = MAXIMISED;
                            checkLoading = true;

                            if (cbTransparentView != null)
                                cbTransparentView.setVisibility(View.VISIBLE);

                            // show the options
                            View view = activity.getLayoutInflater().inflate(R.layout.choose_action, null);
                            if (maxWebview == 0) {
                                calculateMaximumWebViewHeight();
                                maximiseWebviewHeight();
                            }
                            cbBaseView.setVisibility(View.VISIBLE);
                            if (cbSlideBarView != null)
                                cbSlideBarView.setVisibility(View.GONE);

                            calculateCBHeight(view);
                            onHelpAvailable();
                            view.measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                            chooseActionHeight = view.getMeasuredHeight();

                            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            cbBaseView.removeAllViews();
                            cbBaseView.addView(view);
                            if (cbBaseView.isShown())
                                frameState = MAXIMISED;


                            final SpannableStringBuilder str = new SpannableStringBuilder("Select an option for Faster payment");
                            str.setSpan(new android.text.style.StyleSpan(android.graphics.Typeface.BOLD), 21, 27, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                            TextView tv = (TextView) view.findViewById(R.id.choose_text);
                            tv.setText(str);
                            final JSONObject jsonObject;
                            try {
                                jsonObject = new JSONObject(params);
                                if (jsonObject.has(getString(R.string.cb_otp)) && !jsonObject.getBoolean(getString(R.string.cb_otp))) { // otp flow is not visible
                                    view.findViewById(R.id.otp).setVisibility(View.GONE);
                                    view.findViewById(R.id.view).setVisibility(View.GONE);
                                } else {
                                    view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                                    if (autoSelectOtp) {
                                        eventRecorded = CBAnalyticsConstant.CB_AUTO_OTP_SELECT;
                                        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                                        view.findViewById(R.id.otp).performClick();
                                        autoSelectOtp = false;
                                    }
                                }
                                view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                                if (jsonObject.has(getString(R.string.cb_pin)) && !jsonObject.getBoolean(getString(R.string.cb_pin))) { // pin flow is not visible
                                    view.findViewById(R.id.pin).setVisibility(View.GONE);
                                    view.findViewById(R.id.view).setVisibility(View.GONE);
                                } else {
                                    view.findViewById(R.id.pin).setOnClickListener(new View.OnClickListener() { // we have pin flow.

                                        @Override
                                        public void onClick(View view) {
                                            c_hdfc = 1;
                                            pin_selected_flag = true;
                                            approve_flag = true;
                                            maximiseWebviewHeight();
                                            frameState = MINIMISED;
                                            if (cbTransparentView != null)
                                                cbTransparentView.setVisibility(View.GONE);
                                            try {
                                                if (jsonObject.has(getString(R.string.cb_register)) && jsonObject.getBoolean(getString(R.string.cb_register))) { // Register user flow.
                                                    view = activity.getLayoutInflater().inflate(R.layout.register_pin, null);
                                                    cbBaseView.removeAllViews();
                                                    cbBaseView.addView(view);

                                                    if (cbBaseView.isShown())
                                                        frameState = MAXIMISED;

                                                    view.findViewById(R.id.pin).setOnClickListener(new View.OnClickListener() {
                                                        @Override
                                                        public void onClick(View view) {
                                                            try {
                                                                eventRecorded = CBAnalyticsConstant.PASSWORD;
                                                                addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                                                                cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_pin)));
                                                            } catch (JSONException e) {
                                                                e.printStackTrace();
                                                            }
                                                        }
                                                    });
                                                    if (jsonObject.has(getString(R.string.cb_otp)) && !jsonObject.getBoolean(getString(R.string.cb_otp))) {
                                                        view.findViewById(R.id.otp).setVisibility(View.GONE);
                                                    }
                                                    view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                                                } else {
                                                    eventRecorded = CBAnalyticsConstant.PASSWORD;
                                                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                                                    onHelpUnavailable();

                                                    cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_pin)));
                                                }
                                            } catch (JSONException e) {
                                                e.printStackTrace();
                                            }
                                            updateHeight(view);
                                        }
                                    });
                                }
                                if (jsonObject.has(getString(R.string.cb_error))) { // oops sorry some error occured
                                    view.findViewById(R.id.error_message).setVisibility(View.VISIBLE);
                                    ((TextView) view.findViewById(R.id.error_message)).setText(jsonObject.getString("error"));
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        } else if (fields.equals(getString(R.string.cb_incorrect_OTP_2))) { // incorrect otp.

                            addCustomBrowserEventAnalytics();
                            checkLoading = true;
                            onHelpAvailable(); // gotta show cb
                            final View view = activity.getLayoutInflater().inflate(R.layout.retry_otp, null);
                            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            cbBaseView.removeAllViews();
                            cbBaseView.addView(view);

                            if (cbBaseView.isShown()) {
                                frameState = MAXIMISED;
                            } else {
                                if (cbSlideBarView != null)
                                    cbSlideBarView.setVisibility(View.VISIBLE);
                                maximiseWebviewHeight();
                            }

                            if (mPassword == null) {
                                view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                                view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.GONE);
                                try {
                                    JSONObject p = new JSONObject(params);
                                    final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));

                                    view.findViewById(R.id.enter_manually).setOnClickListener(buttonClickListener);
                                    if (pin)
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                    else
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);

                                    view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            updateHeight(view);
                        } else if (fields.equals(getString(R.string.cb_retry_otp))) { // Retry flow.

                            addCustomBrowserEventAnalytics();

                            checkLoading = true;
                            onHelpAvailable(); // show cb
                            hideSoftKeyboard(); // if the keyboard still on the screen, just force it to hide
                            if (cbTransparentView != null)
                                cbTransparentView.setVisibility(View.VISIBLE);

                            final View view;
                            view = activity.getLayoutInflater().inflate(R.layout.retry_otp, null);
                            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            cbBaseView.removeAllViews();
                            cbBaseView.addView(view);

                            if (cbBaseView.isShown()) {
                                frameState = MAXIMISED;
                            } else {
                                if (cbSlideBarView != null)
                                    cbSlideBarView.setVisibility(View.VISIBLE);
                                maximiseWebviewHeight();
                            }

                            try {
                                if (mPassword == null) {
                                    JSONObject p = new JSONObject(params);
                                    final boolean regenerate = p.has(getString(R.string.cb_regenerate)) && p.getBoolean(getString(R.string.cb_regenerate));
                                    final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));

                                    view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                                    if (regenerate) {
                                        view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.VISIBLE);
                                        if (pin) {
                                            view.findViewById(R.id.Enter_manually_gone).setVisibility(View.GONE);
                                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                        } else {
                                            view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);
                                        }
                                    } else {
                                        if (pin)
                                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                        else
                                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);

                                        view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.GONE);
                                        view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                                    }

                                }
                                view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);
                                view.findViewById(R.id.enter_manually).setOnClickListener(buttonClickListener);
                                view.findViewById(R.id.retry).setOnClickListener(buttonClickListener);
                                buttonClickListener.setView(view);
                                view.findViewById(R.id.approve).setOnClickListener(buttonClickListener);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            updateHeight(view);
                        } else if (fields.equals(getString(R.string.cb_enter_pin))) { // user has just selected pin flow.

                            addCustomBrowserEventAnalytics();

                            if (cbSlideBarView != null)
                                cbSlideBarView.setVisibility(View.GONE);

                            onHelpUnavailable();
                            pin_selected_flag = true;
                            approve_flag = true;
                            maximiseWebviewHeight();
                            frameState = MINIMISED;
                            if (cbTransparentView != null)
                                cbTransparentView.setVisibility(View.GONE);

                            maximiseWebviewHeight();
                            cbBaseView.removeAllViews();
                        } else if (fields.equals(getString(R.string.cb_enter_otp))) { // user is waiting for otp
                            SMSOTPClicked = false;
                            checkPermission();
                            enterOtpParams = params;
                            if (!checkPermissionVisibility) {
                                addCustomBrowserEventAnalytics();
                                /*if (bankName.equalsIgnoreCase("hdfc") && c_hdfc == 0)
                                    c_hdfc = 1;
                                else if (bankName.equalsIgnoreCase("hdfc") && c_hdfc > 0)
                                    enter_otp(params);
                                else*/
                                enter_otp(params);


                                /*if (!eventArray.contains(CBAnalyticsConstant.CUSTOM_BROWSER)) {
                                    eventRecorded = CBAnalyticsConstant.CUSTOM_BROWSER;
                                    eventArray.add(CBAnalyticsConstant.CUSTOM_BROWSER);
                                    addEventAnalytics(eventRecorded);
                                }*/
                            }

                        } else if (fields.equals(getString(R.string.cb_incorrect_pin))) { // oops wrong pin attempt.

                            addCustomBrowserEventAnalytics();

                            final JSONObject jsonObject;
                            try {
                                jsonObject = new JSONObject(params);
                                if (jsonObject.has(getString(R.string.cb_otp)) && jsonObject.getBoolean(getString(R.string.cb_otp))) {
                                    checkLoading = true;
                                    onHelpAvailable();
                                    final View view = activity.getLayoutInflater().inflate(R.layout.choose_action, null);

                                    ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                                    if (drawable != null)
                                        im.setImageDrawable(drawable);

                                    TextView errorText = (TextView) view.findViewById(R.id.error_message);
                                    errorText.setVisibility(View.VISIBLE);
                                    errorText.setText(activity.getResources().getString(R.string.cb_incorrect_password));

                                    TextView chooseText = (TextView) view.findViewById(R.id.choose_text);
                                    chooseText.setVisibility(View.VISIBLE);
                                    chooseText.setText(activity.getResources().getString(R.string.cb_retry));


                                    cbBaseView.removeAllViews();
                                    cbBaseView.addView(view);

                                    view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                                    view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);

                                    updateHeight(view);
                                    if (cbBaseView.isShown()) {
                                        frameState = MAXIMISED;
                                    } else {
                                        maximiseWebviewHeight();
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if (fields.equals(getString(R.string.cb_register_option))) { // Register new user.

                            addCustomBrowserEventAnalytics();
                            onHelpAvailable();
                            final View view = activity.getLayoutInflater().inflate(R.layout.register, null);
                            cbBaseView.removeAllViews();
                            cbBaseView.addView(view);
                            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            updateHeight(view);
                            if (cbBaseView.isShown()) {
                                frameState = MAXIMISED;
                            } else {
                                maximiseWebviewHeight();
                            }
                        } else {
                            maximiseWebviewHeight();
                            frameState = MINIMISED;
                            if (cbSlideBarView != null)
                                cbSlideBarView.setVisibility(View.GONE);

                            onHelpUnavailable();

                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                }

            });
        }
    }

    /**
     * add event 'custom-browser' to the array for Custom Browser payment flow
     *
     *
     */
    void addCustomBrowserEventAnalytics(){
        if (!eventArray.contains(CBAnalyticsConstant.CUSTOM_BROWSER)) {
            eventRecorded = CBAnalyticsConstant.CUSTOM_BROWSER;
            eventArray.add(CBAnalyticsConstant.CUSTOM_BROWSER);
            addEventAnalytics( CBAnalyticsConstant.CB_STATUS, eventRecorded);
        }
    }

    public void onPageFinished() {
        if (this.isAdded() && !this.isRemoving() && null != activity) {
            mPageReady = true;
            if (approve_flag) {
                onHelpUnavailable();
                approve_flag = false;
            }

            if (loadingLayout != null && loadingLayout.isShown()) {
                frameState = MINIMISED;
                maximiseWebviewHeight();
                onHelpUnavailable();
            }

            activity.getWindow().setSoftInputMode(WindowManager.
                    LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);

            if (mJS != null && showCB) { // we have cb and we have the bankspecific js, lets show cb.
                try {
                    cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_init)));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (mBankJS != null && mJS == null) {
                if(cbTransparentView !=null)
                cbTransparentView.setVisibility(View.GONE); // Hide the translayout our page is loaded successfully.
            }
        }
    }

    public void onPageStarted() {
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            if (nbhelpVisible) {
                onHelpUnavailable();
                nbhelpVisible = false;
            }
            if (this.isAdded() && !this.isRemoving()) {
                mPageReady = false;
                if (mBankJS != null) { // we have successfully downloaded initialize.js
                    try {
                        if (showCB) {
                            cbWebView.loadUrl("javascript:" + mBankJS.getString(getString(R.string.cb_detect_bank)));
                            showMagicRetryCB();
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }



    /**
     * Call back from furl - failure transaction
     * with no argument.
     * just send empty string back to calling activity
     */
    @JavascriptInterface
    public void onFailure() {
        onFailure("");
    }

    /**
     * call back function from furl - failure transaction.
     * keep the value in {@link #merchantResponse}
     * set result ok, and send the received data.
     *
     * @param result json string
     */
    @JavascriptInterface
    public void onFailure(String result) {
        merchantResponse = result;
    }



    /**
     * Attempt to deprecate furl.
     * Javascript call from payu server.
     * Lets keep the data in local variable and pass it to calling activity.
     * @param result json string result of failure transaction
     */
    @JavascriptInterface
    public void onPayuFailure( String result){
        if (activity != null) {
            eventRecorded = CBAnalyticsConstant.FAILURE_TRANSACTION;
            addEventAnalytics(CBAnalyticsConstant.TRNX_STATUS, eventRecorded);
            isSuccessTransaction = false;
            payuReponse = result;
        }
        callTimer();
    }


    /**
     * Call back from surl - sucess transaction
     * with no argument.
     * just send empty string back to calling activity
     */
    @JavascriptInterface
    public void onSuccess() {
        onSuccess("");
    }

    /**
     * Attempt to deprecate surl.
     * Javascript interface call from payu server.
     * Lets keep the data in local variable and pass it to main activity.
     * @param result json data of post param.
     */

    @JavascriptInterface
    public void onPayuSuccess(final String result){

        isSuccessTransaction = true;

        // lets do the analytics.
        eventRecorded = CBAnalyticsConstant.SUCCESS_TRANSACTION;
        addEventAnalytics(CBAnalyticsConstant.TRNX_STATUS, eventRecorded);

        payuReponse = result;

        if (storeOneClickHash == CBAnalyticsConstant.STORE_ONE_CLICK_HASH_MOBILE){ // store it only if i need to store it
            try {
                JSONObject hashObject = new JSONObject(payuReponse);
                // store the cvv in shared preferences.
                CBUtil.storeInSharedPreferences(activity, hashObject.getString(CBAnalyticsConstant.CARD_TOKEN), hashObject.getString(CBAnalyticsConstant.MERCHANT_HASH));
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        callTimer();
    }



    /**
     * call back function from surl - success transaction.
     * keep the data in {@link #merchantResponse}
     * set result ok, and send the received data.
     * @param result success result received from surl
     */
    @JavascriptInterface
    public void onSuccess( String result) {
        merchantResponse = result;
    }


    /**
     * will be called in case of curl
     * mostly handled by furl
     */
    @JavascriptInterface
    public void onCancel() {
        onCancel("");
    }

    /**
     * will be called in case of curl
     * mostly handled by furl
     */
    @JavascriptInterface
    public void onCancel(final String result) {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (activity != null && !activity.isFinishing() && Bank.this.isAdded()) {
                    Intent intent = new Intent();
                    intent.putExtra(getString(R.string.cb_result), result);
                    activity.setResult(Activity.RESULT_CANCELED, intent);
                    activity.finish();
                }
            }
        });
    }



    /**
     * Method for enter otp.
     * User is waiting to receive otp.
     *
     * @param params - Json object
     */
     void enter_otp(final String params) {
        {
            // Make sure sms listener is prepared.
            prepareSmsListener();
            // log event, cb appeared.
            if (eventRecorded.equals(CBAnalyticsConstant.PAYMENT_INITIATED)) {
                eventRecorded = CBAnalyticsConstant.CUSTOM_BROWSER;
                eventArray.add(CBAnalyticsConstant.CUSTOM_BROWSER);
                addEventAnalytics(CBAnalyticsConstant.CB_STATUS, eventRecorded);
            }
            //   approveButton.setAlpha(1);
            if (chooseActionHeight == 0)
                frameState = MAXIMISED;

            checkLoading = true;
            onHelpAvailable(); // show cb

            if (cbTransparentView != null)
                cbTransparentView.setVisibility(View.VISIBLE);

            final View view;
            view = activity.getLayoutInflater().inflate(R.layout.wait_for_otp, null);
            final Button approveButton;
            approveButton = (Button)view.findViewById(R.id.approve);

            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);
            final TextView timerView = (TextView) view.findViewById(R.id.timer);


            if (drawable != null)
                im.setImageDrawable(drawable);

            ((EditText) view.findViewById(R.id.otp_sms)).addTextChangedListener(new TextWatcher() {

                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                    String otp = ((EditText) view.findViewById(R.id.otp_sms)).getText().toString();
                    if (otp.length() > 5) {
                        buttonClickListener.setView(view);
                        approveButton.setOnClickListener(buttonClickListener);
                        approveButton.setClickable(true);
                        CBUtil.setAlpha(1, approveButton);

                    } else {
                        approveButton.setClickable(false);
                        CBUtil.setAlpha(1, approveButton);
                        approveButton.setOnClickListener(null);
                    }
                }

                @Override
                public void afterTextChanged(Editable editable) {

                }
            });

            View mProgress = view.findViewById(R.id.progress);
            CustomProgressBar.showDialog(activity, mProgress);
            cbBaseView.removeAllViews();
            cbBaseView.addView(view);

            if (cbBaseView.isShown()) {
                frameState = MAXIMISED;
            } else {
                maximiseWebviewHeight();
            }

            if (frameState == MINIMISED) {
                if (cbSlideBarView != null)
                    cbSlideBarView.setVisibility(View.VISIBLE);
            }

            try {
                JSONObject p = new JSONObject(params);
                final boolean regenerate = p.has(getString(R.string.cb_regenerate)) && p.getBoolean(getString(R.string.cb_regenerate));
                final boolean skipScreen = p.has(getString(R.string.cb_skip_screen)) && p.getBoolean(getString(R.string.cb_skip_screen));
                final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));

                if (skipScreen) {
                    if (activity != null && activity.findViewById(R.id.otp_sms) != null &&
                            activity.findViewById(R.id.otp_sms).getVisibility() != View.VISIBLE) {

                        view.findViewById(R.id.retry_text).setVisibility(View.VISIBLE);
                        if (regenerate) {
                            view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.VISIBLE);
                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);
                            view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                        } else {
                            if (pin)
                                view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                            else
                                view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);

                            view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.GONE);
                            view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                        }
                        view.findViewById(R.id.retry_text).setVisibility(View.VISIBLE);
                        view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                        approveButton.setVisibility(View.GONE);
                        view.findViewById(R.id.waiting).setVisibility(View.GONE);
                        view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);
                        view.findViewById(R.id.retry).setOnClickListener(buttonClickListener);
                        view.findViewById(R.id.enter_manually).setOnClickListener(buttonClickListener);
                        updateHeight(view);
                    }
                } else {
                    timer = new Timer();
                    timer.scheduleAtFixedRate(new TimerTask() {  // Timer to gain user's attention while waiting for otp.

                        @Override
                        synchronized public void run() {
                            if (activity != null) {

                                activity.runOnUiThread(enterOtpRunnable);  // updating time.


                            }
                        }
                    }, 0, 1000);
                }

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    if (!permissionGranted) {// if we dont have permission to read sms or merchant has set MERCHANT_SMS_PERMISSION flag false then we follow the IOS flow...

                        final EditText otpSMS = (EditText) view.findViewById(R.id.otp_sms);
                        approveButton.setClickable(false);
                        LinearLayout otpLayout = (LinearLayout) view.findViewById(R.id.linear_layout_waiting_for_otp);
                        otpLayout.setOnTouchListener(new View.OnTouchListener() {
                            @Override
                            public boolean onTouch(View v, MotionEvent event) {
                                if (event.getAction() == MotionEvent.ACTION_DOWN) {
                                    if (otpSMS.isFocused()) {
                                        Rect outRect = new Rect();
                                        otpSMS.getGlobalVisibleRect(outRect);
                                        if (!outRect.contains((int)event.getRawX(), (int)event.getRawY())) {
                                            otpSMS.clearFocus();
                                            InputMethodManager imm = (InputMethodManager) v.getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
                                            imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
                                        }
                                    }
                                }
                                return false;
                            }
                        });
                        otpSMS.setVisibility(View.VISIBLE);
                        approveButton.setVisibility(View.VISIBLE);
                        view.findViewById(R.id.waiting).setVisibility(View.GONE);
                        view.findViewById(R.id.progress).setVisibility(View.GONE);
                        view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                        view.findViewById(R.id.Enter_manually_gone).setVisibility(View.GONE);


                        otpSMS.addTextChangedListener(new TextWatcher() {

                            @Override
                            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {

                            }

                            @Override
                            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                                String otp = ((EditText) view.findViewById(R.id.otp_sms)).getText().toString();
                                if (otp.length() > 5) {
                                    buttonClickListener.setView(view);
                                    approveButton.setOnClickListener(buttonClickListener);
                                    approveButton.setClickable(true);
                                    CBUtil.setAlpha(1, approveButton);


                                } else {
                                    float val = (float) .3;
                                    approveButton.setClickable(false);
                                    CBUtil.setAlpha(val, approveButton);
                                    approveButton.setOnClickListener(null);
                                }
                            }

                            @Override
                            public void afterTextChanged(Editable editable) {

                            }
                        });

//
                    }

                }

            } catch (Exception e) {
                e.printStackTrace();
            }

            final int time_wait_for_sms;
            if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && !permissionGranted){// while permission is denied we follow IOS flow and we will wait for 45 secs before showing regenerate layout
                time_wait_for_sms = 45;
            }else{
                time_wait_for_sms=30;
            }

            enterOtpRunnable = new Runnable() {
                // update every seconds.Build.VERSION.SDK_INT >= Build.VERSION_CODES.M

                int i = time_wait_for_sms;
                final EditText otpSMS = (EditText) view.findViewById(R.id.otp_sms);

                @Override
                public void run() {
                    if (i == 0) {
                        try {
                            if (activity != null && view.isShown() && activity.findViewById(R.id.otp_sms) != null /*&& ((TextView) activity.findViewById(R.id.otp_sms)).getVisibility() != View.VISIBLE*/) {
                                timerView.setVisibility(View.GONE);
                                JSONObject p = new JSONObject(params);
                                final boolean regenerate = p.has(getString(R.string.cb_regenerate)) && p.getBoolean(getString(R.string.cb_regenerate));
                                final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));


                                view.findViewById(R.id.retry_text).setVisibility(View.VISIBLE);
                                if (regenerate) {
                                    view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.VISIBLE);
                                    view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);
                                    view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                                } else {
                                    if (pin)
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                    else
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);

                                    view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.GONE);
                                    view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                                }
                                view.findViewById(R.id.retry_text).setVisibility(View.VISIBLE);
                                view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                                approveButton.setVisibility(View.GONE);
                                view.findViewById(R.id.waiting).setVisibility(View.GONE);
                                view.findViewById(R.id.otp_sms).setVisibility(View.GONE);
                                view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);
                                view.findViewById(R.id.retry).setOnClickListener(buttonClickListener);
                                view.findViewById(R.id.enter_manually).setOnClickListener(buttonClickListener);
                                updateHeight(view);
                            }

                        } catch (Exception e) {

                            e.printStackTrace();
                        }

                    } else if(!otpSMS.hasFocus() && otpSMS.getText().toString().matches("")){
                        if (i == time_wait_for_sms) {
                            timerView.setVisibility(View.VISIBLE);
                        }
                        String tMessage;
                        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && !permissionGranted) {
                            if (i != 1) {
                                tMessage = i + "  secs remaining to regenerate OTP\n";
                            }else {
                                tMessage = i + " sec remaining to regenerate OTP\n";
                            }
                        }else {
                            tMessage = i + "";
                        }
                        timerView.setText(tMessage);
                        i--;
                    }
                }
            };

            if (mPassword != null && activity.findViewById(R.id.otp_sms) != null && !(activity.findViewById(R.id.otp_sms).getVisibility() == View.VISIBLE)) {

                CBUtil.cancelTimer(timer);

                activity.findViewById(R.id.timer).setVisibility(View.GONE);

                if (eventRecorded.equals(CBAnalyticsConstant.PAYMENT_INITIATED) || eventRecorded.equals(CBAnalyticsConstant.CUSTOM_BROWSER)) {
                    eventRecorded = CBAnalyticsConstant.RECEIVED_OTP_DIRECT;
                    addEventAnalytics(CBAnalyticsConstant.OTP_RECIEVED, eventRecorded);
                }

                ((TextView) view.findViewById(R.id.otp_sms)).setText(mPassword);


                approveButton.setText(getString(R.string.cb_approve_otp));
                approveButton.setClickable(true);

                if (autoApprove) {
                    approveButton.performClick();
                    eventRecorded = CBAnalyticsConstant.CB_AUTO_APPROVE;
                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                }

                //approve.setAlpha(1);
                CBUtil.setAlpha(1, approveButton);
                activity.findViewById(R.id.otp_recieved).setVisibility(View.VISIBLE);

                CustomProgressBar.removeDialog(mProgress);
                view.findViewById(R.id.retry_text).setVisibility(View.GONE);
                view.findViewById(R.id.regenerate_layout).setVisibility(View.GONE);

                approveButton.setVisibility(View.VISIBLE);
                view.findViewById(R.id.waiting).setVisibility(View.GONE);
                view.findViewById(R.id.otp_sms).setVisibility(View.VISIBLE);
                buttonClickListener.setView(view);
                approveButton.setOnClickListener(buttonClickListener);

            }
            updateHeight(view);
            if (cbBaseView.isShown()) {
                frameState = MAXIMISED;
            } else {
                maximiseWebviewHeight();
            }
        }
    }

    /**
     * Mapping the string with integers to make sure it works on java 1.6 and below.
     *
     * @param str name
     * @return numnber
     */
     int getCode(String str) {
        if (str.equalsIgnoreCase("pin"))
            return PIN;
        else if (str.equalsIgnoreCase("password"))
            return PASSWORD;
        else if (str.equalsIgnoreCase("enter manually"))
            return ENTER_MANUALLY;
        else if (str.equalsIgnoreCase("approve"))
            return APPROVE;
        else if (str.equalsIgnoreCase("otp") || str.equalsIgnoreCase("use sms otp"))
            return OTP;
        else if (str.equalsIgnoreCase("sms otp"))
            return SMS_OTP;
        else if (str.equalsIgnoreCase("regenerate otp"))
            return REGENERATE_OTP;

        return DEFAULT;
    }








    /**
     * Custom onClick listener for cb's buttons.
     */
    public class ButtonOnclickListener implements View.OnClickListener {
        private View view_edit;

        public void setView(View view_ed) {
            this.view_edit = view_ed;
        }

        @Override
        public void onClick(View v) {
            String str = "";
            if (v instanceof Button) // we have buttons.
                str = (((Button) v).getText()).toString();
            else if (v instanceof TextView) // we have textviews too!.
                str = (((TextView) v).getText()).toString();
            int code = getCode(str.toLowerCase());
            switch (code) {
                case REGENERATE_OTP:
                    try {
                        eventRecorded = CBAnalyticsConstant.REGENERATE;
                        addEventAnalytics( CBAnalyticsConstant.USER_INPUT, eventRecorded);

                        mPassword = null;
                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_regen_otp)));
                        prepareSmsListener();
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case SMS_OTP:
                case OTP:
                    SMSOTPClicked = true;
                    checkPermission();
                    eventRecorded = CBAnalyticsConstant.OTP;
                    addEventAnalytics( CBAnalyticsConstant.USER_INPUT, eventRecorded);

                    if(Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
                        mPassword = null;
                        prepareSmsListener();
                    }


//                    try {
//                        checkPermission();
//                        eventRecorded = CBAnalyticsConstant.OTP;
//                        addEventAnalytics(CBAnalyticsConstant.USER_INPUT,eventRecorded);
//
//                        mPassword = null;
//                        prepareSmsListener();
//                        mCVClicked = true;
//                        mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
//                    } catch (JSONException e) {
//                        e.printStackTrace();
//                    }

                    break;
                case APPROVE:
                    try {
                        hideKeyboardForcefully();
                        mPassword = null;
                        checkLoading = false;
                        approve_flag = true;
                        onHelpUnavailable();
                        maximiseWebviewHeight();
                        frameState = MINIMISED;
                        prepareSmsListener();
                        if (((EditText) view_edit.findViewById(R.id.otp_sms)).getText().toString().length() > 5) {
                            eventRecorded = CBAnalyticsConstant.APPROVED_OTP;
                            addEventAnalytics( CBAnalyticsConstant.USER_INPUT, eventRecorded);
                            cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_process_otp)) + "(\"" + ((TextView) activity.findViewById(R.id.otp_sms)).getText().toString() + "\")");
                        }
                    }catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case ENTER_MANUALLY: {
                    final View view;
                    view = activity.getLayoutInflater().inflate(R.layout.wait_for_otp, null);
                    eventRecorded = CBAnalyticsConstant.ENTER_MANUALLY;

                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);

                    if (chooseActionHeight == 0) {
                        view.measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                        chooseActionHeight = view.getMeasuredHeight();
                    }

                    cbBaseView.removeAllViews();
                    cbBaseView.addView(view);

                    if (cbBaseView.isShown()) {
                        frameState = MAXIMISED;
                    } else {
                        maximiseWebviewHeight();
                    }

                    ImageView im = (ImageView) view.findViewById(R.id.bank_logo);


                    if (drawable != null)
                        im.setImageDrawable(drawable);

                    view.findViewById(R.id.waiting).setVisibility(View.GONE);
                    float val = (float) .3;
                    final Button approveButton = (Button) view.findViewById(R.id.approve);
                    approveButton.setClickable(false);

                    EditText otpSMS = (EditText) view.findViewById(R.id.otp_sms);
                    showSoftKeyboard(otpSMS);
                    CBUtil.setAlpha(val, approveButton);

                    approveButton.setVisibility(View.VISIBLE);
                    otpSMS.setVisibility(View.VISIBLE);
                    view.findViewById(R.id.regenerate_layout).setVisibility(View.GONE);
                    view.findViewById(R.id.progress).setVisibility(View.INVISIBLE);
                    showSoftKeyboard(otpSMS);

                    otpSMS.addTextChangedListener(new TextWatcher() {

                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                            String otp = ((EditText) view.findViewById(R.id.otp_sms)).getText().toString();
                            if (otp.length() > 5) {
                                buttonClickListener.setView(view);
                                approveButton.setOnClickListener(buttonClickListener);
                                approveButton.setClickable(true);
                                //  approveButton.setAlpha(1);
                                CBUtil.setAlpha(1, approveButton);


                            } else {
                                float val = (float) .3;
                                approveButton.setClickable(false);
                                // approveButton.setAlpha(val);
                                CBUtil.setAlpha(val, approveButton);
                                approveButton.setOnClickListener(null);
                            }
                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                        }
                    });
                    updateHeight(view);
                }
                break;

                case PASSWORD:
                case PIN:
                    pin_selected_flag = true;
                    approve_flag = true;
                    maximiseWebviewHeight();
                    frameState = MINIMISED;
                    onHelpUnavailable();

                    if (cbSlideBarView != null)
                        cbSlideBarView.setVisibility(View.GONE);

                    if (cbTransparentView != null)
                        cbTransparentView.setVisibility(View.GONE);

                    try {
                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_pin)));
                        eventRecorded = CBAnalyticsConstant.PASSWORD;
                        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case DEFAULT:
                    if (DEBUG)
                        Toast.makeText(activity, "button text not matching any click listener option", Toast.LENGTH_SHORT).show();
                    break;

            }

        }
    }

    /**
     * set the whtelisted url of magic etry
     * @param urlList white listed url for magic retry
     */
    public void setMagicRetry(Map<String, String> urlList){
        magicRetryFragment.setUrlListWithPostData(urlList);
    }

    /**
     * initialize magic retry
     *
     */
    public void initMagicRetry() {
        FragmentManager fragmentManager = getActivity().getSupportFragmentManager();
        magicRetryFragment = new MagicRetryFragment();
        Bundle newInformationBundle = new Bundle();
        newInformationBundle.putString(MagicRetryFragment.KEY_TXNID, CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getTransactionID());
        magicRetryFragment.setArguments(newInformationBundle);
        fragmentManager.beginTransaction().add(R.id.magic_retry_container, magicRetryFragment, "magicRetry").commit();
        toggleFragmentVisibility(Util.HIDE_FRAGMENT);
        magicRetryFragment.isWhiteListingEnabled(true);
        magicRetryFragment.setWebView(cbWebView);
        magicRetryFragment.initMRSettingsFromSharedPreference(activity);
        cbWebView.setWebViewClient(new PayUWebViewClient(this, magicRetryFragment,Bank.keyAnalytics));
    }

    /**
     * Change the visibility of magic retry
     * @param flag if true magic retry visible else gone
     */
    public void toggleFragmentVisibility(int flag) {
        if (getActivity() != null && !getActivity().isFinishing() && isAdded() && !isRemoving()) {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            if (flag == Util.SHOW_FRAGMENT) {
                // Show fragment
                ft.show(magicRetryFragment).commit();
            } else if (flag == Util.HIDE_FRAGMENT) {
                // Hide fragment
                ft.hide(magicRetryFragment).commit();
                // ft.hide(magicRetryFragment);}

            }
        }
    }

    /**
     * set MR visibility true
     */
    public void showMagicRetry() {
        toggleFragmentVisibility(Util.SHOW_FRAGMENT);
    }

    /**
     * set MR visibility false
     */
    public void hideMagicRetry() {
        toggleFragmentVisibility(Util.HIDE_FRAGMENT);
    }
}