// The MIT License (MIT)
//
// Copyright (c) 2014-2015 PayU India
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package com.payu.custombrowser;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;

import com.payu.custombrowser.Bank;
import com.payu.custombrowser.CBConstant;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

/**
 * Created by amitkumar on 16/01/15.
 *
 * Helps payu to keep track of user interactions with bank page and more.
 * For later fix: make it as singleton.
 */
public class CBAnalytics {
    private static final String TEST_URL = "https://mobiledev.payu.in/merchant/postservice.php?form=2";
    private static final String PRODUCTION_URL = "https://info.payu.in/merchant/postservice.php?form=2";


    private String fileName;
    private static final long TIMER_DELAY = 5000;
    private static CBAnalytics INSTANCE;
    private final Activity mActivity;
    private String ANALYTICS_URL = Bank.DEBUG ? TEST_URL : PRODUCTION_URL;
    private boolean mIsLocked = false;
    private ArrayList<String> mBuffer = new ArrayList<String>();
    private Timer mTimer;

    /**
     * Constructor
     * @param activity
     */
    public CBAnalytics(Activity activity,String filename) {
        mActivity = activity;
        fileName=filename;
        final Thread.UncaughtExceptionHandler defaultUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler _unCaughtExceptionHandler = new Thread.UncaughtExceptionHandler() {
            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                while (mIsLocked) ;
                setLock();
                try {
                    FileOutputStream fileOutputStream = mActivity.openFileOutput(fileName, Context.MODE_PRIVATE);
                    int c = mBuffer.size();
                    for (int i = 0; i < c; i++) {
                        fileOutputStream.write((mBuffer.get(i) + "\r\n").getBytes());
                    }
                    fileOutputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
                releaseLock();
                defaultUEH.uncaughtException(thread, ex);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(_unCaughtExceptionHandler);
    }

    /**
     * keep only one object
     * @param activity
     * @return CBAnalytics instance.
     */
    public static synchronized CBAnalytics getInstance(Activity activity,String fileName) {
        if (INSTANCE == null) {
            INSTANCE = new CBAnalytics(activity,fileName);

        }
        return INSTANCE;
    }

    /**
     * Adding log information to a local file.
     * @param msg
     */

    public void log(final String msg) {
        resetTimer();
        if (mIsLocked) {
            mBuffer.add(msg);
        } else {
            new AsyncTask<Void, Void, Void>() {
                @Override
                protected Void doInBackground(Void... voids) {
                    setLock();
                    try {
                        JSONObject newobject = new JSONObject(msg);
                        JSONArray jsonArray=new JSONArray();
                        int c;
                        String temp = "";
                        File file = new File(mActivity.getFilesDir(), fileName);
                        if (!file.exists()) { // create the file if not created yet.
                            mActivity.openFileOutput(fileName, Context.MODE_PRIVATE);
                        }
                        FileInputStream fileInputStream = mActivity.openFileInput(fileName);
                        while ((c = fileInputStream.read()) != -1) {
                            temp = temp + Character.toString((char) c);

                        }

                        // Issue area!
                        if(temp.equalsIgnoreCase(""))
                            jsonArray = new JSONArray();
                        else
                            jsonArray = new JSONArray(temp);

                        fileInputStream.close();
                        FileOutputStream fileOutputStream = mActivity.openFileOutput(fileName, Context.MODE_PRIVATE);
                        jsonArray.put(jsonArray.length(),newobject);
                        fileOutputStream.write((jsonArray.toString()).getBytes());

                        fileOutputStream.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                        mBuffer.add(msg);
                    }catch(JSONException e){
                        e.printStackTrace();
                    }catch(Exception e){
                        e.printStackTrace();
                    }
                    releaseLock();
                    return null;
                }
            }.execute(null, null, null);
        }
    }

    /**
     * Open file and read the content.
     * Send the contents to payu server
     * command should be sdkWs and var1 should be the actual data.
     */
    private void resetTimer() {
        if (mTimer != null) {
            mTimer.cancel();
        }
        mTimer = new Timer();
        mTimer.schedule(new TimerTask() {
            @Override
            public void run() {
                while (mIsLocked) ;
                setLock();
                String temp = "";
                int c;
                try {
                    File file = new File(mActivity.getFilesDir(), fileName);
                    if (!file.exists()) { // create the file if not created yet.
                        mActivity.openFileOutput(fileName, Context.MODE_PRIVATE);
                    }
                    FileInputStream fileInputStream = mActivity.openFileInput(fileName);
                    while ((c = fileInputStream.read()) != -1) {
                        temp = temp + Character.toString((char) c);

                    }
                    fileInputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                } finally {

                    // temp is a json array.
                    // mBuffer is a json array again.

                    try {

                        JSONArray tempJsonArray = new JSONArray(temp);
                        JSONArray bufferJsonArray = new JSONArray(mBuffer.toString());


                        // now lets merge both arrays.
                        if (bufferJsonArray.length() > 0) {
                            for (int i = 0; i < bufferJsonArray.length(); i++) {
                                tempJsonArray.put(bufferJsonArray.get(i));
                            }
                            // reset buffer
                            mBuffer = new ArrayList<String>();
                        }

                        if (tempJsonArray.length() > 0) {
                            // lets prepare data
                            //  temp="minie";
                            String postData = "command=sdkWsNew&var1=" + tempJsonArray.toString();

                            // content of temp is a json array.
                            // content of mBuffer is a json array again.


                            byte[] postParamsByte = postData.getBytes();

                            // lets find the analytics type
                            // event or device.


                            URL url = new URL(ANALYTICS_URL);
                            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                            conn.setRequestMethod("POST");
                            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");


                            conn.setRequestProperty("Content-Length", String.valueOf(postData.length()));

                            conn.setDoOutput(true);
                            conn.getOutputStream().write(postParamsByte);
                            int responseCode = conn.getResponseCode();

                            InputStream responseInputStream = conn.getInputStream();
                            StringBuffer responseStringBuffer = new StringBuffer();
                            byte[] byteContainer = new byte[1024];
                            for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                                responseStringBuffer.append(new String(byteContainer, 0, i));
                            }

                            if (responseCode == HttpURLConnection.HTTP_OK) {

                                try {
                                    JSONObject jsonObject = new JSONObject(responseStringBuffer.toString());
                                    if (jsonObject.has("status") && jsonObject.getString("status").equals("1")) {
                                        mActivity.deleteFile(fileName);
                                    } else {
                                        try {
                                            FileOutputStream fileOutputStream = mActivity.openFileOutput(fileName, Context.MODE_PRIVATE);
                                            fileOutputStream.write(temp.getBytes());
                                            fileOutputStream.close();
                                        } catch (IOException e1) {
                                            e1.printStackTrace();
                                        }
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                    try {
                                        FileOutputStream fileOutputStream = mActivity.openFileOutput(fileName, Context.MODE_PRIVATE);
                                        fileOutputStream.write(temp.getBytes());
                                        fileOutputStream.close();
                                    } catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                            } else {
                                // Do the required operation. here.
                                try {
                                    FileOutputStream fileOutputStream = mActivity.openFileOutput(fileName, Context.MODE_PRIVATE);
                                    fileOutputStream.write(temp.getBytes());
                                    fileOutputStream.close();
                                } catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }

                        }
                        } catch (MalformedURLException e) {
                            e.printStackTrace();
                        } catch (ProtocolException e) {
                            e.printStackTrace();
                        } catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        } catch (IOException e) {
                            e.printStackTrace();
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }

                if (mBuffer.size() > 0) {
                    resetTimer();
                }
                releaseLock();
            }
        }, TIMER_DELAY);
    }

    synchronized void setLock() {
        mIsLocked = true;
    }

    synchronized void releaseLock() {
        mIsLocked = false;
    }
    
}
