/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import com.payu.custombrowser.R;

public class DotsProgressBar
extends View {
    private float mRadius;
    private float mOuterRadius;
    private Paint mPaintFill = new Paint(1);
    private Paint mPaint = new Paint(1);
    private Handler mHandler = new Handler();
    private int mIndex = 0;
    private int widthSize;
    private int heightSize;
    private int margin = 10;
    private int mDotCount = 5;
    private int step = 1;
    private Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            DotsProgressBar.this.mIndex = DotsProgressBar.this.mIndex + DotsProgressBar.this.step;
            if (DotsProgressBar.this.mIndex < 0) {
                DotsProgressBar.this.mIndex = 1;
                DotsProgressBar.this.step = 1;
            } else if (DotsProgressBar.this.mIndex > DotsProgressBar.this.mDotCount - 1) {
                DotsProgressBar.this.mIndex = 0;
                DotsProgressBar.this.step = 1;
            }
            DotsProgressBar.this.invalidate();
            DotsProgressBar.this.mHandler.postDelayed(DotsProgressBar.this.mRunnable, 400L);
        }
    };

    public DotsProgressBar(Context context) {
        super(context);
        this.init(context);
    }

    public DotsProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public DotsProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mRadius = context.getResources().getDimension(R.dimen.circle_indicator_radius);
        this.mOuterRadius = context.getResources().getDimension(R.dimen.circle_indicator_outer_radius);
        this.mPaintFill.setStyle(Paint.Style.FILL);
        this.mPaintFill.setColor(context.getResources().getColor(R.color.payu_blue));
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(0x33000000);
        this.start();
    }

    public void setDotsCount(int count) {
        this.mDotCount = count;
    }

    public void start() {
        this.mIndex = -1;
        this.mHandler.removeCallbacks(this.mRunnable);
        this.mHandler.post(this.mRunnable);
    }

    public void stop() {
        this.mHandler.removeCallbacks(this.mRunnable);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.widthSize = (int)(this.mRadius * 2.0f * (float)this.mDotCount + (float)(this.margin * this.mDotCount) + (float)this.margin + (this.mOuterRadius - this.mRadius));
        this.heightSize = (int)this.mRadius * 2 + this.getPaddingBottom() + this.getPaddingTop();
        this.setMeasuredDimension(this.widthSize, this.heightSize);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float dX = ((float)this.widthSize - (float)this.mDotCount * this.mRadius * 2.0f - (float)((this.mDotCount - 1) * this.margin)) / 2.0f;
        float dY = this.heightSize / 2;
        for (int i = 0; i < this.mDotCount; ++i) {
            if (i == this.mIndex) {
                canvas.drawCircle(dX, dY, this.mOuterRadius, this.mPaintFill);
            } else {
                canvas.drawCircle(dX, dY, this.mRadius, this.mPaint);
            }
            dX += 2.0f * this.mRadius + (float)this.margin;
        }
    }
}

