/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.app.Activity;
import android.os.AsyncTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

class Analytics {
    private static final String TEST_URL = "https://mobiletest.payu.in/merchant/postservice.php";
    private static final String PRODUCTION_URL = "https://info.payu.in/merchant/postservice.php";
    private static final String FILE_NAME = "local_cache";
    private static final long TIMER_DELAY = 5000L;
    private static Analytics INSTANCE;
    private final Activity mActivity;
    private String ANALYTICS_URL = "https://info.payu.in/merchant/postservice.php";
    private boolean mIsLocked = false;
    private ArrayList<String> mBuffer = new ArrayList();
    private Timer mTimer;

    public Analytics(Activity activity) {
        this.mActivity = activity;
        final Thread.UncaughtExceptionHandler defaultUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler _unCaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                while (Analytics.this.mIsLocked) {
                }
                Analytics.this.setLock();
                try {
                    FileOutputStream fileOutputStream = Analytics.this.mActivity.openFileOutput(Analytics.FILE_NAME, 0);
                    int c = Analytics.this.mBuffer.size();
                    for (int i = 0; i < c; ++i) {
                        fileOutputStream.write(((String)Analytics.this.mBuffer.get(i) + "\r\n").getBytes());
                    }
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Analytics.this.releaseLock();
                defaultUEH.uncaughtException(thread, ex);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(_unCaughtExceptionHandler);
    }

    public static synchronized Analytics getInstance(Activity activity) {
        if (INSTANCE == null) {
            INSTANCE = new Analytics(activity);
        }
        return INSTANCE;
    }

    public void log(final String msg) {
        this.resetTimer();
        if (this.mIsLocked) {
            this.mBuffer.add(msg);
        } else {
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... voids) {
                    Analytics.this.setLock();
                    try {
                        int c;
                        String temp = "";
                        File file = new File(Analytics.this.mActivity.getFilesDir(), Analytics.FILE_NAME);
                        if (!file.exists()) {
                            Analytics.this.mActivity.openFileOutput(Analytics.FILE_NAME, 0);
                        }
                        FileInputStream fileInputStream = Analytics.this.mActivity.openFileInput(Analytics.FILE_NAME);
                        while ((c = fileInputStream.read()) != -1) {
                            temp = temp + Character.toString((char)c);
                        }
                        fileInputStream.close();
                        FileOutputStream fileOutputStream = Analytics.this.mActivity.openFileOutput(Analytics.FILE_NAME, 0);
                        fileOutputStream.write((temp + msg + "\r\n").getBytes());
                        fileOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Analytics.this.mBuffer.add(msg);
                    }
                    Analytics.this.releaseLock();
                    return null;
                }
            }.execute((Object[])new Void[]{null, null, null});
        }
    }

    private void resetTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (Analytics.this.mIsLocked) {
                }
                Analytics.this.setLock();
                String temp = "";
                try {
                    int c;
                    File file = new File(Analytics.this.mActivity.getFilesDir(), Analytics.FILE_NAME);
                    if (!file.exists()) {
                        Analytics.this.mActivity.openFileOutput(Analytics.FILE_NAME, 0);
                    }
                    FileInputStream fileInputStream = Analytics.this.mActivity.openFileInput(Analytics.FILE_NAME);
                    while ((c = fileInputStream.read()) != -1) {
                        temp = temp + Character.toString((char)c);
                    }
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    int c = Analytics.this.mBuffer.size();
                    while (c > 0) {
                        temp = temp + (String)Analytics.this.mBuffer.get(--c) + "\r\n";
                        if (c < 0 || Analytics.this.mBuffer.size() <= c) continue;
                        Analytics.this.mBuffer.remove(c);
                    }
                    if ((temp = temp.trim()).length() > 0) {
                        String postData = "command=sdkWs&var1=" + temp;
                        try {
                            int i;
                            byte[] postParamsByte = postData.getBytes("UTF-8");
                            URL url = new URL(Analytics.this.ANALYTICS_URL);
                            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                            conn.setRequestMethod("POST");
                            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            conn.setRequestProperty("Content-Length", String.valueOf(postData.length()));
                            conn.setDoOutput(true);
                            conn.getOutputStream().write(postParamsByte);
                            int responseCode = conn.getResponseCode();
                            InputStream responseInputStream = conn.getInputStream();
                            StringBuffer responseStringBuffer = new StringBuffer();
                            byte[] byteContainer = new byte[1024];
                            while ((i = responseInputStream.read(byteContainer)) != -1) {
                                responseStringBuffer.append(new String(byteContainer, 0, i));
                            }
                            if (responseCode == 200) {
                                Analytics.this.mActivity.deleteFile(Analytics.FILE_NAME);
                            } else {
                                try {
                                    FileOutputStream fileOutputStream = Analytics.this.mActivity.openFileOutput(Analytics.FILE_NAME, 0);
                                    fileOutputStream.write(temp.getBytes());
                                    fileOutputStream.close();
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                        catch (ProtocolException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (Analytics.this.mBuffer.size() > 0) {
                    Analytics.this.resetTimer();
                }
                Analytics.this.releaseLock();
            }
        }, 5000L);
    }

    synchronized void setLock() {
        this.mIsLocked = true;
    }

    synchronized void releaseLock() {
        this.mIsLocked = false;
    }
}

