/*
 * Decompiled with CFR 0.152.
 */
package com.paytm.pgsdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import android.webkit.JsResult;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.paytm.pgsdk.IntentServicePostNotification;
import com.paytm.pgsdk.PaytmPGActivity;
import com.paytm.pgsdk.PaytmPGService;
import com.paytm.pgsdk.PaytmPaymentTransactionCallback;
import com.paytm.pgsdk.PaytmUtility;
import java.util.Iterator;
import org.json.JSONObject;

@TargetApi(value=21)
public class PaytmWebView
extends WebView {
    private static final String HTML_OUT = "HTMLOUT";
    private static final String JAVA_SCRIPT = "javascript:window.HTMLOUT.processResponse(document.getElementById('response').value);";
    private static final String Y = "Y";
    private static final String SUCCESS = "01";
    private final PaytmPGActivity mContext;
    private volatile boolean mbMerchantCallbackURLLoaded;
    private static final String CALLBACK = "/CAS/Response";

    public PaytmWebView(Context inContext, Bundle inParams) {
        super(inContext);
        this.mContext = (PaytmPGActivity)inContext;
        this.setWebViewClient(new PaytmWebViewClient());
        this.setWebChromeClient(new WebChromeClient(){

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                PaytmUtility.debugLog("JavaScript Alert " + url);
                return super.onJsAlert(view, url, message, result);
            }
        });
        this.getSettings().setJavaScriptEnabled(true);
        int currentapiVersion = Build.VERSION.SDK_INT;
        if (currentapiVersion >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
        this.addJavascriptInterface(new PaytmJavaScriptInterface(), HTML_OUT);
    }

    private synchronized void startProgressDialog() {
        try {
            ((Activity)this.getContext()).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ((PaytmWebView)PaytmWebView.this).mContext.mProgress.setVisibility(0);
                    PaytmUtility.debugLog("Progress dialog started");
                }
            });
        }
        catch (Exception inEx) {
            PaytmUtility.printStackTrace(inEx);
        }
    }

    private synchronized void stopProgressDialog() {
        try {
            ((Activity)this.getContext()).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ((PaytmWebView)PaytmWebView.this).mContext.mProgress.setVisibility(8);
                    PaytmUtility.debugLog("Progress dialog ended");
                }
            });
        }
        catch (Exception inEx) {
            PaytmUtility.printStackTrace(inEx);
        }
    }

    private synchronized Bundle parseResponse(String inResponse) {
        PaytmUtility.debugLog("Parsing the Merchant Response");
        Bundle Response = new Bundle();
        try {
            JSONObject Obj = new JSONObject(inResponse);
            if (Obj != null && Obj.length() > 0) {
                Iterator Keys = Obj.keys();
                while (Keys.hasNext()) {
                    String Key2 = (String)Keys.next();
                    String Value = Obj.getString(Key2);
                    PaytmUtility.debugLog(Key2 + " = " + Value);
                    Response.putString(Key2, Value);
                }
            }
        }
        catch (Exception inEx) {
            PaytmUtility.debugLog("Error while parsing the Merchant Response");
            PaytmUtility.printStackTrace(inEx);
        }
        return Response;
    }

    private synchronized boolean isValidChecksum(Bundle inResponse) {
        boolean bIsValid = false;
        try {
            if (inResponse != null && inResponse.size() > 0 && inResponse.containsKey("IS_CHECKSUM_VALID") && inResponse.getString("IS_CHECKSUM_VALID").equalsIgnoreCase(Y)) {
                bIsValid = true;
            }
        }
        catch (Exception inEx) {
            PaytmUtility.printStackTrace(inEx);
        }
        return bIsValid;
    }

    private class PaytmJavaScriptInterface {
        private PaytmJavaScriptInterface() {
        }

        @JavascriptInterface
        public synchronized void processResponse(String inResponse) {
            try {
                PaytmUtility.debugLog("Merchant Response is " + inResponse);
                Bundle bundleResponse = PaytmWebView.this.parseResponse(inResponse);
                String callBackUrl = PaytmPGService.getService().mOrder.getRequestParamMap().get("CALLBACK_URL");
                if (TextUtils.isEmpty((CharSequence)callBackUrl) || PaytmWebView.this.mbMerchantCallbackURLLoaded) {
                    PaytmUtility.debugLog("Returning the response back to Merchant Application");
                    this.returnResponse(bundleResponse);
                } else {
                    PaytmUtility.debugLog("Merchant Specific URL is present, So posting all parameters to Merchant specific URL");
                    PaytmWebView.this.postUrl(callBackUrl, PaytmUtility.getURLEncodedStringFromBundle(bundleResponse).getBytes());
                }
            }
            catch (Exception inEx) {
                PaytmUtility.printStackTrace(inEx);
            }
        }

        private synchronized void returnResponse(final Bundle inResponse) {
            try {
                ((Activity)PaytmWebView.this.getContext()).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((Activity)PaytmWebView.this.getContext()).finish();
                            PaytmPaymentTransactionCallback PaymentTransactionCallback = PaytmPGService.getService().getmPaymentTransactionCallback();
                            PaymentTransactionCallback.onTransactionResponse(inResponse);
                        }
                        catch (Exception inEx) {
                            PaytmUtility.printStackTrace(inEx);
                        }
                    }
                });
            }
            catch (Exception inEx) {
                PaytmUtility.printStackTrace(inEx);
            }
        }
    }

    private class PaytmWebViewClient
    extends WebViewClient {
        private PaytmWebViewClient() {
        }

        public synchronized void onPageStarted(WebView inView, String inUrl, Bitmap inFavicon) {
            super.onPageStarted(inView, inUrl, inFavicon);
            PaytmUtility.debugLog("Page started loading " + inUrl);
            PaytmWebView.this.startProgressDialog();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void onPageFinished(WebView inView, String inUrl) {
            super.onPageFinished(inView, inUrl);
            if (PaytmPGService.getService() == null || PaytmPGService.getService().mOrder == null) {
                PaytmUtility.debugLog("Transaction cancelled before loading web view completely.");
                return;
            }
            try {
                PaytmUtility.debugLog("Page finished loading " + inUrl);
                PaytmWebView.this.stopProgressDialog();
                if (inUrl.equalsIgnoreCase(PaytmPGService.getService().mOrder.getRequestParamMap().get("CALLBACK_URL").toString())) {
                    PaytmUtility.debugLog("Merchant specific Callback Url is finished loading. Extract data now. ");
                    PaytmWebView.this.mbMerchantCallbackURLLoaded = true;
                    PaytmWebView.this.loadUrl(PaytmWebView.JAVA_SCRIPT);
                } else if (inUrl.endsWith(PaytmWebView.CALLBACK)) {
                    PaytmUtility.debugLog("CAS Callback Url is finished loading. Extract data now. ");
                    PaytmWebView.this.loadUrl(PaytmWebView.JAVA_SCRIPT);
                }
            }
            catch (Exception inEx) {
                PaytmUtility.printStackTrace(inEx);
            }
            finally {
                if (PaytmPGService.getService().mOrder.getRequestParamMap().get("postnotificationurl") != null) {
                    Intent intent = new Intent((Context)PaytmWebView.this.mContext, IntentServicePostNotification.class);
                    intent.putExtra("url", PaytmPGService.getService().mOrder.getRequestParamMap().get("postnotificationurl"));
                    PaytmWebView.this.mContext.startService(intent);
                }
            }
        }

        public synchronized void onReceivedError(WebView inView, int iniErrorCode, String inDescription, String inFailingUrl) {
            super.onReceivedError(inView, iniErrorCode, inDescription, inFailingUrl);
            PaytmUtility.debugLog("Error occured while loading url " + inFailingUrl);
            PaytmUtility.debugLog("Error code is " + iniErrorCode + "Description is " + inDescription);
            if (iniErrorCode == -6) {
                ((Activity)PaytmWebView.this.getContext()).finish();
                PaytmPaymentTransactionCallback PaymentTransactionCallback = PaytmPGService.getService().getmPaymentTransactionCallback();
                if (PaymentTransactionCallback != null) {
                    PaymentTransactionCallback.onErrorLoadingWebPage(iniErrorCode, inDescription, inFailingUrl);
                }
            }
        }

        public synchronized void onReceivedSslError(WebView inView, SslErrorHandler inHandler, SslError inError) {
            PaytmUtility.debugLog("SSL Error occured " + inError.toString());
            PaytmUtility.debugLog("SSL Handler is " + inHandler);
            if (inHandler != null) {
                inHandler.cancel();
            }
        }
    }
}

