/*
 * Decompiled with CFR 0.152.
 */
package com.paytm.pgsdk;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import com.paytm.pgsdk.Log;
import java.net.URLEncoder;
import org.json.JSONObject;

public class PaytmUtility {
    private static final String EQUAL_TO = "=";
    private static final String AMPERSAND = "&";
    private static final String TAG = "PGSDK";
    private static final String UTF_8 = "UTF-8";

    protected static synchronized String getStringFromBundle(Bundle inParams) {
        try {
            PaytmUtility.debugLog("Extracting Strings from Bundle...");
            boolean bFirst = true;
            StringBuffer Params = new StringBuffer();
            for (String Key2 : inParams.keySet()) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    Params.append(AMPERSAND);
                }
                Params.append(Key2);
                Params.append(EQUAL_TO);
                Params.append(inParams.getString(Key2));
            }
            PaytmUtility.debugLog("Extracted String is " + Params.toString());
            return Params.toString();
        }
        catch (Exception inEx) {
            PaytmUtility.printStackTrace(inEx);
            return null;
        }
    }

    protected static synchronized String getURLEncodedStringFromBundle(Bundle inParams) {
        try {
            PaytmUtility.debugLog("Extracting Strings from Bundle...");
            boolean bFirst = true;
            StringBuffer Params = new StringBuffer();
            for (String Key2 : inParams.keySet()) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    Params.append(AMPERSAND);
                }
                Params.append(URLEncoder.encode(Key2, UTF_8));
                Params.append(EQUAL_TO);
                Params.append(URLEncoder.encode(inParams.getString(Key2), UTF_8));
            }
            PaytmUtility.debugLog("URL encoded String is " + Params.toString());
            return Params.toString();
        }
        catch (Exception inEx) {
            PaytmUtility.printStackTrace(inEx);
            return null;
        }
    }

    protected static synchronized void debugLog(String inMsg) {
        Log.d(TAG, inMsg);
    }

    protected static synchronized void printStackTrace(Exception inEx) {
        inEx.printStackTrace();
    }

    protected static synchronized boolean isNetworkAvailable(Context inContext) {
        ConnectivityManager ConnectMgr = (ConnectivityManager)inContext.getSystemService("connectivity");
        if (ConnectMgr == null) {
            return false;
        }
        NetworkInfo NetInfo = ConnectMgr.getActiveNetworkInfo();
        if (NetInfo == null) {
            return false;
        }
        return NetInfo.isConnected();
    }

    protected static String getJSONString(Bundle inParams) {
        try {
            JSONObject Params = null;
            if (inParams != null && inParams.size() > 0) {
                Params = new JSONObject();
                for (String Key2 : inParams.keySet()) {
                    Params.put(Key2, inParams.get(Key2));
                }
            }
            PaytmUtility.debugLog("JSON string is " + Params);
            return Params.toString();
        }
        catch (Exception inEx) {
            PaytmUtility.printStackTrace(inEx);
            return null;
        }
    }

    protected static String getURLEncodedJSONString(Bundle inParams) {
        try {
            JSONObject Params = null;
            if (inParams != null && inParams.size() > 0) {
                Params = new JSONObject();
                for (String Key2 : inParams.keySet()) {
                    Params.put(URLEncoder.encode(Key2, UTF_8), (Object)URLEncoder.encode(inParams.getString(Key2), UTF_8));
                }
            }
            PaytmUtility.debugLog("URL encoded JSON string is " + Params);
            return Params.toString();
        }
        catch (Exception inEx) {
            PaytmUtility.printStackTrace(inEx);
            return null;
        }
    }
}

