/*
 * Decompiled with CFR 0.152.
 */
package com.paytm.pgsdk;

import android.content.Context;
import com.paytm.pgsdk.PaytmClientCertificate;
import com.paytm.pgsdk.PaytmUtility;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class PaytmSSLSocketFactory
extends SSLSocketFactory {
    private volatile SSLContext mSSLContext;
    private static final String PKCS12 = "pkcs12";
    private static final String X509 = "X509";
    private static final String TLS = "TLS";
    private static final String RAW = "raw";

    protected PaytmSSLSocketFactory(Context inCtxt, PaytmClientCertificate inCertificate) {
        X509TrustManager TM = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] inChain, String inAuthType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] inChain, String inAuthType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            if (inCertificate != null && inCertificate.mFileName != null) {
                PaytmUtility.debugLog("Reading the certificate " + inCertificate.mFileName + ".p12");
                KeyStore MyCert = KeyStore.getInstance(PKCS12);
                MyCert.load(inCtxt.getResources().openRawResource(inCtxt.getResources().getIdentifier(inCertificate.mFileName, RAW, inCtxt.getPackageName())), inCertificate.mPassword.toCharArray());
                Enumeration<String> Aliases = MyCert.aliases();
                while (Aliases.hasMoreElements()) {
                    PaytmUtility.debugLog(MyCert.getCertificate(Aliases.nextElement().toString()).toString());
                }
                KeyManagerFactory KMF = KeyManagerFactory.getInstance(X509);
                KMF.init(MyCert, inCertificate.mPassword.toCharArray());
                this.mSSLContext = SSLContext.getInstance(TLS);
                this.mSSLContext.init(KMF.getKeyManagers(), new TrustManager[]{TM}, null);
                PaytmUtility.debugLog("Client certificate attached.");
            } else {
                PaytmUtility.debugLog("Client certificate is not found");
                PaytmUtility.debugLog("so, setting only the trust manager");
                this.mSSLContext = SSLContext.getInstance(TLS);
                this.mSSLContext.init(null, new TrustManager[]{TM}, null);
                PaytmUtility.debugLog("set trust manager");
            }
        }
        catch (Exception inEx) {
            PaytmUtility.debugLog("Exception while attaching Client certificate.");
            PaytmUtility.printStackTrace(inEx);
            try {
                PaytmUtility.debugLog("so, setting only the trust manager");
                this.mSSLContext = SSLContext.getInstance(TLS);
                this.mSSLContext.init(null, new TrustManager[]{TM}, null);
                PaytmUtility.debugLog("set trust manager");
            }
            catch (Exception inEx1) {
                PaytmUtility.debugLog("Exception while setting the trust manager");
                PaytmUtility.printStackTrace(inEx1);
            }
        }
    }

    @Override
    public synchronized Socket createSocket(Socket inS, String inHost, int iniPort, boolean inbAutoClose) throws IOException {
        if (this.mSSLContext != null) {
            return this.mSSLContext.getSocketFactory().createSocket(inS, inHost, iniPort, inbAutoClose);
        }
        return PaytmSSLSocketFactory.getDefault().createSocket(inHost, iniPort);
    }

    @Override
    public synchronized String[] getDefaultCipherSuites() {
        return null;
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return null;
    }

    @Override
    public synchronized Socket createSocket(String inHost, int iniPort) throws IOException, UnknownHostException {
        if (this.mSSLContext != null) {
            return this.mSSLContext.getSocketFactory().createSocket(inHost, iniPort);
        }
        return PaytmSSLSocketFactory.getDefault().createSocket(inHost, iniPort);
    }

    @Override
    public synchronized Socket createSocket(InetAddress inHost, int iniPort) throws IOException {
        if (this.mSSLContext != null) {
            return this.mSSLContext.getSocketFactory().createSocket(inHost, iniPort);
        }
        return PaytmSSLSocketFactory.getDefault().createSocket(inHost, iniPort);
    }

    @Override
    public synchronized Socket createSocket(String inHost, int iniPort, InetAddress inLocalHost, int iniLocalPort) throws IOException, UnknownHostException {
        if (this.mSSLContext != null) {
            return this.mSSLContext.getSocketFactory().createSocket(inHost, iniPort, inLocalHost, iniLocalPort);
        }
        return PaytmSSLSocketFactory.getDefault().createSocket(inHost, iniPort);
    }

    @Override
    public synchronized Socket createSocket(InetAddress inAddress, int iniPort, InetAddress inLocalAddress, int iniLocalPort) throws IOException {
        if (this.mSSLContext != null) {
            return this.mSSLContext.getSocketFactory().createSocket(inAddress, iniPort, inLocalAddress, iniLocalPort);
        }
        return PaytmSSLSocketFactory.getDefault().createSocket(inAddress, iniPort, inLocalAddress, iniLocalPort);
    }
}

