/*
 * Decompiled with CFR 0.152.
 */
package com.paytm.pgsdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.paytm.pgsdk.Log;
import com.paytm.pgsdk.PaytmClientCertificate;
import com.paytm.pgsdk.PaytmOrder;
import com.paytm.pgsdk.PaytmPGActivity;
import com.paytm.pgsdk.PaytmPaymentTransactionCallback;
import com.paytm.pgsdk.PaytmRefundCallback;
import com.paytm.pgsdk.PaytmStatusQueryCallback;
import com.paytm.pgsdk.PaytmUtility;
import com.paytm.pgsdk.SaveReferences;
import java.util.Map;

public class PaytmPGService {
    private static volatile PaytmPGService mService;
    public volatile PaytmOrder mOrder;
    public volatile PaytmClientCertificate mCertificate;
    private volatile boolean mbServiceRunning;
    private volatile String mStatusQueryURL;
    protected volatile String mCancelTransactionURL;
    protected volatile String mPGURL;
    private static final String STAGING_STATUS_QUERY_URL = "https://pguat.paytm.com/oltp/HANDLER_INTERNAL/TXNSTATUS";
    private static final String PRODUCTION_STATUS_QUERY_URL = "https://secure.paytm.in/oltp/HANDLER_INTERNAL/TXNSTATUS";
    private static final String STAGING_CAS_URL = "https://pguat.paytm.com:8448/CAS/ChecksumGenerator";
    private static final String PRODUCTION_CAS_URL = "https://secure.paytm.in/oltp-web/generateChecksum";
    private static final String STAGING_CANCEL_TRANSACTION_URL = "https://pguat.paytm.com/oltp/HANDLER_INTERNAL/CANCEL_TXN";
    private static final String PRODUCTION_CANCEL_TRANSACTION_URL = "https://secure.paytm.in/oltp/HANDLER_INTERNAL/CANCEL_TXN";
    private static final String STAGING_PG_URL = "https://pguat.paytm.com/oltp-web/processTransaction";
    private static final String PRODUCTION_PG_URL = "https://secure.paytm.in/oltp-web/processTransaction";
    private volatile PaytmPaymentTransactionCallback mPaymentTransactionCallback;
    protected volatile PaytmRefundCallback mRefundCallback;
    protected volatile PaytmStatusQueryCallback mStatusQueryCallback;

    protected static synchronized PaytmPGService getService() {
        try {
            if (mService == null) {
                PaytmUtility.debugLog("Creating an instance of Paytm PG Service...");
                mService = new PaytmPGService();
                PaytmUtility.debugLog("Created a new instance of Paytm PG Service.");
            }
        }
        catch (Exception var1) {
            PaytmUtility.printStackTrace(var1);
        }
        return mService;
    }

    public static synchronized PaytmPGService getStagingService() {
        PaytmPGService PGService = PaytmPGService.getService();
        PGService.mStatusQueryURL = STAGING_STATUS_QUERY_URL;
        PGService.mCancelTransactionURL = "https://securegw-stage.paytm.in/theia/closeOrder";
        PGService.mPGURL = "https://securegw-stage.paytm.in/theia/processTransaction";
        SaveReferences.getInstance().setProduction(false);
        return PGService;
    }

    public static synchronized PaytmPGService getProductionService() {
        PaytmPGService PGService = PaytmPGService.getService();
        PGService.mStatusQueryURL = PRODUCTION_STATUS_QUERY_URL;
        PGService.mCancelTransactionURL = "https://securegw.paytm.in/theia/closeOrder";
        PGService.mPGURL = "https://securegw.paytm.in/theia/processTransaction";
        SaveReferences.getInstance().setProduction(true);
        return PGService;
    }

    public synchronized void initialize(PaytmOrder inOrder, PaytmClientCertificate inCertificate) {
        this.mOrder = inOrder;
        this.mCertificate = inCertificate;
    }

    public void enableLog(Context ctx) {
        ApplicationInfo appInfoo = this.getApplicationinfo(ctx);
        if (appInfoo != null) {
            boolean isDebuggable = 0 != (appInfoo.flags &= 2);
            Log.setEnableDebugLog(isDebuggable);
        } else {
            Log.setEnableDebugLog(false);
        }
    }

    public synchronized void startPaymentTransaction(Context inCtxt, boolean inbHideHeader, boolean inbSendAllChecksumResponseParametersToPGServer, PaytmPaymentTransactionCallback inPaymentTransactionCallback) {
        try {
            this.enableLog(inCtxt);
            if (PaytmUtility.isNetworkAvailable(inCtxt)) {
                if (this.mOrder != null && (this.mOrder.getRequestParamMap() == null || this.mOrder.getRequestParamMap().size() <= 0)) {
                    inPaymentTransactionCallback.onTransactionCancel("Invalid Params passed", null);
                    return;
                }
                if (!this.mbServiceRunning) {
                    Bundle inEx = new Bundle();
                    if (this.mOrder != null) {
                        for (Map.Entry<String, String> PG : this.mOrder.getRequestParamMap().entrySet()) {
                            String paramName = PG.getKey();
                            String paramValue = PG.getValue();
                            PaytmUtility.debugLog(paramName + " = " + paramValue);
                            inEx.putString(PG.getKey(), PG.getValue());
                        }
                    }
                    PaytmUtility.debugLog("Starting the Service...");
                    Intent PG1 = new Intent(inCtxt, PaytmPGActivity.class);
                    PG1.putExtra("Parameters", inEx);
                    PG1.putExtra("HIDE_HEADER", inbHideHeader);
                    PG1.putExtra("SEND_ALL_CHECKSUM_RESPONSE_PARAMETERS_TO_PG_SERVER", inbSendAllChecksumResponseParametersToPGServer);
                    this.mbServiceRunning = true;
                    this.mPaymentTransactionCallback = inPaymentTransactionCallback;
                    SaveReferences.getInstance().setPaytmPaymentTransactionCallback(inPaymentTransactionCallback);
                    ((Activity)inCtxt).startActivity(PG1);
                    PaytmUtility.debugLog("Service Started.");
                } else {
                    PaytmUtility.debugLog("Service is already running.");
                }
            } else {
                this.stopService();
                inPaymentTransactionCallback.networkNotAvailable();
            }
        }
        catch (Exception var10) {
            this.stopService();
            PaytmUtility.printStackTrace(var10);
        }
    }

    protected synchronized void stopService() {
        mService = null;
        PaytmUtility.debugLog("Service Stopped.");
    }

    private ApplicationInfo getApplicationinfo(Context ctx) {
        ApplicationInfo app = null;
        try {
            PackageManager manager = ctx.getPackageManager();
            app = manager.getApplicationInfo(ctx.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return app;
    }

    public PaytmPaymentTransactionCallback getmPaymentTransactionCallback() {
        if (this.mPaymentTransactionCallback == null) {
            return SaveReferences.getInstance().getPaytmPaymentTransactionCallback();
        }
        return this.mPaymentTransactionCallback;
    }
}

