/*
 * Decompiled with CFR 0.152.
 */
package com.paytm.pgsdk;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.URLUtil;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.paytm.pgsdk.IntentServicePreNotification;
import com.paytm.pgsdk.PaytmConstants;
import com.paytm.pgsdk.PaytmPGService;
import com.paytm.pgsdk.PaytmPaymentTransactionCallback;
import com.paytm.pgsdk.PaytmSSLSocketFactory;
import com.paytm.pgsdk.PaytmUtility;
import com.paytm.pgsdk.PaytmWebView;
import com.paytm.pgsdk.SaveReferences;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class PaytmPGActivity
extends Activity {
    protected volatile ProgressBar mProgress;
    private volatile PaytmWebView mWV;
    private volatile AuthenticatorTask mAuthenticator;
    private volatile Bundle mParams;
    private static final String CHECKSUMHASH = "CHECKSUMHASH";
    private static final String CLIENT_AUTHENTICATION_FAILED = "Client authentication failed. Please try again later.";
    private static final String CLIENT_AUTHENTICATION_FAILED_DUE_TO_SERVER_ERROR = "Client authentication failed due to server error. Please try again later.";
    private static final String UI_INITIALIZATION_ERROR_OCCURED = "Some error occured while initializing UI of Payment Gateway Activity";
    private static final String UI_WEBVIEW_ERROR_OCCURED = "Some UI error occured in WebView of Payment Gateway Activity";
    private static final String PAYT_STATUS = "payt_STATUS";
    private static final String SUCCESS = "1";
    private static final String TRANSACTION_CANCELLED = "Transaction Cancelled.";
    private static final String TRANSACTION_NOT_CANCELLED = "Transaction not Cancelled.";
    private static final String USER_CANCELED_TRANSACTION = "Transaction cancelled by user.";
    private Dialog mDlg;
    private boolean mbIsCancellingRequest;
    private boolean mbChecksumGenerated;
    private boolean mbHideHeader;
    private String paramsString;
    private String urlString;
    private boolean mbSendAllChecksumResponseParametersToPGServer;

    protected void onRestore(Bundle savedInstanceState) {
        if (SaveReferences.getInstance().isProduction()) {
            PaytmPGService.getProductionService();
        } else {
            PaytmPGService.getStagingService();
        }
        PaytmUtility.debugLog("Came in onRestoreInstanceState");
        this.mbHideHeader = savedInstanceState.getBoolean("HIDE_HEADER");
        this.mbSendAllChecksumResponseParametersToPGServer = savedInstanceState.getBoolean("SEND_ALL_CHECKSUM_RESPONSE_PARAMETERS_TO_PG_SERVER");
        this.mParams = savedInstanceState.getBundle("Parameters");
        this.paramsString = savedInstanceState.getString("Parameters_String");
        this.urlString = savedInstanceState.getString(PaytmConstants.URL_STRING);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        PaytmUtility.debugLog("Came in onSaveInstanceState");
        outState.putBoolean("HIDE_HEADER", this.mbHideHeader);
        outState.putBoolean("SEND_ALL_CHECKSUM_RESPONSE_PARAMETERS_TO_PG_SERVER", this.mbSendAllChecksumResponseParametersToPGServer);
        outState.putBundle("Parameters", this.mParams);
        outState.putString("Parameters_String", this.paramsString);
        outState.putString(PaytmConstants.URL_STRING, this.urlString);
    }

    protected synchronized void onCreate(Bundle inSavedInstanceState) {
        super.onCreate(inSavedInstanceState);
        if (inSavedInstanceState != null) {
            this.onRestore(inSavedInstanceState);
        }
        if (this.initUI()) {
            this.startTransaction();
        } else {
            this.finish();
            PaytmPaymentTransactionCallback PaymentTransactionCallback = PaytmPGService.getService().getmPaymentTransactionCallback();
            if (PaymentTransactionCallback != null) {
                PaymentTransactionCallback.someUIErrorOccurred(UI_INITIALIZATION_ERROR_OCCURED);
            }
        }
    }

    private synchronized boolean initUI() {
        try {
            if (this.getIntent() != null) {
                this.mbHideHeader = this.getIntent().getBooleanExtra("HIDE_HEADER", false);
                this.mbSendAllChecksumResponseParametersToPGServer = this.getIntent().getBooleanExtra("SEND_ALL_CHECKSUM_RESPONSE_PARAMETERS_TO_PG_SERVER", false);
            }
            PaytmUtility.debugLog("Hide Header " + this.mbHideHeader);
            PaytmUtility.debugLog("Initializing the UI of Transaction Page...");
            RelativeLayout RootView = new RelativeLayout((Context)this);
            RelativeLayout TopBar = new RelativeLayout((Context)this);
            RelativeLayout.LayoutParams TopBarParams = new RelativeLayout.LayoutParams(-1, -2);
            TopBar.setLayoutParams((ViewGroup.LayoutParams)TopBarParams);
            TopBar.setId(1);
            TopBar.setBackgroundColor(Color.parseColor((String)"#bdbdbd"));
            Button Cancel = new Button((Context)this, null, 16842825);
            RelativeLayout.LayoutParams CancelParams = new RelativeLayout.LayoutParams(-2, -2);
            CancelParams.addRule(15);
            CancelParams.leftMargin = (int)(this.getResources().getDisplayMetrics().density * 5.0f);
            Cancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PaytmUtility.debugLog("User pressed back button which is present in Header Bar.");
                    PaytmPGActivity.this.cancelTransaction();
                }
            });
            Cancel.setLayoutParams((ViewGroup.LayoutParams)CancelParams);
            Cancel.setText((CharSequence)"Cancel");
            TextView AppName = new TextView((Context)this);
            RelativeLayout.LayoutParams AppNameParams = new RelativeLayout.LayoutParams(-2, -2);
            AppNameParams.addRule(13);
            AppName.setLayoutParams((ViewGroup.LayoutParams)AppNameParams);
            AppName.setTextColor(-16777216);
            AppName.setText((CharSequence)"Paytm Payments");
            TopBar.addView((View)Cancel);
            TopBar.addView((View)AppName);
            RelativeLayout WebLayout = new RelativeLayout((Context)this);
            RelativeLayout.LayoutParams WebLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
            WebLayoutParams.addRule(3, TopBar.getId());
            WebLayout.setLayoutParams((ViewGroup.LayoutParams)WebLayoutParams);
            this.mWV = new PaytmWebView((Context)this, this.mParams);
            this.mWV.setVisibility(8);
            RelativeLayout.LayoutParams WebParams = new RelativeLayout.LayoutParams(-1, -1);
            this.mWV.setLayoutParams((ViewGroup.LayoutParams)WebParams);
            this.mProgress = new ProgressBar((Context)this, null, 16842873);
            RelativeLayout.LayoutParams ProgressParams = new RelativeLayout.LayoutParams(-2, -2);
            ProgressParams.addRule(13);
            this.mProgress.setLayoutParams((ViewGroup.LayoutParams)ProgressParams);
            WebLayout.addView((View)this.mWV);
            WebLayout.addView((View)this.mProgress);
            RootView.addView((View)TopBar);
            RootView.addView((View)WebLayout);
            if (this.mbHideHeader) {
                TopBar.setVisibility(8);
            }
            this.requestWindowFeature(1);
            this.setContentView((View)RootView);
            PaytmUtility.debugLog("Initialized UI of Transaction Page.");
            return true;
        }
        catch (Exception inEx) {
            PaytmUtility.debugLog("Some exception occurred while initializing UI.");
            PaytmUtility.printStackTrace(inEx);
            return false;
        }
    }

    protected synchronized void onDestroy() {
        super.onDestroy();
        try {
            if (this.mAuthenticator != null) {
                this.mAuthenticator.cancel(true);
            }
            PaytmPGService.getService().stopService();
        }
        catch (Exception inEx) {
            PaytmPGService.getService().stopService();
            PaytmUtility.debugLog("Some exception occurred while destroying the PaytmPGActivity.");
            PaytmUtility.printStackTrace(inEx);
        }
    }

    private synchronized boolean extractJSON(String inResult) {
        boolean bSuccess = false;
        try {
            PaytmUtility.debugLog("Parsing JSON");
            JSONObject Obj = new JSONObject(inResult);
            Iterator Keys = Obj.keys();
            PaytmUtility.debugLog("Appending Key Value pairs");
            PaytmUtility.debugLog("Send All Checksum Response Parameters to PG " + this.mbSendAllChecksumResponseParametersToPGServer);
            while (Keys.hasNext()) {
                String Key = (String)Keys.next();
                String Value = Obj.getString(Key);
                Key = Key.trim();
                PaytmUtility.debugLog(Key + " = " + Value);
                if (Key.equals(CHECKSUMHASH)) {
                    this.mParams.putString(Key, Value);
                } else if (this.mbSendAllChecksumResponseParametersToPGServer) {
                    this.mParams.putString(Key, Value);
                }
                if (!Key.equals(PAYT_STATUS) || !Value.equals(SUCCESS)) continue;
                bSuccess = true;
            }
        }
        catch (Exception inEx) {
            PaytmUtility.debugLog("Some exception occurred while extracting the checksum from CAS Response.");
            PaytmUtility.printStackTrace(inEx);
        }
        return bSuccess;
    }

    private synchronized void startTransaction() {
        PaytmUtility.debugLog("Starting the Process...");
        if (this.getIntent() != null && this.getIntent().getBundleExtra("Parameters") != null) {
            this.mParams = this.getIntent().getBundleExtra("Parameters");
            if (this.mParams != null && this.mParams.size() > 0) {
                PaytmUtility.debugLog("Starting the Client Authentication...");
                this.mAuthenticator = new AuthenticatorTask();
                if (PaytmPGService.getService() != null) {
                    this.mWV.setVisibility(0);
                    this.mWV.postUrl(PaytmPGService.getService().mPGURL, PaytmUtility.getURLEncodedStringFromBundle(this.mParams).getBytes());
                    this.mWV.requestFocus(130);
                    if (PaytmPGService.getService().mOrder.getRequestParamMap().get("prenotificationurl") != null) {
                        Intent intent = new Intent(this.getApplicationContext(), IntentServicePreNotification.class);
                        intent.putExtra("url", PaytmPGService.getService().mOrder.getRequestParamMap().get("prenotificationurl"));
                        this.getApplicationContext().startService(intent);
                    }
                }
            }
        }
    }

    public synchronized boolean onKeyDown(int keyCode, KeyEvent event) {
        PaytmUtility.debugLog("User pressed key and key code is " + keyCode);
        if (keyCode == 4) {
            PaytmUtility.debugLog("User pressed hard key back button");
            this.cancelTransaction();
        }
        return super.onKeyDown(keyCode, event);
    }

    private synchronized void displayToastNotification(final String inMsg) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    PaytmPGActivity.this.mbIsCancellingRequest = false;
                    PaytmUtility.debugLog(inMsg);
                    Toast.makeText((Context)PaytmPGActivity.this, (CharSequence)inMsg, (int)0).show();
                    PaytmUtility.debugLog("User cancelled " + PaytmPGActivity.this.mParams);
                    PaytmPGService.getService().getmPaymentTransactionCallback().onTransactionCancel(PaytmPGActivity.USER_CANCELED_TRANSACTION, PaytmPGActivity.this.mParams);
                    PaytmUtility.debugLog("user cancellation");
                    PaytmPGActivity.this.finish();
                }
                catch (Exception inEx) {
                    inEx.printStackTrace();
                }
            }
        });
    }

    private synchronized void cancelTransaction() {
        if (!this.mbIsCancellingRequest) {
            PaytmUtility.debugLog("Displaying Confirmation Dialog");
            AlertDialog.Builder DlgBuilder = null;
            DlgBuilder = Build.VERSION.SDK_INT >= 11 ? new AlertDialog.Builder((Context)this, 16974374) : new AlertDialog.Builder((Context)this);
            DlgBuilder.setTitle((CharSequence)"Cancel Transaction");
            DlgBuilder.setMessage((CharSequence)"Are you sure you want to cancel transaction");
            DlgBuilder.setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PaytmPGActivity.this.onBackPressed();
                }
            });
            DlgBuilder.setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PaytmPGActivity.this.mDlg.dismiss();
                }
            });
            this.mDlg = DlgBuilder.create();
            this.mDlg.show();
        }
    }

    public void onBackPressed() {
        PaytmPGService.getService().getmPaymentTransactionCallback().onBackPressedCancelTransaction();
        super.onBackPressed();
    }

    private class AuthenticatorTask
    extends AsyncTask<String, Void, String> {
        private AuthenticatorTask() {
        }

        protected synchronized String doInBackground(String ... inURL) {
            String Response = "";
            URLConnection UrlConnection = null;
            try {
                URL Url = new URL(inURL[0]);
                PaytmUtility.debugLog("URL is " + Url.toString());
                UrlConnection = Url.openConnection();
                PaytmUtility.debugLog("New Connection is created.");
                if (URLUtil.isHttpsUrl((String)Url.toString())) {
                    PaytmUtility.debugLog("Https url");
                    PaytmUtility.debugLog("Setting SSLSocketFactory to connection...");
                    ((HttpsURLConnection)UrlConnection).setSSLSocketFactory(new PaytmSSLSocketFactory((Context)PaytmPGActivity.this, PaytmPGService.getService().mCertificate));
                    PaytmUtility.debugLog("SSLSocketFactory is set to connection.");
                }
                UrlConnection.setDoOutput(true);
                ((HttpURLConnection)UrlConnection).setRequestMethod("POST");
                String Params = PaytmUtility.getStringFromBundle(PaytmPGActivity.this.mParams);
                if (Params != null && Params.length() > 0) {
                    PaytmUtility.debugLog("Getting the output stream to post");
                    PrintWriter Out = new PrintWriter(UrlConnection.getOutputStream());
                    PaytmUtility.debugLog("posting......");
                    Out.print(Params);
                    Out.close();
                    PaytmUtility.debugLog("posted parameters and closing output stream");
                    int iResponseCode = ((HttpURLConnection)UrlConnection).getResponseCode();
                    String ResponseMessage = ((HttpURLConnection)UrlConnection).getResponseMessage();
                    PaytmUtility.debugLog("Response code is " + iResponseCode);
                    PaytmUtility.debugLog("Response Message is " + ResponseMessage);
                    if (iResponseCode == 200) {
                        PaytmUtility.debugLog("Getting the input stream to read response");
                        Scanner InStream = new Scanner(UrlConnection.getInputStream());
                        PaytmUtility.debugLog("reading......");
                        while (InStream.hasNextLine()) {
                            Response = Response + InStream.nextLine();
                        }
                        InStream.close();
                        PaytmUtility.debugLog("read response and closing input stream");
                    }
                }
            }
            catch (Exception inEx) {
                PaytmUtility.debugLog("Some exception occurred while making client authentication.");
                PaytmUtility.printStackTrace(inEx);
            }
            try {
                if (UrlConnection != null) {
                    ((HttpURLConnection)UrlConnection).disconnect();
                }
                PaytmUtility.debugLog("connection is disconnected");
            }
            catch (Exception inEx) {
                PaytmUtility.printStackTrace(inEx);
            }
            return Response;
        }

        protected synchronized void onPostExecute(String inResult) {
            try {
                if (inResult != null && !inResult.equalsIgnoreCase("")) {
                    PaytmUtility.debugLog("Response is " + inResult);
                    boolean bSuccess = PaytmPGActivity.this.extractJSON(inResult);
                    if (bSuccess) {
                        PaytmPGActivity.this.mbChecksumGenerated = true;
                        PaytmPGActivity.this.mWV.setVisibility(0);
                        PaytmPGActivity.this.mWV.postUrl(PaytmPGService.getService().mPGURL, PaytmUtility.getURLEncodedStringFromBundle(PaytmPGActivity.this.mParams).getBytes());
                        PaytmPGActivity.this.mWV.requestFocus(130);
                    } else {
                        PaytmPGActivity.this.finish();
                        PaytmPaymentTransactionCallback PaymentTransactionCallback = PaytmPGService.getService().getmPaymentTransactionCallback();
                        if (PaymentTransactionCallback != null) {
                            PaymentTransactionCallback.clientAuthenticationFailed(PaytmPGActivity.CLIENT_AUTHENTICATION_FAILED);
                        }
                    }
                } else {
                    PaytmPGActivity.this.finish();
                    PaytmPaymentTransactionCallback PaymentTransactionCallback = PaytmPGService.getService().getmPaymentTransactionCallback();
                    if (PaymentTransactionCallback != null) {
                        PaymentTransactionCallback.clientAuthenticationFailed(PaytmPGActivity.CLIENT_AUTHENTICATION_FAILED_DUE_TO_SERVER_ERROR);
                    }
                }
            }
            catch (Exception inEx) {
                PaytmPGActivity.this.finish();
                PaytmPaymentTransactionCallback PaymentTransactionCallback = PaytmPGService.getService().getmPaymentTransactionCallback();
                if (PaymentTransactionCallback != null) {
                    PaymentTransactionCallback.someUIErrorOccurred(PaytmPGActivity.UI_WEBVIEW_ERROR_OCCURED);
                }
                PaytmUtility.debugLog("Some exception occurred while posting data to PG Server.");
                PaytmUtility.printStackTrace(inEx);
            }
        }
    }
}

