package com.paytm.pgsdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.JsResult;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

import org.json.JSONObject;

import java.util.Iterator;

/**
 * This webview will load the payment gateway page, after client authentication process is completed.
 *
 * @author Suhas K
 */
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
public class PaytmWebView extends WebView {

    /**
     * The name used to expose the object in JavaScript
     */
    private static final String HTML_OUT = "HTMLOUT";

    /** Java Script to get HTML Content and to pass that string to method of an interface object, which is injected into the webview.*/
    ;
    private static final String JAVA_SCRIPT = "javascript:window.HTMLOUT.processResponse(document.getElementById('response').value);";

    /**
     * Y
     */
    private static final String Y = "Y";

    /**
     * Response code success
     */
    private static final String SUCCESS = "01";
    private final PaytmPGActivity mContext;

    //Variable to check whether Merchant specific checksum validation is done or not.
    private volatile boolean mbMerchantCallbackURLLoaded;

    /**
     * Callback
     */
    private static final String CALLBACK = "/CAS/Response";

    /**
     * This will create a webview and it will set the required WebView Client.
     *
     * @param inContext Activity context
     * @author Suhas K
     */
    public PaytmWebView(Context inContext, Bundle inParams) {
        super(inContext);
        mContext = (PaytmPGActivity) inContext;
        setWebViewClient(new PaytmWebViewClient());
        setWebChromeClient(new WebChromeClient() {
            @Override
            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                PaytmUtility.debugLog("JavaScript Alert " + url);
                return super.onJsAlert(view, url, message, result);
            }
        });
        getSettings().setJavaScriptEnabled(true);

        int currentapiVersion = android.os.Build.VERSION.SDK_INT;

        if (currentapiVersion >= android.os.Build.VERSION_CODES.LOLLIPOP) {
            getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        } else {
            // do something for phones running an SDK before froyo
        }

        addJavascriptInterface(new PaytmJavaScriptInterface(), HTML_OUT);
    }

    /**
     * This custom webview client is used in order to track page transition.
     *
     * @author Suhas K
     */
    private class PaytmWebViewClient extends WebViewClient {

        @Override
        public synchronized void onPageStarted(WebView inView, String inUrl, Bitmap inFavicon) {
            super.onPageStarted(inView, inUrl, inFavicon);
            PaytmUtility.debugLog("Page started loading " + inUrl);
            startProgressDialog();
        }

        @Override
        public synchronized void onPageFinished(WebView inView, String inUrl) {
            super.onPageFinished(inView, inUrl);
            if(PaytmPGService.getService() == null || PaytmPGService.getService().mOrder == null){
                PaytmUtility.debugLog("Transaction cancelled before loading web view completely.");
                return;
            }
            try {
                PaytmUtility.debugLog("Page finished loading " + inUrl);
                stopProgressDialog();
                if (inUrl.equalsIgnoreCase(PaytmPGService.getService().mOrder.getRequestParamMap().get("CALLBACK_URL").toString())) {
                    PaytmUtility.debugLog("Merchant specific Callback Url is finished loading. Extract data now. ");
                    mbMerchantCallbackURLLoaded = true;
                    //This call inject JavaScript into the page which just finished loading.
                    loadUrl(JAVA_SCRIPT);
                } else if (inUrl.endsWith(CALLBACK)) {
                    PaytmUtility.debugLog("CAS Callback Url is finished loading. Extract data now. ");
                    //This call inject JavaScript into the page which just finished loading.
                    loadUrl(JAVA_SCRIPT);
                }
            } catch (Exception inEx) {
                PaytmUtility.printStackTrace(inEx);
            }finally {
                if(PaytmPGService.getService().mOrder.getRequestParamMap().get("postnotificationurl")!= null){
                    Intent intent = new Intent(mContext,IntentServicePostNotification.class);
                    intent.putExtra("url",PaytmPGService.getService().mOrder.getRequestParamMap().get("postnotificationurl"));
                    mContext.startService(intent);
                }
            }
        }

        @Override
        public synchronized void onReceivedError(WebView inView, int iniErrorCode, String inDescription, String inFailingUrl) {
            super.onReceivedError(inView, iniErrorCode, inDescription, inFailingUrl);
            PaytmUtility.debugLog("Error occured while loading url " + inFailingUrl);
            PaytmUtility.debugLog("Error code is " + iniErrorCode + "Description is " + inDescription);
            if (iniErrorCode == -6) {
                ((Activity) getContext()).finish();
                PaytmPaymentTransactionCallback PaymentTransactionCallback = PaytmPGService.getService().getmPaymentTransactionCallback();
                if (PaymentTransactionCallback != null)
                    PaymentTransactionCallback.onErrorLoadingWebPage(iniErrorCode, inDescription, inFailingUrl);
            }
        }

        @Override
        public synchronized void onReceivedSslError(WebView inView, SslErrorHandler inHandler, SslError inError) {
            PaytmUtility.debugLog("SSL Error occured " + inError.toString());
            PaytmUtility.debugLog("SSL Handler is " + inHandler);
            if (inHandler != null)
                inHandler.cancel();
        }

    }

    /**
     * This method will start the progress dialog, if it is not showing.
     *
     * @author Suhas K
     */
    private synchronized void startProgressDialog() {
        try {
            ((Activity) getContext()).runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    mContext.mProgress.setVisibility(View.VISIBLE);
                    PaytmUtility.debugLog("Progress dialog started");
                }
            });
        } catch (Exception inEx) {
            PaytmUtility.printStackTrace(inEx);
        }
    }

    /**
     * This method will stop the progress dialog, if it is showing.
     *
     * @author Suhas K
     */
    private synchronized void stopProgressDialog() {
        try {
            ((Activity) getContext()).runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    mContext.mProgress.setVisibility(View.GONE);
                    PaytmUtility.debugLog("Progress dialog ended");
                }
            });
        } catch (Exception inEx) {
            PaytmUtility.printStackTrace(inEx);
        }
    }

    /**
     * An instance of this class will be registered as a JavaScript interface.
     *
     * @author Suhas K
     */
    private class PaytmJavaScriptInterface {

        /**
         * Process the Response as needed by the app
         *
         * @param inResponse, Response string to be processed.
         */
        @JavascriptInterface
        public synchronized void processResponse(final String inResponse) {
            try {
                PaytmUtility.debugLog("Merchant Response is " + inResponse);
                final Bundle bundleResponse = parseResponse(inResponse);
                String callBackUrl = PaytmPGService.getService().mOrder.getRequestParamMap().get("CALLBACK_URL");
                if(TextUtils.isEmpty(callBackUrl) || mbMerchantCallbackURLLoaded){
                    PaytmUtility.debugLog("Returning the response back to Merchant Application");
                    returnResponse(bundleResponse);
                }else{
                    PaytmUtility.debugLog("Merchant Specific URL is present, So posting all parameters to Merchant specific URL");
                    postUrl(callBackUrl, PaytmUtility.getURLEncodedStringFromBundle(bundleResponse).getBytes());
                }
            } catch (Exception inEx) {
                PaytmUtility.printStackTrace(inEx);
            }
        }

        /**
         * This method will return the Response back to Merchant Application.
         *
         * @param inResponse, Response to be returned.
         */
        private synchronized void returnResponse(final Bundle inResponse) {
            try {
                ((Activity) getContext()).runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            ((Activity) getContext()).finish();
                            PaytmPaymentTransactionCallback PaymentTransactionCallback = PaytmPGService.getService().getmPaymentTransactionCallback();
                            /*if(PaymentTransactionCallback != null)
					    	{
					    		if(inResponse.getString(PaytmConstants.RESPONSE_CODE).equalsIgnoreCase(SUCCESS) && isValidChecksum(inResponse))
					    			PaymentTransactionCallback.onTransactionSuccess(inResponse);
					    		else
					    			PaymentTransactionCallback.onTransactionFailure(inResponse.getString(PaytmConstants.RESPONSE_MSG), inResponse);
					    	}*/

                            PaymentTransactionCallback.onTransactionResponse(inResponse);
                        } catch (Exception inEx) {
                            PaytmUtility.printStackTrace(inEx);
                        }
                    }
                });
            } catch (Exception inEx) {
                PaytmUtility.printStackTrace(inEx);
            }
        }

    }

    /**
     * This method will parse the merchant Response and create a Bundle from it.
     *
     * @param inResponse Merchant Response to be parsed.
     * @return Bundle Containing the Response as key value pairs.
     * @author Suhas K
     */
    private synchronized Bundle parseResponse(String inResponse) {
        PaytmUtility.debugLog("Parsing the Merchant Response");
        Bundle Response = new Bundle();
        try {
            JSONObject Obj = new JSONObject(inResponse);
            if (Obj != null && Obj.length() > 0) {
                Iterator<String> Keys = Obj.keys();
                while (Keys.hasNext()) {
                    String Key = Keys.next();
                    String Value = Obj.getString(Key);
                    PaytmUtility.debugLog(Key + " = " + Value);
                    Response.putString(Key, Value);
                }
            }
        } catch (Exception inEx) {
            PaytmUtility.debugLog("Error while parsing the Merchant Response");
            PaytmUtility.printStackTrace(inEx);
        }
        return Response;
    }

    private synchronized boolean isValidChecksum(final Bundle inResponse) {
        boolean bIsValid = false;
        try {
            if (inResponse != null && inResponse.size() > 0) {
                if (inResponse.containsKey(PaytmConstants.IS_CHECKSUM_VALID) && inResponse.getString(PaytmConstants.IS_CHECKSUM_VALID).equalsIgnoreCase(Y))
                    bIsValid = true;
            }
        } catch (Exception inEx) {
            PaytmUtility.printStackTrace(inEx);
        }
        return bIsValid;
    }

}
