package com.paytm.pgsdk;

import java.net.URLEncoder;

import org.json.JSONObject;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;

import com.paytm.pgsdk.Log;

/**
 * This class contains some Utility methods which are used in PayTM PG SDK.
 *
 * @author Suhas K
 */
public class PaytmUtility {

    /**
     * =
     */
    private static final String EQUAL_TO = "=";

    /**
     * &
     */
    private static final String AMPERSAND = "&";

    /**
     * PGSDK
     */
    private static final String TAG = "PGSDK";

    /**
     * UTF-8
     */
    private static final String UTF_8 = "UTF-8";

    /**
     * This method will extracts the key value pairs present in the Bundle and create a String to be posted.
     *
     * @param inParams Bundle containing key value pairs.
     * @return String to be posted.
     */
    protected static synchronized String getStringFromBundle(Bundle inParams) {
        try {
            PaytmUtility.debugLog("Extracting Strings from Bundle...");
            boolean bFirst = true;
            StringBuffer Params = new StringBuffer();
            for (String Key : inParams.keySet()) {
                if (bFirst)
                    bFirst = false;
                else
                    Params.append(AMPERSAND);
                Params.append(Key);
                Params.append(EQUAL_TO);
                Params.append(inParams.getString(Key));
            }
            PaytmUtility.debugLog("Extracted String is " + Params.toString());
            return Params.toString();
        } catch (Exception inEx) {
            PaytmUtility.printStackTrace(inEx);
            return null;
        }
    }

    /**
     * This method will extracts the key value pairs present in the Bundle and create a Url encoded String to be posted.
     *
     * @param inParams Bundle containing key value pairs.
     * @return Url encoded String to be posted.
     */
    protected static synchronized String getURLEncodedStringFromBundle(Bundle inParams) {
        try {
            PaytmUtility.debugLog("Extracting Strings from Bundle...");
            boolean bFirst = true;
            StringBuffer Params = new StringBuffer();
            for (String Key : inParams.keySet()) {
                if (bFirst)
                    bFirst = false;
                else
                    Params.append(AMPERSAND);
                Params.append(URLEncoder.encode(Key, UTF_8));
                Params.append(EQUAL_TO);
                Params.append(URLEncoder.encode(inParams.getString(Key), UTF_8));
            }
            PaytmUtility.debugLog("URL encoded String is " + Params.toString());
            return Params.toString();
        } catch (Exception inEx) {
            PaytmUtility.printStackTrace(inEx);
            return null;
        }
    }

    /**
     * This method will prints the Log Messages. Tag used is PGSDK which is present in {@link PaytmConstants}.
     *
     * @param inMsg Message to be printed.
     */
    protected static synchronized void debugLog(String inMsg) {
        Log.d(TAG, inMsg);
    }

    /**
     * This method will prints the Stack Trace of an Exception
     *
     * @param inEx Exception whose Stack Trace is to be printed.
     */
    protected static synchronized void printStackTrace(Exception inEx) {
        inEx.printStackTrace();
    }

    /**
     * Checks if Network is available.
     *
     * @param inContext activity context.
     */
    protected static synchronized boolean isNetworkAvailable(Context inContext) {
        ConnectivityManager ConnectMgr = (ConnectivityManager) inContext.getSystemService(Context.CONNECTIVITY_SERVICE);
        if (ConnectMgr == null) return false;
        NetworkInfo NetInfo = ConnectMgr.getActiveNetworkInfo();
        if (NetInfo == null) return false;
        return NetInfo.isConnected();
    }

    /**
     * This method will extracts the key value pairs present in the Bundle and create a JSON String to be posted.
     *
     * @param inParams Bundle containing key value pairs.
     * @return JSON String to be posted.
     */
    protected static String getJSONString(Bundle inParams) {
        try {
            JSONObject Params = null;
            if (inParams != null && inParams.size() > 0) {
                Params = new JSONObject();
                for (String Key : inParams.keySet()) {
                    Params.put(Key, inParams.get(Key));
                }
            }
            PaytmUtility.debugLog("JSON string is " + Params);
            return Params.toString();
        } catch (Exception inEx) {
            PaytmUtility.printStackTrace(inEx);
            return null;
        }
    }

    /**
     * This method will extracts the key value pairs present in the Bundle and create a Url encoded JSON String to be posted.
     *
     * @param inParams Bundle containing key value pairs.
     * @return Url encoded JSON String to be posted.
     */
    protected static String getURLEncodedJSONString(Bundle inParams) {
        try {
            JSONObject Params = null;
            if (inParams != null && inParams.size() > 0) {
                Params = new JSONObject();
                for (String Key : inParams.keySet()) {
                    Params.put(URLEncoder.encode(Key, UTF_8), URLEncoder.encode(inParams.getString(Key), UTF_8));
                }
            }
            PaytmUtility.debugLog("URL encoded JSON string is " + Params);
            return Params.toString();
        } catch (Exception inEx) {
            PaytmUtility.printStackTrace(inEx);
            return null;
        }
    }

}
