package com.paytm.pgsdk;

import android.os.Bundle;

/**
 * This interface contains callback methods of Status Query Operation back to Merchant Application.
 * 
 * @author Suhas K
 */
public interface PaytmStatusQueryCallback 
{

	/**
	 * Status Query completed.
	 * 
	 * @param inResponse Response.
	 */
	public void onStatusQueryCompleted(Bundle inResponse);
	
	/**
	 * Status Query failed.
	 * 
	 * @param inErrorMessage Error Message describing reason for failure.
	 */
	public void onStatusQueryFailed(String inErrorMessage);
	
}
