package com.paytm.pgsdk;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import java.security.cert.CertificateExpiredException;

import javax.net.ssl.TrustManagerFactory;

import android.content.Context;

/**
 * This is a custom SSLSocketFactory, which will trust all Server side certificates.
 * It also initializes the SSLContext instance, which will be used for socket creation with the
 * key managers which we get from Client side certificate, that is certificates.p12 file.
 *
 * @author Suhas K
 */
public class PaytmSSLSocketFactory extends SSLSocketFactory {

    //SSLContext instance which is used to create socket for connection establishment.
    private volatile SSLContext mSSLContext;

    /**
     * PKCS12
     */
    private static final String PKCS12 = "pkcs12";

    /**
     * PKCS12
     */
    private static final String X509 = "X509";

    /**
     * PKCS12
     */
    private static final String TLS = "TLS";

    /**
     * Raw
     */
    private static final String RAW = "raw";

    /**
     * This will initialize the SSLContext instance with the key managers which we generate from certificates.p12 file.
     * This will also create a TrustManager Instance which will trust all Server side certificates.
     *
     * @param inCtxt        activity context in order get stream from certificates.p12 file.
     * @param inCertificate Client certificate Object holding the Certificate related information.
     */
    protected PaytmSSLSocketFactory(Context inCtxt, PaytmClientCertificate inCertificate) {
        TrustManager TM = new X509TrustManager() {
            public void checkClientTrusted(X509Certificate[] inChain, String inAuthType) throws CertificateException {

            }

            public void checkServerTrusted(X509Certificate[] inChain, String inAuthType) throws CertificateException {

            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };

        try {
            if (inCertificate != null && inCertificate.mFileName != null) {
                PaytmUtility.debugLog("Reading the certificate " + inCertificate.mFileName + ".p12");
                KeyStore MyCert = KeyStore.getInstance(PKCS12);
                MyCert.load(inCtxt.getResources().openRawResource(inCtxt.getResources().getIdentifier(inCertificate.mFileName, RAW, inCtxt.getPackageName())), inCertificate.mPassword.toCharArray());
                Enumeration<String> Aliases = MyCert.aliases();
                while (Aliases.hasMoreElements()) {
                    PaytmUtility.debugLog(MyCert.getCertificate(Aliases.nextElement().toString()).toString());
                }
                KeyManagerFactory KMF = KeyManagerFactory.getInstance(X509);
                KMF.init(MyCert, inCertificate.mPassword.toCharArray());

                mSSLContext = SSLContext.getInstance(TLS);
                mSSLContext.init(KMF.getKeyManagers(), new TrustManager[]{TM}, null);
                PaytmUtility.debugLog("Client certificate attached.");
            } else {
                PaytmUtility.debugLog("Client certificate is not found");
                PaytmUtility.debugLog("so, setting only the trust manager");
                mSSLContext = SSLContext.getInstance(TLS);
                mSSLContext.init(null, new TrustManager[]{TM}, null);
                PaytmUtility.debugLog("set trust manager");
            }
        } catch (Exception inEx) {
            PaytmUtility.debugLog("Exception while attaching Client certificate.");
            PaytmUtility.printStackTrace(inEx);
            try {
                PaytmUtility.debugLog("so, setting only the trust manager");
                mSSLContext = SSLContext.getInstance(TLS);
                mSSLContext.init(null, new TrustManager[]{TM}, null);
                PaytmUtility.debugLog("set trust manager");
            } catch (Exception inEx1) {
                PaytmUtility.debugLog("Exception while setting the trust manager");
                PaytmUtility.printStackTrace(inEx1);
            }
        }
    }

    /*private TrustManager[] getTrusManager() throws Exception {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(
                    TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore) null);

            TrustManager[] trustManagers = tmf.getTrustManagers();
            final X509TrustManager origTrustmanager = (X509TrustManager) trustManagers[0];

            return new TrustManager[]{
                    new X509TrustManager() {
                        public X509Certificate[] getAcceptedIssuers() {
                            return origTrustmanager.getAcceptedIssuers();
                        }

                        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                            try {
                                origTrustmanager.checkClientTrusted(certs, authType);
                            } catch (CertificateException e) {
                                throw new CertificateException("Certificate not valid or trusted.");
                            }
                        }

                        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                            try {
                                origTrustmanager.checkServerTrusted(certs, authType);
                            } catch (CertificateExpiredException e) {
                                throw new CertificateException("Certificate not valid or trusted.");
                            }
                        }
                    }
            };
        } catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }
*/
    @Override
    public synchronized Socket createSocket(Socket inS, String inHost, int iniPort, boolean inbAutoClose) throws IOException {
        if (mSSLContext != null)
            return mSSLContext.getSocketFactory().createSocket(inS, inHost, iniPort, inbAutoClose);
        else
            return getDefault().createSocket(inHost, iniPort);
    }

    @Override
    public synchronized String[] getDefaultCipherSuites() {
        return null;
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return null;
    }

    @Override
    public synchronized Socket createSocket(String inHost, int iniPort) throws IOException, UnknownHostException {
        if (mSSLContext != null)
            return mSSLContext.getSocketFactory().createSocket(inHost, iniPort);
        else
            return getDefault().createSocket(inHost, iniPort);
    }

    @Override
    public synchronized Socket createSocket(InetAddress inHost, int iniPort) throws IOException {
        if (mSSLContext != null)
            return mSSLContext.getSocketFactory().createSocket(inHost, iniPort);
        else
            return getDefault().createSocket(inHost, iniPort);
    }

    @Override
    public synchronized Socket createSocket(String inHost, int iniPort, InetAddress inLocalHost, int iniLocalPort) throws IOException, UnknownHostException {
        if (mSSLContext != null)
            return mSSLContext.getSocketFactory().createSocket(inHost, iniPort, inLocalHost, iniLocalPort);
        else
            return getDefault().createSocket(inHost, iniPort);
    }

    @Override
    public synchronized Socket createSocket(InetAddress inAddress, int iniPort, InetAddress inLocalAddress, int iniLocalPort) throws IOException {
        if (mSSLContext != null)
            return mSSLContext.getSocketFactory().createSocket(inAddress, iniPort, inLocalAddress, iniLocalPort);
        else
            return getDefault().createSocket(inAddress, iniPort, inLocalAddress, iniLocalPort);
    }

}
