package com.paytm.pgsdk;

import android.os.Bundle;

/**
 * This interface contains callback methods of Refund Operation back to Merchant Application.
 * 
 * @author Suhas K
 */
public interface PaytmRefundCallback 
{

	/**
	 * Refund completed.
	 * 
	 * @param inResponse Response
	 */
	public void onRefundCompleted(Bundle inResponse);
	
	/**
	 * Refund failed.
	 * 
	 * @param inErrorMessage Error Message describing reason for failure.
	 */
	public void onRefundFailed(String inErrorMessage);
	
}
